;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold without
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

(in-package :user)


;;  pcvars are in the following format ?NAME (NAME = ID[_COUNT])

(proclaim '(inline make-pcvar var-eq pcvar-p pcvar-id set-pcvar-id ))

(defvar *pcvar-id-table* (make-hash-table :test #'eql :size 100))
(defvar *id-pcvar-table* (make-hash-table :test #'eql :size 100))
(defvar *id-count-table* (make-hash-table :test #'eql :size 100))

(defun clear-variables ()
  (clrhash *pcvar-id-table*)
  (clrhash *id-pcvar-table*)
  (clrhash *id-count-table*))

#|
(defun make-pcvar (&key (id (gensym)) (count nil))
  (let ((variable (intern (format nil "?~a~@[_~a~]" id count))))
    (setf (gethash variable *pcvar-id-table*) id
          (gethash id *id-count-table*) (or count 0))
    variable))
|#

(defun make-pcvar (&key (id (gensym)) (count nil))
  (if count
    (let ((variable (intern (format nil "?~a_~a" id count))))
      (setf (gethash id *id-count-table*) count
            (gethash variable *pcvar-id-table*) id)
      variable)
    (or (gethash id *id-pcvar-table*)
        (let ((variable (intern (format nil "?~a" id))))
          (setf (gethash variable *pcvar-id-table*) id
                (gethash id *id-count-table*) 0
                (gethash id *id-pcvar-table*) variable)
          variable))))

(defun make-unique-pcvar (&key (id (gensym)))
  (let ((count (gethash id *id-count-table*)))
    (make-pcvar :id id :count (if count (incf count) nil))))

#|
(defun pcvar-p (thing)
  (or (gethash thing *pcvar-id-table*)
      (and (symbolp thing)
           (eq (char (symbol-name thing) 0) #\?))))

(defun pcvar-id (variable)
  (or (gethash variable *pcvar-id-table*)
      (read-from-string (subseq (symbol-name variable) 1))))

(defun pcvar-p (thing)
  (or (gethash thing *pcvar-id-table*)
      (and (symbolp thing)
           (eq (char (symbol-name thing) 0) #\?)
           (or (pcvar-id thing) t))))

(defun pcvar-id (variable)
  (or (gethash variable *pcvar-id-table*)
      (let* ((name (subseq (symbol-name variable) 1))
             (position (position #\_ name :from-end t))
             (count (when position (read-from-string (subseq name (+ position 1)) nil nil)))
             (id (if (numberp count) (read-from-string (subseq name 0 position) nil nil) (read-from-string name nil nil))))
        (setf (gethash id *id-count-table*) (if (numberp count) count 0)
              (gethash variable *pcvar-id-table*) id))))
|#

(defun pcvar-p (thing)
  (or (gethash thing *pcvar-id-table*)
      (and (symbolp thing)
           (eq (char (symbol-name thing) 0) #\?)
           (set-pcvar-id thing))))

(defun pcvar-id (variable)
  (or (gethash variable *pcvar-id-table*)
      (set-pcvar-id variable)))

(defun set-pcvar-id (variable)
  (let ((id (read-from-string (subseq (symbol-name variable) 1) nil t)))
    (setf (gethash id *id-count-table*) 0
          (gethash variable *pcvar-id-table*) id)))

(defstruct (r (:print-function print-r-struct))
  (name nil)                        ;;
  (arity 0)                         ;; an integer
  (vars nil)                        ;; a list (arity), specifying pretty names of each argument
  (type nil)                        ;; a list (arity), specifying the type of each argument
  (mode nil)                        ;; a list (arity), specifying the mode of each argument
  (determinacy nil)                 ;; a list (arity), specifying the determinacy of each argument position
  (kind nil)                        ;; :pred, :rule, :builtin, :builtin-fn, :is-op, :reduction-pred
  (questions nil)                   ;; question for asking user about fact (or printing about x
  (infix nil)                       ;; is the r-struct a prolog infix operator
  (nodes nil)                       ;; nodes representing the r-struct
  (equality? nil)                   ;; distinguish equality builtins
  (from-r-struct nil)               ;; r-struct that the rule is derived from
  (from-cliche nil)                 ;; cliche that the rule is derived from
  (pos nil)                         ;; list of the positive tuples
  (neg nil)                         ;; list of the negative tuples
  (pos-hash nil)                    ;; equal hash table, returns list of tuple if tuple is positive, nil otherwise
  (neg-hash nil)                    ;; used to avoid recomputation of first literal of clause
  (neg-hash-for-negated nil)        ;; since neg-tuples doesn't change
  (slot-value-hash  nil)            ;; array of hash tables, one per parameter, each hash table returns a list of
                                    ;;   tuples that have a particular value for a particular argument position
  (clauses nil)                     ;; list of clause structures - for compatobility with prolog, clauses are also on plist of name
  (prolog-function nil)
  (function nil)                    ;; lisp function that defines predicate [is-op-arithmetic-op]
  (variabilizations                 ;; maps (old . arity) to list of legal variabilizations
   (make-hash-table :test #'equal :size 4))
  (sort-fn nil)                     ;; sorting fn to make non-numeric builtins possible
  (constraint nil)                  ;;
  (commutative nil)                 ;;
  (treat-as-commutative nil)        ;; should only only one of X fn Y or Y fn X be computed
  (induction nil)                   ;; nil if predicate should be ignored during induction
  (try-constants nil)               ;; should a threshold be computed for each var [one-variable-comp]

  (function-def nil)
  (sort-fn-def nil)
  (compute-neg nil)
)

(defstruct (reduction-pred (:include r))
  reduction-type               ;; the type of the argument reduced
  reduction-variabilization    ;; constrains the variabilizations when operator is used for reduction as part of a cliche
  )

(defun pred-p (r-struct) (and (r-p r-struct) (eq (r-kind r-struct) :extensional)))
(defun rule-p (r-struct) (and (r-p r-struct) (eq (r-kind r-struct) :intensional)))
(defun builtin-p (r-struct) (and (r-p r-struct) (eq (r-kind r-struct) :builtin)))
(defun builtin-fn-p (r-struct) (and (r-p r-struct) (eq (r-kind r-struct) :builtin-fn)))
(defun is-p (r-struct) (and (r-p r-struct) (eq (r-kind r-struct) :is)))
(defun =-p (r-struct) (and (r-p r-struct) (eq (r-kind r-struct) :=)))
(defun is-op-p (r-struct) (and (r-p r-struct) (eq (r-kind r-struct) :is-op)))
(defun arithmetic-op-p (r-struct) (and (r-p r-struct) (eq (r-kind r-struct) :arithmetic-op)))

(defun get-r-struct (name)
  (when (symbolp name)
    (or (get name 'reduction-pred)
        (get name 'r-struct))))

(defun set-r-struct (name r-struct)
  (if (reduction-pred-p r-struct)
    (setf (get name 'reduction-pred) r-struct))
  (setf (get name 'r-struct) r-struct))

(defun get-pred (name)
  (let ((r-struct (get-r-struct name)))
    (if (pred-p r-struct) r-struct)))

(defun get-rule (name)
  (let ((r-struct (get-r-struct name)))
    (if (rule-p r-struct) r-struct)))

(defun get-builtin (name)
  (let ((r-struct (get-r-struct name)))
    (if (builtin-p r-struct) r-struct)))

(defun get-builtin-fn (name)
  (let ((r-struct (get-r-struct name)))
    (if (builtin-fn-p r-struct) r-struct)))


(defstruct (clause (:print-function print-clause))
  body             ;; list of prolog literals
  parameters       ;; list of variables bound by the head
  number           ;; number of the clause for a rule- maintained for future use
  head             ;; name of rule- makes debugging easier
  new-vars         ;; list of new-variables in clause
  neg-tuples-hash  ;; note that we never try the negation of a clause, so no neg-tuples-hash-for-negated
  rule             ;; points to a rule that is the rule for a single clause
  of)              ;; points back to rule structure

(defun get-clauses (rule-name) (get rule-name 'clauses))
(defun set-clauses (rule-name clauses) (setf (get rule-name 'clauses) clauses))

(defstruct (literal (:print-function print-literal))
  (negated? nil)    ;; true if literal is a negation
  negated-literals  ;; only used for negations- filled by a literal structure
  predicate-name    ;; name of predicate
  variablization    ;; variables used in predicate
  prev              ;; maintained, but not yet used
  (next nil)        ;; if this is non-nil, its another literal, the next one in a clause
  pos               ;; positive tuples that this has been used on
  neg               ;; negative tuples 
  new-pos           ;; positive tuples satisfied by literal
  new-neg           ;; negative tuples satisfied by literal
  derivation        ;; a deivation structure, explains reason for using literal
  (deleted? nil)    ;; t if literal should not be considered part of the clause
  )

(defun literal-disjunction-p (literal-disjunction)
  (and (consp literal-disjunction) (every #'literal-p literal-disjunction)))

(defstruct graph
  (free-nodes nil)   ;;; a list of nodes allocated to graph which are not used
  (used-nodes nil)   ;;; a list of nodes allocated to graph which are used
  (root nil)         ;;; the root of all used nodes in graph
  (permanent? nil)   ;;; nil if the graph can be disposed of when there are no views of it
  (views nil))       ;;; a list of all views of the graph


(defstruct (node (:print-function (lambda (node stream depth)
                                    (declare (ignore depth))
                                    (format stream "{NODE ~A }" (node-string node)))))
  (consequent nil)   ;;; a single node
  (antecedents nil)  ;;; a disjunction of conjunctions of nodes
  (r-struct nil)     ;;; the corresponding r structure
  (vars nil)         ;;; a list of variables
  (deleted? nil)     ;;; nil or t
  (selected? nil)    ;;; nil or t
  (recursive? nil)   ;;; nil or t
  (kind nil)         ;;; nil, :intensional, :builtin, :extensional, :not, :cut,
  (state nil)        ;;; nil, :unoperationalized, :builtin, :cliche, :determinate, :extensional, :intensional, :ebl
  (cells nil)        ;;; a list of graphic cells representing the node
  (coverage nil)     ;;; a list of coverage structures
  (aux nil)          ;;; anything you want
  )

(defstruct (coverage)
  (from nil)            ;; where these examples came from :learning, :all
  (input-pos nil)       ;; positive tuples presented to node
  (input-neg nil)       ;; negative tuples presented to node
  (input-vars nil)      ;; variable names used to reference tuple values
  (input-type nil)      ;; types of variables used to reference tuple values
  (output-pos nil)      ;; positive tuples satisfying node
  (output-neg nil)      ;; negative tuples satisfying node
  (output-vars nil)     ;; variable names used to reference tuple values
  (output-type nil)     ;; types of variables used to reference tuple values
  )

(defstruct (cell (:print-function (lambda (cell stream depth)
                                       (declare (ignore depth))
                                       (format stream "{CELL ~A }" (or (cell-text cell)
                                                                       (node-string (cell-node cell)))))))
  (left 0)
  (top 0)
  (right 100)
  (bottom 10)
  (in-h 0)
  (in-v 5)
  (out-h 100)
  (out-v 5)
  (text-h 4)
  (text-v 8)
  (text nil)           ;;; text in the cell
  (external-text nil)  ;;; text to appear below or behind cell
  (on-screen? nil)     ;;; t or nil
  (hidden? nil)        ;;; t or nil
  (node nil)           ;;; a pointer to the node the cell represents
  (view nil)           ;;; a pointer to the view containing the cell
  )


;;; records information needed build a conjunction with an extensional predicate
(defstruct conj-info
  extensional-gain
  pred
  variabilization
  max-negated?
  pos-tuples
  neg-tuples
  vars
  types)

(defstruct derivation
  (type nil)   ;; :ebl, :intensional-induction, ...
  (path nil)   ;; the node in the derivation graph that the literal represents
  (graph nil)) ;; the derivation graph

(defstruct variabilization-struct
  (variabilization nil)
  (look-at-positive? t)
  (look-at-negative? nil))

(defstruct gain
  gain
  t++
  pp   ;; the number of positive tuples
  nn   ;; the number of negative tuples
  n++)
 
(defstruct (winner (:include gain))
  literal
  source
  vars
  types
  pos
  neg
  negated?)


;;is this a good idea?
;;;inside operationalize-if-need literal is is (clause . derivation structure) vars isn't used
;;;inside find-max-literal literal is a pred struct and vars is a variabilization
;;;
;;in find-a-literal 
;;literal is always a literal structure and vars and types are the new vars
;;;if its any consoliation, the change in focus occurs at the same time newvars become old

;;used to represent the best (or a member of the best) literals
;; 

(defstruct winners
  (all-winners nil)  ;;all- whether converted or not
  (new-winners nil)  ;;added- but not converted to literals
  (number 0)
  (best-gain-so-far nil)
  (worst-gain-so-far nil)
  ) 

(defstruct work
  (extensional 0)
  (builtin 0)
  (intensional 0)
  (determinate 0)
  (cliche 0)
  (ebl 0)
  (simplify-operationalization 0)
  (simplify-clause 0)
  (frontier-ebl 0)
  (frontier-induction 0)
  (frontier-simpliciation 0))

(defstruct example-template
  (name nil)
  (vars nil)
  (types nil)
  (facts nil))

(defstruct user-monitor 
  (show-rule 0)
  (show-all-rules 0)
  (new-rule 0)
  (copy-rule 0)
  (rename-rule 0)
  (delete-rule 0)
  (add-clause-to-rule 0)
  (add-literal-to-clause 0)
  (delete-clause-from-rule 0)
  (delete-literal-from-clause 0)
  (text-edit-clause 0)
  (text-edit-rule 0)
  (change-vars-english 0)

  (show-fact 0)
  (show-all-facts 0)
  (show-example 0)
  (new-fact 0)
  (rename-fact 0)
  (delete-fact 0)
  (delete-positive-fact 0)
  (delete-negative-fact 0)
  (delete-example 0)
  (retract-new-facts 0)
  (text-edit-fact 0)
  (add-english 0)
  (change-english 0)
  (delete-english 0)
  (change-variable-type 0)

  (show-type 0)
  (show-all-types 0)
  (menu-new-type 0)
  (menu-delete-type 0)
  (add-to-type 0)
  (delete-from-type 0)

  (run-on-new-example 0)
  (run-on-old-example 0)
  (test-on-all-examples 0)
  (prove-goal-interactive 0)
  (prove-goal-batch 0)
  (find-all-proofs 0)
  (who-calls-menu 0)
  (who-calls-relation-window 0)
  (check-rules 0)
  (edit-rule-warnings 0)
  (explain-last-proof 0)
  (change-top-level-predicate 0)
  (trace-all 0)
  (untrace-all 0)
  (add-trace 0)
  (remove-trace 0)
  (add-spy 0)
  (remove-spy 0)

  (display-top-level-examples 0)
  (new-template 0)
  (edit-template 0)
  (delete-template 0)
  (new-extensional-relation 0)
  (new-builtin-relation 0)
  (new-intensional-relation 0)
  (edit-relation 0)
  (rename-relation 0)
  (delete-relation 0)
  (who-calls-relation 0)
  (display-relation 0)

  (new-type 0)
  (edit-type 0)
  (delete-type 0)

  (new-cliche 0)
  (edit-cliche 0)
  (delete-cliche 0)
  (use-cliche 0)
  (dont-use-cliche 0)
  (display-goal-concept 0)
  (display-domain-theory 0)
  (display-learned-description 0)
  (window-setup 0)
  (default-setup 0)

  (change-learning-parameters 0)
  (change-builtin-flags 0)
  (analyze-coverage 0)
  (learn 0)
  (revise 0)

  (edit-translation-define 0)
  (edit-translation-cancel 0)

  (example-window-display-using-template 0)
  (example-window-display-without-template 0)
  (example-window-define-from-template 0)
  (example-window-define 0)
  (example-window-delete-column 0)
  (example-window-delete-row 0)
  (example-window-delete-var 0)
  (example-window-delete-type 0)
  (example-window-delete-mode 0)
  (example-window-delete-datum 0)
  (example-window-new-column 0)
  (example-window-new-row 0)
  (example-window-new-var 0)
  (example-window-new-type  0)
  (example-window-new-mode 0)
  (example-window-new-datum 0)

  (rule-editor-edit-definition 0)
  (rule-editor-create-literal 0)
  (rule-editor-copy 0)                
  (rule-editor-negate 0)
  (rule-editor-attach 0)
  (rule-editor-replace 0)
  (rule-editor-delete 0)
  (rule-editor-show 0)
  (rule-editor-hide 0)
  (rule-editor-analyze 0)
  (rule-editor-cancel 0)
  (rule-editor-define 0)

  (file-names nil)
  (times nil))

