;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

(in-package :user)


(defun greater-ratio-then-coverage (source old new favor-old)
  (cond ((> (gain-gain new) (gain-gain old)) T)
        ((< (gain-gain new) (gain-gain old)) nil)
        ((> (gain-pp new) (gain-pp old)) T)
        ((< (gain-pp new) (gain-pp old)) nil)
        ;;they are equal
        (*retain-only-all-best-winners* T)         ;; CAB added to retain all literals with the best gain
        ((or (not (winner-p old))
             (eq source (winner-source old)))
         (if favor-old nil t))
        (t (higher-priority-source source (winner-source old)))))
  
(defun greater-gain-and-not-worse-accuracy (source old new favor-old)
  (and (greater-gain source old new favor-old)
       (ratio-neg-total-improves (gain-pp old)(gain-nn old)(gain-pp new)(gain-nn new)))
  )

(defun greater-gain (source old new favor-old)
  (cond ((> (gain-gain new) (gain-gain old)) T)
        ((< (gain-gain new) (gain-gain old)) nil)
        (*retain-only-all-best-winners* T)         ;; CAB added to retain all literals with the best gain
        ((or (not (winner-p old))
             (eq source (winner-source old)))
         (if favor-old nil t))
        (t (higher-priority-source source (winner-source old)))))

(defun higher-priority-source (new old)
  (member old (cdr (member new *source-priorities*))))

(defun choose-a-winner (winners)
  (let ((winner (case *selection-function* 
                  (:maximum (best-winner winners))
                  (:probabilistic (random-winner winners))
                  (:manual (user-choose-a-winner winners)))))
    (when (and winner
	       (listp (winner-source winner))
	       (eq (car (winner-source winner)) :cliche))
      (create-pred-from-cliche (winner-literal winner) (second (winner-source winner)) ;; name
			       (cddr (winner-source winner)))) ;; cliche-head-vars
    winner))

(defun best-winner (winners)
  (car (winners-all-winners winners)))


(defun remove-winner (winner winners)
  (when (member winner (winners-all-winners winners))
    (setf (winners-all-winners winners) (delete winner (winners-all-winners winners))
	  (winners-new-winners winners) (delete winner (winners-new-winners winners)))
    (decf (winners-number winners))
    (if (eq winner (winners-best-gain-so-far winner))
	(setf (winners-best-gain-so-far winner) (car (winners-all-winners winners))))
    (if (eq winner (winners-worst-gain-so-far winner))
	(setf (winners-worst-gain-so-far winner) (car (last (winners-all-winners winners)))))))


(defun choose-best-new-winner-to-continue (new-winners winners)
  (some #'(lambda(w) (when (member w new-winners) w))
	(winners-all-winners winners)))


;;;_________________________
;;;  update-winner?

(defun update-winner? (winners fn prefer-old gain literal source
                               &key (vars nil) (negated? nil) (useful-if-zero-gain nil)
                               (max *max-winners*) (instantiated-cliche nil))
  (when *display-learning?*
    (display-winner-gain *CURRENT-GAIN-WINDOW* literal :vars vars :negated? negated?
                         :source source :gain gain :instantiated-cliche instantiated-cliche))
  (and (if useful-if-zero-gain
         (>= (gain-gain gain) 0)
         (> (gain-gain gain) 0))
       (or (< (winners-number winners) max)
           (funcall fn source (winners-worst-gain-so-far winners) gain prefer-old))))

;;;_________________________
;;;  update-winner

(defun update-winner (winners fn prefer-old gain literal source
                              &key (vars nil) (types nil) (negated? nil) (pos nil) (neg nil) (max *max-winners*) (instantiated-cliche nil))
  (let ((new (get-new-winner-structure)))
    (setf (winner-gain new) (gain-gain gain)
          (winner-t++ new) (gain-t++ gain)
          (winner-pp new) (gain-pp gain)
          (winner-nn new) (gain-nn gain)
          (winner-literal new) literal
          (winner-source new) source
          (winner-pos new) pos
          (winner-vars new) vars
          (winner-types new) types
          (winner-negated? new) negated?
          (winner-neg new) neg)
    (cond (*retain-only-all-best-winners*                      ;; CAB added to retain all literals with the best gain
           (cond ((or (null (winners-best-gain-so-far winners))
                      (> (winner-gain new) (winner-gain (winners-best-gain-so-far winners))))
                  (dolist (luser (winners-all-winners winners))
                    (deallocate-luser-if-needed luser)
                    (discard-winner luser))
                  (setf (winners-number winners) 1
                        (winners-best-gain-so-far winners) new
                        (winners-worst-gain-so-far winners) new
                        (winners-all-winners winners) (list new)
                        (winners-new-winners winners) (list new)))
                 (t (push new (winners-new-winners winners))
                    (incf (winners-number winners))
                    (setf (winners-all-winners winners) 
                          (insert-into-sorted new (winners-all-winners winners) source fn prefer-old)
                          (winners-best-gain-so-far winners) (first (winners-all-winners winners))
                          (winners-worst-gain-so-far winners) (first (last (winners-all-winners winners)))))))
          ((= max 1)
           (deallocate-luser-if-needed (winners-best-gain-so-far winners))
           (discard-winner (winners-best-gain-so-far winners))
           (setf (winners-number winners) 1
                 (winners-best-gain-so-far winners) new
                 (winners-worst-gain-so-far winners) new
                 (winners-all-winners winners) (list new)
                 (winners-new-winners winners) (list new)))
          (t (push new (winners-new-winners winners))
             (cond ((< (winners-number winners) max)
                    (incf (winners-number winners)))
                   (t (let ((luser (car(last (winners-all-winners winners)))))
                        (deallocate-luser-if-needed luser)
                        (setf (winners-all-winners winners)
                              (butlast (winners-all-winners winners)))
                        (setf (winners-new-winners winners)
                              (delete luser (winners-new-winners winners)))
                        (discard-winner luser))))
             (setf (winners-all-winners winners) 
                   (insert-into-sorted new (winners-all-winners winners) source fn prefer-old)
                   (winners-best-gain-so-far winners) (first (winners-all-winners winners))
                   (winners-worst-gain-so-far winners) (first (last (winners-all-winners winners))))))
    (when (and *display-learning?*
               (eq new (winners-best-gain-so-far winners)))
      (display-winner-gain *BEST-GAIN-WINDOW* literal :vars vars :negated? negated?
                           :source source :gain gain :instantiated-cliche instantiated-cliche))
    (values winners new)))


(defun insert-into-sorted (new olds source fn prefer-old)
  (cond((null olds)(list new))
       ((funcall fn source (car olds) new prefer-old)
        (cons new olds))
       (t (cons (car olds) (insert-into-sorted new (cdr olds) source fn prefer-old)))))


(defun deallocate-luser-if-needed (luser)
  (when (winner-is-a-cliche? luser)
    (deallocate-literal-info-structs (winner-literal luser))))


;;  rv  who    date     reason
;;  00  glenn  1/30/91  auxiliary function for simplify determines if the 
;;   new clause generated (by the simplify routine) improves the ratio of 
;;   positive to negative examples

(defun ratio-neg-total-improves (old-pos old-neg new-pos new-neg)
  (cond ((= new-pos 0) nil)
	((= old-pos 0) t)
	(*retain-only-all-best-winners*            ;; CAB added to retain all literals with the best gain
         (or (<= (/ new-neg (+ new-pos new-neg))
                 (/ old-neg (+ old-pos old-neg)))
             (and (zerop old-neg) (zerop new-neg) 
                  (>= new-pos old-pos))))
	(t (or (< (/ new-neg (+ new-pos new-neg))
		  (/ old-neg (+ old-pos old-neg)))
	       (and (zerop old-neg) (zerop new-neg) 
		    (> new-pos old-pos))))
	))

(defun discard-winner (x)
  (when (winner-p x) (push x *used-winners*)))

(defun discard-gain (x)
  (when (gain-p x)(push x *used-gains*)))

(defun get-new-gain-structure ()
  (if *used-gains* (pop *used-gains*)(make-gain)))

(defun get-new-winner-structure ()
  (if *used-winners* (pop *used-winners*) (make-winner)))

(defun make.gain (gain t++ p n n++ &aux (new (get-new-gain-structure)))
  n++
  (setf (gain-gain new) gain
	(gain-t++ new) t++
	(gain-pp new) p
	(gain-nn new) n
  	(gain-n++ new) n)
  new)


(defun compute-max-possible-gain (pos-matches current-state-value)
  (case *gain-function* 
    (:information
	 (*  pos-matches current-state-value))
    (otherwise ;;****NOT DONE YET
      2525)))

(defun rand-from-distribution (alist &optional (fn #'car))
       (let* ((max (reduce  #'+ (mapcar fn alist)))
              (v (random (float max)))
              (total 0))
         (some #'(lambda(x)
                  (incf total (funcall fn x))
                  (when (> total v)
                    x))
               alist)))

(defun random-winner (winners)
  (rand-from-distribution (winners-all-winners winners) #'winner-gain))

(defun amm (n name &rest others &key &allow-other-keys)
  (unless (member :max-winners others)
    (push 11 others)
    (push :max-winners others))
  (unless (member :selection-function others)
    (push :probabilistic others)
    (push :selection-function others))
  (unless (member :stop-when-all-pos-covered others)
    (push nil others)
    (push :stop-when-all-pos-covered others))
  (let ((answers nil))
    (dotimes (i n) i
             (push (apply #'focl name others) answers))
    answers))


(defun make-voting-rule (name arity list-of-clauses &aux (ctr -1) old-vars (cv (+ arity 1)))
  (def-rule vote-counter 
    :induction nil
    :clauses (((vote-counter ?in ?goal ?out)
               (call ?goal)
               !
               (is ?out (+ ?in 1)))
              ((vote-counter ?in ?goal ?out)
               (= ?out ?in))))
  (setq old-vars (do ( (i (- arity 1) (decf i))
                       (result nil))
                     ((< i 0) result)
                   (push (make-pcvar :id i) result) ))
  (let* ((clause (cons `(,name .,old-vars)
                       (nconc  (mapcar #'(lambda(x) (incf ctr)(incf cv)
                                          `(vote-counter ,(if (= ctr 0) 0 (make-pcvar :id cv))
                                                         (, (make-prolog-rule (intern-symbol name '-voter- ctr)
                                                                              arity
                                                                              x
                                                                              :old-vars old-vars
                                                                              )
                                                            . ,old-vars)
                                                         ,(make-pcvar :id (+ cv 1))))
                                       list-of-clauses)
                               (list `(> ,(make-pcvar :id (+ cv 1)) ,(/ ctr 2)))))))
    
    (eval `(def-rule ,name          :induction nil
             :process-clauses nil :clauses (,clause)))))

;;;=======================================================================================
;;;  New Determinate Literal Addition Code - July 1993 - Cliff Brunk
;;;  Shorter, Faster, More Correct - Just Plane Better...
;;;
;;;  r-determinacy field is no longer needed or used.
;;;=======================================================================================

(defun literal-syntatically-at-least-as-general (general specific)
  (let ((mapping nil)
        (bucket nil))
    (and (equal (first general) (first specific))
         (every #'(lambda (G S)
                    (if (new-var? G)
                      (if (setq bucket (assoc G mapping))
                        (equal (rest bucket) S)
                        (push (cons G S) mapping))
                      (equal G S)))
                (rest general) (rest specific)))))

(defun add-r-and-var-if-general-enough (r-and-var r-and-var-list)
  ;; only add r-and-var if more general those currently in r-and-var-list
  (dolist (d-r-and-var r-and-var-list)                             
    (when (literal-syntatically-at-least-as-general d-r-and-var r-and-var)
      (setq r-and-var nil)))
  ;; delete any more specific r-and-vars currently in r-and-var-list
  (when r-and-var
    (dolist (d-r-and-var r-and-var-list)                           
      (if (literal-syntatically-at-least-as-general r-and-var d-r-and-var)
        (setq r-and-var-list (delete d-r-and-var r-and-var-list))))
    (push r-and-var r-and-var-list)))

(defun add-to-determinate-rs-and-vars (pred variabilization gain original-pos original-neg)
  (when (and *enable-determinate-literals*
             (some #'new-var? variabilization)                                      ;; must introduce at least one new variable
             (< (maximum-variable-depth variabilization) *max-determinate-depth*))  ;; literal depth must not exceed *max-determinate-depth*
    (let ((original-pos-with-extensions (gain-t++ gain))
          (extended-pos (gain-pp gain))
          (extended-neg (gain-nn gain))
          (r-and-var (cons pred variabilization)))
      (if (= original-pos-with-extensions original-pos)                             ;; must have at least one extension for each postive tuple
        (if (and (<= *max-number-of-observed-extensions* *max-determinacy*)         ;; must have at most *max-determinacy* extensions for any positive or negative tuple
                 (<= (/ extended-neg (+ extended-pos extended-neg))                 ;; must not increase the ratio of negative tuples
                     (/ original-neg (+ original-pos original-neg))))
          (setq *determinate-rs-and-vars* (add-r-and-var-if-general-enough r-and-var *determinate-rs-and-vars*))
          (setq *rs-and-vars-introducing-new-vars-covering-all-pos* (add-r-and-var-if-general-enough r-and-var *rs-and-vars-introducing-new-vars-covering-all-pos*)))
        (setq *rs-and-vars-introducing-new-vars* (add-r-and-var-if-general-enough r-and-var *rs-and-vars-introducing-new-vars*))))))

(defvar *variable-depth-table* (make-hash-table :test #'eql :size 100))

(defun set-variable-depths-to-zero (variables)
  (clrhash *variable-depth-table*)
  (dolist (variable variables)
    (when (pcvar-p variable)
      (setf (gethash variable *variable-depth-table*) 0))))

(defun maximum-variable-depth (variables &optional (max-depth -1))
  (cond ((null variables) max-depth)
        ((consp variables) (maximum-variable-depth (rest variables) (maximum-variable-depth (first variables) max-depth)))
        (t (max max-depth (gethash variables *variable-depth-table* -1)))))

(defun set-variable-depths (literal old-vars)
  (when (literal-p literal)
    (let (variable-depth)
      (do ((l literal (next-literal l)))
          ((null l))
        (setq variable-depth (+ (maximum-variable-depth (literal-variablization l)) 1))
        (dolist (variable (literal-variablization l))
          (when (pcvar-p variable)
            (unless (member variable old-vars :test #'var-eq)
              (setf (gethash variable *variable-depth-table*) variable-depth))))))))

(defun apply-mapping-to-literals (literal mapping)
  (when (literal-p literal)
    (setf (literal-variablization literal) (direct-substitute (literal-variablization literal) mapping))
    (apply-mapping-to-literals (literal-negated-literals literal) mapping)
    (apply-mapping-to-literals (literal-next literal) mapping)))

(defun remove-redundent-new-variables (old-vars old-types new-vars new-types pos-tuples neg-tuples new-pos-tuples new-neg-tuples literals)
  (let* ((vars (append old-vars new-vars))
         (types (append old-types new-types))
         (lov (length old-vars))
         (lnv (length vars))
         (mapping nil))
    (do ((nvi lov (incf nvi)))                                                          ;; find a mapping of redundent new-variables onto first corresponding variables
        ((>= nvi lnv))
      (do ((ovi 0 (incf ovi)))
          ((>= ovi nvi))
        (when (and (type-eq (nth nvi types) (nth ovi types))                               ;; redundent only if type compatible
                   (every #'(lambda (p) (equal (nth nvi p) (nth ovi p))) new-pos-tuples)   ;; redundent only if all values in positive tuples are the same
                   (every #'(lambda (n) (equal (nth nvi n) (nth ovi n))) new-neg-tuples)   ;; redundent only if all values in negative tuples are the same
                   )
          (push (list (nth nvi vars) (nth ovi vars)) mapping)
          (setq ovi nvi))))
    (when mapping
      (let ((reduced-new-vars nil)
            (reduced-new-types nil))
        (do ((nvs new-vars (rest nvs))
             (nts new-types (rest new-types)))
            ((null nvs))
          (unless (member (first nvs) mapping :key #'first :test #'var-eq)
            (push (first nvs) reduced-new-vars)
            (push (first nts) reduced-new-types)))
        (setq new-vars (nreverse reduced-new-vars)
              new-types (nreverse reduced-new-types)))
      (unless new-vars
        (setq literals nil
              new-pos-tuples pos-tuples
              new-neg-tuples neg-tuples))
      (when new-vars
        (apply-mapping-to-literals literals mapping)                                      ;; map rededundent variables to corresponding variables in literal
        (do ((L literals (literal-next L)))                                               ;; delete unneeded object identity constaints
            ((null L))
          (when (and (literal-negated? L)
                     (eql (derivation-type (literal-derivation L)) :object)               ;; L introduced by object identity
                     (let* ((not-= (literal-variablization (literal-negated-literals L))) ;; L is there for of the form (not (= ?a ?b))
                            (a (first not-=))                                             ;; if ?a and ?b are equal or both are old vars delete constraint
                            (b (second not-=)))
                       (or (equal a b)
                           (and (member a old-vars)
                                (member b old-vars)))))
            (setf (literal-next (literal-prev L)) (literal-next L)
                  (literal-prev (literal-next L)) (literal-prev L))))
        (multiple-value-setq (new-pos-tuples new-neg-tuples)
          (insert-literal-tuples literals pos-tuples neg-tuples old-vars))))
    (values literals new-vars new-types new-pos-tuples new-neg-tuples)))

(defun create-literals-from-rs-and-vars (rs-and-vars vars type pos-tuples neg-tuples winners)
  (let ((literals nil)
        (last-literal nil)
        (new-var-id 0)
        (initial-pos pos-tuples)
        (initial-neg neg-tuples)
        (current-state-value (current-metric (length pos-tuples) (length neg-tuples)))
        (literals-vars vars)
        (literals-types type)
        (all-new-vars nil)
        (all-new-types nil)
        new-literal new-vars new-types new-pos-tuples new-neg-tuples r-struct variablization winner)
    (dolist (r.var rs-and-vars)
      (setq r-struct (first r.var)
            variablization (mapcar #'(lambda (v) (if (new-var? v) (make-pcvar :id (decf new-var-id)) v)) (rest r.var)))
      (multiple-value-setq (new-literal new-vars new-types new-pos-tuples new-neg-tuples)
        (create-literal r-struct variablization nil :determinate literals-vars pos-tuples neg-tuples literals-types))
      (multiple-value-setq (new-literal new-vars new-types new-pos-tuples new-neg-tuples)
        (remove-redundent-new-variables literals-vars literals-types new-vars new-types pos-tuples neg-tuples new-pos-tuples new-neg-tuples new-literal))
      (setq literals-vars (append literals-vars new-vars)
            literals-types (append literals-types new-types)
            all-new-vars (append all-new-vars new-vars)
            all-new-types (append all-new-types new-types)
            pos-tuples new-pos-tuples
            neg-tuples new-neg-tuples)
      (when new-literal
        (when last-literal
          (setf (literal-next last-literal) new-literal
                (literal-prev new-literal) last-literal))
        (unless literals (setq literals new-literal))
        (setq last-literal (last-literal literals))))
    (when literals
      (multiple-value-setq (winners winner)
        (update-winner winners
                       #'(lambda (s o n f) (declare (ignore s o n f)) t)  ;; force literals to front of winners   used to be   *literal-better-function*
                       nil
                       (GAIN-METRIC current-state-value
                                    (count-originals-extended initial-pos pos-tuples)
                                    (length pos-tuples)
                                    (length neg-tuples)
                                    (count-originals-extended initial-neg neg-tuples))
                       literals :determinate
                       :vars all-new-vars
                       :types all-new-types
                       :pos pos-tuples
                       :neg neg-tuples)))
    (values winners winner)))










