;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)

;;;______________________________________________________
;;; Types

(def-type :ROW 1 2 3 4 5 6 7 8)

(def-type :COLUMN 1 2 3 4 5 6 7 8)

;;;______________________________________________________
;;; Predicates - Extensionally Defined Relations

(def-pred NEAR_ROW
  :vars  (?ROW1 ?ROW2)
  :type  (:ROW :ROW)
  :mode  (:? :?)
  :pos ( (9 8) (8 9) (8 7) (7 8) (7 6) (6 7) (6 5) (5 6) (5 4) (4 5) (4 3) (3 4) (3 2) (2 3) (2 1) (1 2) )
  :neg ( (?0 ?1) )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  T
  :questions  ( (:FACT (?ROW1 IS NEAR ?ROW2)) )
   )

(def-pred EQUAL_ROW
  :vars  (?ROW1 ?ROW2)
  :type  (:ROW :ROW)
  :mode  (:+ :+)
  :pos ( (1 1) (2 2) (3 3) (4 4) (5 5) (6 6) (7 7) (8 8) )
  :neg ( (?0 ?1) )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  T
  :questions  ( (:FACT (?ROW1 IS EQUAL TO ?ROW2)) )
   )

(def-pred BETWEEN_ROW
  :vars  (?ROW1 ?ROW2 ?ROW3)
  :type  (:ROW :ROW :ROW)
  :mode  (:? :? :?)
  :pos ( (8 7 6) (8 7 5) (8 7 4) (8 7 3) (8 7 2) (8 7 1) (8 6 5) (8 6 4) (8 6 3) (8 6 2) 
         (8 6 1) (8 5 4) (8 5 3) (8 5 2) (8 5 1) (8 4 3) (8 4 2) (8 4 1) (8 3 2) (8 3 1) 
         (8 2 1) (7 6 5) (7 6 4) (7 6 3) (7 6 2) (7 6 1) (7 5 4) (7 5 3) (7 5 2) (7 5 1) 
         (7 4 3) (7 4 2) (7 4 1) (7 3 2) (7 3 1) (7 2 1) (6 7 8) (6 5 4) (6 5 3) (6 5 2) 
         (6 5 1) (6 4 3) (6 4 2) (6 4 1) (6 3 2) (6 3 1) (6 2 1) (5 7 8) (5 6 8) (5 6 7) 
         (5 4 3) (5 4 2) (5 4 1) (5 3 2) (5 3 1) (5 2 1) (4 7 8) (4 6 8) (4 6 7) (4 5 8) 
         (4 5 7) (4 5 6) (4 3 2) (4 3 1) (4 2 1) (3 7 8) (3 6 8) (3 6 7) (3 5 8) (3 5 7) 
         (3 5 6) (3 4 8) (3 4 7) (3 4 6) (3 4 5) (3 2 1) (2 7 8) (2 6 8) (2 6 7) (2 5 8) 
         (2 5 7) (2 5 6) (2 4 8) (2 4 7) (2 4 6) (2 4 5) (2 3 8) (2 3 7) (2 3 6) (2 3 5) 
         (2 3 4) (1 7 8) (1 6 8) (1 6 7) (1 5 8) (1 5 7) (1 5 6) (1 4 8) (1 4 7) (1 4 6) 
         (1 4 5) (1 3 8) (1 3 7) (1 3 6) (1 3 5) (1 3 4) (1 2 8) (1 2 7) (1 2 6) (1 2 5) 
         (1 2 4) (1 2 3) )
  :neg ( (?0 ?1 ?2) )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  NIL
  :questions  ( (:FACT (?ROW3 IS BETWEEN ?ROW1 AND ?ROW2)) )
   )

(def-pred NEAR_COLUMN
  :vars  (?COLUMN1 ?COLUMN2)
  :type  (:COLUMN :COLUMN)
  :mode  (:? :?)
  :pos ( (9 8) (8 9) (8 7) (7 8) (7 6) (6 7) (6 5) (5 6) (5 4) (4 5) (4 3) (3 4) (3 2) (2 3) 
         (2 1) (1 2) )
  :neg ( (?0 ?1) )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  T
  :questions  ( (:FACT (?COLUMN1 IS NEAR ?COLUMN2)) )
   )

(def-pred EQUAL_COLUMN
  :vars  (?COLUMN1 ?COLUMN2)
  :type  (:COLUMN :COLUMN)
  :mode  (:+ :+)
  :pos ( (1 1) (2 2) (3 3) (4 4) (5 5) (6 6) (7 7) (8 8) )
  :neg ( (?0 ?1) )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  T
  :questions  ( (:FACT (?COLUMN1 IS EQUAL TO ?COLUMN2)) )
   )

(def-pred BETWEEN_COLUMN
  :vars  (?COLUMN1 ?COLUMN1 ?COLUMN1)
  :type  (:COLUMN :COLUMN :COLUMN)
  :mode  (:? :? :?)
  :pos ( (8 7 6) (8 7 5) (8 7 4) (8 7 3) (8 7 2) (8 7 1) (8 6 5) (8 6 4) (8 6 3) (8 6 2) 
         (8 6 1) (8 5 4) (8 5 3) (8 5 2) (8 5 1) (8 4 3) (8 4 2) (8 4 1) (8 3 2) (8 3 1) 
         (8 2 1) (7 6 5) (7 6 4) (7 6 3) (7 6 2) (7 6 1) (7 5 4) (7 5 3) (7 5 2) (7 5 1) 
         (7 4 3) (7 4 2) (7 4 1) (7 3 2) (7 3 1) (7 2 1) (6 7 8) (6 5 4) (6 5 3) (6 5 2) 
         (6 5 1) (6 4 3) (6 4 2) (6 4 1) (6 3 2) (6 3 1) (6 2 1) (5 7 8) (5 6 8) (5 6 7) 
         (5 4 3) (5 4 2) (5 4 1) (5 3 2) (5 3 1) (5 2 1) (4 7 8) (4 6 8) (4 6 7) (4 5 8) 
         (4 5 7) (4 5 6) (4 3 2) (4 3 1) (4 2 1) (3 7 8) (3 6 8) (3 6 7) (3 5 8) (3 5 7) 
         (3 5 6) (3 4 8) (3 4 7) (3 4 6) (3 4 5) (3 2 1) (2 7 8) (2 6 8) (2 6 7) (2 5 8) 
         (2 5 7) (2 5 6) (2 4 8) (2 4 7) (2 4 6) (2 4 5) (2 3 8) (2 3 7) (2 3 6) (2 3 5) 
         (2 3 4) (1 7 8) (1 6 8) (1 6 7) (1 5 8) (1 5 7) (1 5 6) (1 4 8) (1 4 7) (1 4 6) 
         (1 4 5) (1 3 8) (1 3 7) (1 3 6) (1 3 5) (1 3 4) (1 2 8) (1 2 7) (1 2 6) (1 2 5) 
         (1 2 4) (1 2 3) )
  :neg ( (?0 ?1 ?2) )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  NIL
  :questions  ( (:FACT (?COLUMN3 IS BETWEEN ?COLUMN1 AND ?COLUMN2)) )
   )

(def-pred KNIGHT
  :vars  (?START_R ?START_C ?END_R ?END_C)
  :type  (:ROW :COLUMN :ROW :COLUMN)
  :mode  (:? :? :? :?)
  :pos ( (8 8 7 6) (8 8 6 7) (8 7 6 8) (8 7 7 5) (8 7 6 6) (8 6 7 8) (8 6 6 7) 
         (8 6 7 4) (8 6 6 5) (8 5 7 7) (8 5 6 6) (8 5 7 3) (8 5 6 4) (8 4 7 6) 
         (8 4 6 5) (8 4 7 2) (8 4 6 3) (8 3 7 5) (8 3 6 4) (8 3 7 1) (8 3 6 2) 
         (8 2 7 4) (8 2 6 3) (8 2 6 1) (8 1 7 3) (8 1 6 2) (7 8 8 6) (7 8 6 6) 
         (7 8 5 7) (7 7 5 8) (7 7 8 5) (7 7 6 5) (7 7 5 6) (7 6 6 8) (7 6 5 7) 
         (7 6 8 4) (7 6 6 4) (7 6 5 5) (7 6 8 8) (7 5 6 7) (7 5 5 6) (7 5 8 3) 
         (7 5 6 3) (7 5 5 4) (7 5 8 7) (7 4 6 6) (7 4 5 5) (7 4 8 2) (7 4 6 2) 
         (7 4 5 3) (7 4 8 6) (7 3 6 5) (7 3 5 4) (7 3 8 1) (7 3 6 1) (7 3 5 2) 
         (7 3 8 5) (7 2 6 4) (7 2 5 3) (7 2 5 1) (7 2 8 4) (7 1 6 3) (7 1 5 2) 
         (7 1 8 3) (6 8 8 7) (6 8 7 6) (6 8 5 6) (6 8 4 7) (6 7 4 8) (6 7 8 6) 
         (6 7 7 5) (6 7 5 5) (6 7 4 6) (6 7 8 8) (6 6 5 8) (6 6 4 7) (6 6 8 5) 
         (6 6 7 4) (6 6 5 4) (6 6 4 5) (6 6 8 7) (6 6 7 8) (6 5 5 7) (6 5 4 6) 
         (6 5 8 4) (6 5 7 3) (6 5 5 3) (6 5 4 4) (6 5 8 6) (6 5 7 7) (6 4 5 6) 
         (6 4 4 5) (6 4 8 3) (6 4 7 2) (6 4 5 2) (6 4 4 3) (6 4 8 5) (6 4 7 6) 
         (6 3 5 5) (6 3 4 4) (6 3 8 2) (6 3 7 1) (6 3 5 1) (6 3 4 2) (6 3 8 4) 
         (6 3 7 5) (6 2 5 4) (6 2 4 3) (6 2 8 1) (6 2 4 1) (6 2 8 3) (6 2 7 4) 
         (6 1 5 3) (6 1 4 2) (6 1 8 2) (6 1 7 3) (5 8 7 7) (5 8 6 6) (5 8 4 6) 
         (5 8 3 7) (5 7 3 8) (5 7 7 6) (5 7 6 5) (5 7 4 5) (5 7 3 6) (5 7 7 8) 
         (5 6 4 8) (5 6 3 7) (5 6 7 5) (5 6 6 4) (5 6 4 4) (5 6 3 5) (5 6 7 7) 
         (5 6 6 8) (5 5 4 7) (5 5 3 6) (5 5 7 4) (5 5 6 3) (5 5 4 3) (5 5 3 4) 
         (5 5 7 6) (5 5 6 7) (5 4 4 6) (5 4 3 5) (5 4 7 3) (5 4 6 2) (5 4 4 2) 
         (5 4 3 3) (5 4 7 5) (5 4 6 6) (5 3 4 5) (5 3 3 4) (5 3 7 2) (5 3 6 1) 
         (5 3 4 1) (5 3 3 2) (5 3 7 4) (5 3 6 5) (5 2 4 4) (5 2 3 3) (5 2 7 1) 
         (5 2 3 1) (5 2 7 3) (5 2 6 4) (5 1 4 3) (5 1 3 2) (5 1 7 2) (5 1 6 3) 
         (4 8 6 7) (4 8 5 6) (4 8 3 6) (4 8 2 7) (4 7 2 8) (4 7 6 6) (4 7 5 5) 
         (4 7 3 5) (4 7 2 6) (4 7 6 8) (4 6 3 8) (4 6 2 7) (4 6 6 5) (4 6 5 4) 
         (4 6 3 4) (4 6 2 5) (4 6 6 7) (4 6 5 8) (4 5 3 7) (4 5 2 6) (4 5 6 4) 
         (4 5 5 3) (4 5 3 3) (4 5 2 4) (4 5 6 6) (4 5 5 7) (4 4 3 6) (4 4 2 5) 
         (4 4 6 3) (4 4 5 2) (4 4 3 2) (4 4 2 3) (4 4 6 5) (4 4 5 6) (4 3 3 5) 
         (4 3 2 4) (4 3 6 2) (4 3 5 1) (4 3 3 1) (4 3 2 2) (4 3 6 4) (4 3 5 5) 
         (4 2 3 4) (4 2 2 3) (4 2 6 1) (4 2 2 1) (4 2 6 3) (4 2 5 4) (4 1 3 3) 
         (4 1 2 2) (4 1 6 2) (4 1 5 3) (3 8 5 7) (3 8 4 6) (3 8 2 6) (3 8 1 7) 
         (3 7 1 8) (3 7 5 6) (3 7 4 5) (3 7 2 5) (3 7 1 6) (3 7 5 8) (3 6 2 8) 
         (3 6 1 7) (3 6 5 5) (3 6 4 4) (3 6 2 4) (3 6 1 5) (3 6 5 7) (3 6 4 8) 
         (3 5 2 7) (3 5 1 6) (3 5 5 4) (3 5 4 3) (3 5 2 3) (3 5 1 4) (3 5 5 6) 
         (3 5 4 7) (3 4 2 6) (3 4 1 5) (3 4 5 3) (3 4 4 2) (3 4 2 2) (3 4 1 3) 
         (3 4 5 5) (3 4 4 6) (3 3 2 5) (3 3 1 4) (3 3 5 2) (3 3 4 1) (3 3 2 1) 
         (3 3 1 2) (3 3 5 4) (3 3 4 5) (3 2 2 4) (3 2 1 3) (3 2 5 1) (3 2 1 1) 
         (3 2 5 3) (3 2 4 4) (3 1 2 3) (3 1 1 2) (3 1 5 2) (3 1 4 3) (2 8 4 7) 
         (2 8 3 6) (2 8 1 6) (2 7 4 6) (2 7 3 5) (2 7 1 5) (2 7 4 8) (2 6 1 8) 
         (2 6 4 5) (2 6 3 4) (2 6 1 4) (2 6 4 7) (2 6 3 8) (2 5 1 7) (2 5 4 4) 
         (2 5 3 3) (2 5 1 3) (2 5 4 6) (2 5 3 7) (2 4 1 6) (2 4 4 3) (2 4 3 2) 
         (2 4 1 2) (2 4 4 5) (2 4 3 6) (2 3 1 5) (2 3 4 2) (2 3 3 1) (2 3 1 1) 
         (2 3 4 4) (2 3 3 5) (2 2 1 4) (2 2 4 1) (2 2 4 3) (2 2 3 4) (2 1 1 3) 
         (2 1 4 2) (2 1 3 3) (1 8 3 7) (1 8 2 6) (1 7 3 6) (1 7 2 5) (1 7 3 8) 
         (1 6 3 5) (1 6 2 4) (1 6 3 7) (1 6 2 8) (1 5 3 4) (1 5 2 3) (1 5 3 6) 
         (1 5 2 7) (1 4 3 3) (1 4 2 2) (1 4 3 5) (1 4 2 6) (1 3 3 2) (1 3 2 1) 
         (1 3 3 4) (1 3 2 5) (1 2 3 1) (1 2 3 3) (1 2 2 4) (1 1 3 2) (1 1 2 3) )
  :neg ( (?0 ?1 ?2 ?3) )
  :induction    NIL
  :constraint   :UNIQUE-VARS
  :commutative  NIL
  :questions  ( (:FACT (?START_R ?START_C IS A KNIGHT MOVE FROM ?END_R ?END_C)) )
   )

(def-pred ILLEGAL_FACT
  :vars  (?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C)
  :type  (:ROW :COLUMN :ROW :COLUMN :ROW :COLUMN)
  :mode  ()
  :pos ((3 7 5 6 1 6) (5 3 1 8 1 6) (3 5 5 2 4 4) (1 3 6 5 6 8) (8 1 5 8 2 8) (5 6 3 7 5 6)
        (5 3 3 8 4 2) (8 3 2 6 7 4) (2 5 4 7 4 4) (2 7 7 8 7 5) (3 8 6 2 8 2) (5 7 7 4 7 6)
        (5 2 2 1 2 5) (4 5 5 5 5 3) (4 8 4 2 5 2) (7 1 4 3 7 3) (4 2 1 7 3 7) (1 7 8 4 8 3)
        (8 7 7 2 5 2) (5 1 7 2 7 2) (3 3 1 3 1 2) (2 7 3 7 2 7) (5 6 6 3 4 7) (2 8 5 2 5 2)
        (2 7 6 3 3 6) (5 7 4 8 4 1) (3 4 6 1 6 8) (3 5 3 6 3 8) (3 4 2 3 2 8) (5 7 8 4 1 4)
        (1 8 6 8 4 8) (3 3 4 1 7 1) (8 8 1 8 1 3) (3 2 8 4 8 6) (2 6 1 8 1 4) (4 6 1 4 4 6)
        (2 2 8 8 4 8) (4 4 4 4 8 7) (7 4 1 3 8 3) (2 7 7 4 6 4) (1 2 4 5 3 5) (2 7 2 6 8 6)
        (1 4 7 4 1 5) (5 5 5 4 5 6) (5 5 8 4 8 2) (1 7 4 5 4 6) (2 7 3 2 6 2) (7 8 8 3 7 7)
        (1 4 8 1 8 5) (5 5 3 1 4 5) (6 4 7 8 6 3) (3 6 7 8 3 5) (4 1 8 2 8 3) (2 7 6 5 6 2)
        (6 2 2 8 6 1) (5 1 4 1 3 1) (1 4 3 7 6 7) (3 2 2 1 8 1) (1 1 4 7 6 7) (1 7 3 3 1 6)
        (8 6 1 1 1 6) (1 7 2 7 7 7) (3 8 3 8 2 5) (6 6 8 4 8 1) (6 4 6 4 2 8) (8 8 6 6 6 3)
        (4 1 8 8 4 1) (4 5 4 3 5 3) (5 1 7 5 7 8) (8 6 1 5 1 1) (7 3 5 8 7 2) (6 2 7 5 6 1)
        (4 8 4 5 8 5) (4 8 1 3 1 8) (5 1 6 6 6 3) (3 7 3 6 4 7) (2 2 7 6 1 6) (8 4 3 6 8 3)
        (5 4 1 5 6 4) (5 4 7 5 5 5) (6 1 2 5 2 7) (4 3 8 6 3 4) (5 2 6 1 4 3) (8 2 3 3 8 2)
        (3 3 2 1 2 8) (4 8 8 1 8 3) (5 7 7 1 7 5) (3 6 3 3 4 5) (6 8 5 6 6 6) (6 7 5 5 5 2)
        (7 7 7 5 7 4) (3 1 7 7 8 7) (7 3 8 2 8 1) (1 1 2 4 2 6) (7 5 2 6 6 6) (6 8 5 1 5 3)
        (1 8 8 3 8 6) (5 8 2 6 2 2) (3 2 7 2 2 1) (3 1 6 8 6 1) (5 8 1 8 1 7) (2 2 1 5 5 5)
        (5 8 2 1 8 1) (2 7 6 2 3 2) (4 1 7 3 2 3) (1 6 3 6 7 6) (6 3 8 2 8 6) (7 3 1 1 1 8)
        (8 5 4 2 4 5) (8 7 6 4 5 4) (7 8 7 7 7 7) (6 6 7 8 5 6) (3 5 1 8 1 1) (8 8 4 8 7 8)
        (6 1 2 7 2 3) (1 8 6 8 6 1) (4 3 8 6 2 6) (8 2 5 2 3 2) (4 6 1 4 3 7) (5 1 2 4 2 8)
        (5 8 1 2 6 2) (1 1 6 4 6 4) (2 1 8 1 1 2) (4 6 4 2 3 7) (3 8 6 5 6 7) (8 8 4 1 4 1)
        (5 4 5 4 8 5) (2 8 3 4 3 3) (4 7 7 8 7 8) (4 5 2 4 2 2) (8 2 5 4 6 4) (5 4 5 6 5 8)
        (8 5 5 5 5 7) (8 8 1 8 1 1) (2 2 6 8 2 1) (7 5 7 6 2 6) (6 4 4 8 6 8) (7 2 7 2 1 1)
        (2 6 1 6 1 3) (3 5 5 7 3 4) (4 2 2 7 2 7) (7 5 4 8 3 8) (4 6 2 1 2 4) (3 5 2 4 6 4)
        (1 1 5 6 5 2) (7 4 5 3 6 4) (5 3 1 5 8 5) (8 4 3 3 7 4) (4 6 8 3 7 3) (7 7 7 7 3 4)
        (1 2 2 2 2 2) (3 8 3 1 4 8) (5 2 5 6 4 1) (3 8 5 4 6 4) (1 8 6 8 2 7) (6 6 5 5 5 7)
        (4 6 7 2 3 7) (8 5 1 4 7 5) (8 4 4 5 4 6) (3 3 3 4 3 5) (3 1 4 6 7 6) (5 4 1 5 7 5)
        (8 5 6 8 6 5) (5 8 5 6 1 6) (2 7 4 8 4 7) (4 4 6 3 4 5) (8 3 4 8 7 8) (5 4 8 4 8 1)
        (8 4 8 7 4 7) (1 2 3 5 3 4) (8 4 8 6 7 6) (4 7 1 1 1 5) (3 8 6 3 5 3) (3 4 4 8 4 4)
        (2 3 2 6 2 4) (8 6 1 7 5 7) (2 4 4 7 4 5) (5 2 5 8 6 2) (3 7 3 1 1 1) (7 7 5 8 1 8)
        (8 3 8 7 8 7) (2 4 5 6 2 4) (4 7 3 4 5 7) (1 8 5 6 5 1) (3 5 3 4 2 5) (1 4 5 8 2 5)
        (5 7 5 7 7 5) (5 6 3 7 3 1) (7 4 6 1 8 3) (6 1 2 6 2 2) (6 2 5 2 7 1) (1 8 3 5 2 8)
        (4 7 5 4 5 5) (7 3 3 6 2 6) (6 3 3 1 7 2) (7 2 2 8 7 2) (2 4 2 2 1 5) (5 1 1 4 1 4)
        (3 8 6 4 6 1) (3 4 8 8 3 3) (3 8 4 6 7 6) (4 6 5 7 5 7) (5 2 4 7 4 4) (5 2 5 8 5 7)
        (3 4 7 6 6 6) (6 5 4 2 2 2) (6 8 6 3 7 7) (4 5 2 3 2 3) (6 7 3 1 5 8) (4 5 4 3 5 3)
        (3 3 3 3 5 5) (4 4 5 3 4 4) (6 1 8 4 8 1) (3 8 8 2 3 2) (6 3 3 7 4 7) (1 5 8 3 8 3)
        (5 2 3 3 5 3) (5 3 4 5 7 5) (1 8 1 5 7 5) (6 3 7 7 7 2) (8 5 4 2 6 2) (5 4 2 4 2 5)
        (1 8 2 2 2 7) (3 8 2 3 4 7) (8 1 7 4 7 3) (8 5 4 1 4 3) (8 8 7 5 3 5) (2 3 4 7 4 8)
        (7 4 5 2 8 2) (4 4 5 4 3 3) (5 2 4 4 5 1) (2 3 4 5 3 5) (1 2 1 4 6 4))
  :neg ((3 8 6 1 8 5) (8 6 4 1 1 8) (1 8 6 7 4 8) (4 4 7 3 4 8) (8 8 1 6 4 7) (4 2 7 7 1 4)
        (8 4 4 1 7 8) (4 7 1 4 4 5) (7 8 2 7 7 6) (3 5 1 5 7 5) (2 2 5 5 4 4) (7 6 4 6 3 8)
        (5 1 5 6 1 8) (8 4 4 7 1 1) (1 3 8 1 6 2) (3 1 7 8 6 1) (7 2 7 8 1 6) (5 6 7 1 6 2)
        (6 5 2 3 5 7) (6 6 7 5 8 1) (5 6 3 7 7 1) (4 7 8 5 5 2) (3 1 8 8 7 4) (7 7 1 1 3 2)
        (4 6 4 5 5 3) (4 4 4 3 8 8) (2 8 1 8 5 4) (4 3 2 1 7 2) (7 3 6 3 8 6) (6 6 6 7 1 5)
        (5 2 2 7 3 2) (2 2 4 3 7 8) (1 4 4 2 5 5) (3 8 6 2 4 5) (3 5 4 2 5 7) (7 4 1 6 2 1)
        (8 3 8 1 8 8) (4 5 5 7 8 5) (4 6 7 5 2 8) (5 5 8 2 5 3) (8 6 4 4 3 2) (2 3 8 2 2 8)
        (6 8 2 4 3 8) (1 8 8 6 6 8) (8 1 3 8 2 1) (6 2 7 6 2 7) (3 7 8 1 1 4) (1 2 3 8 4 1)
        (2 3 6 5 5 2) (1 8 7 2 5 5) (4 7 2 6 6 7) (8 1 1 8 7 3) (8 3 3 6 4 2) (2 2 3 3 7 4)
        (6 3 5 4 2 1) (6 2 4 1 3 8) (2 8 4 3 8 7) (7 2 8 5 1 8) (7 6 6 6 4 3) (6 2 1 1 7 6)
        (4 3 1 6 3 7) (8 4 8 6 1 2) (4 7 3 6 7 5) (3 2 7 6 8 2) (2 3 8 7 5 8) (1 1 5 3 6 7)
        (2 8 8 8 7 3) (1 1 4 8 6 5) (7 1 5 8 7 3) (5 1 7 8 1 1) (8 8 2 6 4 3) (6 2 8 7 6 5)
        (1 2 4 8 6 2) (1 4 6 4 1 7) (6 7 7 3 5 5) (1 5 2 8 5 7) (2 4 6 1 2 2) (4 6 2 4 1 2)
        (1 6 1 2 5 6) (2 1 4 8 3 6) (3 1 4 1 3 8) (4 7 4 1 5 2) (1 3 5 6 1 8) (6 5 4 3 2 4)
        (1 6 1 8 3 5) (6 2 1 7 2 6) (7 4 5 1 3 8) (4 7 5 6 4 4) (4 1 2 5 4 4) (2 6 5 6 4 8)
        (4 3 6 2 8 7) (7 5 5 2 1 6) (2 6 5 4 1 3) (1 5 4 2 6 6) (1 3 4 5 3 2) (2 4 1 5 5 7)
        (6 7 3 4 4 3) (4 4 5 3 8 7) (4 7 1 2 6 6) (7 5 7 2 6 7) (2 8 1 6 5 7) (2 4 1 4 6 6)
        (3 3 5 5 4 7) (4 5 2 2 3 1) (6 5 7 6 6 2) (7 8 8 2 6 3) (6 1 8 6 6 5) (2 8 2 3 8 8)
        (5 4 1 3 5 1) (8 5 2 6 5 7) (3 5 3 7 5 6) (5 6 6 7 3 2) (5 5 3 6 1 3) (2 6 4 8 8 2)
        (8 7 5 5 3 2) (3 5 1 7 7 6) (4 7 6 6 4 5) (2 2 2 6 7 5) (8 4 1 7 5 2) (8 1 7 1 2 8)
        (7 3 4 4 6 8) (4 1 6 2 1 7) (6 6 5 4 8 5) (2 8 1 3 3 4) (4 5 5 2 7 8) (1 4 8 4 4 5)
        (6 8 7 5 2 8) (8 6 7 2 3 6) (2 6 3 6 5 8) (6 6 7 2 2 3) (6 4 4 4 2 1) (4 8 2 3 5 1)
        (7 7 1 3 6 4) (2 6 8 6 1 8) (8 5 1 4 6 5) (2 3 5 5 1 7) (4 4 5 5 3 6) (1 4 3 6 6 5)
        (1 1 1 6 6 2) (4 5 1 4 2 2) (2 1 3 2 6 4) (4 3 5 7 4 1) (8 7 1 2 7 5) (8 3 6 1 3 8)
        (2 5 8 6 6 5) (4 6 5 4 6 3) (3 1 4 5 2 4) (2 2 5 7 8 3) (2 2 2 6 8 1) (3 6 8 5 7 7)
        (3 3 4 8 5 7) (2 8 4 4 1 3) (1 5 5 3 6 8) (3 1 1 5 5 1) (2 5 8 8 5 2) (8 6 2 5 7 4)
        (4 7 2 2 1 4) (6 6 7 3 4 8) (2 1 5 6 1 4) (8 7 3 5 1 2) (6 8 2 5 1 2) (8 5 2 8 6 5)
        (8 3 2 4 1 5) (3 1 5 1 6 5) (6 5 6 7 2 5) (2 7 8 4 5 7) (3 6 8 7 6 3) (4 8 1 1 7 3)
        (7 4 3 2 2 5) (8 2 3 5 6 4) (7 5 8 6 3 1) (5 6 7 4 8 5) (4 2 2 6 8 7) (8 6 3 4 5 5)
        (8 5 2 4 7 7) (2 6 6 8 3 4) (2 3 1 2 4 8) (6 1 5 6 4 4) (4 1 3 1 5 7) (2 5 2 3 4 6)
        (4 5 5 5 1 2) (8 4 1 3 7 7) (7 4 2 6 4 1) (3 2 8 8 7 2) (6 3 7 8 1 6) (7 4 3 7 7 6)
        (8 5 8 1 6 8) (6 4 3 5 4 1) (7 6 7 5 8 4) (7 5 4 1 2 3) (2 4 6 3 7 1) (4 3 2 4 3 8)
        (7 3 3 7 2 5) (1 1 3 2 7 4) (2 5 3 2 5 6) (5 6 6 7 3 2) (7 8 5 3 6 6) (1 2 1 1 8 6)
        (7 8 5 4 6 6) (3 4 1 1 8 4) (6 8 3 2 8 6) (1 4 6 8 4 2) (2 4 8 5 3 1) (5 3 6 4 2 3)
        (5 8 6 3 8 7) (1 4 7 8 4 5) (1 5 3 1 4 7) (2 8 4 6 2 1) (4 6 1 2 6 4) (6 1 2 1 7 3)
        (6 6 3 1 7 3) (2 8 8 3 7 2) (7 2 1 1 5 6) (4 5 1 3 7 5) (3 6 2 7 5 3) (4 4 8 4 2 1)
        (7 7 5 7 7 1) (8 1 3 7 4 1) (1 4 7 7 4 4) (7 8 2 3 6 4) (6 5 1 3 6 2) (4 1 1 3 7 4)
        (2 3 7 6 4 1) (5 3 4 4 5 6) (5 3 4 7 7 2) (5 7 6 5 3 6) (5 5 6 1 4 2) (8 2 8 1 4 5)
        (1 2 5 3 7 8) (7 3 8 6 2 8) (1 6 5 7 8 8) (4 8 2 6 1 2) (7 2 8 8 5 1) (5 2 6 7 4 8)
        (2 2 5 3 3 4) (1 1 7 8 3 1) (8 4 4 3 8 2) (5 4 5 7 7 2) (1 8 8 2 7 5) (1 6 6 8 2 1)
        (7 6 5 2 2 7) (7 6 6 3 3 7) (8 1 7 7 8 6) (3 1 7 1 6 4) (1 8 1 7 2 6) (5 7 8 7 1 2)
        (3 7 4 3 2 1) (2 1 4 6 5 4) (6 4 8 7 3 3) (5 3 6 4 8 6) (3 1 3 6 1 5) (8 6 1 4 2 2)
        (7 8 5 5 8 1) (7 3 1 3 4 1) (8 7 6 7 4 3) (7 8 7 6 2 3) (7 7 8 4 1 8) (7 8 2 1 3 4)
        (4 8 8 4 4 6) (3 7 8 8 7 2) (4 4 2 8 5 1) (2 4 4 3 8 2) (7 2 2 7 3 5) (3 3 5 3 4 8)
        (8 1 6 2 7 7) (6 1 7 7 1 1) (7 5 8 3 5 8) (1 6 2 8 1 3) (2 5 6 3 2 2) (4 6 1 8 2 3)
        (5 5 4 8 8 4) (8 2 3 4 6 2) (5 8 4 4 7 7) (4 6 4 8 4 2) (3 4 6 2 5 5) (7 2 3 1 7 6)
        (4 6 7 5 4 8) (5 3 4 2 1 3) (1 6 2 3 5 2) (2 2 4 4 5 8) (4 4 5 2 1 3) (8 6 2 5 3 8)
        (2 1 6 7 5 1) (3 4 4 4 2 6) (6 6 6 1 2 6) (6 4 4 5 7 8) (3 7 1 7 6 1) (3 1 4 7 1 3)
        (3 2 5 7 6 2) (7 1 7 7 1 2) (2 8 4 4 8 2) (1 3 1 2 7 8) (1 8 7 6 4 8) (5 7 3 7 2 2)
        (4 1 2 6 6 5) (5 5 1 8 4 2) (4 3 7 7 1 8) (7 4 2 1 3 6) (1 4 1 3 6 1) (7 6 7 8 2 1)
        (3 8 4 8 7 6) (2 3 2 1 4 6) (8 6 1 8 6 2) (3 3 6 6 1 3) (7 3 8 5 1 7) (2 6 5 8 4 3)
        (5 3 8 2 2 3) (6 4 5 3 3 7) (1 6 8 8 4 1) (8 5 2 5 4 1) (3 1 3 4 4 7) (5 3 6 5 2 6)
        (6 2 3 8 5 5) (2 8 3 7 8 4) (4 1 5 1 2 7) (8 3 7 1 2 2) (8 1 7 8 8 4) (2 4 3 3 2 1)
        (1 5 1 6 7 3) (8 6 3 1 2 8) (7 4 7 1 4 4) (5 6 3 2 4 3) (7 4 8 5 4 1) (3 5 1 7 7 5)
        (5 6 8 5 2 2) (1 4 5 6 6 2) (4 3 5 8 1 5) (8 6 7 2 8 3) (2 7 7 6 6 1) (7 8 2 6 1 2)
        (1 5 3 5 8 1) (1 5 7 8 8 5) (8 7 3 8 7 3) (3 3 8 7 6 2) (1 7 8 4 5 8) (1 3 7 8 2 5)
        (8 6 7 1 6 2) (5 2 2 7 7 4) (5 8 2 1 1 4) (2 2 4 1 5 7) (1 3 7 4 6 5) (7 8 5 3 7 1)
        (6 1 4 7 6 5) (4 2 8 5 1 1) (8 8 8 2 6 7) (2 2 5 8 1 4) (8 3 8 8 6 6) (4 1 6 2 1 6)
        (4 1 7 2 1 8) (7 5 2 5 6 8) (4 6 3 6 6 8) (3 1 6 4 2 6) (8 6 2 6 5 3) (8 4 8 5 3 8)
        (4 3 3 2 1 7) (1 4 6 5 8 8) (7 1 8 1 2 4) (5 3 4 2 3 8) (8 3 1 7 5 4) (1 4 2 7 1 2)
        (4 5 6 4 7 1) (2 6 5 4 1 8) (6 2 5 5 4 8) (1 2 5 6 2 7) (2 3 4 2 7 3) (5 5 5 3 7 6)
        (3 6 3 7 4 8) (8 1 4 1 2 4) (3 6 3 1 8 5) (7 3 1 5 3 6) (3 5 3 7 8 5) (5 7 4 3 8 5)
        (2 2 4 1 5 7) (2 5 3 6 6 5) (7 6 8 4 3 5) (6 2 3 3 8 7) (8 4 8 7 3 3) (2 1 7 5 8 7)
        (5 1 7 3 6 7) (4 1 4 8 6 2) (6 4 1 2 4 1) (7 7 7 3 1 1) (8 6 4 2 5 4) (5 3 4 8 8 6)
        (8 7 2 1 6 6) (1 8 5 1 6 7) (5 5 5 1 3 4) (5 1 2 7 3 3) (1 5 6 4 2 8) (5 7 4 5 3 6)
        (7 8 4 2 1 4) (2 1 8 5 2 8) (3 1 7 5 4 6) (1 6 4 4 3 3) (8 8 6 8 8 3) (8 8 8 5 3 2)
        (4 3 5 3 6 5) (8 1 7 1 8 7) (3 6 5 5 8 8) (1 2 1 8 6 4) (6 1 6 3 1 5) (7 7 3 3 8 5)
        (6 7 4 7 3 1) (2 2 8 3 5 1) (1 7 8 2 6 1) (6 7 7 1 2 7) (1 3 7 5 2 1) (2 7 4 5 7 1))
  :induction    NIL
  :constraint   NIL
  :commutative  NIL
  )


(def-rule SAME_LOC
  :vars  (?ROW1 ?COLUMN1 ?ROW2 ?COLUMN2)
  :type  (:ROW :COLUMN :ROW :COLUMN)
  :mode  (:+ :+ :+ :+)
  :clauses
     ( ((SAME_LOC ?ROW1 ?COLUMN1 ?ROW2 ?COLUMN2) (EQUAL_ROW ?ROW1 ?ROW2) (EQUAL_COLUMN ?COLUMN1 ?COLUMN2))
     )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  NIL
  :questions    (POSITION ?ROW1 ?COLUMN1 IS THE SAME LOCATION AS POSITION ?ROW2 ?COLUMN2)
  )

(def-rule KING_ATTACK_KING
  :vars  (?WK_R ?WK_C ?BK_R ?BK_C)
  :type  (:ROW :COLUMN :ROW :COLUMN)
  :mode  (:+ :+ :+ :+)
  :clauses
     ( ((KING_ATTACK_KING ?WK_R ?WK_C ?BK_R ?BK_C) (NEAR_ROW ?WK_R ?BK_R) (NEAR_COLUMN ?WK_C ?BK_C))
       ((KING_ATTACK_KING ?WK_R ?WK_C ?BK_R ?BK_C) (EQUAL_ROW ?WK_R ?BK_R) (NEAR_COLUMN ?WK_C ?BK_C))
       ((KING_ATTACK_KING ?WK_R ?WK_C ?BK_R ?BK_C) (KNIGHT ?WK_R ?WK_C ?BK_R ?BK_C))
       ((KING_ATTACK_KING ?WK_R ?WK_C ?BK_R ?BK_C) (NEAR_ROW ?WK_R ?BK_R) (EQUAL_COLUMN ?WK_C ?BK_C))
     )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  NIL
  :questions    (THE WHITE KING AT POSITION ?WK_R ?WK_C CAN ATTACK THE BLACK KING AT POSITION ?BK_R ?BK_C)
  )

(def-rule ROOK_ATTACK_KING
  :vars  (?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C)
  :type  (:ROW :COLUMN :ROW :COLUMN :ROW :COLUMN)
  :mode  (:+ :+ :+ :+ :+ :+)
  :clauses
     ( ((ROOK_ATTACK_KING ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (EQUAL_ROW ?WR_R ?BK_R))
       ((ROOK_ATTACK_KING ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (EQUAL_COLUMN ?WR_C ?BK_C))
     )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  NIL
  :questions    (WITH WHITE KING AT POSITION ?WK_R ?WK_C THE WHITE ROOK AT POSITION ?WR_R ?WR_R CAN ATTACK THE BLACK KING AT POSITION ?BK_R ?BK_C)
  )

(def-rule IN_CHECK
  :vars  (?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C)
  :type  (:ROW :COLUMN :ROW :COLUMN :ROW :COLUMN)
  :mode  (:+ :+ :+ :+ :+ :+)
  :clauses
     ( ((IN_CHECK ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (KING_ATTACK_KING ?WK_R ?WK_C ?BK_R ?BK_C))
       ((IN_CHECK ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (ROOK_ATTACK_KING ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C))
     )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  NIL
  :questions    (THE BLACK KING IS IN CHECK IN THE BOARD CONFIGURATION ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C)
  )

(def-rule INVALID
  :vars  (?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C)
  :type  (:ROW :COLUMN :ROW :COLUMN :ROW :COLUMN)
  :mode  (:+ :+ :+ :+ :+ :+)
  :clauses
     ( ((INVALID ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (SAME_LOC ?WK_R ?WK_C ?WR_R ?WR_C))
       ((INVALID ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (SAME_LOC ?WR_R ?WR_C ?BK_R ?BK_C))
       ((INVALID ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (SAME_LOC ?WK_R ?WK_C ?BK_R ?BK_C))
     )
  :induction    T
  :constraint   :UNIQUE-VARS
  :commutative  NIL
  :questions    (INVALID BOARD CONFIGURATION ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C)
  )

(def-rule ILLEGAL_RULE
  :vars  (?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C)
  :type  (:ROW :COLUMN :ROW :COLUMN :ROW :COLUMN)
  :mode  (:+ :+ :+ :+ :+ :+)
  :clauses
     ( ((ILLEGAL_RULE ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (IN_CHECK ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C))
       ((ILLEGAL_RULE ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C) (INVALID ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C))
     )
  :induction    NIL
  :constraint   :UNIQUE-VARS
  :commutative  (ILLEGAL BOARD CONFIGURATION ?WK_R ?WK_C ?WR_R ?WR_C ?BK_R ?BK_C)
  )

(def-focl-problem ILLEGAL_FACT
  :GOAL-CONCEPT-NAME ILLEGAL_RULE
  :MAX-NEW-VARIABLES 2
  :INTENSIONAL-INDUCTION NIL
  :REFINEMENT :FRONTIER
  )

(def-focl-problem ILLEGAL_FACT
  :GOAL-CONCEPT-NAME ILLEGAL_RULE
  :MAX-NEW-VARIABLES 2
  :INTENSIONAL-INDUCTION NIL
  )



  