;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: XGINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: macros.lisp,v 1.4 1993/06/04 06:28:06 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :xginseng)


;;; Test if on display
(defmacro on-display-p (a-node)
  `(boundp ,a-node))

;;; Macros to manipulate XGinseng cables
(defmacro make-cable (arc node)
  `(list ,arc ,node))

(defmacro get-arc (cable)
  `(first ,cable))

(defmacro get-node (cable)
  `(second ,cable))

;;; Stringifiers:
(defmacro stringify.r (rel)
"Returns <rel> as a string"
  `(string-downcase (symbol-name ,rel)))

(defmacro stringify.n (sneps-node)
"Returns name of <sneps-node> as a string"
  `(string-right-trim `(#\!) (format nil "~a" (sneps:node ,sneps-node))))

(defmacro clean-stringify.r (rel)
"Returns <rel> as a string without a '-' "
  `(string-right-trim `(#\-) (string-downcase (symbol-name ,rel))))
