;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: new-and-ent.lisp,v 1.1 1993/07/17 02:16:27 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;------------------------------
;  AND-entailment handler
;------------------------------

(defun rule-handler.&-ent (ant-report cqch)
  ; if the antecedents have the same set of variables,
  ; use S-indexing, otherwise use P-tree
  (do* ((ants (ants.cqch cqch))
	(ruis (if (is-all-pat-same-vars ants)
		  (get-rule-use-info-sindexing ant-report cqch)
		  (get-rule-use-info-ptree ant-report cqch))
	      (others.ruis ruis))
	(rui (choose.ruis ruis) (choose.ruis ruis)))
       ((isnew.ruis ruis))
    (when (eq (poscount.rui rui) (cardinality.ns ants))
      (let ((restr (make.restr (subst.rui rui)))
	    (ch (channel.cqch cqch)))
	(unless-remarkedp.rui
	  rui (remark '"~%Since" (makeone.ns *NODE*) restr)
	  (do.ns (ant ants)	
	     (remark '"and" (makeone.ns ant) restr))
	  rui (remark '"I infer" (makeone.ns (destination.ch ch)) restr))
	(send-reports
	  (makeone.repset
	    (make.rep
	      (restrict.sbst (subst.rui rui) (freevars.n (destination.ch ch)))
	      (compute-new-support.&-ent ch rui)
	      'POS
	      *NODE*
	      nil
	      (context.ch ch)
	      ))
	  ch)))))




