;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: sign.lisp,v 1.3 1993/06/04 06:26:41 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <sign>  ::=  POS | NEG
;
; =============================================================================
;
; RECOGNIZERS    is.sign   : <universal> --> <boolean>
;
; TESTS          iseq.sign : <sign> x <sign> --> <boolean>
;
; =============================================================================
;
; is.sign
; -------
;
;       arguments     : u - <universal>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "u" is a <sign>, "false" otherwise
;
;                                        written :  rgh 11/10/85
;                                        modified:
;
;
(defmacro is.sign (u)
  `(and (atom ,u)
        (or (eq ,u 'POS)
            (eq ,u 'NEG))))
;
;
; =============================================================================
;
; iseq.sign
; ---------
;
;       arguments     : s1 - <sign>
;                       s2 - <sign>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "s1" and "s2" are equal
;
;                                        written :  rgh 11/30/85
;                                        modified:
;
;
(defmacro iseq.sign (s1 s2)
  `(eq ,s1 ,s2))
;
;
; =============================================================================
