;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: ich.lisp,v 1.3 1993/06/04 06:26:22 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <i-channel> ::= ( <channel> <context> <node set> <rule-use-info set> )
;
;     The <node set> is a set of all consequents of this rule
;
; -----------------------------------------------------------------------------
;
; PRIMITIVE      
;  ELEMENTS
;
; RECOGNIZERS    
;
; CONSTRUCTORS   make.ich : <channel> x <context> x <node set> x <rule-use-info set>
;                                 --> <i-channel>
;
; SELECTORS      channel.ich     : <i-channel> --> <channel>
;                context.ich     : <i-channel> --> <context>
;                consequents.ich : <i-channel> --> <node set>
;                ruiset.ich      : <i-channel> --> <rule-use-info set>
;
; =============================================================================
;
; make.ich
; --------
;
;       arguments     : ch - <channel>
;                       ct - <context>
;                       cqts - <node set>
;                       ruis - <rule-use-info set>
;
;       returns       : <i-channel>
;
;       description   : returns a <i-channel> consisting of the arguments
;
;                                        written :  cpf 11/04/88
;                                        modified:
;
;
(defmacro make.ich (ch ct cqts ruis)
  `(list ,ch ,ct ,cqts ,ruis))
;
;
; =============================================================================
;
; channel.ich
; ------------
;
;       arguments     : ich - <i-channel>
;
;       returns       : <channel>
;
;       description   : returns the <channel> of "ich"
;
;                                        written :  cpf 11/04/88
;                                        modified:
;
;
(defmacro channel.ich (ich)
  `(first ,ich))
;
;
; =============================================================================
;
; context.ich
; -----------
;
;       arguments     : ich - <i-channel>
;
;       returns       : <context>
;
;       description   : returns the <context> of the <i-channel> `ich'.
;                   
;                   
;
;                                        written :  cpf 11/04/88
;                                        modified:
;
;
(defmacro context.ich (ich)
  `(second ,ich))
;
;
; =============================================================================
;
; consequents.ich
; ---------------
;
;       arguments     : ich - <i-channel>
;
;       returns       : <node set>
;
;       description   : returns the <node set> of all rule consequents 
;               
;         
;
;                                        written :  cpf 11/04/88
;                                        modified:
;
;
(defmacro consequents.ich (ich)
  `(third ,ich))
;
;; =============================================================================
;
; ruiset.ich
; ----------
;
;       arguments     : ich - <i-channel>
;
;       returns       : <rule-use-info set>
;
;       description   : returns the <rule-use-info set> of "ich"
;
;                                        written :  cpf 11/04/88
;                                        modified:
;
;
(defmacro ruiset.ich (ich)
  `(fourth ,ich))
;
;
; =============================================================================
