;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: cqch.lisp,v 1.3 1993/06/04 06:26:02 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <cq-channel> ::= ( <channel> <node set> <rule-use-info set> )
;
;     The <node set> is a set of all antecedents for this consequent.
;
; -----------------------------------------------------------------------------
;
; PRIMITIVE      
;  ELEMENTS
;
; RECOGNIZERS    
;
; CONSTRUCTORS   make.cqch : <channel> x <node set> x <rule-use-info set>
;                                 --> <cq-channel>
;
; SELECTORS      channel.cqch : <cq-channel> --> <channel>
;                ants.cqch    : <cq-channel> --> <node set>
;                ruiset.cqch  : <cq-channel> --> <rule-use-info set>
;
; =============================================================================
;
; make.cqch
; ---------
;
;       arguments     : ch - <channel>
;                       ants - <node set>
;                       ruis - <rule-use-info set>
;
;       returns       : <cq-channel>
;
;       description   : returns a <cq-channel> consisting of the arguments
;
;                                        written :  rgh  2/12/86
;                                        modified:
;
;
(defmacro make.cqch (ch ants ruis)
  `(list ,ch ,ants ,ruis))
;
;
; =============================================================================
;
; channel.cqch
; ------------
;
;       arguments     : cqch - <cq-channel>
;
;       returns       : <channel>
;
;       description   : returns the <channel> of "cqch"
;
;                                        written :  rgh  2/12/86
;                                        modified:
;
;
(defmacro channel.cqch (cqch)
  `(first ,cqch))
;
;
; =============================================================================
;
; ants.cqch
; ---------
;
;       arguments     : cqch - <cq-channel>
;
;       returns       : <node set>
;
;       description   : returns the <node set> of all rule antecedents for
;                       the consequent which is the destination of the
;                       channel of "cqch"
;
;                                        written :  rgh  2/12/86
;                                        modified:
;
;
(defmacro ants.cqch (cqch)
  `(second ,cqch))
;
;
; =============================================================================
;
; ruiset.cqch
; -----------
;
;       arguments     : cqch - <cq-channel>
;
;       returns       : <rule-use-info set>
;
;       description   : returns the <rule-use-info set> of "cqch"
;
;                                        written :  rgh  2/12/86
;                                        modified:
;
;
(defmacro ruiset.cqch (cqch)
  `(third ,cqch))
;
;
; =============================================================================
