;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: exports.lisp,v 1.14 1993/09/02 18:50:17 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


;;;  Export the following symbols from the SNePS package.

(export '(sneps snepslog))

(export '(|#| ^ |=| |*| % |!| $ ? + - build assert define find find-or-build
	      find findassert findconstant findpattern findbase findvariable
	      clear-infer topsneval add resetnet erase lisp demo demo-internal
	      set-context set-default-context describe-context list-context-names
	      add-to-context copyright))
	      
(export '(defsnepscom undefsnepscoms
	  ;; and for backward compatibility:
	  =command =topcommand))

(export '(inunit outunit))

(export '(isbase.n ismol.n isvar.n ispat.n is.n isnumber.n isassert.n describe.n
	  nodeset.n iseq.n freevars.n assert.n
	  activate.n quantified-vars.n activation.n dominates.n activated.n is-v-ent.n
	  is-&-ent.n is-thresh.n is-and-or.n is-num-ent.n is-num-quant.n is-non-deriv.n
	  dominatednodes.n node-to-number.n is-nor.n is-and.n
	  n-to-downcs pp-nodetree))

(export '(new.ns isnew.ns ismemb.ns choose.ns others.ns makeone.ns union.ns do.ns
	  insert.ns cardinality.ns apply-subst.ns remove.ns remove-if-not.ns
	  in-context.ns iseq.ns issubset.ns
	  new.cs insert.cs apply-subst.cs clean-quantifiers.cs issubset.cs))

(export '(pathfrom checkpath evalsnd protect-eval pseudolisp initialized-p
	  node-fcableset node-type node-freevars node-perm node-p node-na node-snepslog
	  copy-assertion-state.n slight-surface sneps-error surface
	  is.r new.r isdn.r set.sv value.sv isnew.svs 
	  new.fcs insert.fcs delete.fcs others.fcs relation.fcs do.fcs
	  down.fcs relationset.fcs downfcs.pbi))

(export '(new.cts isnew.cts ismemb.cts choose.cts others.cts makeone.cts union.cts
	  insert.cts cardinality.cts remove.cts issubset.cts repeat name.ct
	  value.sv isassert.n context-hyps context-restriction 
	  fullbuildcontext compl.ns
	  node-asupport node n^ c^ default-defaultct all-hyps
	  new.c relation.c nodeset.c
	  hyp der ext assertion restriction named snip crntct
	  is.ct iseq.ct isinconsis.ct issubset.ct
	  cts make.cts do.cts compl.cts isnew.ctcs is.ctcs 
	  new.ctcs insert.ctcs others.ctcs ot.ctcs contextset.ctcs
	  getcontextset.ctcs filter.ctcs ctcs-to-cts ctcs-to-ots
	  getsndescr processcontextdescr
	  getcontext nodeaccess update-contexts buildcontext
	  mark-inconsistent updateall newjust context-names
	  ))

(export '(converse compose kstar kplus relative-complement irreflexive-restrict
		   exception domain-restrict range-restrict))

(export '( nodes patterns varnodes variables defaultct commands topcommands
	  assertions bnscommands fnscommands rscommands nscommands command))

(export '(;; reader macros
	  star-reader dollar-reader percent-reader hash-reader
	  question-reader bang-reader equal-reader))

(export '(;; demo-tool user interface
	  with-demo-control demo-set demo-get demo-start
	  *demo-interactive-io*
	  ;; io-utils
	  read-single-character read-word read-word-insist read-filename
	  menu-item menu-item-key menu-item-label menu-item-value
	  make-menu-item copy-menu-item menu-item-p
	  menu-selection-insist
	  ;; Various menus
	  *available-demos-menu* *available-sneps-demos-menu*
	  *available-snepslog-demos-menu*
	  ;; A new readfunction
	  pseudolisp-read
	  ))

(export '(;; utilities
	  chew-up-output redefine-function in.environment substitute-tree
	  ))

(export '(;; with-snepsul user functions
	  with-snepsul with-snepsul-direct
	  with-snepsul-silent with-snepsul-direct-silent
	  *with-snepsul-eval-function* with-snepsul-standard-eval
	  with-snepsul-trace-eval with-snepsul-toplevel-style-eval))

(import '(;; with-snepsul user functions
	  with-snepsul with-snepsul-direct
	  with-snepsul-silent with-snepsul-direct-silent
	  *with-snepsul-eval-function* with-snepsul-standard-eval
	  with-snepsul-trace-eval with-snepsul-toplevel-style-eval)
	(find-package 'snepsul))

(import '(defsnepscom undefsnepscoms) (find-package 'snepsul))

(shadowing-import '(^^ % ?
		    fwd-infer exit stack sneps
		    hyp der ext assertion restriction named n^ c^)
	(find-package 'snepsul))

(import '(converse compose kstar kplus relative-complement irreflexive-restrict
		   exception domain-restrict range-restrict)
	(find-package 'snepsul))

(import '(nodes assertions relations patterns varnodes variables defaultct
	  commands topcommands bnscommands fnscommands rscommands nscommands
	  default-defaultct all-hyps)
	(find-package 'snepsul))

(defvar *initial-relations*
	'(&ant ant arg forall cq dcq default emax emin etot exists fname 
	   max min pevb thresh threshmax context r))

(export '*initial-relations*)

(mapcar #'(lambda (ident)
	    (let ((ident&conv (list ident (intern (concatenate 'string (symbol-name ident) "-")))))
	      (export ident&conv)
	      (import ident&conv (find-package 'snepsul)) 
	      (import ident&conv (find-package 'snip))))
	*initial-relations*)

(in-package :snepsul)
(export '(r a c k u q s n d yes y ok sure no end))

;; Needed for SNePSLOG:
(export '(|.| |,| ? ?? ~ |:| { } ! _ => &=> v=> <=>
	  thresh andor all exists nexists |0| |1|))
