;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: otag.lisp,v 1.3 1993/06/04 06:24:03 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; =============================================================================
;
; Data Type:   <ot> ::= 'HYP | 'DER | 'EXT 
;
; =============================================================================




; =============================================================================
;
; Data Type:   <ot> 
; 
; -----------------------------------------------------------------------------
;
; RECOGNIZERS :   is.ot       : <universal> --> <boolean>
;
; CONSTRUCTORS:   --------- 
;
; SELECTORS   :   --------- 
;
; TESTS       :   ---------
;
; UTILITY     :   describe.ot : 
;                 iseq.ot     : <ot> x <ot> --> <boolean>
;
; =============================================================================





;
; =============================================================================
;
; is.ot 
; -----
;
;       arguments     : o - <ot>
;
;       returns       : <boolean>
;
;       description   : It returns T if o is a <ot>.
;
;                                        written :  cpf 09/13/88
;                                        modified:
;
;
(defmacro is.ot (o)
  `(or (eq ,o 'der)
       (eq ,o 'hyp)
       (eq ,o 'ext)))


;
; =============================================================================
;
; describe.ot 
; -----------
;
;       arguments     : o - <ot>
;
;       returns       : <bolean>
;
;       description   : It returns an <atom> which is a description of the
;                       <ot> "o" to be printed.
;                       The description is identical to "o".
;
;                                        written:
;                                        modified:
;
;
(defmacro describe.ot (o)
  `,o)

;
; =============================================================================
;
; iseq.ot 
; -------
;
;       arguments     : ot1  - <ot>
;                       ot2  - <ot>
;
;       returns       : <bolean>
;
;       description   : It returns T if ot1 and ot2 are the same <ot>.
;
;                                        written :  cpf 10/07/88
;                                        modified:
;
;
(defmacro iseq.ot (ot1 ot2)
  `(eq ,ot1 ,ot2))

; =============================================================================


