;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: node0.lisp,v 1.4 1993/06/04 06:23:50 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; =============================================================================
; Data Type:  <node>
; =============================================================================
;

(defstruct (node
	     (:print-function node-printer)
	     )
  (na nil)	   ; Node Access, nil if this is a temporary node
  (type ':unknown) ; Node type. Possibilities are :base :mol :var :pat :unknown
                   ; NOTE: type :unknown can also appear from read.fcs -- ssc 02/26/87
  (perm nil)	   ; Flag. T if node is permanent.
  (freevars nil)   ; The sneps variable nodes that are free in this node.
  (fcableset nil)  ; The node's flat-cable-set (a disembodied property list).
  (gi-node nil)	   ; The ginseng node for displaying this node graphically.
  (activation nil) ; the process associated with this node.
  (asupport nil)   ; The assumption-support.
  (jsupport nil)   ; The justification-support.
  (contexts nil)   ; The contexts where the node is present as an hyp.
  (snepslog nil))  ; the snepslog version of this node  pam 89/1/3


(defun node-printer (obj stream depth)
  (declare (ignore depth))
  ;;
  ;; Test whether CRNTCT is bound, because if it is not (due to some
  ;; sneps bug) debugging (inspecting, tracing) doesn't work because
  ;; these functions try to print nodes using this print function
  ;;
  ;; (buildcontext nil) = (buildcontext (new.ns))
  ;; it was used nil because this file has to be loaded before
  ;; macro new.ns.
  ;;
  (let ((crntct (if (boundp 'crntct) crntct (buildcontext nil))))
    (declare (special crntct))
    (write-string (symbol-name (node-na obj)) stream)
    (if (isassert.n obj) (write-string "!" stream))))
