;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: node.lisp,v 1.3 1993/06/04 06:21:38 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defparameter *node-list* nil)


(defflavor node
	   ((arcs nil)				; A list of all arc instances of this Node.
	    xpos				; The X-Coordinate of this Node.
	    ypos				; The Y-Coordinate of this Node.
	    the-node				; The Sneps accesible object.
	    (shapeflavor nil)
	    (textflavor nil)
	    (typeof-object 'node)
	    (radius *min-node-radius*)		; The radius of the node.
	    (label nil))			; The Node label.
	   ()
  :settable-instance-variables
  :gettable-instance-variables
  :initable-instance-variables
  (:required-init-keywords :xpos :ypos))

(defflavor arc
	   ((arc-label nil)			; The Arc Label.
	    (shapeflavor nil)
	    (textflavor nil)
	    (textborder nil) 
	    (triangleflavor nil)		; SUDY HERE IS the definition of triangleflavor
	    (typeof-object 'arc)
	    node1				; The Top Node.
	    node2)				; The Bottom Node of the arc.
	   ()
  (:settable-instance-variables arc-label shapeflavor textflavor triangleflavor)
  (:initable-instance-variables node1 node2 arc-label triangleflavor)
  (:gettable-instance-variables typeof-object node1 node2 shapeflavor
				textflavor textborder arc-label triangleflavor))


(defmethod (node :reset-radius) ()
  (send self :set-radius
	(if label
	    (max *min-node-radius*
		 (+ *node-margin-size
		    (* 9 (// (zlc:string-length (send self :label)) 2))))
	    *min-node-radius*)))

(defmethod (node :init) (&rest ignore)
  (send self :reset-radius)			;
  (cond ((null (is-drawn self *node-list*)) (push self *node-list*))))


(defmethod (node :add-arc) (arc)
  (push arc arcs))

(defmethod (arc :init) (&rest ignore)
  (send node1 :add-arc self)
  (send node2 :add-arc self))

(defmethod (node :remove-arc) (arc)
  (setq arcs (zlc:delq arc arcs)))

(defmethod (node :delete)()
  (loop until (null arcs)
	do (send (car arcs) :delete))
  (setq *node-list* (zlc:delq self *node-list*)))


(defun calculate-edges (r1 x1 y1 r2 x2 y2 base-p)
  (let* ((dx (- x2 x1)) (dy (- y2 y1)) (length (isqrt (+ (* dx dx) (* dy dy))))
	 (coor (cond (base-p
		      (let* ((left (- x2 r2))
			     (right (+ x2 r2))
			     (top (- y2 10))
			     (bottom (+ y2 10))
			     (code (gwin:sector-code x1 y1 left top right bottom)))
			(list (cond ((logbitp 0 code) left)
				    ((logbitp 1 code) right)
				    (t x2))
			      (cond ((logbitp 2 code) bottom)
				    ((logbitp 3 code) top)
				    (t y2)))))
		     (t (list (- x2 (// (* dx r2) length))
			      (- y2 (// (* dy r2) length)))))))
    (values (+ x1 (// (* dx r1) length))
	    (+ y1 (// (* dy r1) length))
	    (car coor)
	    (cadr coor)
	    (// (+ x1 x2) 2)
	    (// (+ y1 y2) 2))))



(defmethod (node :draw-self) (window) 
  (cond ((sneps:isbase.n the-node)
	 (setq shapeflavor
	       (send world :insert-rectangle (- xpos radius) (- ypos 10) (* radius 2) 20))
	 (setq textflavor
	       (send world :insert-text (+ 4 (- xpos radius)) (- ypos 8) label)))
	(t (setq shapeflavor
		 (send world :insert-circle xpos ypos radius))
	   (setq textflavor
		 (send world :insert-text (- (- xpos 3)
					     (// radius 2))
		       (+ 3 (- ypos (// radius 2))) label))))
  (send shapeflavor :draw window)
  (send textflavor :draw window)
  (add-to-oblist shapeflavor self)
  (and label (add-to-oblist textflavor self)))


(Defmethod (arc :draw-self) (window) 
  (multiple-value-bind (x1 y1 x2 y2 xmpt ympt)
      (calculate-edges (send node1 :radius)(send node1 :xpos) (send node1 :ypos)
		       (send node2 :radius)(send node2 :xpos) (send node2 :ypos) 
		       (sneps:isbase.n (send node2 :the-node)))
    (setq shapeflavor (send world :insert-line x1 y1 x2 y2 1))
    (setq textflavor (send world :insert-text (- xmpt (// (* (zlc:string-length arc-label) 10) 2))
			   (- ympt (// (send window :line-height) 2))
			   (mystring (remove-converse (mystring arc-label)))
			   0.9))
    (let ((tri-coor (draw-me self)))
      (setq triangleflavor (send world :insert-triangle
				 (first tri-coor)
				 (second tri-coor)
				 (third tri-coor)
				 (fourth tri-coor)
				 (fifth tri-coor)
				 (sixth tri-coor)
				 (send world :current-thickness)
				 (send world :current-edge-color)
				 7		; fills in the triangle completely
				 (send world :current-alu ))))
    (send shapeflavor :draw window)
    (send textflavor :draw window)
    (send triangleflavor :draw window)
    (add-to-oblist shapeflavor self)
    (add-to-oblist textflavor self)
    (add-to-oblist triangleflavor self)))

(defun get-instance-of-arc (arc node1 node2)
  (is-in arc node1 node2))

(defun is-in (arc n1 n2)
  (is-in-1 arc (send n1 :arcs) n2 n1))

(defun is-in-1 (arc arcs n2 n1)
  (cond ((null arcs) nil)
	(t 
	 (cond (( and (eq arc(remove-front (send (car arcs) :arc-label)))
		 (or(eq (send (car arcs) :node1 ) n2 )
		    (eq (send (car arcs) :node2) n2 )))
		(cond ((check-other-node arc (car arcs) n2 n1) (car arcs))
		      ( t (is-in-1 arc (cdr arcs) n2 n1))))
	       (t (is-in-1 arc (cdr arcs) n2 n1 ))))))

(defun check-other-node (arc1 arc2 n2 n1)
  (declare (ignore arc1 arc2 n2 n1))
  t)


;
(defun remove-converse (arc)
  (read-from-string (string-right-trim "-" (mystring arc))))

(defun add-converse (arc)
  (read-from-string (merge 'string "-" (mystring arc) 'neq)))


(defflavor graph-window ()
	   (tv:process-mixin
	    gwin:graphics-window)
  (:default-init-plist :process '(graph-window-top-level-function) 
    :blinker-p nil
    :label "SNEPS/GINSENG WINDOW"
    :deexposed-typeout-action ':permit
    :font-map '(fonts:hl12i)))












