;;; -*- Syntax: Common-lisp; Base: 10; Package: SNEPSUL; Mode: LISP -*-

(in-package :snepsul)

(defun number-to-node (n)
  (or (sneps:node (sneps::un-ize n))
      (sneps::newpbase.n (sneps::un-ize n))))

(defun node-to-number (n)
  ;; defined just so can apply it
  (sneps:node-to-number.n n))

(defsnepscom dbmin ((ns) (top ns bns fns))
  (list (number-to-node
	 (apply #'lisp:min
		(mapcar #'node-to-number
			(sneps::nseval ns))))))

(defsnepscom dbmax ((ns) dbmin)
  (list (number-to-node
	 (apply #'lisp:max 
		(mapcar #'node-to-number
			(sneps::nseval ns))))))

(defsnepscom dbtot ((ns) dbmin)
  (list (number-to-node
	 (apply #'lisp:+
		(mapcar #'node-to-number
			(sneps::nseval ns))))))

(defsnepscom dbcount ((ns) dbmin)
  (list (number-to-node (length (sneps::nseval ns)))))

(defsnepscom project ((nodesetexp &rest rels))
  (let ((nodeset (sneps::nseval nodesetexp)))
    (format t "~&~A~%"
	    (delete-duplicates
	     (mapcar #'(lambda (nde)
			 (mapcan #'(lambda (rel)
				     (list rel (sneps:pathfrom
						(sneps::rel-to-path rel)
						nde)))
				 rels))
		     nodeset)
	     :from-end t :test #'equal))
    (values)))

(setq infertrace nil)
