;lshare:unlocked:Wed Oct 23 10:52:42 1991
;;; -*- Syntax: common-lisp; Mode: LISP; Package: (util :use common-lisp :colon-mode :internal); Base: 10 -*- 

(in-package 'util :use '(lisp))

(eval-when (compile load eval)
  (in-package 'util :use '(lisp)))

(export '(value-from-undo-frame

	   setf-undo
	   push-undo
	   pop-undo
	   delete-undo
	   incf-undo
	   decf-undo
	   setf-undo-assoc-value

	   notice-undo-popping ;user-modifiable piece function
	   notice-undo-popped ;user-modifiable piece function
	   notice-undo-pushing ;user-modifiable piece function
	   notice-undo-pushed ;user-modifiable piece function

	   clear-undo-stack
	   *undo-frame-number*
	   base-frame?

	   undo-rep
	   clear-frame))

(defvar *undo-stack* nil)

(defvar *undo-frame-number* 0)

(defun clear-undo-stack ()
  (setf *undo-stack* nil)
  (setf *undo-frame-number* 0))

(definline base-frame? ()
  (= *undo-frame-number* 0))

(definline prev-undo-frame () (1- *undo-frame-number*))

(defmacro setf-undo (reference value) ;look up setf-method in the common lisp manual.
  (multiple-value-bind (vars vals stores store-form access-form)
      (get-setf-method reference)
    (let* ((val-var (gensym "OLD-VALUE"))
	   (restore-thunk `(lambda ()
			     ,(sublis (acons (car stores) val-var nil)
				      store-form))))
      `(let* ,(mapcar #'list
		      (append vars stores)
		      (append vals (list value)))
	 (let ((,val-var ,access-form))
	   (when *undo-stack* (push ,restore-thunk (car *undo-stack*)))
	   ,store-form)))))

(defmacro setf-undo-assoc-value (item alist value)
  (multiple-value-bind (vars vals stores store-form access-form)
      (get-setf-method (list 'assoc-value item alist))
    (let* ((val-var (gensym "OLD-VALUE"))
	   (restore-thunk `(lambda ()
			     (let* ,(mapcar #'list
					    (append vars stores)
					    (append vals (list value)))
			       ,(sublis (acons (car stores) val-var nil)
					store-form)))))
      `(let* ,(mapcar #'list
		      (append vars stores)
		      (append vals (list value)))
	 (let ((,val-var ,access-form))
	   (when *undo-stack* (push ,restore-thunk (car *undo-stack*)))
	   ,store-form)))))

(defmacro push-undo (new-member reference) ;look up setf-method in the common lisp manual.
  (gensym "G-")
  (multiple-value-bind (vars vals stores store-form access-form)
      (get-setf-method reference)
    (let* ((val-var (gensym "OLD-VALUE"))
	   (restore-thunk `(lambda ()
			     ,(sublis (acons (car stores) val-var nil)
				      store-form))))
      `(let* (,@(mapcar #'list vars vals)
	      (,val-var ,access-form)
	      (,(car stores) (cons ,new-member ,val-var)))
	 (when *undo-stack* (push ,restore-thunk (car *undo-stack*)))
	 ,store-form))))

(defmacro pop-undo (reference) ;look up setf-method in the common lisp manual.
  (gensym "G-")
  (multiple-value-bind (vars vals stores store-form access-form)
      (get-setf-method reference)
    (let* ((val-var (gensym "OLD-VALUE"))
	   (restore-thunk `(lambda ()
			     ,(sublis (acons (car stores) val-var nil)
				      store-form))))
      `(let* (,@(mapcar #'list vars vals)
	      (,val-var ,access-form)
	      (,(car stores) (cdr ,val-var)))
	 (when *undo-stack* (push ,restore-thunk (car *undo-stack*)))
	 ,store-form
	 (car ,val-var)))))

(defmacro delete-undo (item reference) ;look up setf-method in the common lisp manual.
  (gensym "G-")
  (multiple-value-bind (vars vals stores store-form access-form)
      (get-setf-method reference)
    (let* ((item-var (gensym "ITEM-"))

	   (val-var (gensym "OLD-VALUE-"))
	   (restore-thunk `(lambda ()
			     ,(sublis (acons (car stores) val-var nil)
				      store-form))))
      `(let* (,@(mapcar #'list vars vals)
	      (,val-var ,access-form)
	      (,item-var ,item))
	 (delete-undo-fun ,item-var ,val-var)
	 (when (eq (car ,val-var) ,item-var)
	   (let ((,(car stores) (cdr ,val-var)))
	     (when *undo-stack* (push ,restore-thunk (car *undo-stack*)))
	     ,store-form))))))

(defun delete-undo-fun (item list)
  (iterate loop ((current-cell list)
		 (next-cell (cdr list)))
    (when next-cell
      (cond ((eq (car next-cell) item)
	     (setf-undo (cdr current-cell) (cdr next-cell))
	     (loop current-cell (cdr next-cell)))
	    (t
	     (loop next-cell (cdr next-cell)))))))

;;; NOTE:  The following two macros don't handle the case
;;;        where the reference does side-effects.
;;;
(defmacro incf-undo (reference)
  `(setf-undo ,reference (1+ ,reference)))

(defmacro decf-undo (reference)
  `(setf-undo ,reference (1- ,reference)))


(defvar *push-deamons* nil)

(defpiecefun notice-undo-pushing ())
(defpiecefun notice-undo-pushed ())

(defun push-undo-frame ()
  (notice-undo-pushing)
  (push nil *undo-stack*)
  (incf *undo-frame-number*)
  (notice-undo-pushed))

;We must allow for many pops in a row followed by a single restart.

(defpiecefun notice-undo-popping ())
(defpiecefun notice-undo-popped ())

(defun pop-undo-frame ()
  (if (base-frame?)
    (format t "~%~%Warning: attempt to pop undo stack in base context~%~%")
    (progn
      (notice-undo-popping)
      (run-thunks (car *undo-stack*))
      (pop *undo-stack*)
      (decf *undo-frame-number*)
      (notice-undo-popped))))

(defun run-thunks (thunks)
  (mapc #'funcall thunks))

(defexportmacro value-from-undo-frame (&body forms)
  `(value-from-undo-thunk (lambda () ,@forms)))

(defexport value-from-undo-thunk (thunk)
  (push-undo-frame)
  (unwind-protect (funcall thunk)
    (pop-undo-frame)))


(defexport undo-push ()
  (catch 'abort
    (value-from-undo-frame (read-eval-print t))))

;
(defun undo-rep ()
  (value-from-undo-frame (read-eval-print t)))

(defun clear-frame ()
  (pop-undo-frame)
  (push-undo-frame))

