;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'ontic)

(bnf (class (fail)))

(rule fail-rule ((= ?c (fail)))
  (not (there-exists ?c)))

(declare-variables (formula ?p ?phi))
(declare-variables (class ?x ?y ?a ?b ?t ?b1 ?b2 ?c ?c1 ?c2 ?type ?e ?fun ?body ?when))
(declare-variables (ontic-gensym ?n))

(rule is-1 ((= ?phi (is ?x ?y))
	    (not ?phi))
  (there-exists ?x))

(rule is-1-contra ((= ?phi (is ?x ?y))
		   (not (there-exists ?x)))
  ?phi)

(rule =-1-contra ((= ?phi (= ?x ?y))
		   (not (there-exists ?x))
		   (not (there-exists ?y)))
  ?phi)

(rule is-2 ((there-exists ?x)
	    (not (there-exists ?y)))
  (not (is ?x ?y)))

(rule reflexivity ((= ?p (is ?x ?x)))
  ?p)

(rule det1 ((at-most-one ?y)
	    (is ?x ?y))
  (at-most-one ?x))

(rule exists1 ((there-exists ?x)
	       (is ?x ?y))
  (there-exists ?y))

(rule exists7 ((not (there-exists ?a)))
      (at-most-one ?a))

(rule exists8 ((not (at-most-one ?a)))
      (there-exists ?a))

(rule exists1-contra ((not (there-exists ?y))
		      (is ?x ?y))
  (not (there-exists ?x)))

(rule anti-symmetry ((is ?a ?b)
		     (is ?b ?a))
  (= ?a ?b))

(rule det2 ((is ?a ?b)
	    (there-exists ?a)
	    (at-most-one ?b))
  (= ?a ?b))

(rule det2-contra-1 ((= ?phi (= ?a ?b))
		     (not ?phi)
		     (there-exists ?a)
		     (at-most-one ?b))
  (=intern ?phi (is ?a ?b)))

(rule det3 ((= ?phi (is ?b ?a))
	    (not ?phi)
	    (there-exists ?a)
	    (at-most-one ?b))
  (=intern ?phi (is ?a ?b)))

(rule reflexive-contra ((not (is ?a ?b)))
  (not (= ?a ?b)))



;Existential witnesses.


(bnf (class (not-general-const ontic-gensym class)))

(setf (gethash 'not-general-const *constructor-weight*) -1)

(deftranslator not-general-constant (type)
  `(not-general-const ,(new-gensym-expression) ,(translate type)))

(defun new-not-general-constant (type &key justification)
  (cintern (translate `(not-general-constant ,type)) :justification justification))

(rule not-general-constant-1 ((= ?c (not-general-const ?n ?type)))
  (is ?c ?type))

(rule not-general-constant-2 ((= ?c (not-general-const ?n ?type)))
  (at-most-one ?c))

(rule not-general-constant-3 ((= ?c (not-general-const ?n ?type))
		  (there-exists ?type))
  (there-exists ?c))

(rule not-general-constant-4 ((= ?c (not-general-const ?n ?type))
			      (at-most-one ?type))
  (= ?c ?type))

(bnf (class (const ontic-gensym class)))

(deftranslator constant (exp)
  `(const ,(new-gensym-expression) ,(translate exp)))

(defun new-constant (type)
  (tintern `(constant ,type)))

(rule constant-1 ((= ?c (const ?n ?type)))
  (is ?c ?type))

(rule constant-2 ((= ?c (const ?n ?type)))
  (at-most-one ?c))

(rule constant-3 ((= ?c (const ?n ?type))
		  (there-exists ?type))
  (there-exists ?c))


(defsequent let-be-sequent
    ((sequent ()
       (invisible-theorem (there-exists ?c)))
     (sequent ((invisible-theorem (there-exists ?c))
	       (let-be ?x ?c))
       (theorem ?phi)))
  (if (not (internal-member '?x (translate '?phi)))
      (theorem ?phi)
      (theorem (forall ((?x ?c)) ?phi))))

(defextender let-be (symbol expression)
  (execute-extension `(define ,symbol (constant ,expression) :resize nil))
  (execute-extension `(hl-write-as (,symbol ,expression))))

(defmac let-be-no-args
  (let-be () . ?body)
  (not (eq (car ?body) 'such-that))
  (lemma (proof-body . ?body)))

(defmac let-be-with-such-that-in-binding
  (let-be ((?var ?bind such-that ?phi) . ?rest-args) . ?body)
  t
  (let-be ((?var (some-such-that ?var ?bind ?phi)) . ?rest-args) . ?body))


(defmac let-be-multiple-args
  (let-be ((?var ?bind) . ?rest-args) . ?body)
  (not (selectmatch ?body
	 ((such-that . :anything) t)
	 ((((hlps-tag show :anything) :anything using (is :anything (?f . :anything)) . :anything) . :anything)
	  (and (symbolp ?f)
	       (fixpoint-definition-of ?f)))
	 ((((hlps-tag show-by-evaluation :anything) (:anything (?f . :anything) :anything) . :anything) . :anything)
	  (and (symbolp ?f)
	       (fixpoint-definition-of ?f)))))
  (let-be-sequent (sequent ()
		    (invisible-show (there-exists ?bind)))
		  (sequent ((invisible-theorem (there-exists ?bind))
			    (let-be ?var ?bind))
		    (let-be ?rest-args . ?body))))

(defmac consider
  (consider ?bindings . ?body)
  (and *goal* (not (eq (car ?body) 'such-that)))
  (lisp-let ((?phi *goal*))
    (let-be ?bindings
      (show-internal ?phi
	. ?body))))

(defmac consider-such-that
  (consider ?bindings such-that ?psi . ?body)
  *goal*
  (lisp-let ((?phi *goal*))
    (let-be ?bindings
      such-that ?psi
      (show-internal ?phi
	. ?body))))

(defmac consider-no-goal
  (consider ?bindings . ?body)
  (null *goal*)
  (let-be ?bindings . ?body))


(defsequent let-be-from-not-is-sequent
    ((sequent ()
	(theorem (not (is ?c1 ?c2))))
     (sequent ((let-be ?x (not-general-constant ?c1))
	       (axiom (not (is ?x ?c2)) ))
	(theorem ?phi)))
  (when (not (internal-member '?x (translate '?phi)))
      (theorem ?phi)))

(defmac let-be-from-not-is
  (let-be ((?var ?c1)) such-that (not (is ?var ?c2))
	  . ?body)
  t
  (let-be-from-not-is-sequent
   (sequent ()
     (show (not (is ?c1 ?c2))))
   (sequent ((let-be ?var (not-general-constant ?c1))
	     (axiom (not (is ?var ?c2))))
     (proof-body . ?body))))


(defsequent let-be-from-not-at-most-one-sequent
    ((sequent () (theorem (not (at-most-one ?c))))
     (sequent ((let-be ?x1 (not-general-constant ?c))
	       (let-be ?x2 (not-general-constant ?c))
	       (axiom (not (= ?x1 ?x2))))
       (theorem ?phi)))
  (when (and (not (internal-member '?x1 (translate '?phi)))
	     (not (internal-member '?x2 (translate '?phi))))
    (theorem ?phi)))

(defmac let-be-from-not-at-most-one-forward-args
  (let-be ((?var1 ?c) (?var2 ?c)) such-that (not (= ?var1 ?var2))
	  . ?body)
  t
  (let-be-from-not-at-most-one-sequent
   (sequent ()
     (show (not (at-most-one ?c))))
   (sequent ((let-be ?var1 (not-general-constant ?c))
	     (let-be ?var2 (not-general-constant ?c))
	     (axiom (not (= ?var1 ?var2))))
     (proof-body . ?body))))

(defmac let-be-from-not-at-most-one-backward-args
  (let-be ((?var2 ?c) (?var1 ?c)) such-that (not (= ?var1 ?var2))
	  . ?body)
  t
  (let-be-from-not-at-most-one-sequent
   (sequent ()
     (show (not (at-most-one ?c))))
   (sequent ((let-be ?var1 (not-general-constant ?c))
	     (let-be ?var2 (not-general-constant ?c))
	     (axiom (not (= ?var1 ?var2))))
     (proof-body . ?body))))

(defmac let-be-from-not-at-most-one-forward-args2
  (let-be ((?var1 ?c) (?var2 ?c)) such-that (not (is ?var1 ?var2))
	  . ?body)
  t
  (let-be-from-not-at-most-one-sequent
   (sequent ()
     (show (not (at-most-one ?c))))
   (sequent ((let-be ?var1 (not-general-constant ?c))
	     (let-be ?var2 (not-general-constant ?c))
	     (axiom (not (= ?var1 ?var2))))
     (proof-body . ?body))))

(defmac let-be-from-not-at-most-one-backward-args2
  (let-be ((?var2 ?c) (?var1 ?c)) such-that (not (is ?var1 ?var2))
	  . ?body)
  t
  (let-be-from-not-at-most-one-sequent
   (sequent ()
     (show (not (at-most-one ?c))))
   (sequent ((let-be ?var1 (not-general-constant ?c))
	     (let-be ?var2 (not-general-constant ?c))
	     (axiom (not (= ?var1 ?var2))))
     (proof-body . ?body))))




;; Universal generalization.

;; We have now introduced typed constants.  If c is a constant of type (a-foo)
;; (is c (a-bar)) we can infer (is (a-foo) (a-bar)).  This a form of universal
;; generalization since it is generalizing a fact about c to a fact about the
;; class (a-foo).  To ensure that no assumptions have been
;; made about c we compare the ``creation number'' of c with the
;; last-assumption-time.  To check that c does not appear free in (a-bar)
;; we compare the creation number of c to the maximum of the creation
;; numbers of all the constants in (a-bar).  If the number of c is greater than
;; the maximum of the constants in (a-bar), then c does not appear in (a-bar).
;; If both conditions hold, then the generalization is valid.

;the variable *last-assumption-max-const* is defined and maintained in
;the file sbhlps.

(rule generalize-to-is ((= ?c (const ?n ?t))
			(is ?c ?type)
			(when (> (max-constant ?n) (max-constant ?type))
			  (notice-max-constant ?type))
			(when (> (max-constant ?n) *last-assumption-max-const*)))
  (is ?t ?type))

(rule generalize-equality ((= (const ?n1 ?t) (const ?n2 ?t))
			   (when (not (eq ?n1 ?n2)))
			   (when (< *last-assumption-max-const* (max-constant ?n1)))
			   (when (< *last-assumption-max-const* (max-constant ?n2)))
			   (when (< (max-constant ?t) (max-constant ?n1))
			     (notice-max-constant ?t))
			   (when (< (max-constant ?t) (max-constant ?n2))))
      (at-most-one ?t))
      




(declare-categories class-pair)

(bnf (class-pair (pair-classes class class)))

(bnf (class (if-builder formula class-pair)
	    (when formula class)
	    (amb class class)
	    (intersection class class)))

(deftranslator if (test case1 case2)
  (translate `(if-builder ,test (pair-classes ,case1 ,case2))))

(rule if-true ((= ?c (if-builder ?phi (pair-classes ?x ?y)))
	       ?phi)
  (= ?c ?x))

(rule if-false ((= ?c (if-builder ?phi (pair-classes ?x ?y)))
		(not ?phi))
  (= ?c ?y))

(rule determined-if ((= ?c (if-builder ?phi (pair-classes ?x ?y)))
		     (at-most-one ?x)
		     (at-most-one ?y))
  (at-most-one ?c))

(rule exists-if ((= ?c (if-builder ?phi (pair-classes ?x ?y)))
		 (there-exists ?x)
		 (there-exists ?y))
  (there-exists ?c))

(rule if-amb ((= ?c (if-builder ?phi (pair-classes ?x ?y))))
  (force (is ?c (amb ?x ?y))))

(deftranslator cond (&rest cases)
  (selectmatch cases
     (((?test ?form))
      (translate `(when ,?test ,?form)))
     (((?test ?form) . ?rest-clauses)
      (translate `(if ,?test ,?form (cond ,@?rest-clauses))))
     (:anything
      (error "incorrect syntax for an Ontic cond clause"))))

(deftranslator either (&rest args)
  (cond ((null args) (translate '(fail)))
	((null (cdr args))
	 (translate (car args)))
	(t
	 `(amb ,(translate (car args))
	          ,(translate `(either ,@(cdr args)))))))

(deftranslator both (&rest args)
  (cond ((null args)
	 (error "the system does not allow both of no arguments"))
	((null (cdr args))
	 (translate (car args)))
	(t
	 `(intersection
	   ,(translate (car args))
	   ,(translate `(both ,@(cdr args)))))))

(rule when-1 ((= ?x (when ?p ?c))
	      ?p)
  (= ?x ?c))

(rule when-2 ((= ?x (when ?p ?c))
	      (not ?p))
  (not (there-exists ?x)))

(rule when-3 ((= ?x (when ?p ?c))
	      (there-exists ?x))
  ?p)

(rule when-4 ((= ?x (when ?p ?c)))
  (is ?x ?c))

(rule when-5 ((not (is ?x ?body))
	      (= ?when (when ?phi ?body)))
  (not (is ?x ?when)))

(rule when-5i ((not (is ?x ?body))
	       (= ?when (when ?phi ?body)))
  (intern (is ?x ?when)))

(rule either-1 ((= ?e (amb ?c1 ?c2))
		(not (there-exists ?c1)))
  (= ?e ?c2))

(rule either-2 ((= ?e (amb ?c1 ?c2))
		(not (there-exists ?c2)))
  (= ?e ?c1))

(rule either-3 ((= ?e (amb ?c1 ?c2)))
  (is ?c1 ?e))

(rule either-4 ((= ?e (amb ?c1 ?c2)))
  (is ?c2 ?e))

(rule either-7 ((= ?e (amb ?c1 ?c2))
		(is ?t ?e)
		(at-most-one ?t)
		(not (is ?t ?c1)))
  (is ?t ?c2))

(rule either-8 ((= ?e (amb ?c2 ?c1))
		(is ?t ?e)
		(at-most-one ?t)
		(not (is ?t ?c1)))
  (is ?t ?c2))

(rule both-1 ((= ?b (intersection ?c1 ?c2)))
  (is ?b ?c1))

(rule both-2 ((= ?b (intersection ?c1 ?c2)))
  (is ?b ?c2))

(rule both-3 ((= ?b1 (intersection ?c1 ?c2))
	      (= ?b2 (intersection ?c2 ?c1)))
  (= ?b1 ?b2))

(rule both-4 ((= ?b (intersection ?c1 ?c2))
	      (is ?t ?c1)
	      (is ?t ?c2))
  (is ?t ?b))


(rule not-under-both-symmetry ((not (there-exists (intersection ?b1 ?b2))))
  (=intern (intersection ?b2 ?b1) (intersection ?b1 ?b2)))



;basic application

(bnf (class (apply class class)))

(rule exists2 ((there-exists (apply ?fun ?x)))
  (there-exists ?fun))

(rule exists3 ((there-exists (apply ?fun ?x)))
  (there-exists ?x))

(rule exists-2-contra ((= ?a (apply ?fun ?x))
		       (not (there-exists ?fun)))
  (not (there-exists ?a)))

(rule exists-3-contra ((= ?a (apply ?fun ?x))
		       (not (there-exists ?x)))
  (not (there-exists ?a)))

(declare-variables (class ?f ?f1 ?f2))

(rule apply-either-1 ()
  (= (apply ?f (amb ?a ?b)) (amb (apply ?f ?a) (apply ?f ?b))))

(rule apply-either-2 ()
  (= (apply (amb ?f1 ?f2) ?a) (amb (apply ?f1 ?a) (apply ?f2 ?a))))




;********************************************************************
;Classify!
;********************************************************************

;The formula (classify! ?x) is used in trying to prove formulas
;of the form (is ?x T) using the inference rules of reflexivity, transitivity,
;monotonicity, and the rules for classifying amb expressions.

(bnf (formula (classify! class)))

(control-predicate classify!)

(rule classify-reflexivity ((classify! ?t))
  (is ?t ?t))

(rule semi-trans ((classify! ?f)
		  (is ?f ?t1)
		  (is ?t1 ?t2))
  (is ?f ?t2))

(rule either-class-call-1 ((classify! ?t)
			   (is ?t (amb ?c1 ?c2)))
  (classify! ?c1))

(rule either-class-call-2 ((classify! ?t)
			   (is ?t (amb ?c1 ?c2)))
  (classify! ?c2))

(rule either-class-return-1 ((classify! ?t)
			     (is ?t (amb ?c1 ?c2))
			     (is ?c1 ?type)
			     (is ?c2 ?type))
  (is (amb ?c1 ?c2) ?type))

(declare-variables (class ?b1 ?b2 ?c) (formula ?phi))
(rule not-under-both ((not (there-exists (intersection ?b1 ?b2)))
		      (classify! ?c)
		      (there-exists ?c)
		      (at-most-one ?c)
		      (is ?c ?b1)
		      (= ?phi (is ?c ?b2)))
  (not ?phi))

(rule class-prop-1 ((classify! ?t)
		    (is ?t (apply ?f ?g)))
  (classify! ?f))

(rule class-prop-2 ((classify! ?t)
		    (is ?t (apply ?f ?g)))
  (classify! ?g))

(rule monotonicity ((is ?f ?g)
		    (is ?x ?y))
  (is (apply ?f ?x) (apply ?g ?y)))

;remember that we have reflexivity for classify! classes ---
;so we have reflexivity for ?f and ?g.

(defsequent write-as-sequent
    ((sequent ()
	(theorem (at-most-one ?c)))
     (sequent ()
	(theorem (is ?c (let ((?var ?bind) . ?rest-bindings) ?type))))
     (sequent ((let-be ?var (not-general-constant ?bind))
	       (axiom (at-most-one ?c))
	       (axiom (is ?c (let ?rest-bindings ?type)))
	       (match-mark! (let ?rest-bindings ?type)))
       (theorem ?phi)))
  (when (not (internal-member '?var (translate '?phi)))
    (theorem ?phi)))

(defmac let-be-write
  (let-be ?bindings such-that (is ?c ?type)
	  . ?body)
  (let ((internal-c (translate ?c)))
    (notany (lambda (binding)
	      (or (not (selectmatch binding ((:anything :anything) t) (:anything nil)))
		  (internal-member (first binding) internal-c)))
	    ?bindings)) 
  (lisp-let ((?reduced-type (unsound-beta-reduce (reverse ?bindings) (translate ?type))))
    (write-as ?c ?bindings ?type ?reduced-type . ?body)))

(defsequent write-as-sequent
    ((sequent ()
	(theorem (at-most-one ?c)))
     (sequent ()
	(theorem (is ?c (let ((?var ?bind) . ?rest-bindings) ?type))))
     (sequent ((let-be ?var (not-general-constant ?bind))
	       (axiom (at-most-one ?c))
	       (axiom (is ?c (let ?rest-bindings ?type)))
	       (match-mark! (let ?rest-bindings ?type)))
       (theorem ?phi)))
  (when (not (internal-member '?var (translate '?phi)))
    (theorem ?phi)))

(defmac write-as-1
  (write-as ?c ((?var ?bind) . ?rest-bindings) ?type ?reduced-type . ?body)
  t
  (write-as-sequent
   (sequent ()
     (show (at-most-one ?c)))
   (sequent ()
     (show (is ?c (let ((?var ?bind) . ?rest-bindings) ?type))
       (first
	(show-internal (is ?c ?reduced-type))
	(do-nothing))
       (proof-cond
	((is ?c ?reduced-type)
	 (hl-write-as (?c ?reduced-type)
	   (show-internal (is ?c (let ((?var ?bind) . ?rest-bindings) ?type))))))))
   (sequent ((let-be ?var (not-general-constant ?bind))
	     (axiom (at-most-one ?c))
	     (axiom (is ?c (let ?rest-bindings ?type)))
	     (match-mark! (let ?rest-bindings ?type)))
     (write-as ?c ?rest-bindings ?type ?reduced-type . ?body))))

(defmac write-as-2
  (write-as :anything () :anything :anything . ?body)
  t
  (proof-body . ?body))

(defun unsound-beta-reduce (bindings w)
  (if bindings
      (unsound-beta-reduce
       (rest bindings)
       (subst (second (first bindings)) (first (first bindings)) w))
      w))



;
;(bnf (formula (functional class number)
;	      (total class number)))
;
;these formulas and rules seem to allow infinite inference
;of the form (functional f n) where n becomes arbitrarily large.
;
;These formulas and rules also have other problems.

;* The generalization
;rules require the creation of constants.  Variable values can not be
;equated with constants because variable values must have infinite max-const
;(see the comments on the propagation rules for max-const).

;* An alternative would be to base generalization
;on variable values.  This fails because variable values
;have infinite max-const and
;in operators with more than one argument this will block universal generalization.
;For example, if x and y are variable values then one can not generalize
;(at-most-one ((f x) y)) to (functional (f x) 1) because (f x) has infinite
;max-const.
;
;* The introduction of constants could be made automatic and in addition
;to the creation of variables.  Under this approach it seems quite difficult
;to avoid structure generation that is exponential in the number of
;arguments to an operator.
;
;The above comments imply that functionality and totality are difficult to
;handle as purely forward chaining syntactic properties of operators.  A
;better approach seems to be to use universal lemmas attached to operators
;rather than functional and total formulas.
;
;
;********************************************************************
;The failed attempt
;********************************************************************
;The formula (functional f n) means that f is an operator
;and that (f x1 ... xn) has at most one value.
;
;;The formula (total f n) means that f is an operator and
;;that (f x1 ... xn) has at least one value when x1 ... xn
;;are in the appropriate domain types.
;
;(rule generalize-functional-1 ((at-most-one (apply ?f (const ?n (apply (a-domain-member-of) ?f))))
;			       (when (> (max-constant ?n) (max-const ?f)))
;			       (when (> (max-constant ?n) *last-assumption-max-const*)))
;  (:lisp (assert-functional ?f (number>node 1))))
;
;(rule generalize-total-1 ((there-exists (apply ?f (const ?n (apply (a-domain-member-of) ?f))))
;			  (when (> (max-constant ?n) (max-const ?f)))
;			  (when (> (max-constant ?n) *last-assumption-max-const*)))
;  (:lisp (assert-total ?f (number>node 1))))
;
;(declare-variables (ontic-number ?k))
;
;(rule generalize-functional-2 ((functional (apply ?f (const ?n (apply (a-domain-member-of) ?f)))
;					   ?k)
;			       (when (> (max-constant ?n) (max-const ?f)))
;			       (when (> (max-constant ?n) *last-assumption-max-const*)))
;  (:lisp (assert-functional ?f (number>node (1+ (node>number ?k))))))
;
;(rule generalize-total-2 ((total (apply ?f (const ?n (apply (a-domain-member-of) ?f)))
;				 ?k)
;			  (when (> (max-constant ?n) (max-const ?f)))
;			  (when (> (max-constant ?n) *last-assumption-max-const*)))
;  (:lisp (assert-total ?f (number>node (1+ (node>number ?k))))))
;
;(rule use-functional ((= ?x (apply ?f ?y))
;		      (functional ?f ?k)
;		      (is ?y (apply (a-domain-member-of) ?f))
;		      (at-most-one ?y))
;  (:lisp
;   (let ((k2 (node>number ?k)))
;     (if (> k2 1)
;	 (assert-functional ?x (number>node (1- k2)))
;	 (assert-at-most-one ?x)))))
;
;(rule use-total ((= ?x (?f ?y))
;		 (total ?f ?k)
;		 (is ?y (apply (a-domain-member-of) ?f))
;		 (there-exists ?y))
;  (:lisp
;   (let ((k2 (node>number ?k)))
;     (if (> k2 1)
;	 (assert-total ?x (number>node (1- k2)))
;	 (assert-at-most-one ?x)))))
;
;     
;
;
;


;More Macros

(defmac suppose-there-is-no-args
  (suppose-there-is () . ?body)
  t
  (let-be () . ?body))

(defsequent suppose-there-is-sequent
    ((sequent ((assume (there-exists ?type))) (theorem ?phi)))
  (if (and (consp '?phi)
	   (eq (car '?phi) 'forall)
	   (consp (second '?phi))
	   (eq (second (first (second '?phi)))
	       '?type))			       
      (theorem ?phi)
      (theorem (implies (there-exists ?type) ?phi))))

(defmac suppose-there-is-multiple-args
  (suppose-there-is ((?var ?type) . ?rest-args) . ?body)
  (not (selectmatch ?body
	 ((such-that . :anything) t)
	 ((((hlps-tag show :anything) :anything using (is :anything (?f . :anything)) . :anything) . :anything)
	  (and (symbolp ?f)
	       (fixpoint-definition-of ?f)))
	 ((((hlps-tag show-by-evaluation :anything) (:anything (?f . :anything) :anything) . :anything) . :anything)
	  (and (symbolp ?f)
	       (fixpoint-definition-of ?f)))))  
  (suppose-there-is-sequent (sequent ((assume (there-exists ?type)))
			      (let-be ((?var ?type))
				(suppose-there-is ?rest-args . ?body)))))

(defmac suppose-there-is-multiple-args-such-that
  (suppose-there-is ((?var ?type such-that ?phi) . ?rest-args) . ?body)
  t
  (suppose-there-is ((?var (some-such-that ?var ?type ?phi))
		     . ?rest-args)
    . ?body))

(defmac suppose-there-might-be-no-args
  (suppose-there-might-be () . ?body)
  t
  (progn . ?body))


(defsequent suppose-there-might-be-sequent
    ((sequent ((suppose-there-might-be ?x ?c))
       (theorem ?phi)))
  (if (not (internal-member '?x (translate '?phi)))
      (theorem ?phi)
      (theorem (forall ((?x ?c)) ?phi))))

(defextender suppose-there-might-be (symbol expression)
  (execute-extension `(define ,symbol (constant ,expression) :resize nil :allow-non-existence t))
  (execute-extension `(hl-write-as (,symbol ,expression))))

(defmac suppose-there-might-be-args
  (suppose-there-might-be ((?var ?type) . ?rest-args) . ?body)
  t
  (suppose-there-might-be-sequent
   (sequent ((suppose-there-might-be ?var ?type))
     (suppose-there-might-be ?rest-args . ?body))))

(defmac suppose-there-might-be-args-such-that
  (suppose-there-might-be ((?var ?type such-that ?phi) . ?rest-args) . ?body)
  t
  (suppose-there-might-be-sequent
   (sequent ((suppose-there-might-be ?var (some-such-that ?var ?type ?phi)))
     (suppose-there-might-be ?rest-args . ?body))))

(emacs-indent suppose-there-might-be 1)

(defpiece (check-definition basic-piece) (symbol translated-def keylist)
  (unless (eq (expression-category translated-def) 'class)
    (ontic-error (format nil "Cannot define ~s to be a non-class expression"
			 symbol)))
    (unless (and (consp translated-def)
		 (member (car translated-def) '(db-lambda lambda0)))
      (let ((int (cintern translated-def)))
	(unless (or *contradiction*
		    (and (or (getf keylist :allow-non-existence)
			     (eq (there-exists-internal int) :true))
			 (eq (at-most-one-internal int) :true)))
	  (ontic-error (format nil "Definition for ~s is not obviously singleton"
			       symbol))))))

(defun expression-category (texp)
  (cond ((symbolp texp)
	 'class)
	((basic-object-p texp)
	 (type-of texp))
	((numberp texp) 'class)
	((not (consp texp)) nil)
	((eq (car texp) '=)
	 'formula)
	((numberp (car texp))
	 'ontic-number)
	(t
	 (output-category (first texp)))))

(setf (get 'recursively-axiom 'execution-function) 'grovel-fun)

(defun grovel-fun (pred-name expression)
  (t-grovel pred-name (translate expression)))

(defun t-grovel (pred-name texp)
  (when (eq (expression-category texp) 'class)
    (axiom-fun `(,pred-name ,texp)))
  (when (consp texp)
    (mapc (lambda (exp)
	    (t-grovel pred-name exp))
	  (rest texp))))
    

(defmac equivalents-macro-1
  (equivalent ?term1 ?term2)
  t
  (show (= ?term1 ?term2)))

(defmac equivalent-macro-2
  (equivalent ?term1 ?term2 ?term3 . ?rest)
  t
  (progn (show (= ?term1 ?term2))
	 (equivalent ?term2 ?term3 . ?rest)))


;========================================================================
;the following heurisitc speeds up lots of inferences
;========================================================================

(declare-variables (class ?f))

(rule classify!-small-operators ((closed ?f)
				 (when (print-size-< (print-size ?f) 10)
				   (notice-print-size ?f))
				 (when (and (max-constant ?f) (= 0 (max-constant ?f)))
				   (notice-max-constant ?f)))
  (classify! ?f))