;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'ontic)

;The structure name may appear in the types and the condition.
;To guarantee that the following definitions are not circular
;the maker-function is not used in the definition of the structure
;type.  Defontic can handle a single recursion, but mutual
;recursion is not yet implemented.

(emacs-indent def-o-struct 1)
(defmacro def-o-struct (name &body body)
  `(invisible-module
    (module-def-o-struct ,name . ,body)))


(defun generate-defstruct (name body)
  (let* ((tail (member 'such-that body))
	 (slot-list (set-difference body tail))
	 (condition (when tail (cadr tail)))
	 (maker-name (combine-symbols 'make name))
	 (x (gentemp "?X-")))
    `(progn
      (module-definition (,name)
       (let* ,slot-list
	 ,(if condition
	      `(when ,condition
		(list 'structure-marker ',name ,@(mapcar 'car slot-list)))
	      `(list 'structure-marker ',name ,@(mapcar 'car slot-list)))))
      (module-definition (,maker-name ,@slot-list)
       ,(if condition
	    `(when ,condition
	      (list 'structure-marker ',name ,@(mapcar 'car slot-list)))
	    `(list 'structure-marker ',name ,@(mapcar 'car slot-list))))
      ,@(mapcar (lambda (slot-name index)
		  `(module-definition (,(car slot-name) (,x (,name)))
		    (car ,(make-n-cdrs x (+ index 1)))))
	 slot-list
	 (integers-between 1 (length slot-list)))
      (axiom (forall ((,x (,name)))
	       (and
		(= ,x
		   (,maker-name ,@(mapcar (lambda (slot) `(,(car slot) ,x))
					  slot-list)))
		,@(mapcan (lambda (slot)
			    `((there-exists (,(car slot) ,x))
			      (at-most-one (,(car slot) ,x))
			      (is (,(car slot) ,x)
			       ,(macro-invert
				  (sublis (mapcar (lambda (slot)
						    (cons (car slot)
							  (list (car slot)
								x)))
						  slot-list)
					  (translate (second slot)))))))
			  slot-list))))
      ,@(let* ((binding-list (rename-bindings slot-list))
	       (structure `(,maker-name ,@(mapcar 'car binding-list))))
	  `((axiom (forall ,binding-list
		     ,(let ((body
			     `(and (is ,structure (,name))
			       ,@(mapcar (lambda (binding slot)
					   `(= (,(car slot) ,structure)
					     ,(car binding)))
				  binding-list
				  slot-list))))
			(if condition
			    `(implies ,(sublis (mapcar (lambda (binding slot)
							 (cons (car slot) (car binding)))
						       binding-list slot-list)
					       condition)
				      ,body)
			    body))))
	    (first (show-internal (there-exists (,name)))
	     (show-internal (true)))
	    (first (show-internal (is (,name) (a-thing)))
	     (show-internal (true)))))
      (lisp-when (progn
		   (goto-context *real-context*)
		   (when (and (not (eq :yes (? (there-exists (,name)))))
			      (not *faith-mode*))
		     (ontic-warning (format nil "Failure to show (THERE-EXISTS (~s))" ',name)
				    '(not (eq :yes (? (there-exists (,name))))))))
	(do-nothing)))))


(defmac def-o-struct
  (module-def-o-struct ?name . ?body)
  t
  (evaluate-proof
   (generate-defstruct '?name '?body)))

(defun rename-bindings (bindings)
  (when bindings
    (let* ((first-binding (first bindings))
	   (name (first first-binding)))
      (let ((new-name (copy-var name)))
	(cons (cons new-name (cdr first-binding))
	      (rename-bindings (sublis (acons name new-name nil) (cdr bindings))))))))
	       
      

(defun integers-between (n m)
  (if (> n m)
      nil
      (cons n (integers-between (1+ n) m))))

(defun make-n-cdrs (arg n)
  (if (= n 0)
      arg
      `(cdr ,(make-n-cdrs arg (1- n)))))

(defpiece (ontic-init-phase2 define-structure-thunk) ()
  (defontic (a-structure)
      (some-such-that ?x (a-cons-cell)
	(= (car ?x) 'structure-marker))))





