;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'ontic)

;;;This file is about controling the instantiation of quantifiers.



;********************************************************************
;simplify!
;********************************************************************
;Eventually simplify! should be elminiated from the system in favor of domain
;marking.  It was used to control grammar rewriting.  Grammar rewriting
;is no longer used.  Now it is only used to control beta reduction.  The current
;beta reduction code is nonlinear in the number of domains.  This needs to be
;fixed.

(bnf (formula (simplify! anything)))

(control-predicate simplify!)

(defun expression-size (texp)
  (if (or (symbolp texp)
	  (basic-object-p texp))
      (print-size (cintern texp))
      (let* ((rhs (rest texp))
	     (weight (constructor-weight (first texp))))
	(if (null rhs)
	    weight
	    (let ((s1 (expression-size (first rhs))))
	      (when s1
		(if (null (cdr rhs))
		    (+ weight s1)
		    (let ((s2 (expression-size (second rhs))))
		      (when s2
			(+ weight s1 s2))))))))))


(emacs-indent recursively-apply 2)

(defsequent recursively-apply-eliminate
    ((sequent ((recursively-apply ?fun . ?args))
       (theorem ?phi)))
  (theorem ?phi))

(defmac recursively-apply-macro
  (recursively-apply ?fun ?args . ?body)
  t
  (recursively-apply-eliminate
    (sequent ((recursively-apply ?fun . ?args))
      (first (ensure *goal*)
	     (progn . ?body)))))


;The simplification control predicate propagates over the print
;grammar of the simplified term.
;

(declare-variables (class ?c ?f ?arg ?w))

(rule simplify-to-classify ((simplify! ?c))
  (classify! ?c))

(declare-variables (anything (?u-const anything) (?b-const anything anything) ?a1 ?a2 ?a3))

(declare-variables (class-combinator ?comb ?sub-comb) (class ?arg ?app ?type) (anything ?subexp))

(declare-variables (class ?app ?f))

(declare-variables (class ?arg ?app))

(rule create-lambda-demon ((= ?f (db-lambda ?t ?c-body))
			   (= ?app (apply ?f ?arg))
			   (simplify! ?arg)
			   (at-most-one ?arg)
			   (there-exists ?arg)
			   (is ?arg ?t)
			   (when (zerop (db-index-so-far ?t))
			     (notice-db-index ?t))
			   (when (zerop (db-index-so-far ?c-body))
			     (notice-db-index ?c-body))
			   (when (zerop (db-index-so-far ?arg))
			     (notice-db-index ?arg)))
  (=intern ?app (apply-class-combinator ?c-body ?arg)))

(rule create-lambda-fun-demon-i ((is ?f (db-lambda-fun ?t ?c-body))
				 (at-most-one ?f)
				 (there-exists ?f)
				 (= ?app (apply ?f ?arg))
				 (simplify! ?app)
				 (at-most-one ?arg)
				 (there-exists ?arg)
				 (is ?arg ?t)
				 (when (zerop (db-index-so-far ?t))
				   (notice-db-index ?t))
				 (when (zerop (db-index-so-far ?c-body))
				   (notice-db-index ?c-body))
				 (when (zerop (db-index-so-far ?arg))
				   (notice-db-index ?arg)))
  (intern (apply-class-combinator ?c-body ?arg)))

(rule create-lambda-fun-demon ((is ?f (db-lambda-fun ?t ?c-body))
			       (at-most-one ?f)
			       (there-exists ?f)
			       (= ?app (apply ?f ?arg))
			       (simplify! ?app)
			       (at-most-one ?arg)
			       (there-exists ?arg)
			       (is ?arg ?t)
			       (when (zerop (db-index-so-far ?t))
			         (notice-db-index ?t))
			       (when (zerop (db-index-so-far ?c-body))
			         (notice-db-index ?c-body))
			       (when (zerop (db-index-so-far ?arg))
				 (notice-db-index ?arg))
			       (= ?c (apply-class-combinator ?c-body ?arg)))
  (is ?app ?c))



;========================================================================
;the quantifier forall
;========================================================================
;forall
 
(bnf (formula (db-forall class formula-combinator)))

(declare-variables (class-combinator ?c-body ?c-body1 ?c-body2))
(declare-variables (formula-combinator ?c-phi ?c-phi1 ?c-phi2))
(declare-variables (class ?c ?t ?f ?type ?body))
(declare-variables (formula ?phi ?psi))
(declare-variables (gensym ?n))

(deftranslator forall (bindings formula)
  (cond ((null bindings)
	 (translate formula))
	(t (let* ((var (first (first bindings)))
		  (t-type (if (eq (third (first bindings)) 'such-that)
			      (translate `(some-such-that ,var ,(second (first bindings)) ,(fourth (first bindings))))
			      (translate (second (first bindings)))))
		  (t-body (translate `(formula-combinator ,var (forall ,(rest bindings) ,formula)))))
	     (let ((bodies (conjuncts (second t-body))))
	       (create-and (mapcar (lambda (body)
				     (if (db-occurs 1 body)
					 (possibly-simplify `(db-forall ,t-type (db-formula-combinator ,body))) 
					 `(implies (there-exists ,t-type) ,body)))
				   bodies)))))))

(defun conjuncts (formula)
  (selectmatch formula
    ((not (implies ?t1 (not ?t2)))
     (cons ?t1 (conjuncts ?t2)))
    (:anything
     (list formula))))

(defun create-and (bodies)
  (if (null (cdr bodies))
      (car bodies)
      `(not (implies ,(car bodies) (not ,(create-and (cdr bodies)))))))

(defun db-occurs (num formula)
  (cond ((atom formula)
	 nil)
	(t (let ((constructor (car formula))
		 (args (cdr formula)))
	     (case constructor
	       (de-bruijn (= (caar args) num))
	       ((db-class-combinator db-formula-combinator) (db-occurs (1+ num) (car args)))
	       (t (some (lambda (form) (db-occurs num form)) args)))))))


(rule forall-2 ((= ?phi (db-forall ?type ?c-phi))
		(when (and (db-index ?phi) (= (db-index ?phi) 0))
		  (notice-db-index ?phi))
		(not (there-exists ?type)))
  ?phi)

(rule forall-3 ((= ?phi (db-forall ?type ?c-phi))
		(there-exists ?type)
		(at-most-one ?type))
  (=intern ?phi (apply-formula-combinator ?c-phi ?type)))

;;;
;;;(rule generalize-to-forall ((= ?c (const ?n ?t))
;;;			    (= ?phi (apply-formula-combinator ?c-phi ?c))
;;;			    ?phi
;;;			    (= ?psi (db-forall ?t ?c-phi))
;;;			    (when (> (max-constant ?n)
;;;				     (max (max-constant ?psi)
;;;					  *last-assumption-max-const*))
;;;			      (notice-max-constant ?psi)))
;;;  ?psi)

(rule trivial-forall ((= ?phi (db-forall ?t (db-formula-combinator ?psi)))
		      (there-exists ?t)
		      (when (and (db-index ?psi)
				 (= (db-index ?psi) 0))
			(notice-db-index ?psi)))
  (= ?psi ?phi))



;========================================================================
;  quantifier elimination code
;========================================================================

(defun possibly-simplify (exp)
  (mvlet (((types matrix) (destructure-forall exp)))
    (if (null types) exp
	(selectmatch matrix
	  ((is ?t1 ?t2)
	   (simplify-is-matrix types ?t1 ?t2))
	  ((not (not ?phi))
	   (possibly-simplify (build-forall types ?phi)))
	  ((singleton (apply ?f ?arg))
	   (if (not (eq ?f 'funcall0-operator))
	       (simplify-application-singleton-matrix types  `(apply ,?f ,?arg))
	       exp))
	  ((there-exists (apply ?f ?arg))
	   (if (not (eq ?f 'funcall0-operator))
	       (simplify-application-existence-matrix types `(apply ,?f ,?arg))
	       exp))
	  ((at-most-one (apply ?f ?arg))
	   (if (not (eq ?f 'funcall0-operator))
	       (simplify-application-determined-matrix types `(apply ,?f ,?arg))
	       exp))
	  (:anything exp)))))

(defun uncurry (app)
  (selectmatch app
    ((apply (apply ?f ?arg1) ?arg2)
     (append (uncurry `(apply ,?f ,?arg1)) (list ?arg2)))
    ((apply ?f ?arg) `(,?f ,?arg))
    (?exp ?exp)))
     

(defun simplify-application-singleton-matrix (types application)
  (labels ((simplify-one-type (type types-done app-so-far)
	     (let ((db-level (1+ (length types-done))))
	       (if (or (db-occurs-in-type-list 1 types-done)
		       (> (db-count db-level app-so-far) 1)
		       (not (well-behaved-for app-so-far `(de-bruijn (,db-level)) nil :allowable-position t)))
		   (values (cons type types-done) app-so-far)
		   (values (decrement-dbs-in-type-list types-done 1)
			   (expression-db-subst app-so-far
						(increment-dbs type 1 :inc-amount (1- db-level))
						db-level)))))  ;;expression-db-subst increments the db-nums > than db-level

	   (simplify-type-list-from-end (types app-so-far)
	     (if (null types)
		 (values nil app-so-far)
		 (mvlet (((types-done app-result) (simplify-type-list-from-end (cdr types) app-so-far)))
		   (simplify-one-type (car types) types-done app-result)))))

    (mvlet (((result-types result-application)
	     (simplify-type-list-from-end types application)))
      (mvlet (((eta-abstraction eta-fun eta-types) (eta-abstract result-application)))
	(if (equal eta-abstraction eta-fun)
	    (build-forall result-types
			  `(is ,eta-abstraction
			    ,(translate
			      `(a-function-from ,@(mapcar (lambda (et)
							    `(the-set-of-all ,et))
						   eta-types)
				to (the-set-of-all (,eta-fun ,@eta-types))))))
	    (build-forall types `(singleton ,(translate application))))))))


(defun simplify-application-existence-matrix (types application)
  (labels ((simplify-one-type (type types-done app-so-far)
	     (let ((db-level (1+ (length types-done))))
	       (if (or (db-occurs-in-type-list 1 types-done)
		       (> (db-count db-level app-so-far) 1)
		       (not (well-behaved-for app-so-far `(de-bruijn (,db-level)) nil :allowable-position t)))
		   (values (cons type types-done) app-so-far)
		   (values (decrement-dbs-in-type-list types-done 1)
			   (expression-db-subst app-so-far
						(increment-dbs type 1 :inc-amount (1- db-level))
						db-level)))))  ;;expression-db-subst increments the db-nums > than db-level

	   (simplify-type-list-from-end (types app-so-far)
	     (if (null types)
		 (values nil app-so-far)
		 (mvlet (((types-done app-result) (simplify-type-list-from-end (cdr types) app-so-far)))
		   (simplify-one-type (car types) types-done app-result)))))

    (mvlet (((result-types result-application)
	     (simplify-type-list-from-end types application)))
      (mvlet (((eta-abstraction eta-fun eta-types) (eta-abstract result-application)))
	(if (equal eta-abstraction eta-fun)
	    (build-forall result-types
			  `(is ,eta-abstraction
			    ,(translate
			      `(a-total-operator-from
				,@(mapcar (lambda (et)
					    `(the-set-of-all ,et))
				   eta-types)
				to (the-set-of-all (,eta-fun ,@eta-types))))))
	    (build-forall types `(there-exists ,(translate application))))))))


(defun simplify-application-determined-matrix (types application)
  (labels ((simplify-one-type (type types-done app-so-far)
	     (let ((db-level (1+ (length types-done))))
	       (if (or (db-occurs-in-type-list 1 types-done)
		       (> (db-count db-level app-so-far) 1)
		       (not (well-behaved-for app-so-far `(de-bruijn (,db-level)) nil :allowable-position t)))
		   (values (cons type types-done) app-so-far)
		   (values (decrement-dbs-in-type-list types-done 1)
			   (expression-db-subst app-so-far
						(increment-dbs type 1 :inc-amount (1- db-level))
						db-level)))))  ;;expression-db-subst increments the db-nums > than db-level

	   (simplify-type-list-from-end (types app-so-far)
	     (if (null types)
		 (values nil app-so-far)
		 (mvlet (((types-done app-result) (simplify-type-list-from-end (cdr types) app-so-far)))
		   (simplify-one-type (car types) types-done app-result)))))

    (mvlet (((result-types result-application)
	     (simplify-type-list-from-end types application)))
      (mvlet (((eta-abstraction eta-fun eta-types) (eta-abstract result-application)))
	(if (equal eta-abstraction eta-fun)
	    (build-forall result-types
			  `(is ,eta-abstraction
			    ,(translate
			      `(a-partial-function-from
				,@(mapcar (lambda (et)
					    `(the-set-of-all ,et))
				   eta-types)
				to (the-set-of-all (,eta-fun ,@eta-types))))))
	    (build-forall types `(at-most-one ,(translate application))))))))

(defun build-fun-from-to (domain-types range-type)
  (if (null domain-types)
      range-type
      (translate `(a-function-from (the-set-of-all ,(car domain-types)) to
		   (the-set-of-all ,(build-fun-from-to (cdr domain-types) range-type))))))


(defun build-total-rel-from-to (domain-types range-type)
  (if (null domain-types)
      range-type
      `(apply (apply (total-rel-from-to) (the-set-of-all-internal ,(car domain-types)))
	(the-set-of-all-internal ,(build-total-rel-from-to (cdr domain-types) range-type)))))

(defun build-partial-fun-from-to (domain-types range-type)
  (if (null domain-types)
      range-type
      `(apply (apply (partial-fun-from-to) (the-set-of-all-internal ,(car domain-types)))
	(the-set-of-all-internal ,(build-partial-fun-from-to (cdr domain-types) range-type)))))
      
(defun eta-abstract (application)
  (setf application (uncurry application))
  (values (if (equal (extract-lambda-types (definition-of (car application)))
		     (cdr application))
	      (car application)
	      (build-lambda (cdr application) (translate `(,(car application) ,@(build-db-tuple (1- (length application)))))))
	  (car application)
	  (cdr application)))

(defun extract-lambda-types (exp)
  (selectmatch exp
    ((db-lambda ?type (db-class-combinator ?body))
     (cons ?type (extract-lambda-types ?body)))
    (:anything nil)))

(defun build-db-tuple (length)
  (if (zerop length)
      nil
      (cons `(de-bruijn (,length))
	    (build-db-tuple (1- length)))))
   
(defun build-lambda (types body)
  (if (null types)
      body
      `(db-lambda ,(car types) (db-class-combinator ,(build-lambda (mapcar #'increment-dbs (cdr types)) body)))))


(defun simplify-is-matrix (types t1 t2)
  (labels ((simplify-one-type (type types-done t1-so-far t2-so-far)
	     (let ((db-level (1+ (length types-done))))
	       (if (or (db-occurs-in-type-list 1 types-done)
		       (db-occurs db-level t2-so-far)
		       (> (db-count db-level t1-so-far) 1)
		       (not (well-behaved-for t1-so-far `(de-bruijn (,db-level)) nil :allowable-position t)))
		   (values (cons type types-done)
			   t1-so-far
			   t2-so-far)
		   (values (decrement-dbs-in-type-list types-done 1)
			   (expression-db-subst t1-so-far
						(increment-dbs type 1 :inc-amount (1- db-level))
						db-level)  ;;expression-db-subst increments the db-nums above db-level
			   (decrement-dbs t2-so-far db-level)))))

	   (simplify-type-list-from-end (types t1-so-far t2-so-far)
	     (if (null types)
		 (values nil t1-so-far t2-so-far)
		 (mvlet (((types-done t1-result t2-result) (simplify-type-list-from-end (cdr types) t1-so-far t2-so-far)))
		   (simplify-one-type (car types) types-done t1-result t2-result)))))

    (mvlet (((result-types result-t1 result-t2)
	     (simplify-type-list-from-end types t1 t2)))
      (build-forall result-types `(is ,result-t1 ,result-t2)))))

(defun db-occurs-in-type-list (db-num types)
  (and types
       (or (db-occurs db-num (car types))
	   (db-occurs-in-type-list (1+ db-num) (cdr types)))))

(defun decrement-dbs-in-type-list (types db-num)
  (if (null types)
      nil
      (cons (decrement-dbs (car types) db-num)
	    (decrement-dbs-in-type-list (cdr types) (1+ db-num)))))



(defun build-forall (types matrix)
  (if (null types)
      matrix
      `(db-forall ,(car types) (db-formula-combinator ,(build-forall (cdr types) matrix)))))


(defun destructure-forall (exp)
  (selectmatch exp
    ((db-forall ?type (db-formula-combinator ?matrix))
     (mvlet (((types matrix) (destructure-forall ?matrix)))
       (values (cons ?type types) matrix)))
    (:anything (values nil exp))))



;========================================================================
;the quantifier some-such-that
;========================================================================

(bnf (class (db-some-such-that class formula-combinator)))

(deftranslator some-such-that (symbol class formula)
  `(db-some-such-that
    ,(translate class)
    ,(translate `(formula-combinator ,symbol ,formula))))

(deftranslator exists (bindings formula)
  (selectmatch bindings
    (()
     (translate formula))
    (((?var ?type) . ?rest-bindings)
     (translate `(there-exists (some-such-that ,?var ,?type (exists ,?rest-bindings ,formula)))))
    (:anything
     (error "illegal syntax for Ontic exists"))))

(rule such-that-subclass ((= ?f (db-some-such-that ?type ?c-phi))
			  (closed ?f))
  (is ?f ?type))

(declare-variables (class ?st) (formula-combinator ?st-phi))

(rule some-such-that-phi-interning ((simplify! ?c)
				    (at-most-one ?c)
				    (there-exists ?c)
				    (is ?c ?t)
				    (= ?st (db-some-such-that ?t ?c-phi)))
  (=intern (apply-formula-combinator ?c-phi ?c)
	   (is ?c (db-some-such-that ?t ?c-phi))))

(rule some-such-thatness ((= ?st (db-some-such-that ?t ?c-phi))
			  (apply-formula-combinator ?c-phi ?c)
			  (is ?c ?t))
  (is ?c ?st))

(rule some-such-that-application ((is ?c (db-some-such-that ?t ?c-phi))
				  (= ?phi (apply-formula-combinator ?c-phi ?c)))
  ?phi)

(declare-variables (class ?st ?t ?arg ?c1 ?c2) (formula-combinator ?c-phi))
(rule such-that-phi-classify! ((= ?st (db-some-such-that ?t ?c-phi))
			       (= ?phi (apply-formula-combinator ?c-phi ?arg))
			       (= ?phi (is ?c1 ?c2)))
  (classify! ?c1)
  (classify! ?c2))


;========================================================================
;match code
;========================================================================

; Matching code: The following code implements the ternary "match"
; relation.  Match(Pattern, Exp, Subst) is true if Pattern is a
; db-open expression, Exp is a db-closed expression, and Subst is a
; substitution that makes Pattern equal Exp.  The values substituted
; for de-bruijn numbers must be singleton, simplify!-ed class
; expressions.

; Match is also sometimes true between two db-open expressions; every
; db-open expression, for instance, matches itself.  This is because
; with the current implementation, for
; (db-forall T (db-formula-combinator (is (de-bruijn (1)) (de-bruijn (2)))))
; to match
; (db-forall T (db-formula-combinator (is (de-bruijn (1)) C))),
; the expression (de-bruijn (1)) must match itself.


;========================================================================
;argument restrictions
;========================================================================
;
;Control of Lemma instantiation is critical to the overall performance of
;the system.  There are three important "constraints" on the match process.
;The first is a critical constraint that guarantees completeness of the system.

;1) any instance of any lemma, if stated in an identical way to the statement
;of the lemma, must be obvious to the system.

;2) The number of lemma instantiations should not be so large that it takes
;several mintes to determine if a fact is obviuos.

;3) Matching should allow lemmas to be applied to write-as constants.

;4) Enough of the "right" lemmas should be instantiated so that the system
;is smart.

;To control lemma instantiation we introduce the notion of
;"dominates".  We identify certain "critical
;nodes" in the expression tree of the goal.  Every node is dominated
;by the innermost critical node that contains it.  Domination is
;used to control the matching process.



;========================================================================
;substitutions
;========================================================================

;substitutions are lists of values.  The first value is always the binding for
;the first deBruijn number, the second value the binding for the second debruijn
;number and so on.  Substitutions are finite and any beBruijn number not given an
;explicit value is mapped to itself.

(declare-categories substitution)

(bnf (substitution (undefined-substitution)
		   (subst-cons class substitution)
		   (combine-substs substitution substitution))
     (class (undefined-value) (self-binding))
     (formula (complete-subst substitution)))

(defun undefined-value? (exp)
  (some #'(lambda (prod) (eq (phrase-constructor prod) 'undefined-value))
	(productions-from exp)))

(defun self-binding? (exp)
  (some #'(lambda (prod) (eq (phrase-constructor prod) 'self-binding))
	(productions-from exp)))

(defun undefined-substitution? (exp)
  (some #'(lambda (prod) (eq (phrase-constructor prod) 'undefined-substitution))
	(productions-from exp)))

(defun subst-list (subst)
  (unless (eq :true (complete-subst? subst))
    (ontic-error "an attempt has been made to listify an incomplete substitution"))
  (dolist (prod (productions-from subst))
    (case (phrase-constructor prod)
      (subst-cons
       (return-from subst-list
	 (let ((val (first (rhs prod))))
	   (cons (if (undefined-value? val) 'reindex val)
		 (subst-list (second (rhs prod)))))))
       (undefined-substitution
	(return-from subst-list
	  nil))))
  (declare-ontic-bug "unable to compute subst-list"))
	 

;; we'd better never have more than 100 nested db-nums
(defvar *de-bruijn-array* (make-array 100 :initial-element nil)) 

(defpiece (ontic-init-phase0 :initi-db-array) ()
    (setf *de-bruijn-array* (make-array 100 :initial-element nil)))

(usually-null-property db-num-cache)

(definline db-num-of (node)
  (or (db-num-cache node)
      (let ((num (node>number (first (rhs (find-if (lambda (prod)
						     (eq (phrase-constructor prod)
							 'de-bruijn))
						   (productions-from node)))))))
	(setf (db-num-cache node) num)
	num)))

(defun db-num-node (num)
  (when (< num 1)
    (error "Trying to intern db-num ~s" num))
  (or (aref *de-bruijn-array* num)
      (let ((node (cintern `(de-bruijn (,num)))))
	(setf-undo (aref *de-bruijn-array* num) node)
;;	(setf-undo (class-constant? node) 1)
	node)))

(defun create-substitution (db-node value &key justification)
  (cintern (substitution-expression (db-num-of db-node) value) :justification justification))

(defun substitution-expression (db-num value)
  (if (= db-num 1)
      `(subst-cons ,value (undefined-substitution))
      `(subst-cons (undefined-value) ,(substitution-expression (1- db-num) value))))

(declare-variables (substitution ?comb ?s ?s1 ?s2))

(rule combine-substs-1 ((= ?comb (combine-substs (undefined-substitution) ?s)))
  (= ?comb ?s))

(rule combine-substs-2 ((= ?comb (combine-substs ?s (undefined-substitution))))
  (= ?comb ?s))

(rule combine-substs-3 ((= ?comb (combine-substs (subst-cons ?c ?s1) (subst-cons ?c ?s2))))
  (=intern ?comb (subst-cons ?c (combine-substs ?s1 ?s2))))

(rule combine-substs-4 ((= ?comb (combine-substs (subst-cons (undefined-value) ?s1) (subst-cons ?c ?s2))))
  (=intern ?comb (subst-cons ?c (combine-substs ?s1 ?s2))))

(rule combine-substs-5 ((= ?comb (combine-substs (subst-cons ?c ?s1) (subst-cons (undefined-value) ?s2))))
  (=intern ?comb (subst-cons ?c (combine-substs ?s1 ?s2))))

(defpiece (ontic-init-phase1 :initialize-complete-substitution) ()
  (axiom (complete-subst (undefined-substitution))))

(rule combine-substs-6 ((complete-subst ?s))
  (complete-subst (subst-cons ?c ?s)))


(bnf (class (subst-value ontic-number substitution)))

(declare-variables (class ?v) (ontic-number ?db-number))

(rule compute-subst-value ((= ?v (subst-value ?db-number ?s))
			   (complete-subst ?s))
  (queue *delay-q*
    (:lisp
     (let ((v2 (nth (1- (node>number ?db-number)) (subst-list ?s))))
       (when (and v2 (not (eq v2 'reindex)))
	 (equate! ?v v2 :justification ?justification))))))


;
;========================================================================
;match-marking and domination
;========================================================================

;The extender match-mark! operates (obviously) on text.  A node is asserted to be
;critical ;if it is either the root node of the expression given to match-mark! or
;or an apply node that is not the first argument of an apply node (more complex now---rlg)
;in the expression
;given to match-mark!.  The formula (dominates ?n1 ?n2) is asserted if ?n1 is a class,
;?n1 is equal to or above ?n2 in the parse tree, and no critical nodes appear properly between
;?n1 and ?n2.

(bnf (formula (dominates ontic-gensym class))
     (formula (dominates-substitution ontic-gensym substitution))
     (formula (marker-dominates ontic-gensym ontic-gensym))
     (formula (marks ontic-gensym class)))


(declare-variables (ontic-gensym ?m))
(rule marked-implies-simplify! ((dominates ?m ?t))
  (simplify! ?t))


(control-extender match-mark!)

(defextender match-mark! (exp)
  (when exp
    (let* ((texp (translate exp))
	   (texp-with-nodes (pair-with-nodes texp))
	   (domains-and-markers (domains-and-markers texp-with-nodes)))
      (dolist (dom domains-and-markers)
	(let ((marker (car dom)))
	  (assert-is-true (make-marks marker (cddr dom)) :true)
	  (install-domain marker (cdr dom) (remove dom domains-and-markers)))))))

(defun pair-with-nodes (texp)
  (if (consp texp)
      (let ((constructor (car texp))
	    (child-exps (mapcar #'pair-with-nodes (rest texp))))
	(cons (cons constructor child-exps)
	      (hashlist constructor (mapcar #'cdr child-exps))))
      (cons texp (ti texp))))

(defun domains-and-markers (texp-with-nodes &optional parent-with-nodes)
  (when (consp (car texp-with-nodes))
    (let ((apply-subnodes (mapcan (lambda (subexp-with-node) (domains-and-markers subexp-with-node texp-with-nodes))
				  (cdar texp-with-nodes))))
      (if (or (and (eq 'class (expression-category (car texp-with-nodes)))
		   (or (null parent-with-nodes)
		       (not (eq (expression-category (car parent-with-nodes)) 'class))))
	      (and (eq (caar texp-with-nodes) 'apply)
		   (not (and parent-with-nodes
			     (or (and (eq (caar parent-with-nodes) 'apply)					  
				      (eq texp-with-nodes (second (car parent-with-nodes))))
				 (eq (caar parent-with-nodes) 'not-general-const)))))
	      (and (eq (caar texp-with-nodes) 'not-general-const)
		   (not (and parent-with-nodes
			     (eq (caar parent-with-nodes) 'apply)
			     (eq texp-with-nodes (second (car parent-with-nodes)))))))
	  (cons (cons (new-gensym) texp-with-nodes) apply-subnodes)
	  apply-subnodes))))

(defun install-domain (domain-marker domain domains-and-markers)
  (install-domination domain-marker (cdr domain))
  (let ((dom-and-mark (find-if (lambda (x) (eq (cdr x) domain)) domains-and-markers)))
    (when (and (consp (car domain))
	       (null dom-and-mark))
      (mapc (lambda (child-with-nodes)
	      (install-domain domain-marker child-with-nodes domains-and-markers))
	    (cdar domain)))
    (when dom-and-mark
      (assert-is-true (make-marker-dominates domain-marker (car dom-and-mark))
		      :true))))

(defun install-domination (domain-marker node)
  (when (class-p node)
    (assert-is-true (make-dominates domain-marker node) :true)))



;========================================================================
;domination of substitutions
;========================================================================


(declare-variables (ontic-gensym ?mark ?mark1 ?mark2) (class ?exp ?pattern))

(def-rule-const ?*undefined-substitution* (undefined-substitution))

(rule dominates-subst-0 ((marks ?mark ?exp)
			 (constant ?*undefined-substitution*))
  (dominates-substitution ?mark ?*undefined-substitution*))

;(rule dominates-subst-1 ((dominates-substitution ?mark ?s))
;  (dominates-substitution ?mark (subst-cons (self-binding) ?s)))

(rule dominates-subst-2 ((dominates-substitution ?mark ?s))
  (dominates-substitution ?mark (subst-cons (undefined-value) ?s)))

(rule dominates-subst-3 ((dominates-substitution ?mark ?s)
			 (dominates ?mark ?exp))
  (dominates-substitution ?mark (subst-cons ?exp ?s)))

;; dominates-subst-4 is below, because it depends on match

(rule dominates-subst-5 ((dominates-substitution ?mark ?s1)
			 (dominates-substitution ?mark ?s2)
			 (complete-subst (combine-substs ?s1 ?s2)))
  (dominates-substitution ?mark (combine-substs ?s1 ?s2)))




;========================================================================
;matches
;========================================================================

(declare-categories match-pair)

(bnf (match-pair (cons-match-pair class class))
     (formula (match match-pair substitution))
     (formula (pattern! anything)))

(declare-variables (match-pair ?mpair ?mpair1 ?mpair2)
		   (class ?pattern ?pattern1 ?pattern2 ?exp ?exp1 ?exp2))

(declare-variables (class ?c) (ontic-number ?n))

(defun create-match (pattern node subst &key justification)
  (unless (and (eq pattern node)
	       (closed-true-internal node))
    (assert-match-internal (make-cons-match-pair pattern node :justification justification)
			   subst :justification justification)))

;(rule match-reflexive ((= ?c (de-bruijn ?n))
;		       (pattern! ?c))
;  (:lisp (create-match ?c ?c (create-substitution ?c (make-self-binding) :justification ?justification)
;		       :justification ?justification)))

; The rule match-base isn't threaded.  To get around this problem, we
; save the existing de-bruijn numbers and simplify!-ed terms in global
; variables.

(defvar *de-bruijns* nil)
(defvar *singletons* nil)

(defpiece (ontic-init-phase0 init-match-vars) ()
  (setf *de-bruijns* nil)
  (setf *singletons* nil))

(declare-variables (ontic-number ?n))


(rule dominates-subst-4 ((marker-dominates ?mark1 ?mark2)
			 (marks ?mark2 ?exp)
			 (dominates-substitution ?mark2 ?s)
			 (match (cons-match-pair ?pattern ?exp) ?s))
  (dominates-substitution ?mark1 ?s))


(rule match-base-1 ((= ?c (de-bruijn ?n))
		    (pattern! ?c))		    
  (:lisp (progn
	   (when (not (member ?c *de-bruijns*))
	     (push-undo ?c *de-bruijns*)
	     (dolist (x *singletons*)
	       (create-match ?c x (create-substitution ?c x :justification ?justification)
			     :justification ?justification))))))

(rule match-base-2 ((simplify! ?x)
		    (there-exists ?x)
		    (at-most-one ?x)
		    (closed ?x))
  (:lisp (progn
	   (push-undo ?x *singletons*)
	   (dolist (c *de-bruijns*)
	     (create-match c ?x (create-substitution c ?x :justification ?justification)
			   :justification ?justification)))))

(declare-variables (class (?binary-class-constructor class class)
			  (?unary-class-constructor class)))


(rule unary-match-1 ((match (cons-match-pair ?pattern1 ?exp1) ?s)
		     (= ?pattern (?unary-class-constructor ?pattern1))
		     (pattern! ?pattern)
		     (= ?exp (?unary-class-constructor ?exp1))
		     (when (not (or (eq ?unary-class-constructor 'db-formula-combinator)
				    (eq ?unary-class-constructor 'db-class-combinator)))))
  (:lisp (create-match ?pattern ?exp ?s :justification ?justification)))

;(rule unary-match-2 ((match (cons-match-pair ?pattern1 ?exp1) (subst-cons (self-binding) ?s))
;		     (= ?pattern (?unary-class-constructor ?pattern1))
;		     (pattern! ?pattern)
;		     (= ?exp (?unary-class-constructor ?exp1))
;		     (when (or (eq ?unary-class-constructor 'db-formula-combinator)
;			       (eq ?unary-class-constructor 'db-class-combinator))))
;  (:lisp (create-match ?pattern ?exp ?s :justification ?justification)))

(rule binary-match-1 ((match (cons-match-pair ?pattern1 ?exp1) ?s1)
		      (match (cons-match-pair ?pattern2 ?exp2) ?s2)
		      (= ?pattern (?binary-class-constructor ?pattern1 ?pattern2))
		      (pattern! ?pattern)
		      (= ?exp (?binary-class-constructor ?exp1 ?exp2)))
  (intern (combine-substs ?s1 ?s2)))

(rule binary-match-2 ((match (cons-match-pair ?pattern1 ?exp1) ?s1)
		      (match (cons-match-pair ?pattern2 ?exp2) ?s2)
		      (= ?pattern (?binary-class-constructor ?pattern1 ?pattern2))
		      (pattern! ?pattern)
		      (= ?exp (?binary-class-constructor ?exp1 ?exp2))
		      (= ?s (combine-substs ?s1 ?s2))
		      (dominates-substitution ?mark ?s))
  (:lisp (create-match ?pattern ?exp ?s :justification ?justification)))


(rule binary-match-3 ((match (cons-match-pair ?pattern1 ?exp1) ?s1)
		      (= ?pattern (?binary-class-constructor ?pattern1 ?pattern2))
		      (pattern! ?pattern)
		      (= ?exp (?binary-class-constructor ?exp1 ?pattern2))
;		      (closed ?pattern2)
		      )
  (:lisp (create-match ?pattern ?exp ?s1 :justification ?justification)))

(rule binary-match-4 ((match (cons-match-pair ?pattern1 ?exp1) ?s1)
		      (= ?pattern (?binary-class-constructor ?pattern2 ?pattern1))
		      (pattern! ?pattern)
		      (= ?exp (?binary-class-constructor ?pattern2 ?exp1))
;		      (closed ?pattern2)
		      )
  (:lisp (create-match ?pattern ?exp ?s1 :justification ?justification)))


;Carl's rules for not-general-constants.

(declare-variables (ontic-gensym ?n))

(rule ngc-match-base ((= ?c (not-general-const ?n ?x))
		      (there-exists ?c)
		      (pattern! ?x))
  (:lisp
   (create-match ?x ?c (make-undefined-substitution) :justification ?justification)))

(rule ngc-match-propagation ((match (cons-match-pair ?pattern ?exp) ?s)
			     (= ?c (not-general-const ?n ?exp)))
  (:lisp (create-match ?pattern ?c ?s :justification ?justification)))




;========================================================================
;simplified matches
;========================================================================
;a simplified match is just like a match but there are fewer simplified
;matches than matches and the substitution in a simplifed match does not have
;any undominated nodes. Lemma instantiation is invoked by simplified matches
;only and it is important to carefully control the generation of simplified matches.
;the following code converts matches to simplified matches.

(bnf (formula (simplified-match match-pair substitution)))

;There are two rules for turning simplifed matches into matches.

;1. Any match to a simplify!'d node where the sum of the size of the
;nodes in the substitution is smaller than the size of the matched node
;is converted to a simplified match.

(rule convert-match-1 ((match (cons-match-pair ?pattern ?exp) ?s)
		       (simplify! ?exp)
		       (print-size-<= ?s ?exp))
  (simplified-match (cons-match-pair ?pattern ?exp) ?s))


;2. another way to get a simplified match
(rule convert-match-2 ((match (cons-match-pair ?pattern ?exp) ?s)
		       (dominates ?mark ?exp)
		       (dominates-substitution ?mark ?s))
  (simplified-match (cons-match-pair ?pattern ?exp) ?s))





;========================================================================
;;; Code to instantiate forall formulas
;========================================================================


;;;  This code selects one or more "handles" for each forall
;;;  formula that becomes true, and whenever there is a 
;;;  a MATCH generated for a handle, the substitution for
;;;  that MATCH is used to instantiate the entire forall formula.

(bnf (formula (forall-handle formula class-pair)))

(declare-variables (class ?index))

(rule mark-handle ((forall-handle ?phi (pair-classes ?pattern ?index)))
  (pattern! ?pattern))

(declare-variables (anything ?any ?any1 ?any2 (?unary-const anything) (?binary-const anything anything)))

(rule propagate-pattern-1 ((pattern! ?any)
			   (min= ?any (?unary-const ?any2)))
  (pattern! ?any2))

(rule propagate-pattern-2 ((pattern! ?any)
			   (min= ?any (?binary-const ?any1 ?any2)))
  (pattern! ?any1)
  (pattern! ?any2))

;A handle for a forall formula is any class expression that contains
;the outermost variable and is maximal among thoese class expressions
;containing the variable.  A handle must be stored with an "offset" that
;allows one to map the db-numbers in the handle to the first bound variable
;of the forall.  For example, the first bound variable of the forall can
;correspond to db-number 3 in the handle pattern.

(declare-variables (formula ?f-app))

(rule not-exists->forall ((= ?phi (there-exists
				   (db-some-such-that ?t
						      (db-formula-combinator ?psi))))
			  (not ?phi))
  (force (= (not ?phi)
	    (db-forall ?t (db-formula-combinator (not ?psi))))))

(rule install-forall-handles ((= ?phi (db-forall ?type ?c-phi))
			      (when (and (db-index ?phi) (= (db-index ?phi) 0))
				(notice-db-index ?phi)))
  (queue *delay-q* (:lisp (find-forall-handles ?c-phi ?type ?phi 0))))

(rule assert-forall-instance ((= ?phi (db-forall ?type ?c-phi))
			      ?phi
			      (= ?f-app (apply-formula-combinator ?c-phi ?arg))
			      (is ?arg ?type))
  ?f-app)

(defun is-db-num? (obj)
  (dolist (prod (productions-from obj))
    (when (eq (phrase-constructor prod) 'de-bruijn)
      (return-from is-db-num? t))))

;db-num is the number of quantifiers external to obj.

(defun find-forall-handles (obj type root db-num)
  (let ((obj (uf-find obj))
	(root (uf-find root)))
    (let ((handles-list (find-forall-handles-2 obj db-num)))
      (when handles-list
	(if (every #'is-db-num? (mapcar #'car handles-list))
	    (assert-is-true (make-forall-handle root
						(make-pair-classes
						 (car (first handles-list))
						 (cdr (first handles-list))))
			    :true)
	    (dolist (handle handles-list)
	      (unless (is-db-num? (car handle))
		(assert-is-true (make-forall-handle root
						    (make-pair-classes
						     (car handle)
						     (cdr handle)))
				:true))))))))

;; this is a weird function
;;   It expects to be called with a _combinator_, and returns a list of handle-pairs.
;;   On recursive calls, it returns either T, a handle-pair, or a list of handle-pairs, as follows:
;;      T                               = obj was a pure class which did not "contain" db-num
;; a (cons class-node db-node)          = obj was a pure class containing db-num, so obj was returned
;; a list of (cons class-node db-node)  = obj was not a pure class, the list is the handles in it
;;

(defun find-forall-handles-2 (obj db-num)
  (cond ((and (class-p obj) (eq obj (db-num-node db-num)))
	 (cons obj (db-num-node db-num)))
	((and (db-index obj) (< (db-index obj) db-num)) (class-p obj))
	(t (let ((prod (smallest-lhs-production obj)))
	     (when prod
	       (let* ((pc (phrase-constructor prod))
		      (db-binder? (or (eq 'db-class-combinator pc)
				      (eq 'db-formula-combinator pc)))
		      (child-results (mapcar (lambda (sub-obj)
					       (find-forall-handles-2
						sub-obj (apply-if db-binder? #'1+ db-num)))
					     (rhs prod))))
		 (if (or (not (eq 'class (output-category pc)))
			 (some #'(lambda (x)
				   (and (not (eq x t))
					(not (class-p (cdr x)))))
			       child-results))
		     (mapcan (lambda (child)
			       (cond ((eq child t) nil)
				     ((class-p (cdr child)) (list child))
				     (t child)))
			     child-results)
		     (let ((db-num-node (find-if #'consp child-results)))
		       (if (not db-num-node)
			   t
			   (cons obj (cdr db-num-node)))))))))))

(defun contains-db-num? (obj db-num db-num-node)
  (or (eq obj db-num-node)
      (and (not (and (db-index obj)
		     (< (db-index obj) db-num)))
	   (let* ((prod (smallest-lhs-production obj))
		  (const (phrase-constructor prod)))
	     (if (combinator-constructor? const)
		 (contains-db-num? (first (rhs prod))
				   (1+ db-num)
				   (db-num-node (1+ db-num)))
		 (some #'(lambda (arg) (contains-db-num? arg db-num db-num-node))
		       (rhs prod)))))))

;
(declare-variables (class-pair ?p) (class ?index) (ontic-number ?n) (formula-combinator ?form-comb))

(rule intern-subst-value ((simplified-match (cons-match-pair ?pattern ?exp) ?s)
			  (complete-subst ?s)
			  (forall-handle ?phi (pair-classes ?pattern (de-bruijn ?n))))
  (intern (subst-value ?n ?s)))

(bnf (formula (instantiate-on! (formula :rare t) substitution)))

(rule instantiate-lemma ((simplified-match (cons-match-pair ?pattern ?exp) ?s)
			 (closed ?exp)
			 (complete-subst ?s)
			 (forall-handle ?phi ?p)
			 (= ?p (pair-classes ?pattern ?index))
			 (= ?phi (db-forall ?type ?form-comb))
			 (= ?index (de-bruijn ?n))
			 (is (subst-value ?n ?s) ?type))
  (queue *delay-q*
    (:lisp
     (if (= (length (subst-list ?s)) (db-num-of ?index))
	 (assert-instantiate-on!-internal ?phi ?s :justification ?justification)
	 (ontic-error "pattern failed to bind correct number of variables")))))

(rule pick-up-instantiate-on! ((instantiate-on! ?phi ?s)
			       (= ?phi (db-forall ?type ?form-comb)))
  (:lisp (instantiate-forall ?phi ?s ?form-comb :justification ?justification)))

(defun instantiate-forall (forall subst forall-body &key justification)
  (let ((forall-body (uf-find forall-body)))
    (assert-is-true (make-implies forall
				  (inst-and-typecheck-forall (subst-list subst)
							     forall-body 1)
				  :justification justification)
		    :true
		    :justification justification)))

;the db-index is the number of quantifiers above the forall-body argument.
;db-index thus gives the number of db-numbers in the body argument that
;can be meaningfully instantiated (we assume the top level lemma is closed).

(defun inst-and-typecheck-forall (subst-list forall-body db-index)
  (let* ((comb-prod (the-one (productions-from forall-body)))
	 (prod (smallest-lhs-production (first (rhs comb-prod))))
	 (current-subst (last-n db-index subst-list)))
    (if (or (not (eq (phrase-constructor prod) 'db-forall))
	    (= db-index (length subst-list)))
	(non-recording-db-substitute-multiple (first (rhs comb-prod)) current-subst)
	(let* ((db-type (first (rhs prod)))
	       (type (non-recording-db-substitute-multiple db-type current-subst))
	       (reduced-matrix
		(inst-and-typecheck-forall subst-list (second (rhs prod)) (1+ db-index)))
	       (object-to-substitute (nth (- (length subst-list) (1+ db-index)) subst-list)))
	  (cond ((eq object-to-substitute 'reindex)
		 (make-db-forall type (make-db-formula-combinator reduced-matrix)))
		((is? object-to-substitute type) reduced-matrix)
		(t (make-implies (make-is object-to-substitute type) reduced-matrix)))))))

;(last-n 3 '(a b c d e)) => (c d e).

(defun last-n (n list)
  (nthcdr (- (length list) n) list))

;
;The lambda-handle of a lambda-expression is the lambda handle of the body.
;The lambda-handle of a let expression is the lambda handle of the body.
;The lambda-handle of any other type of expression is itself.

(bnf (formula (lambda-handle (class :rare t) class-pair)))

(rule notice-lambda-handle ((lambda-handle ?l (pair-classes ?pattern ?index)))
  (pattern! ?pattern))			    

(rule install-lambda-handles ((= ?l (db-lambda ?type (db-class-combinator ?body)))
			      (closed ?l))
  (queue *delay-q* (:lisp (find-lambda-handles ?body ?l 1))))

(defun find-lambda-handles (obj root db-num)
  (flet ((assert-handle (obj root db-num)
	   (let ((db-num-node (db-num-node db-num)))
	     (when (contains-db-num? obj db-num db-num-node)
	       (assert-is-true (make-lambda-handle root (make-pair-classes obj db-num-node)) :true)))))
    (let ((obj (uf-find obj))
	  (root (uf-find root)))
      (assert-handle obj root db-num)
      (let ((prod (first (small-lhs-productions obj))))
	(when prod
	  (let ((pc (phrase-constructor prod)))
	    (case pc
	      (apply (let* ((fun-node (first (rhs prod)))
			    (fun-prod (first (small-lhs-productions fun-node))))
		       (if (and fun-prod
				(eq (phrase-constructor fun-prod) 'db-lambda)
				(or (null (db-index fun-node))
				    (>= (db-index fun-node) db-num)))
			   (progn
;;;			     (find-lambda-handles (second (rhs prod)) root db-num)
;;;   		             (find-lambda-handles (first (rhs fun-prod)) root db-num)
			     (let ((comb-prod (first (small-lhs-productions (second (rhs fun-prod))))))
			       (find-lambda-handles (first (rhs comb-prod)) root (1+ db-num)))))))
	      (db-lambda (let ((comb-prod (first (small-lhs-productions (second (rhs prod))))))
			   (if comb-prod
			       (find-lambda-handles (first (rhs comb-prod)) root (1+ db-num))))))))))))

(declare-variables (class ?db-body ?db-num-node))

;the (is x ?type) condition can not be promoted into the antecedents of the following
;rule because the rule can not be made to fire when x dies in favor of y where (is y ?type)
;was already true but x is the value in the substitution.  The problem is the mixture
;of lisp code with rules.

(rule beta-abstraction ((= ?l (db-lambda ?type ?c-body))
			(lambda-handle ?l (pair-classes ?db-body ?db-num-node))
			(simplified-match (cons-match-pair ?db-body ?exp) ?s)
			(complete-subst ?s)
			(closed ?l))
  (queue *delay-q*
      (:lisp
       (let ((x (nth (1- (db-num-of ?db-num-node)) (subst-list ?s))))
	 (when (class-p x)
	   (assert-is-true (make-implies (make-is x ?type)
					 (make-= (make-apply ?l x)
						 (make-apply-class-combinator ?c-body x)))
			   :true
			   :justification ?justification))))))

