;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package :ontic)

(defun recursively-define (symbol expression keylist &key (resize t))
  (selectmatch expression
    ((lambda ?args ?body)
     (let ((expression (untranslated-definition symbol)))
       (unless expression
	 (ontic-error
	   (format nil "attempt to construct a fixed point of the undefined function ~s" symbol)))
       (unless (internal-member symbol (translate expression))
	 (ontic-error
	   (format nil "attempt to construct a fixed point of the non-recursive function ~s" symbol)))
       (basic-define
	symbol
	(translate
	 `(lambda ,?args
	   ((fix (lambda (,symbol) ,expression))
	    ,@(mapcar #'car ?args))))
	keylist
	:resize resize))
     (if (acceptable-recursion? symbol expression)
	 (let ((lambda-exp (translate `(lambda ,?args ,?body))))
	   (execute-extension `(axiom (= ,symbol ,lambda-exp)))
	   (setf-undo (fixpoint-definition-of symbol) lambda-exp))
	 (progn
	   (ontic-warning (format nil "Warning:  unable to establish fixed point property for ~s"
				  symbol)
			  `(not
			     (when (eq :yes (? (= ,symbol ,(translate `(lambda ,?args ,?body)))))
			       (setf-undo (fixpoint-definition-of ',symbol)
					  ',(translate `(lambda ,?args ,?body)))
			       t)))
	   nil)))
    (:anything
     (ontic-error
       (format nil "attempted recursive definition of something other than a thunk or operator")))))

(def-proof-function (internal-evaluation ?level ?phi using (is ?term ?exp)) context
  (setq ?exp (translate ?exp))
  (when *trace-evaluation* (rprint `(eval ,(macro-invert ?exp))))
  (let ((*evaluation-stack* (append *evaluation-stack* `((eval ,?exp)))))
    (selectmatch ?exp
      ((if-builder ?psi (pair-classes ?x ?y))
       (cond ((obvious-sequent? context ?psi)
	      (evaluate-proof `(internal-evaluation ,?level ,?phi using (is ,?term ,?x))
			      context))
	     ((obvious-sequent? context `(not ,?psi))
	      (evaluate-proof `(internal-evaluation ,?level ,?phi using (is ,?term ,?y))
			      context))
	     (t
	      (let ((new-context (add-extension context `(match-mark! ,?psi))))
		(cond ((obvious-sequent? new-context ?psi)
		       (evaluate-proof `(internal-evaluation ,?level ,?phi using (is ,?term ,?x))
				       new-context))
		      ((obvious-sequent? new-context `(not ,?psi))
		       (evaluate-proof `(internal-evaluation ,?level ,?phi using (is ,?term ,?y))
				       new-context))
		      (t
		       (evaluate-proof `(first
					 (ensure ,?phi)
					 (show ,?phi
					   (eval-suppose ,?psi
					     (internal-evaluation ,?level ,?phi
								  using (is ,?term ,?x)))
					   (eval-suppose (not ,?psi)
					     (internal-evaluation ,?level ,?phi
								  using (is ,?term ,?y)))))
				       new-context)))))))
      ((apply :anything :anything)
       (eval-reduction ?level ?phi ?term ?exp context))
      ((amb ?x ?y)
       (evaluate-proof `(first
			 (ensure ,?phi)
			 (show ,?phi
			   (eval-suppose (is ,?term ,?x)
			     (internal-evaluation ,?level ,?phi
						  using (is ,?term ,?x)))
			   (eval-suppose (not (is ,?term ,?x))
			     (eval-suppose (is ,?term ,?y)
			       (internal-evaluation ,?level ,?phi
						    using (is ,?term ,?y))))))
		       context))
      ((when ?psi ?x)
       (unless (obvious-sequent? context ?psi)
	 (declare-ontic-bug "failure to maintain the existence invariant in evaluation --- show an ontic hacker"))
       (evaluate-proof `(internal-evaluation ,?level ,?phi using (is ,?term ,?x))
		       context))
      (:anything
       (ieval-base-case ?phi ?term ?exp context)))))

(defun tonicity-as-operator (symbol expression arity)
  (cond ((eq expression symbol)
	 'both)
	((not (internal-member symbol expression))
	 'constant)
	(t
	 (selectmatch expression
	   ((apply (funcall0-operator) ?thunk)
	    (application-tonicity symbol (list ?thunk) arity))
	   ((apply :anything :anything)
	    (application-tonicity symbol (uncurry expression) arity))
	   ((if-builder ?phi (pair-classes ?x ?y))
	    (let ((test-tone (tonicity-as-operator symbol ?phi arity)))
	      (case test-tone
		(both 'both)
		(constant (combine-tonicities (tonicity-as-operator symbol ?x arity)
					      (tonicity-as-operator symbol ?y arity)))
		(t 'both))))
	   ((when ?phi ?x)
	    (combine-tonicities (tonicity-as-operator symbol ?phi arity)
				(tonicity-as-operator symbol ?x arity)))
	   ((amb ?x ?y)
	    (combine-tonicities (tonicity-as-operator symbol ?x arity)
				(tonicity-as-operator symbol ?y arity)))
	   ((intersection ?x ?y)
	    (combine-tonicities (tonicity-as-operator symbol ?x arity)
				(tonicity-as-operator symbol ?y arity)))
	   ((is ?x ?y)
	    (combine-tonicities (invert-tonicity (tonicity-as-operator symbol ?x arity))
				(tonicity-as-operator symbol ?y arity)))
	   ((db-some-such-that ?x ?phi)
	    (combine-tonicities (tonicity-as-operator symbol ?x arity)
				(tonicity-as-operator symbol ?phi arity)))
	   ((there-exists ?x)
	    (tonicity-as-operator symbol ?x arity))
	   ((at-most-one ?x)
	    (invert-tonicity (tonicity-as-operator symbol ?x arity)))
	   ((singleton :anything) 'both)
	   ((forall ?t (formula-combinator ?phi))
	    (combine-tonicities (invert-tonicity (tonicity-as-operator symbol ?t arity))
				(tonicity-as-operator symbol ?phi arity)))
	   ((not ?phi)
	    (invert-tonicity (tonicity-as-operator symbol ?phi arity)))
	   ((implies ?psi ?phi)
	    (combine-tonicities (invert-tonicity (tonicity-as-operator symbol ?psi arity))
				(tonicity-as-operator symbol ?phi arity)))
	   (:anything 'both)))))

(rule large-cons-2 ((is ?c ?a-cons-cell)
		    (there-exists ?c)
		    (classify! ?c)
		    (at-most-one ?c))
  (=intern ?c (apply (apply ?cons-function (apply ?car-function ?c))
		     (apply ?cdr-function ?c))))
