;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'ontic)

;The following is a way of representing arbitrary lisp
;objects as ontic nodes.

(bnf (class (lisp-object ontic-gensym)
	    (a-symbol)
	    (an-integer)))

(deftranslator quote (object)
  (unless (or (symbolp object) (member object '(0 1)))
    (if (numberp object)
	(ontic-error (format nil "Only 0 and 1 are recognized as numbers, can't handle ~s" object))
	(ontic-error (format nil "Attempt to insert quoted object ~s" object))))
  `(lisp-object ,(object>gensym-expression object)))

(declare-variables (class ?c ?c1 ?c2)
		   (ontic-gensym ?n))

(def-rule-const ?an-integer (an-integer))
(def-rule-const ?a-symbol (a-symbol))

(rule object-typing-integer ((= ?c (lisp-object ?n))
			     (when (integerp (gensym-expression>object (object-expression ?n))))
			     (constant ?an-integer))
  (is ?c ?an-integer))

(rule object-typing-symbol ((= ?c (lisp-object ?n))
			    (when (symbolp (gensym-expression>object (object-expression ?n))))
			    (constant ?a-symbol))
  (is ?c ?a-symbol))

(declare-variables (ontic-gensym ?n1 ?n2))

(rule object-distinctness ((= (lisp-object ?n1) (lisp-object ?n2)))
  (:lisp
   (let ((o1 (gensym-expression>object (object-expression ?n1)))
	 (o2 (gensym-expression>object (object-expression ?n2))))
     (when (or (and (numberp o1)
		    (numberp o2)
		    (not (= o1 o2)))
	       (and (symbolp o1)
		    (symbolp o2)
		    (not (eq o1 o2))))
       (assert-contradiction :justification
			     (make-justification ": distinct constants proved equal"
			       (list (make-invocation-frame (= o1 o2)
				       ?justification))))))))

(rule object-existence ((= ?c (lisp-object ?n)))
  (there-exists ?c))

(rule object-at-most-one ((= ?c (lisp-object ?n)))
  (at-most-one ?c))



;
(defvar function-token (gensym "FUNCTION-OBJECT"))

(defun make-function-object (function)
  (list function-token function (gensym "UNIQUE-ID-")))

(defun function-object? (x)
  (and (consp x)
       (eq (car x) function-token)))

(defun function-part (fun-obj)
  (cadr fun-obj))

;For example, the file ontic-init-load.lisp contains the following.
;
;(axiom-fun `(= 1+ ',(make-function-object '1+)))
;
;(axiom-fun `(= 1- ',(make-function-object '1-)))
;
;(defun curried-+ (x)
;  (make-function-object
;   (lambda (y)
;     (+ x y))))
;
;(axiom-fun `(= +  ',(make-function-object 'curried-+)))
;
;Function objects are guaranteed to be unique so that, for example, the function
;1+ can not be proven to be equal to the symbol '1+ as would happen if
;we used (axiom (= 1+ '1+)) instead of the above.

(declare-variables (class ?a ?f ?x) (ontic-gensym ?fobj ?xobj))

;
;(rule compute-value ((= ?a (apply ?f ?x))
;		     (= ?f (lisp-object ?fobj))
;		     (is ?x (apply (domain-operator) ?f))
;		     (= ?x (lisp-object ?xobj)))
;      (:lisp
;       (let ((xobj (node>object ?xobj))
;	     (fobj (node>object ?fobj)))
;	 (when (function-object? fobj)
;	   (equate! ?a
;		    (make-lisp-object
;		     (object>node
;		      (funcall (function-part fobj) xobj))))))))


