;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :ontic)

(clear-language)


;********************************************************************
;number>node and node>number
;********************************************************************

;(declare-categories ontic-number) ;done in (clear-language)

(defun number>node (n)
  (cintern (list n)))

(defun number>node-expression (n) (list n))

(defun node>number (node)
  (phrase-constructor (the-one (productions-from node))))


;********************************************************************
;gensyms
;********************************************************************

;(declare-categories ontic-gensym) ;done in (clear-language)

(declare-variables (ontic-gensym ?n ?n1 ?n2))

(bnf (ontic-gensym (the-gensym ontic-number)))

(defvar *gensym-count* 0)

(defpiece (ontic-init-phase1 :set-gensym-count) ()
  (setq *gensym-count* 0))

(deftranslator gensym ()
  (new-gensym-expression))

(defun new-gensym-expression ()
  `(the-gensym ,(number>node-expression (incf *gensym-count*))))

(defun new-gensym ()
  (cintern (new-gensym-expression)))



;********************************************************************
;basic formulas
;********************************************************************

;formula is a distinguished category in the file syntax.lisp

;(declare-categories formula) ;done in (clear-language)

(declare-variables (formula ?phi ?psi ?theta ?phi1 ?phi2))

;; Done in (clear-language)
;(bnf (formula (is-true formula)
;	      (not formula)
;	      (= basic-object basic-object)))

(declare-variables (basic-object ?b1 ?b2))
(rule =-symmetry ((= ?phi (= ?b1 ?b2))
		  (= ?psi (= ?b2 ?b1)))
  (= ?phi ?psi))


;The formulas true and false.

(bnf (formula (true) (false)))

(rule false-1 ((= ?phi (false)))
      (not ?phi))

(rule true-1 ((= ?phi (true)))
      ?phi)


(defsequent refutation-sequent
    ((sequent ((assume ?phi))
       (theorem (false))))
  (theorem (not ?phi)))

(defsequent case-sequent
    ((sequent ((assume ?psi))
       (theorem ?phi))
     (sequent ((assume (not ?psi)))
       (theorem ?phi)))
  (theorem ?phi))

(defsequent implication-introduction-sequent
    ((sequent ((assume ?phi))
       (theorem ?psi)))
  (theorem (implies ?phi ?psi)))


;; Suppose is now a special form.
;;(defmac suppose
;;  (suppose ?phi . ?body)
;;  t
;;  (let-proof (((theorem (implies ?phi ?psi))
;;	       (implication-introduction-sequent
;;		(sequent ((assume ?phi))
;;			 (proof-body . ?body)))))
;;    (first
;;     (case-sequent
;;      (sequent ((assume ?phi))
;;	(note ?psi :goal-stack nil))
;;      (sequent ((assume (not ?phi)))
;;	(note ?psi :goal-stack nil)))
;;     (note (implies ?phi ?psi)))))

(defmac suppose-for-refutation
  (suppose-for-refutation ?phi . ?body)
  t
  (lemma
   (refutation-sequent
    (sequent ((assume ?phi))
      (show (false)
	. ?body)))))

(emacs-indent suppose-not 0)
(defmac suppose-not
  (suppose-not . ?body)
  *goal*
  (lisp-let ((?phi *goal*))
    (suppose-for-refutation (not ?phi) . ?body)))


(emacs-indent suppose-for-cases 1)
(emacs-indent suppose-for-refutation 1)
(emacs-indent suppose 1)

(defmac suppose-for-cases-list
  (suppose-for-cases (?phi . ?rest) . ?body)
  t
  (progn (suppose ?phi 
	   (suppose-for-cases ?rest . ?body))
	 (suppose (not ?phi)
	   (suppose-for-cases ?rest . ?body))))

(defmac suppose-for-cases-base
  (suppose-for-cases nil . ?body)
  t
  (progn . ?body))
  



;Boolean Connectives

;The constructor not is defined in the function clear-language.

;The only other internal Boolean connective is implies.

;Other Boolean conectives are done with translation.

(bnf (formula (implies formula formula)))

(declare-variables (formula ?p ?q ?phi ?imp))

(rule not-1 ()
  (= (not (not ?phi)) ?phi))

(rule implies-1
      ((implies ?p ?q)
       ?p)
  ?q)

(rule implies-2
      ((implies ?q ?p)
       (not ?p))
  (not ?q))

(rule implies-3
      ((= ?imp (implies ?p ?q))
       (not ?p))
  ?imp)

(rule implies-4
      ((= ?imp (implies ?p ?q))
       ?q)
  ?imp)

(rule implies-5
      ((= ?phi (implies ?p ?q))
	?p
	(not ?q))
  (not ?phi))

(rule implies-6
      ((not (implies ?p ?q)))
  ?p)

(rule implies-7
      ((not (implies ?p ?q)))
  (not ?q))

(rule implies-8
    ((= ?p (= ?phi ?psi))
     (implies ?phi ?psi)
     (implies ?psi ?phi))
  ?p)

(deftranslator or (arg1 &rest args)
  (if args
      `(implies (not ,(translate arg1)) ,(apply #'or-translator args))
      (translate arg1)))

(deftranslator and (arg1 &rest args)
  (if args
      `(not (implies ,(translate arg1) (not ,(apply #'and-translator args))))
      (translate arg1)))

(deftranslator iff (p q)
  `(= ,(translate p) ,(translate q)))

(rule iff-true ((= ?p (= ?phi ?psi))
		?phi
		?psi)
  ?p)


;********************************************************************
;object>node and gensym-expression>object
;********************************************************************

(defvar *object>node-table* (make-hash-table))

(defvar *node>object-table* (make-hash-table :test #'equal))

(defpiece (ontic-init-phase1 clear-quotation-tables) ()
  (clrhash *object>node-table*)
  (clrhash *node>object-table*))

;the caching of object>node must be undone because *node-count*
;is undone and node numbers would be duplicated if nodes
;created in a deep context were saved in the cache.

(defun object>gensym-expression (object)
  (let ((val (gethash object *object>node-table*)))
    (or val
	(let ((node-expression (new-gensym-expression)))
	  (setf (gethash object *object>node-table*) node-expression)
	  (setf (gethash node-expression *node>object-table*) object)
	  node-expression))))

(defun gensym-expression>object (gensym-expression)
  (mvlet (((val flag) (gethash gensym-expression *node>object-table*)))
    (if flag
	val
	(error "illegal attempt to convert a gensym expression to an object"))))


;;;********************************************************************
;;;Holders
;;;********************************************************************
;;
;;;(declare-categories holder)
;;;This allows the user to define expressions of type holder.
;;
;;;The function ADD-DEMON takes a holder and a demon and adds the demon to
;;;the holder (the holder "holds" the demon).  The demon must be a lisp procedure
;;;of one argument that can can be applied to class objects.  Typically, a demon asserts
;;;some property of its argument.  If d is a demon and x is a class
;;;then applying d to x asserts something about x.  For example, applying d to
;;;x might assert that (f x) equals B[x] where f is a lambda expression
;;;with body B.
;;
;;;The function APPLY-HOLDER takes a holder and a class and applies all the demons
;;;held by that holder to the given class.  The holder holds both a set of demons and
;;;a set of classes and every demon is applied to every class independent of the order
;;;in which demons and classes are given to the holder.  Furthermore, holders can be
;;;equated in which case the resulting merged holder contains all of the demons and classes
;;;from each of the merged holders.
;;
;;;Each holder has a type.
;;
;;;(bnf (class (holder-type holder)))
;;;
;;;The demons held by a holder must have the property
;;;that they can be soundly applied to any element of that type.  Holder types
;;;are important because of the semantic-modulation based implementation.
;;;Even if a holder is never applied to a class, the demons in the holder
;;;will be applied to variable values.  When a holder is applied to a class
;;;the class is equated to a varaible value to which the demons have been applied.
;;;To avoid creating impossible objects, and unsounding infering the existence of
;;;such objects, the holder can not apply demons to variable values until it knows
;;;that the holder type is non-empty.
;;
;;;****************************************************************************************************
;;;  IMPLEMENTATION
;;;****************************************************************************************************
;;
;;;The implementation of holders is based on semantic modulation.
;;;The demons are applied to "variables" which are then (in deeper contexts)
;;;temporarily equated to classes to which the holders are applied.
;;
;;;A variable has an ``identity'' distinct from its value.
;;;The independent existence of the variable allows us to
;;;keep track of whether or not a variable has been bound.
;;
(declare-categories class)

(bnf (formula (there-exists class)
	      (at-most-one class)
	      (singleton class)
	      (is class class)))

(declare-variables (class ?x))

(rule singleton-1 ((there-exists ?x)
		   (at-most-one ?x))
  (singleton ?x))

(rule singleton-2 ((singleton ?x))
  (there-exists ?x))

(rule singleton-3 ((singleton ?x))
  (at-most-one ?x))

(deftranslator every (class1 class2)
  `(is ,(translate class1) ,(translate class2)))

(declare-variables (class ?x ?y ?z ?x1 ?x2
			  ?a ?b ?c ?d ?e ?a1 ?a2 ?b1 ?b2 ?c1 ?c2 ?e1 ?e2
			  ?f ?g ?f1 ?f2 ?g1 ?g2 ?fun ?fun1 ?fun2
			  ?type ?t ?t1 ?t2))

;;(declare-categories ontic-variable)
;;
;;(declare-variables (ontic-variable ?v ?v1 ?v2))
;;
;;(bnf (ontic-variable (variable ontic-gensym))
;;     (class (value ontic-variable)))
;;
;;(bnf (formula (bound ontic-variable)))
;;
;;(defun new-variable ()
;;  (make-variable (new-gensym)))
;;
;;(rule variable-has-a-value ((= ?v (variable ?n)))
;;  (:lisp (make-value ?v)))
;;
;;(rule variable-2 ((= ?x (value (variable ?n))))
;;  (at-most-one ?x))
;;
;;(rule variable-3 ((= ?x (value (variable ?n))))
;;  (there-exists ?x))
;;
;;;bind! is used in semantic modulation
;;
;;(defun bind! (var class)
;;  (assert-bound var :true)
;;  (equate! (make-value var) class))
;;
;;;Note that ``being bound'' is a property of a variable, not a property
;;;of the value of the variable.
;;
;;
;;;We start with a correct but inefficient implementation of holders.
;;;For reasons to become clear below, these inefficient holders are called
;;;internal holders, or iholders.
;;
;;(declare-categories internal-holder)
;;
;;(bnf (internal-holder (iholder ontic-gensym)))
;;
;;(setf (gethash 'iholder *constructor-weight*) *infinity*)
;;
;;;To get the effect of semantic modulation we create at least one variable
;;;for each iholder in the base context even if the iholder has never been applied.
;;
;;(defun new-iholder ()
;;  (let ((iholder (make-iholder (new-gensym))))
;;    (assert-held-variable iholder (new-variable))
;;    iholder))
;;
;;;The following two formulas define slots on iholders that actually
;;;do the holding.
;;
;;(bnf (formula (held-demon internal-holder ontic-gensym)
;;	      (held-variable internal-holder ontic-variable)))
;;
;;(declare-variables (internal-holder ?iholder) (class ?var-val))
;;
;;;; The rule which actually runs the demons was moved into the
;;;; section on holders, below.
;;
;;(defun add-demon-to-iholder (iholder demon)
;;  (assert-held-demon iholder (object>node demon)))
;;
;;(defun apply-iholder (iholder x)
;;  (unless (some (lambda (var) (eq (make-value var) (uf-find x)))
;;		(held-variable-forward iholder))
;;    (bind! (get-free-variable iholder) x)))
;;
;;(defun get-free-variable (iholder)
;;  (or (find-if-not 'bound? (held-variable-forward iholder))
;;      (let ((var (new-variable)))
;;	(assert-held-variable iholder var)
;;	var)))
;;
;;
;;
;;;For efficiency reasons it is important to minimize the number of times a
;;;given demon is applied.  Suppose that three holders have been equated.
;;;Each holder has at least one variable (all holders have at least one
;;;variable).  Equating three iholders would result in an iholder with
;;;three variables and each demon would be applied three times instead
;;;of once.  With nested demons (demons that create
;;;demons) this repeated application can multiply.  To avoid unnecessary repeated
;;;demon application we avoid equating iholders.  Instead we think of iholders
;;;themselves as demons which can be applied and create another level of holder.
;;;Holders, unlike iholders, can be equated.  However, if a holder is never equated
;;;then it contains exactly one iholder and behaves exactly as that
;;;single iholder would behave.
;;
;;(declare-categories holder)
;;
;;(declare-variables (holder ?holder))
;;
;;(bnf (formula (held-iholder holder internal-holder))
;;     (formula (held-class holder class))
;;     (class (holder-type holder)))
;;
;;(rule run-demons ((held-demon ?iholder ?n)
;;		  (held-variable ?iholder ?v)
;;		  (= ?var-val (value ?v))
;;		  (held-iholder ?holder ?iholder)
;;		  (there-exists (holder-type ?holder)))
;;  (:lisp (funcall (node>object ?n) ?var-val)))
;;
;;(defun get-iholder (holder)
;;  (or (car (held-iholder-forward holder))
;;      (let ((iholder (new-iholder)))
;;	(assert-held-iholder holder iholder)
;;	(make-holder-type holder)
;;	iholder)))
;;
;;(declare-variables (class ?holder-type))
;;(rule apply-iholders ((held-iholder ?holder ?iholder)
;;		      (= ?holder-type (holder-type ?holder))
;;		      (there-exists ?holder-type)
;;		      (held-class ?holder ?x))
;;  (:lisp (apply-iholder ?iholder ?x)))
;;
;;
;;(defun add-demon (holder demon)
;;  (add-demon-to-iholder (get-iholder holder) demon))
;;
;;(defun apply-holder (holder class)
;;  (assert-held-class (uf-find holder) (uf-find class)))


;********************************************************************
;De Bruijn numbers
;********************************************************************

(bnf (class (de-bruijn ontic-number)))

(declare-variables (ontic-number ?number))

(rule de-bruijn-existence ((= ?x (de-bruijn ?number)))
  (there-exists ?x))

(rule de-bruijn-uniqueness ((= ?x (de-bruijn ?number)))
  (at-most-one ?x))

(defpiece (notice-nullary-production nullary-db-closedness) (lhs constructor)
  (set-db-index lhs 0))

(defpiece (notice-unary-production unary-db-closedness) (lhs constructor arg)
  (propagate-db-index lhs constructor (list arg)))

(defpiece (notice-binary-production binary-db-closedness) (lhs constructor arg1 arg2)
  (propagate-db-index lhs constructor (list arg1 arg2)))

;; for use during inference propagation
;;
(defun db-index-so-far (node)
  (or (db-index node) *infinity*))

(defpiecefun notice-db-index (node))
(defmergefun merged-notice-db-index (?node))
(definterpfun interpreted-notice-db-index (?node))

(defun propagate-db-index (lhs const rhs)
  (case const
    ((db-class-combinator db-formula-combinator)
     (when (db-index (first rhs))
       (set-db-index lhs (max 0 (1- (db-index (first rhs)))))))
    (de-bruijn (set-db-index lhs (node>number (first rhs))))
    (apply-substitution nil)
    (subst-value-reindexing nil)
    (t (when (every #'db-index rhs)
	 (set-db-index lhs (apply #'max (mapcar #'db-index rhs)))))))

(defun set-db-index (node value)
  (let ((old-value (db-index node)))
    (when (or (null old-value)
	      (< value old-value))
      (setf-undo (db-index node) value)
      (notice-db-index node)
      (mapc #'(lambda (prod)
		(propagate-db-index (lhs prod) (phrase-constructor prod) (rhs prod)))
	    (productions-to node)))))

(defpiece (notice-db-index call-merged-notice) (node)
  (merged-notice-db-index node)
  (interpreted-notice-db-index node))


(declare-variables (ontic-number ?n) (class ?c))

(definline db-closed? (x)
  (zerop (db-index x)))

(bnf (formula (closed anything)))

(defpiece (notice-db-index :check-for-closedness) (node)
  (when (= (db-index node) 0)
    (assert-closed-internal node :true)))

(rule de-bruijn-openness ((= ?c (de-bruijn ?n)))
  (not (closed ?c)))


;********************************************************************
;Combinators
;********************************************************************
;;; obsolete comments deleted  ---rlg
;********************************************************************
;Implementation
;********************************************************************

(declare-categories class-combinator formula-combinator)

(declare-variables (class-combinator ?c-body ?c-body1 ?c-body2))
(declare-variables (formula-combinator ?c-phi ?c-phi1 ?c-phi2))

(bnf (class-combinator (db-class-combinator class))
     (formula-combinator (db-formula-combinator formula))
     (class (apply-class-combinator class-combinator class))
     (formula (apply-formula-combinator formula-combinator class)))

;; apply-formula-combinator should never be a minimal production.
(setf (gethash 'apply-formula-combinator *constructor-weight*) *infinity*)
(setf (gethash 'apply-class-combinator *constructor-weight*) *infinity*)

;The following is more useful than make-db-class-combinator as
;created by the above bnf.

(defun db-class-combinator (var translated-body)
  (make-db-class-combinator (cintern (insert-db-number var 1 translated-body))))

(defun db-formula-combinator (var translated-body)
  (make-db-formula-combinator (cintern (insert-db-number var 1 translated-body))))

(deftranslator class-combinator (var body)
  `(db-class-combinator ,(insert-db-number var 1 (translate body))))

(deftranslator formula-combinator (var body)
  `(db-formula-combinator ,(insert-db-number var 1 (translate body))))

(defun insert-db-number (var-name number expression)
  (cond ((eq expression var-name) `(de-bruijn (,number)))
	((atom expression) expression)
	(t (let ((constructor (first expression))
		 (children (rest expression)))
	     (if (member constructor '(db-formula-combinator db-class-combinator))
		 `(,constructor ,(insert-db-number var-name (1+ number) (first children)))
		 `(,constructor ,@(mapcar (lambda (arg) (insert-db-number var-name number arg))
					  children)))))))


(defun equate-combinator (node comb arg justification)
  (let ((prod (the-one (remove-if #'(lambda (prod) (eq 'fix-comb (phrase-constructor prod)))
				  (productions-from comb)))))
    (unless (member (phrase-constructor prod) '(db-class-combinator db-formula-combinator))
      (declare-ontic-bug "Combinator with non-combinator destructuring"))
    (db-substitution node (first (rhs prod)) arg
		     (make-justification 'db-substitution
		       (list (make-invocation-frame (equate-combinator node comb arg)
			       justification))))))

(declare-variables (class ?x ?y) (formula ?phi))

(rule apply-formula-combinator ((= ?phi (apply-formula-combinator ?c-phi ?x))
				(when (zerop (db-index-so-far ?phi))
				  (notice-db-index ?phi)))
  (queue *delay-q*
    (:lisp
      (equate-combinator ?phi ?c-phi ?x ?justification))))

(rule apply-class-combinator ((= ?y (apply-class-combinator ?c-body ?x))
			      (when (zerop (db-index-so-far ?y))
				(notice-db-index ?y)))
  (queue *delay-q*
    (:lisp
      (equate-combinator ?y ?c-body ?x ?justification))))

;; calls to this function should only occur when quiescent
;;

(defun simple-db-substitution (node argument justification)
  (unless *quiescent?*
    (declare-ontic-bug "APPLY-COMBINATOR called in non-quiescent state"))
  (if (not *record-justifications*)
      (values (non-recording-db-substitution nil node argument) nil)
      (mvlet (((new-node rframe) (cintern (db-subst-expression node argument 1)
					  :justification
					  (make-invocation-frame (db-substitution node argument)
					    justification))))
	(values new-node (make-return-frame (simple-db-substitution node argument) new-node
			   (make-justification 'simple-db-substitution
			     (list rframe)))))))

(defun simple-db-substitution-hashlist (constructor db-arg1 db-arg2 argument justification)
  (mvlet (((new-arg1 rframe1) (simple-db-substitution db-arg1 argument justification))
	  ((new-arg2 rframe2) (simple-db-substitution db-arg2 argument justification)))
    (let ((iframe (when *record-justifications*
		    (make-invocation-frame (simple-db-substitution-hashlist constructor db-arg1 db-arg2 argument)
		      justification))))
    (mvlet (((new-node hframes)
	     (hashlist constructor (list new-arg1 new-arg2)
		       :justification
		       (when *record-justifications*
			 (make-justification 'simple-db-substitution-hashlist
			   (append (list iframe)
				   (cons-when rframe1
					      (cons-when rframe2 nil))))))))
      (values new-node
	      (when (and *record-justifications*
			 (or rframe1 rframe2 hframes))
		(make-return-frame (simple-db-substitution-hashlist constructor db-arg1 db-arg2 argument) new-node
		  (make-justification 'simple-db-substitution-hashlist
		    (cons-when rframe1
			       (cons-when rframe2 hframes))))))))))

(defun db-substitution (equate node argument justification)
  (unless *quiescent?*
    (declare-ontic-bug "APPLY-COMBINATOR called in non-quiescent state"))
  (if *record-justifications*
      (recording-db-substitution equate node argument justification)
      (non-recording-db-substitution equate node argument)))

(defun recording-db-substitution (equate node argument justification)
  (let ((expression (db-subst-expression node argument 1)))
    (mvlet (((node iframe) (cintern expression :justification justification)))
      (equate! node equate :justification (add-frames justification iframe)))))


(defun db-subst-expression (node argument db-index)
  (if (db-closed? node)
      node
      (let ((prod (smallest-lhs-production node)))
	(unless prod
	  (declare-ontic-bug "db-open node without production"))
	(let ((constructor (phrase-constructor prod))
	      (rhs (rhs prod)))
	  (if (eq constructor 'de-bruijn)
	      (let ((number (node>number (first rhs))))
		(cond ((= number db-index)
		       argument)
		      ((> number db-index)
		       ;;(declare-ontic-bug "APPLY-COMBINATOR called on db-open comb")
		       `(de-bruijn (,(1- number))))
		      (t node)))
	      (let ((next-index (if (member constructor
					    '(db-class-combinator db-formula-combinator))
				    (1+ db-index)
				    db-index)))
		(cons constructor
		      (mapcar (lambda (child)
				(db-subst-expression child argument next-index))
			      rhs))))))))

;;;(declare-categories arg-list apply-multiple-descriptor)
;;;(bnf (arg-list (arg-cons class arg-list)
;;;	       (arg-nil))
;;;     (apply-multiple-descriptor (describe-apply-multiple anything arg-list))
;;;     (formula (apply-multiple-cache apply-multiple-descriptor (anything :rare t))))
;;;
;;;(defun make-argtuple (arguments)
;;;  (if arguments
;;;      (make-arg-cons (first arguments) (make-argtuple (rest arguments)))
;;;      (make-arg-nil)))

(defun non-recording-db-substitute-multiple (node arguments)
;;;  (let* ((cache-key (make-describe-apply-multiple node (make-argtuple arguments)))
;;;	 (cache-result (apply-multiple-cache-forward-internal cache-key)))
;;;    (or (first cache-result)
;;;	(let ((result (non-recording-db-substitute-multiple-nocache node arguments 1)))
;;;	  (assert-is-true (make-apply-multiple-cache cache-key result) :true)
;;;	  result)))
  (non-recording-db-substitute-multiple-nocache node arguments 0)
  )

(defun combinator-constructor? (const)
  (or (eq const 'db-formula-combinator)
      (eq const 'db-class-combinator)))

;subst-list is a substitution represented as a list, i.e., a list of
;of class nodes and the symbol 'reindex.  If previous count is 0, as in the initial
;call,  then the first element of subst-list refers to deBruijn 1.  As we descend through
;quantififiers previous-count is incremented and in general the first element of subst-list
;refers to deBrjuin (+ 1 previous-count). (+ (length subst-list) previous-count)
;is the number of debruijn numbers that are currently meaningful.  The node should
;not contain unmeaningful debruijn numbers.



(defun non-recording-db-substitute-multiple-nocache (node subst-list previous-count)
  (if (zerop (db-index node))
      node
      (let ((prod (smallest-lhs-production node)))
	(unless prod
	  (declare-ontic-bug "db-open node without production of print-size size"))
	(let ((constructor (phrase-constructor prod))
	      (rhs (rhs prod)))
	  (cond
	    ((eq constructor 'de-bruijn)
	     (let ((number (node>number (first rhs))))
	       (cond ((<= number previous-count)
		      node)
		     ((> number (+ previous-count (length subst-list)))
		      (declare-ontic-bug "unmeaningul node in substitution"))
		     (t (subst-value subst-list (- number previous-count) previous-count)))))
	    (t
	     (let ((next-previous (if (combinator-constructor? constructor) (1+ previous-count) previous-count)))
	       (hashlist constructor
			 (mapcar #'(lambda (child)
				     (non-recording-db-substitute-multiple-nocache child subst-list next-previous))
				 rhs)))))))))

(defun subst-value (subst-list index previous-count)
  (cond ((null subst-list)
	 (declare-ontic-bug "ilegal call to subst-value"))
	((eq (car subst-list) 'reindex)
	 (if (= index 1)
	     (make-de-bruijn (number>node (1+ previous-count)))
	     (subst-value (cdr subst-list) (1- index) (1+ previous-count))))
	(t
	 (if (= index 1)
	     (car subst-list)
	     (subst-value (cdr subst-list) (1- index) previous-count)))))

(defun non-recording-db-substitution (equate node argument)
  (let ((original-equate equate))
    (labels ((db-subst (node2 db-index equate production)
	       (if (zerop (db-index node2))
		   (progn
		     (when equate
		       (equate! equate node2))
		     node2)
		   (let ((prod (smallest-lhs-production node2)))
		     (unless prod
		       (declare-ontic-bug "db-open node without production of print-size size"))
		     (let ((constructor (phrase-constructor prod))
			   (rhs (rhs prod)))
		       (cond
			 ((eq constructor 'de-bruijn)
			  (let ((number (node>number (first rhs))))
			    (cond ((= number db-index)
				   (when equate
				     (equate! argument equate)) argument)
				  ((> number db-index)
;;;			         (declare-ontic-bug "APPLY-COMBINATOR called on db-open comb")
				   (let ((result (hashlist 'de-bruijn
							   (list (hashlist (1- number) nil)))))
				     (when equate (equate! result equate))
				     result))
				  (t (when equate (equate! node2 equate))  node2))))
			 ((and (eq constructor '=)
			       equate
			       (formula-p equate)
			       (eq (is-true-internal equate) :true))
			  (let ((prod1 (db-subst (first rhs) db-index nil t))
				(prod2 (db-subst (second rhs) db-index nil t)))
			    (let ((arg
				   (if (consp prod1)
				       (if (consp prod2)
					   (equate-productions (first prod1) (second prod1)
							       (first prod2) (second prod2))
					   (add-production prod2 (first prod1) (second prod1)))
				       (if (consp prod2)
					   (add-production prod1 (first prod2) (second prod2))
					   (progn
					     (equate! prod1 prod2)
					     (uf-find prod1))))))
			      (add-production equate '= (list arg arg)))))
			 (t (let* ((args (mapcar
					  (lambda (child)
					    (db-subst child
						      (apply-if (member constructor
									'(db-class-combinator
									  db-formula-combinator))
								'1+
								db-index)
						      nil
						      nil))
					  rhs)))
			      (if production
				  (list constructor args)
				  (if equate
				      (add-production equate constructor args)
				      (hashlist constructor args)))))))))))
      (db-subst node 1 equate nil))))


(defun expression-db-subst (t-exp argument db-index)
  (selectmatch t-exp
    ((de-bruijn (?n))
     (cond ((= ?n db-index)
	    argument)
	   ((> ?n db-index)
	    `(de-bruijn (,(1- ?n))))
	   (t t-exp)))
    ((?constructor . ?rhs)
     (let ((next-index (if (member ?constructor
				   '(db-class-combinator db-formula-combinator))
			   (1+ db-index)
			   db-index)))
       (cons ?constructor
	     (mapcar (lambda (child)
		       (expression-db-subst child argument next-index))
		     ?rhs))))
    (:anything t-exp)))

(defun expression-db-closed? (t-exp &optional (db-index 1))
  (selectmatch t-exp
    ((de-bruijn (?n))
     (< ?n db-index))
    ((?constructor . ?rhs)
     (let ((next-index (if (member ?constructor
				   '(db-class-combinator db-formula-combinator))
			   (1+ db-index)
			   db-index)))
       (every  (lambda (child)
		 (expression-db-closed? child next-index))
	       ?rhs)))
    (:anything t)))

(defun db-count (num formula)
  (cond ((atom formula) 0)
	(t (let ((constructor (car formula))
		 (args (cdr formula)))
	     (case constructor
	       (de-bruijn (if (= (caar args) num) 1 0))
	       ((db-class-combinator db-formula-combinator) (db-count (1+ num) (car args)))
	       (t (apply #'+ (mapcar (lambda (form) (db-count num form)) args))))))))

(defun expression-db-index (exp)
  (cond ((atom exp) 0)
	(t (let ((constructor (car exp))
		 (args (cdr exp)))
	     (case constructor
	       (de-bruijn (caar args))
	       ((db-class-combinator db-formula-combinator) (max 0 (1- (expression-db-index (car args)))))
	       (t (apply #'max (mapcar #'expression-db-index args))))))))


(defun swap-dbs (t-exp db1 db2)
  (selectmatch t-exp
    ((de-bruijn (?n))
     (cond ((= ?n db1) `(de-bruijn (,db2)))
	   ((= ?n db2) `(de-bruijn (,db1)))
	   (t t-exp)))
    ((?constructor . ?rhs)
     (if (member ?constructor
		 '(db-class-combinator db-formula-combinator))
	 (cons ?constructor
	       (mapcar (lambda (child)
			 (swap-dbs child (1+ db1) (1+ db2)))
		       ?rhs))
	 (cons ?constructor
	       (mapcar (lambda (child)
			 (swap-dbs child db1 db2))
		       ?rhs))))
    (:anything t-exp)))


(defun increment-dbs (t-exp &optional (db-bound 1) &key (inc-amount 1))
  (selectmatch t-exp
    ((de-bruijn (?n))
     (cond ((< ?n db-bound) t-exp)
	   (t `(de-bruijn (,(+ ?n inc-amount))))))
    ((?constructor . ?rhs)
     (let ((next-bound (if (member ?constructor
				   '(db-class-combinator db-formula-combinator))
			   (1+ db-bound)
			   db-bound)))
       (cons ?constructor
	     (mapcar (lambda (child)
		       (increment-dbs child next-bound :inc-amount inc-amount))
		     ?rhs))))
    (:anything t-exp)))

(defun decrement-dbs (t-exp &optional (db-bound 1))
  (selectmatch t-exp
    ((de-bruijn (?n))
     (cond ((< ?n db-bound) t-exp)
	   (t `(de-bruijn (,(1- ?n))))))
    ((?constructor . ?rhs)
     (let ((next-bound (if (member ?constructor
				   '(db-class-combinator db-formula-combinator))
			   (1+ db-bound)
			   db-bound)))
       (cons ?constructor
	     (mapcar (lambda (child)
		       (decrement-dbs child next-bound))
		     ?rhs))))
    (:anything t-exp)))