;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'ontic)

;Cons cells

(bnf (class (cons-function)
	    (car-function)
	    (cdr-function)))

(def-rule-const ?cons-function (cons-function))
(def-rule-const ?car-function (car-function))
(def-rule-const ?cdr-function (cdr-function))

(defun new-small-operator (x)
;;  (axiom-fun `(is ,x (an-operator)))  ;; If we say it's an operator, then it's small.
  (axiom-fun `(at-most-one ,x))
  (axiom-fun `(small-operator ,x))
  (axiom-fun `(there-exists ,x)))

(deftranslator cons (arg1 arg2)
  `(apply (apply (cons-function) ,(translate arg1)) ,(translate arg2)))

(deftranslator car (arg1)
  `(apply (car-function) ,(translate arg1)))

(deftranslator cdr (arg1)
  `(apply (cdr-function) ,(translate arg1)))

(defpiece (ontic-init-phase1 cons-car-cdr) ()
  (mapc 'new-small-operator '((cons-function) (car-function) (cdr-function))))
	 
(declare-variables (class ?a ?b ?c ?a1 ?a2 ?car-c ?cdr-c
			  ?cons ?cons-a ?cons-a-b
			  ?car-cons-a-b ?cdr-cons-a-b))

(rule cons-1 ((= ?cons-a-b (apply (apply ?cons-function ?a) ?b))
	      (= ?car-c (apply ?car-function ?c))
	      (is ?c ?cons-a-b)
	      (there-exists ?b))
      (is ?car-c ?a))

(rule cons-1a ((= ?cons-a-b (apply (apply ?cons-function ?a) ?b))
	       (= ?car-c (apply ?car-function ?c))
	       (is ?cons-a-b ?c)
	       (there-exists ?b))
      (is ?a ?car-c))

(rule cons-2 ((= ?cons-a-b (apply (apply ?cons-function ?a) ?b))
	      (= ?cdr-c (apply ?cdr-function ?c))
	      (is ?c ?cons-a-b)
	      (there-exists ?a))
      (is ?cdr-c ?b))

(rule cons-2a ((= ?cons-a-b (apply (apply ?cons-function ?a) ?b))
	       (= ?cdr-c (apply ?cdr-function ?c))
	       (is ?cons-a-b ?c)
	       (there-exists ?a))
      (is ?b ?cdr-c))


(rule cons-3 ((= ?cons-a-b (apply (apply ?cons-function ?a) ?b))
	      (there-exists ?a)
	      (there-exists ?b))
      (there-exists ?cons-a-b))

(rule cons-4 ((= ?cons-a-b (apply (apply ?cons-function ?a) ?b))
	      (at-most-one ?a)
	      (at-most-one ?b))
      (at-most-one ?cons-a-b))

(rule cons-5 ((= ?cons-a (apply ?cons-function ?a))
	      (there-exists ?a))
      (there-exists ?cons-a))

(rule cons-6 ((= ?cons-a (apply ?cons-function ?a))
	      (at-most-one ?a))
  (at-most-one ?cons-a))

(rule cons-7 ((= ?c (apply (apply ?cons-function ?a) ?b))
	      (is ?t ?c)
	      (there-exists ?t))
  (there-exists (apply ?car-function ?t)))

(rule cons-8 ((= ?c (apply (apply ?cons-function ?a) ?b))
	      (is ?t ?c)
	      (there-exists ?t))
  (there-exists (apply ?cdr-function ?t)))

 (rule cons-9 ((= ?c (apply (apply ?cons-function ?a) ?b))
	      (is ?t ?c)
	      (at-most-one ?t))
  (at-most-one (apply ?car-function ?t)))

(rule cons-10 ((= ?c (apply (apply ?cons-function ?a) ?b))
	       (is ?t ?c)
	       (at-most-one ?t))
  (at-most-one (apply ?cdr-function ?t)))

(deftranslator list (&rest args)
  (cond ((null args) (translate ''nil))
	((null (cdr args))
	 (translate `(cons ,(car args) 'nil)))
	(t
	 (translate `(cons ,(car args) (list ,@(cdr args)))))))



;
;thunks

(bnf (class (lambda0 class)
	    (funcall0-operator)
	    (lambda-rel0 class)))
(def-rule-const ?funcall0-operator (funcall0-operator))

(defpiece (ontic-init-phase1 funcall0) ()
  (new-small-operator '(funcall0-operator)))

(deftranslator funcall0 (thunk)
  `(apply (funcall0-operator) ,(translate thunk)))

(declare-variables (class ?a ?b ?thunk ?class))

(rule lambda0-2 ((= ?thunk (lambda0 ?class)))
  (at-most-one ?thunk))

(rule lambda0-3 ((= ?thunk (lambda0 ?class)))
  (there-exists ?thunk))

(rule apply0-1 ((= ?c (lambda0 ?class))
		(= ?a (apply ?funcall0-operator ?c)))
  (= ?a ?class))



(rule lambda-rel0-0 ((= ?thunk (lambda-rel0 ?class)))
  (there-exists ?thunk))

(rule apply0-rel-1 ((is ?c (lambda-rel0 ?class))
		    (at-most-one ?c)
		    (there-exists ?c)
		    (= ?a (apply ?funcall0-operator ?c)))
  (is ?a ?class))

(rule lambda-rel0-1 ((= ?thunk (lambda0 ?a)))
  (is ?thunk (lambda-rel0 ?a)))

(rule lambda-rel0-2 ((is ?a ?b))
      (is (lambda0 ?a) (lambda-rel0 ?b)))

(rule lambda-rel0-3 ((is (lambda0 ?a) (lambda-rel0 ?b)))
      (is ?a ?b))

(rule lambda-rel0-4 ((is ?a ?b))
      (is (lambda-rel0 ?a) (lambda-rel0 ?b)))

(rule lambda-rel0-5 ((is (lambda-rel0 ?a) (lambda-rel0 ?b)))
      (is ?a ?b))





;
;sets

(bnf (class (the-set-of-all-internal class)
	    (member-operator)
	    (subset-operator)))
(def-rule-const ?member-operator (member-operator))
(def-rule-const ?subset-operator (subset-operator))


(declare-variables (class ?t1 ?t2))
(rule the-set-of-all-classify!-prop ((classify! ?t1)
				     (is ?t1 (the-set-of-all-internal ?t2)))
  (classify! ?t2))

(defpiece (ontic-init-phase1 member-and-subset) ()
  (mapc 'new-small-operator '((member-operator) (subset-operator))))

(deftranslator a-member-of (set)
  `(apply (member-operator) ,(translate set)))

(deftranslator a-subset-of (set)
  `(apply (subset-operator) ,(translate set)))

(deftranslator the-set-of-all (&rest args)
  (cond ((= (length args) 1)
	 `(the-set-of-all-internal ,(translate (car args))))
	((and (= (length args) 4)
	      (eq (third args) 'such-that))
	 `(the-set-of-all-internal
	   ,(translate `(some-such-that ,(first args) ,(second args) ,(fourth args)))))
	(t
	 (ontic-error (format nil "ill-formed the-set-of-all expression")))))
	 

(declare-variables (class ?s ?t ?set ?set1 ?set2 ?set3 ?set4 ?set5 ?class))

(rule intern-member-of ((= ?s (the-set-of-all-internal ?t)))
  (intern (apply (member-operator) ?s)))

(rule the-set-of-all-internal-2 ((= ?set (the-set-of-all-internal ?class)))
  (at-most-one ?set))

(rule the-set-of-all-internal-3 ((= ?set (the-set-of-all-internal ?class)))
  (there-exists ?set))

(declare-variables (class ?member ?subset))

(rule member-of-1 ((= ?c (the-set-of-all-internal ?class))
		   (= ?a (apply ?member-operator ?c)))
  (= ?a ?class))



(rule subset-1 ((= ?set (the-set-of-all-internal ?class))
		(= ?set2 (apply ?subset-operator ?set)))
  (there-exists ?set2))

(rule subset-2 ((= ?set (the-set-of-all-internal ?class))
		(= ?set2 (apply ?subset-operator ?set))
		(= ?a (apply ?member-operator ?set2)))
  (= ?a ?class))


(rule subset-3 ((= ?s (the-set-of-all-internal ?a)))
  (is ?s (apply ?subset-operator ?s)))

(rule subset-4 ((is ?a ?b))
      (is (the-set-of-all-internal ?a) (apply ?subset-operator (the-set-of-all-internal ?b))))

(rule subset-5 ((is (the-set-of-all-internal ?a) (apply ?subset-operator (the-set-of-all-internal ?b))))
  (is ?a ?b))

(rule subset-6 ((is ?a ?b))
      (is (apply ?subset-operator (the-set-of-all-internal ?a))
	  (apply ?subset-operator (the-set-of-all-internal ?b))))

(rule subset-7 ((is (apply ?subset-operator (the-set-of-all-internal ?a))
		    (apply ?subset-operator (the-set-of-all-internal ?b))))
  (is ?a ?b))

(rule subset-8 ((not (there-exists ?c))
		(= ?phi (is (the-set-of-all-internal ?c) (apply ?subset-operator ?b))))
      ?phi)

(rule subset-9 ((is ?a (apply ?subset-operator ?b)))
  (is (apply ?member-operator ?a)
      (apply ?member-operator ?b)))

(defpiece (ontic-init-phase2 the-empty-set) ()
  (defontic (the-empty-set)
    (the-set-of-all-internal (fail))))

(def-rule-const ?the-empty-set (the-set-of-all-internal (fail)))

(rule set-of-all-not-there-exists ((= ?a (the-set-of-all-internal ?b))
				   (not (there-exists ?b)))
  (= ?a ?the-empty-set))


;operators

(bnf (class (db-lambda class class-combinator)
	    (db-lambda-fun class class-combinator)
	    (rel-from-to)
	    (partial-fun-from-to)
	    (total-rel-from-to)
	    (domain-operator)
	    (a-range-element class))
     (formula (operator-class class)
	      (generic-application (class :rare t) (class :rare t))
	      (set-monotone class)
	      (every-subset-some (class :rare t) (class :rare t))))

(rule lambda-class-down-is-arcs ((operator-class ?x)
				 (is ?y ?x))
  (operator-class ?y))

(def-rule-const ?rel-from-to (rel-from-to))
(def-rule-const ?partial-fun-from-to (partial-fun-from-to))
(def-rule-const ?total-rel-from-to (total-rel-from-to))
(def-rule-const ?domain-operator (domain-operator))

;; rel-from-to, partial-fun-from-to and total-rel-from-to cannot be small-operators
;; because they are binary
;; so we make them singleton here, and have dedicated smallness rules for them.

(rule rel-from-to-singleton ((= ?t (rel-from-to)))
  (at-most-one ?t)
  (there-exists ?t))

(rule total-rel-from-to-singleton ((= ?t (total-rel-from-to)))
  (at-most-one ?t)
  (there-exists ?t))

(rule partial-fun-from-to-singleton ((= ?t (partial-fun-from-to)))
  (at-most-one ?t)
  (there-exists ?t))

(defpiece (ontic-init-phase1 domain-operator) ()
  (new-small-operator '(domain-operator)))


;; The following depends on the current print-size format.
(setf (gethash 'db-lambda *constructor-weight*) '(1 . 1))

(deftranslator a-domain-member-of (fun)
  `(apply (domain-operator) ,(translate fun)))

(defun make-a-domain-member-of (x)
  (make-apply (make-domain-operator) x))

(deftranslator lambda (args body)
  (cond ((null args)
	 `(lambda0 ,(translate body)))
	((not (consp args))
	 (ontic-error "ill-formed lambda expression"))
	(t
	 (let ((body2 (if (cdr args)
			  `(lambda ,(cdr args) ,body)
			  body)))
	   (selectmatch (first args)
	     ((?var ?type)
	      `(db-lambda ,(translate ?type) ,(translate `(class-combinator ,?var ,body2))))
	     ((?var ?type such-that ?formula)
	      (translate `(lambda ((,?var (some-such-that ,?var ,?type ,?formula)))
			   ,body2)))
	     (:anything
	      (ontic-error "illegal syntax for ontic lambda")))))))

(deftranslator let (bindings body)
  (mvlet (((new-bindings alist)
	   (alpha-purify bindings)))
    (translate `((lambda ,new-bindings ,(sublis alist (translate body)))
		 ,@(mapcar #'second bindings)))))

(defun alpha-purify (bindings)
  (if (null bindings)
      (values nil nil)
      (let* ((var (first (car bindings)))
	     (new-var (gensym (string var))))
	(mvlet (((tail-bindings tail-alist)
		 (alpha-purify (cdr bindings))))
	  (values (cons (list new-var (second (first bindings)))
			tail-bindings)
		  (acons var new-var tail-alist))))))


(deftranslator let* (bindings body)
  (cond ((null bindings)
	 (translate body))
	((cdr bindings)
	 (translate `(let* (,(first bindings))
		       (let* ,(rest bindings) ,(translate body)))))
	(t (translate `((lambda ,bindings ,body) ,(second (first bindings)))))))


(deftranslator a-choice-function-from (&rest args)
  (selectmatch args
    (((?var ?type) to ?range-exp)
     (translate `(lambda-fun ((,?var ,?type)) ,?range-exp)))
    (((?var ?type) . ?rest)
     (if (> (length ?rest) 2)
	 (translate `(lambda-fun ((,?var ,?type)) ,(translate `(a-choice-function-from ,@?rest))))
	 (ontic-error "illegal syntax for a-choice-function-from")))
    (:anything
     (ontic-error "illegal syntax for a-choice-function-from"))))


(deftranslator lambda-fun (args body)
  (cond ((null args)
	 (ontic-error "lambda-fun must have at least one parameter"))
	((not (consp args))
	 (ontic-error "ill-formed lambda-fun expression"))
	(t
	 (let ((body2 (if (cdr args)
			  `(lambda-fun ,(cdr args) ,body)
			  body)))
	   (selectmatch (first args)
	     ((?var ?type)
	      `(db-lambda-fun ,(translate ?type) ,(translate `(class-combinator ,?var ,body2))))
	     ((?var ?type such-that ?formula)
	      (translate `(lambda-fun ((,?var (some-such-that ,?var ,?type ,?formula)))
			   ,body2)))
	     (:anything
	      (ontic-error "illegal syntax for ontic lambda-fun")))))))

(deftranslator an-operator-from (&rest args)
  (selectmatch args
    ((to ?range-type)
     (translate `(lambda-rel0 (a-member-of ,?range-type))))
    ((?type to ?range-type)
     (translate `((rel-from-to) ,?type ,?range-type)))
    ((?type . ?rest)
     (if (> (length ?rest) 2)
	 (translate `(a-function-from ,?type to ,(translate `(the-set-of-all (an-operator-from ,@?rest)))))
	 (ontic-error "illegal syntax for an-operator-from")))
    (:anything 	 (ontic-error "illegal syntax for an-operator-from"))))

(deftranslator a-total-operator-from (&rest args)
  (selectmatch args
    ((?type to ?range-type)
     (translate `((total-rel-from-to) ,?type ,?range-type)))
    ((?type . ?rest)
     (if (> (length ?rest) 2)
	 (translate `(a-function-from ,?type to (the-set-of-all (a-total-operator-from ,@?rest))))
	 (ontic-error "illegal syntax for an-total-operator-from")))
    (:anything 	 (ontic-error "illegal syntax for a-total-operator-from"))))

(deftranslator a-partial-function-from (&rest args)
  (selectmatch args
    ((?type to ?range-type)
     (translate `((partial-fun-from-to) ,?type ,?range-type)))
    ((?type . ?rest)
     (if (> (length ?rest) 2)
	 (translate `(a-function-from ,?type to (the-set-of-all (a-partial-function-from ,@?rest))))
	 (ontic-error "illegal syntax for an-partial-function-from")))
    (:anything 	 (ontic-error "illegal syntax for a-partial-function-from"))))

(deftranslator a-function-from (&rest args)
  (selectmatch args
    ((:anything to :anything)
     (translate `(both
		  (a-total-operator-from ,@args)
		  (a-partial-function-from ,@args))))
    ((?type . ?rest)
     (if (> (length ?rest) 2)
	 (translate `(a-function-from ,?type to (the-set-of-all (a-function-from ,@?rest))))
	 (ontic-error "illegal syntax for an-function-from")))
    (:anything 	 (ontic-error "illegal syntax for a-function-from"))))

;;;the predicate operator-class is used to identify classes of operators.

(declare-variables (class-combinator ?c-body)
		   (class ?s1 ?s2 ?s3 ?s4 ?f))

(rule recognize-db-lambda ((= ?f (db-lambda ?t ?c-body)))
  (operator-class ?f))

(rule recognize-db-lambda-fun ((= ?f (db-lambda-fun ?t ?c-body)))
  (operator-class ?f))

(rule recognize-rel-from-to ((= ?f (apply (apply ?rel-from-to ?s1) ?s2)))
  (operator-class ?f))

(rule recognize-partial-fun-from-to ((= ?f (apply (apply ?partial-fun-from-to ?s1) ?s2)))
  (operator-class ?f))

(rule recognize-total-rel-from-to ((= ?f (apply (apply ?total-rel-from-to ?s1) ?s2)))
  (operator-class ?f))

;without queueing the following rule can generate an infinite sequence of
;lambda expressions.

(rule operator-lambdaness ((operator-class ?c)
			   (there-exists ?c)
			   (at-most-one ?c)
			   (closed ?c))
  (queue *delay-q*
    (=intern ?c (db-lambda (apply ?domain-operator ?c)
			   (db-class-combinator (apply ?c (de-bruijn (1))))))))

(rule determined-lambda ((= ?f (db-lambda ?c ?c-body)))
  (at-most-one ?f))

(rule there-exists-lambda ((= ?f (db-lambda ?c ?c-body)))
  (there-exists ?f))

(def-rule-const ?empty-lambda (db-lambda (fail) (db-class-combinator (fail))))

(rule empty-lambda ((operator-class ?f)
		    (there-exists ?f)
		    (not (there-exists (apply ?domain-operator ?f))))
  (= ?f ?empty-lambda))

(declare-variables (class ?rel-space-builder ?builder ?range))

(rule empty-lambda-under-rel-space ((= ?builder (apply ?rel-space-builder ?the-empty-set))
				    (set-monotone ?builder)
				    (= ?phi (is ?empty-lambda (apply ?builder ?range))))
  ?phi)

(declare-variables (ontic-gensym ?n)
		   (class-combinator ?c-t1)
		   (class ?domain ?lf))

(rule there-exists-lambda-fun ((= ?c (const ?n ?domain))
			       (there-exists (apply-class-combinator ?c-t1 ?c))
			       (= ?lf (db-lambda-fun ?domain ?c-t1))
			       (when (> (max-constant ?n)
					(max (max-constant ?lf)
					     *last-assumption-max-const*))
				 (notice-max-constant ?lf)))
  (there-exists ?lf))

(rule there-exists-empty-lambda-fun ((= ?lf (db-lambda-fun ?domain ?c-t1))
				     (not (there-exists ?domain)))
  (there-exists ?lf))

(rule there-exists-lambda-fun-helper ((= ?c (const ?n ?domain))
				      (= ?lf (db-lambda-fun ?domain ?c-t1))
				      (classify! ?lf))
  (intern (apply-class-combinator ?c-t1 ?c)))

(declare-variables (class ?t1 ?t2 ?t3))

(rule there-exists-rel-from-to ((= ?f (apply (apply ?rel-from-to ?t1)
					     ?t2))
				(= (the-set-of-all-internal ?c1) ?t1)
				(= (the-set-of-all-internal ?c2) ?t2))
  (there-exists ?f))

(rule there-exists-total-rel-from-to ((= ?f (apply (apply ?total-rel-from-to ?t1)
						   ?t2))
				      (= (the-set-of-all-internal ?c1) ?t1)
				      (= (the-set-of-all-internal ?c2) ?t2)
				      (there-exists ?c2))
  (there-exists ?f))

(rule there-exists-partial-fun-from-to ((= ?f (apply (apply ?partial-fun-from-to ?t1)
						     ?t2))
					(= (the-set-of-all-internal ?c1) ?t1)
					(= (the-set-of-all-internal ?c2) ?t2))
  (there-exists ?f))

(rule there-exists-fun-from-to ((= ?f (intersection (apply (apply ?total-rel-from-to ?t1)
							   ?t2)
						    (apply (apply ?partial-fun-from-to ?t1)
							   ?t2)))
				(= (the-set-of-all-internal ?c1) ?t1)
				(= (the-set-of-all-internal ?c2) ?t2)
				(there-exists ?c2))
  (there-exists ?f))

(declare-variables (class ?body ?app ?arg))

(rule empty-body-lambda ((= ?f1 (db-lambda ?t (db-class-combinator ?body)))
			 (not (there-exists ?body))
			 (= ?app (apply ?f1 ?arg)))
  (not (there-exists ?app)))

;getting the domain out of an operator

(rule lambda-domain ((= ?c (db-lambda ?t1 ?c-body))
		     (= ?t2 (apply ?domain-operator ?c)))
  (= ?t2 ?t1))

(rule lambda-fun-domain ((= ?c (db-lambda-fun ?t1 ?c-body))
			 (there-exists ?c)
			 (= ?t2 (apply ?domain-operator ?c)))
  (= ?t2 ?t1))

(rule rel-from-to-domain ((is ?f (apply (apply ?rel-from-to ?s1)
					?s2))
			  (at-most-one ?s1)
			  (there-exists ?f)
			  (closed ?f))
  (=intern (apply ?domain-operator ?f) (apply ?member-operator ?s1)))

(rule partial-fun-from-to-domain ((is ?f (apply (apply ?partial-fun-from-to ?s1)
						?s2))
				  (at-most-one ?s1)
				  (there-exists ?f)
				  (closed ?f))
  (=intern (apply ?domain-operator ?f) (apply ?member-operator ?s1)))

(rule total-rel-from-to-domain ((is ?f (apply (apply ?total-rel-from-to ?s1)
					      ?s2))
				(at-most-one ?s1)
				(there-exists ?f)
				(closed ?f))
  (=intern (apply ?domain-operator ?f) (apply ?member-operator ?s1)))

(rule application-implies-domain-member ((= ?a (apply ?f ?x))
					 (operator-class ?f)
					 (there-exists ?a)
					 (at-most-one ?f)
					 (at-most-one ?x)
					 (= ?domain (apply ?domain-operator ?f)))
  (is ?x ?domain))

;the special properties

(rule lambda-fun-1 ((is ?f (db-lambda-fun ?type ?c-body))
		    (at-most-one ?f)
		    (= ?a (apply ?f ?x))
		    (at-most-one ?x))
  (at-most-one ?a))

(rule lambda-fun-2 ((is ?f (db-lambda-fun ?type ?c-body))
		    (there-exists ?f)
		    (= ?a (apply ?f ?x))
		    (there-exists ?x)
		    (is ?x ?type))
  (there-exists ?a))

(rule partial-fun-from-to-1 ((is ?f (apply (apply ?partial-fun-from-to ?type)
					   ?t2))
			     (at-most-one ?f)
			     (= ?a (apply ?f ?x))
			     (at-most-one ?x))
  (at-most-one ?a))

(rule total-rel-from-to-2 ((is ?f (apply (apply ?total-rel-from-to ?type) ?t2))
			   (there-exists ?f)
			   (= ?a (apply ?f ?x))
			   (there-exists ?x)
			   (at-most-one ?type)
			   (is ?x (apply ?member-operator ?type)))
  (there-exists ?a))

(declare-variables (class ?t ?c ?domain ?t2 ?f ?lr ?lf ?l1 ?l2 ?result ?app)
		   (class-combinator ?c-t1)
		   (ontic-gensym ?n))

(declare-variables (class ?rft-range ?rft-domain ?range ?rft ?range-set ?domain-set))


;range type

(declare-variables (class-combinator ?lambda-body)
		   (class ?rtype ?rtype2))

(rule intern-range-type ((operator-class ?f))
  (=intern (a-range-element ?f)
	   (apply ?f (apply ?domain-operator ?f))))

(rule rel-from-to-range-type ((= ?f (apply (apply ?rel-from-to ?s1) ?s2)))
  (force (is (a-range-element ?f) (apply (member-operator) ?s2))))

(rule partial-fun-from-to-range-type ((= ?f (apply (apply ?partial-fun-from-to ?s1) ?s2)))
  (force (is (a-range-element ?f) (apply (member-operator) ?s2))))

(rule total-rel-from-to-range-type ((= ?f (apply (apply ?total-rel-from-to ?s1) ?s2)))
  (force (is (a-range-element ?f) (apply (member-operator) ?s2))))

;;;proving formulas of the form (is ?f <function-type>).

(declare-variables (class ?t1 ?t2))

(declare-variables (class-combinator ?cc-body))

(rule monotonicity-2 ((classify! ?t)
		      (is ?t (apply (db-lambda ?t1 ?cc-body)  ?g))
		      (is ?t1 ?t2)
		      (is ?g ?g2))
  (is ?t (apply (db-lambda ?t2 ?cc-body) ?g2)))

(rule notice-generic-application ((= ?c (const ?n ?domain))
				  (= ?app (apply ?f ?c))
				  (= ?domain (apply ?domain-operator ?f)))
  (generic-application ?f ?c))


(rule classify-lambda-fun ((generic-application ?f ?c)
			   (= ?domain (apply ?domain-operator ?f))
			   (= ?app (apply ?f ?c))
			   (= ?lf (db-lambda-fun ?domain ?lambda-body))
			   (= ?t1 (apply-class-combinator ?lambda-body ?c))
			   (at-most-one ?app)
			   (there-exists ?app)
			   (is ?app ?t1)
			   (when (> (max-constant ?c)
				    (max (max-constant ?f)
					 (max-constant ?lf)
					 *last-assumption-max-const*))
			     (notice-max-constant ?f)
			     (notice-max-constant ?lf)))
  (is ?f ?lf))


(rule classify-lambda-funness-helper ((generic-application ?f ?c)
				      (= ?app (apply ?f ?c))
				      (at-most-one ?app)
				      (there-exists ?app)
				      (= ?lf (db-lambda-fun (apply ?domain-operator ?f) ?c-t1)))
  (intern (apply-class-combinator ?c-t1 ?c)))

(declare-variables (class ?s ?s1 ?s2 ?s3))

(rule classify-rel-from-to ((operator-class ?f)
			    (singleton ?f)
			    (classify! ?f))
  (force (is ?f
	     (apply (apply (rel-from-to)
			   (the-set-of-all-internal (apply (domain-operator) ?f)))
		    (the-set-of-all-internal (a-range-element ?f))))))

(rule classify-partial-fun-from-to ((generic-application ?f ?c)
				    (free-for-generalization ?c (?f))
				    (at-most-one (apply ?f ?c)))
  (force (is ?f
	     (apply (apply (partial-fun-from-to)
			   (the-set-of-all-internal (apply (domain-operator) ?f)))
		    (the-set-of-all-internal (a-range-element ?f))))))

(rule classify-total-rel-from-to ((generic-application ?f ?c)
				  (free-for-generalization ?c (?f))
				  (there-exists (apply ?f ?c)))
  (force (is ?f
	     (apply (apply (total-rel-from-to)
			   (the-set-of-all-internal (apply (domain-operator) ?f)))
		    (the-set-of-all-internal (a-range-element ?f))))))

(rule rel-from-to-monotonicity ()
  (set-monotone (apply ?rel-from-to ?s)))

(rule partial-fun-from-to-monotonicity ()
  (set-monotone (apply ?partial-fun-from-to ?s)))

(rule total-rel-from-to-monotonicity ()
  (set-monotone (apply ?total-rel-from-to ?s)))

(rule every-subset-some ((is (apply ?member-operator ?s1) (apply ?member-operator ?s2))
			 (singleton ?s2)
			 (is ?s2 ?s3))
  (every-subset-some ?s1 ?s3))

(rule set-monotonicity ((set-monotone ?f)
			(is ?f ?g)
			(every-subset-some ?s1 ?s2))
  (is (apply ?f ?s1) (apply ?g ?s2)))

(rule lambda-extensionality ((generic-application ?l1 ?c)
			     (generic-application ?l2 ?c)
			     (= (apply ?l1 ?c) (apply ?l2 ?c))
			     (singleton ?l1)
			     (singleton ?l2)
			     (free-for-generalization ?c (?l1 ?l2)))
  (= ?l1 ?l2))





;
;large thunks

(bnf (class (a-cons-cell)
	    (a-thunk)
	    (a-set)
	    (an-operator)
	    (a-thing)))

(def-rule-const ?a-thing (a-thing))
(def-rule-const ?an-operator (an-operator))
(def-rule-const ?a-thunk (a-thunk))
(def-rule-const ?a-set (a-set))
(def-rule-const ?a-cons-cell (a-cons-cell))

(defpiece (ontic-init-phase2 define-a-thing) ()
  (axiom (= (a-thing)
	    (either (a-symbol) (an-integer) (a-cons-cell)
		    (a-thunk) (a-set) (an-operator)))))

(bnf (formula (small class)
	      (small-operator class)))

(defvar *large-thunks* '(a-cons-cell a-thunk a-set an-operator a-thing
			 cons-function car-function cdr-function
			 funcall0-operator member-operator subset-operator
			 rel-from-to partial-fun-from-to total-rel-from-to
			 domain-operator))

(declare-variables (class ?f ?arg ?app))
(rule small-operators ((= ?app (apply ?f ?arg))
		       (small-operator ?f)
		       (small ?arg))
  (small ?app))

(declare-variables (class (?n-class-const) (?u-class-const class) (?b-class-const class class)))

(rule nullary-smallness ((= ?c (?n-class-const))
			 (when (not (member ?n-class-const *large-thunks*))))
  (small ?c))

(rule unary-smallness ((= ?c (?u-class-const ?a))
		       (small ?a))
  (small ?c))

(rule binary-smallness ((= ?c (?b-class-const ?a ?b))
			(small ?a)
			(small ?b))
  (small ?c))


(declare-variables (ontic-number ?o-n))
(rule de-bruijn-smallness ((= ?c (de-bruijn ?o-n)))
  (small ?c))
			   

(rule small-is-propagation ((is ?c1 ?c2)
			    (small ?c2))
  (small ?c1))

(rule the-zf-replacement-axiom ((small (apply ?f (const ?n ?t)))
				(small ?t)
				(when (> (max-constant ?n)
					 (max (max-constant ?f)
					      *last-assumption-max-const*))
				  (notice-max-constant ?f)))
  (small (apply ?f ?t)))


(declare-variables (class ?t ?l ?body) (ontic-number ?number))

(rule lambda-smallness ((= ?l (db-lambda ?t (db-class-combinator ?body)))
			(small ?body)
			(small ?t))
  (small ?l))

(rule lambda-fun-smallness ((= ?l (db-lambda-fun ?t (db-class-combinator ?body)))
			    (small ?body)
			    (small ?t))
  (small ?l))

(rule rel-from-to-smallness ((= ?l (apply (apply ?rel-from-to ?t)
					  ?t1))
			     (small ?t1)
			     (small ?t))
  (small ?l))

(rule total-rel-smallness ((= ?l (apply (apply ?total-rel-from-to ?t)
					  ?t1))
			     (small ?t1)
			     (small ?t))
  (small ?l))

(rule partial-fun-smallness ((= ?l (apply (apply ?partial-fun-from-to ?t)
					  ?t1))
			     (small ?t1)
			     (small ?t))
  (small ?l))


;
;cons cells

;The following rule, together with large-cons-2, will
;generate an infinite loop without
;the introduced delay.

(rule large-cons-1 ((= ?cons-a (apply ?cons-function ?a))
		    (= ?cons-a-b (apply ?cons-a ?b))
		    (when (= (db-index-so-far ?cons-a-b) 0) (notice-db-index ?cons-a-b))
		    (small ?cons-a-b))
  (queue *delay-q* (is ?cons-a-b ?a-cons-cell)))

(rule large-cons-2 ((is ?c ?a-cons-cell)
		    (classify! ?c)
		    (at-most-one ?c))
  (=intern ?c (apply (apply ?cons-function (apply ?car-function ?c))
		     (apply ?cdr-function ?c))))

;;;The following rule violates predicativity. -dam
;;    --you're right -rlg,cwitty

(rule large-cons-3 ((is ?c (a-cons-cell))
		    (at-most-one ?c))
  (small ?c))


;
;thunks

(declare-variables (class ?a ?b ?c ?a2 ?b2))

(rule thunk-1 ((= ?c (lambda0 ?a))
	       (when (= (db-index-so-far ?c) 0) (notice-db-index ?c))
	       (small ?c))
  (queue *delay-q* (is ?c ?a-thunk)))

(rule thunk-2 ((is ?c ?a-thunk)
	       (there-exists ?c)
	       (at-most-one ?c))
  (=intern ?c (lambda0 (apply (funcall0-operator) ?c))))

(rule thunk-3 ((is ?c ?a-thunk)
	       (at-most-one ?c))
      (small ?c))

(rule thunk-4 ((= ?c (lambda-rel0 ?a))
	       (when (= (db-index-so-far ?c) 0) (notice-db-index ?c))
	       (small ?c))
  (is ?c ?a-thunk))

(rule lambda-rel0-monotonicity ((classify! ?c)
				(is ?c (lambda-rel0 ?t1))
				(is ?t1 ?t2))
  (is ?c (lambda-rel0 ?t2)))


;
;sets

(declare-variables (class ?a ?b ?c ?a2 ?b2))
(declare-variables (class ?z ?s ?s1))

(rule setness ((is ?z (apply ?member-operator ?s))
	       (is ?s ?a-set)
	       (there-exists (apply ?member-operator ?z)))
  (is ?z ?a-set))

(rule set-1 ((= ?c (the-set-of-all-internal ?a))
	     (when (= (db-index-so-far ?c) 0) (notice-db-index ?c))
	     (small ?c))
  (queue *delay-q* (is ?c ?a-set)))

(rule set-2 ((is ?c ?a-set)
	     (classify! ?c)
	     (there-exists ?c)
	     (at-most-one ?c))
  (=intern ?c (the-set-of-all-internal (apply (member-operator) ?c))))

(rule set-3 ((is ?c ?a-set)
	     (at-most-one ?c))
      (small ?c))

(rule set-4 ((= ?c (apply ?subset-operator ?a))
	     (is ?a ?a-set))
  (is ?c ?a-set))


;
;Operators

(declare-variables (class ?type ?c ?c2))

;A delay is needed to break a possible infinite recursion in
;the following rule.  The recursion goes through the rule operator-4
;which interns a lambda expression.

(rule operator-1 ((operator-class ?c)
		  (small ?c)
		  (closed ?c))
  (is ?c ?an-operator))

(rule operator-2 ((is ?c ?an-operator))
  (operator-class ?c))

(rule operator-5 ((is ?c ?an-operator)
		  (at-most-one ?c))
      (small ?c))

(rule smallness-of-operators ((small (apply ?f (const ?n (apply ?domain-operator ?f))))
			      (at-most-one ?f)
			      (small (apply ?domain-operator ?f))
			      (when (> (max-constant ?n)
				       (max (max-constant ?f)
					    *last-assumption-max-const*))
				(notice-max-constant ?f)))
  (small ?f))



(rule thingness-1 ((is ?c ?a-thing)
		   (at-most-one ?c))
  (small ?c))

;The following rule implies (among other things) that the members
;of an arbitrary set are things.


(rule smallness-implies-thing ((small ?c)
			       (when (= (db-index-so-far ?c) 0) (notice-db-index ?c)))
  (is ?c ?a-thing))


(declare-variables (class ?arg ?body ?t ?app))
(rule application-smallness ((= ?app (apply (db-lambda ?t (db-class-combinator ?body)) ?arg))
			     (small ?body)
			     (small ?arg))
  (small ?app))



(defpiece (ontic-init-phase2 disjointness-axioms) ()
  (axiom (not (there-exists (both (an-integer) (a-symbol)))))
  (axiom (not (there-exists (both (an-integer) (a-set)))))
  (axiom (not (there-exists (both (an-integer) (a-thunk)))))
  (axiom (not (there-exists (both (an-integer) (an-operator)))))
  (axiom (not (there-exists (both (an-integer) (a-cons-cell)))))
  (axiom (not (there-exists (both (a-symbol) (a-set)))))
  (axiom (not (there-exists (both (a-symbol) (a-thunk)))))
  (axiom (not (there-exists (both (a-symbol) (an-operator)))))
  (axiom (not (there-exists (both (a-symbol) (a-cons-cell)))))
  (axiom (not (there-exists (both (a-set) (a-thunk)))))
  (axiom (not (there-exists (both (a-set) (an-operator)))))
  (axiom (not (there-exists (both (a-set) (a-cons-cell)))))
  (axiom (not (there-exists (both (a-thunk) (an-operator)))))
  (axiom (not (there-exists (both (a-thunk) (a-cons-cell)))))
  (axiom (not (there-exists (both (an-operator) (a-cons-cell))))))

