;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'ontic)

(bnf (class (plus-operator)))
(def-rule-const ?plus (plus-operator))
;Axioms for integers.

(defpiece (ontic-init-phase2 integer-axioms) ()

  (axiom (there-exists (an-integer)))

  (defontic + (not-general-constant (a-function-from (the-set-of-all (an-integer))
						     (the-set-of-all (an-integer)) to
						     (the-set-of-all (an-integer)))))

  (axiom (= (plus-operator) +))  ;; don't ask

  (axiom (forall ((x (an-integer)))
	   (= (+ x 0) x)))

  (axiom (forall ((x (an-integer)))
	   (not (= (+ x 1) x))))

  (axiom (forall ((x (an-integer))
		  (y (an-integer)))
	   (= (+ x y) (+ y x))))

  (axiom (forall ((x (an-integer))
		  (y (an-integer))
		  (z (an-integer)))
	   (= (+ x (+ y z))
	      (+ (+ x y) z))))


  (defontic minus (not-general-constant (a-function-from (the-set-of-all (an-integer)) to
							 (the-set-of-all (an-integer)))))

  (axiom (forall ((x (an-integer)))
	   (= (+ x (minus x)) 0)))

  (defontic * (not-general-constant (a-function-from (the-set-of-all (an-integer))
						     (the-set-of-all (an-integer)) to
						     (the-set-of-all (an-integer)))))

  (axiom (forall ((x (an-integer)))
	   (= (* x 1) x)))

  (axiom (forall ((x (an-integer)))
	   (= (* x 0) 0)))

  (axiom (forall ((x (an-integer))
		  (y (an-integer)))
	   (= (* x y) (* y x))))

  (axiom (forall ((x (an-integer))
		  (y (an-integer))
		  (z (an-integer)))
	   (= (* x (* y z))
	      (* (* x y) z))))

  (axiom (forall ((x (an-integer))
		  (y (an-integer))
		  (z (an-integer)))
	   (= (* x (+ y z))
	      (+ (* x y) (* x z)))))

  (defontic (the-integers) (the-set-of-all (an-integer)))

  (defontic !an-integer->= (not-general-constant (an-operator-from (the-integers) to (the-integers))))

  (defontic (an-integer->= (x (an-integer)))
    (either x
	    (+ 1 (an-integer->= x))))

  (axiom (= an-integer->= !an-integer->=))

  (axiom (forall ((x (an-integer)))
	   (is x (an-integer->= x))))

  (axiom (forall ((x (an-integer)))
	   (is (+ 1 (an-integer->= x))
	       (an-integer->= x))))

  (axiom (forall ((x (an-integer)))
	   (is (an-integer->= (an-integer->= x))
	       (an-integer->= x))))

  (axiom (forall ((x (an-integer))
		  (y (an-integer->= x)))
	   (implies (is x (an-integer->= y))
		    (= x y))))

  (axiom (forall ((x (an-integer))
		  (y (an-integer)))
	   (or (is y (an-integer->= x))
	       (is x (an-integer->= y)))))

  ;; added by rlg 1/22/92
  ;;   --provable by induction
  (axiom (forall ((x (an-integer))
		  (y (an-integer))
		  (z (an-integer)))
	   (iff (is x (an-integer->= y))
		(is (+ x z) (an-integer->= (+ y z))))))  

  ;;induction
  (axiom (forall ((x (an-integer))
		  (a-foo (an-operator-from to (an-integer))))
	   (implies (and (is x (a-foo))
			 (is (+ 1 (a-foo)) (a-foo)))
		    (is (an-integer->= x)
			(a-foo)))))

  ;; Added by kcz 5/3/92
  (axiom (forall ((x (an-integer))
		  (y (+ 1 x)))
	   (= (an-integer->= y)
	      (+ 1 (an-integer->= x)))))

  (axiom (there-exists (an-integer->= 0)))   ;; easily proven, but needed known for induction code to work.

  ;;Procedural attachments
  
;;  (axiom-fun `(= +  ',(make-function-object 'curried-+)))
;;
;;  (axiom-fun `(= -  ',(make-function-object '-)))
;;
;;  (axiom-fun `(= *  ',(make-function-object 'curried-*)))
  )

(defun curried-+ (x)
  (make-function-object
   (lambda (y)
     (+ x y))))

(defun curried-* (x)
  (make-function-object
   (lambda (y)
     (* x y))))

;
;We can handle proofs such as the following.
;
;(let-be ((y (an-integer))
;         (z (an-integer)))
;  (show-by-induction-on ((?x (an-integer->= 0))) 
;         (= (+ x (+ y z))
;            (+ (+ x y) z))
;     (proof-cond
;        ((= x 0)
;         (show (= (+ 0 (+ y z))
;                  (+ (+ 0 y) z))
;            ...))
;        ((= (+ x (+ y z))
;            (+ (+ x y) z))
;         (show (= (+ (1+ x) (+ y z))
;                  (+ (+ (1+ x) y) z))
;            ...)))))
;
;Show-by-induction-on is a proof macro.  In the above proof, the body
;of the induction proof is a proof-cond.  This is like lisp cond
;but for proofs.  The body will be executed in several places and
;the proof-cond allows it to do the right thing in each place that it
;is evaluated.
;
;;;
;;;(defmac an-integer->=-induction-macro
;;;  (show-by-induction-on ((?x (an-integer->= ?z)))
;;;      ?phi
;;;    . ?body)
;;;  t
;;;  (lisp-let ((?a-foo-number (new-proof-variable 'A-FOO-NUMBER))
;;;	     (?y (new-proof-variable 'Y))
;;;	     (?inc-phi (sublis (acons ?x `(+ 1 ,?x) nil)
;;;			       ?phi)))
;;;    (let-be ((?a-foo-number (lambda () (some-such-that ?x (an-integer->= ?z)
;;;					 ?phi))))
;;;      (show (forall ((?x (an-integer->= ?z)))
;;;	      ?phi)
;;;	(lemma
;;;	 (progn . ?body))
;;;	(show (is (an-integer->= ?z) (?a-foo-number))
;;;	  (lemma
;;;	   (let-be ((?x ?z))
;;;	     (show (is ?z (?a-foo-number))
;;;	       (show ?phi))))
;;;	  (show (is (+ 1 (?a-foo-number)) (?a-foo-number))
;;;	    (let-be ((?y (+ 1 (?a-foo-number))))
;;;	      (show (is ?y (?a-foo-number))
;;;		(let-be ((?x (?a-foo-number)))
;;;		  such-that (is ?y (+ 1 ?x))
;;;		  (progn (show ?inc-phi)
;;;			 (show (is ?y (?a-foo-number)))))))))
;;;	(lemma
;;;	 (let-be ((?x (an-integer->= ?z)))
;;;	   (show ?phi)))))))

