;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :ontic)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Goals Code:                                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(bnf (formula (goal! formula)))

(declare-variables (class ?c ?w ?t ?t1 ?t2)
		   (formula ?phi ?psi))

(defvar *equivalent-goals* nil)

(defmacro oe (expr)
  `(object-expression ,expr))

(defmacro new-goal (form)
  `(push ,form *equivalent-goals*))

(rule goal!-is ((goal! (is ?c ?w)))
  (:lisp
    (new-goal `(is ,(oe ?c) ,(oe ?w)))))

(rule goal!-is-lambda-fun
    ((goal! (is ?c (db-lambda-fun ?t (db-class-combinator ?w)))))
  (:lisp
    (new-goal `(is ,(oe ?c) (db-lambda-fun
			      ,(oe ?t) (db-class-combinator ,(oe ?w)))))))

(rule goal!-is-both
    ((goal! (is ?c (intersection ?w ?t))))
  (:lisp
   (new-goal `(is ,(oe ?c) (intersection ,(oe ?w) ,(oe ?t))))))

(rule goal!-is-subset
    ((constant ?subset-operator)
     (goal! (is ?c (apply ?subset-operator ?w))))
  (:lisp
   (new-goal `(is ,(oe ?c) (apply (subset-operator) ,(oe ?w))))))

(rule goal!-is-lambda-rel ((goal! (is ?c (lambda-rel0 ?t))))
  (:lisp
    (new-goal `(is ,(oe ?c) (lambda-rel0 ,(oe ?t))))))

(rule goal!-is-rel-from-to ((constant ?rel-from-to)
			    (goal! (is ?c (apply (apply ?rel-from-to ?t1) ?t2))))
  (:lisp
    (new-goal `(is ,(oe ?c) (apply (apply (rel-from-to) ,(oe ?t1)) ,(oe ?t2))))))

(rule goal!-is-sst ((goal! (is ?c (db-some-such-that
				    ?type (db-formula-combinator ?phi)))))
  (:lisp
   (new-goal `(is ,(oe ?c) (db-some-such-that
			     ,(oe ?type)
			     (db-formula-combinator ,(oe ?phi)))))))

(rule goal!-and ((goal! (not (implies ?phi (not ?psi)))))
  (:lisp
    (new-goal `(not (implies ,(oe ?phi) (not ,(oe ?psi)))))))

(rule goal!-or ((goal! (implies (not ?phi) ?psi)))
  (:lisp
    (new-goal `(implies (not ,(oe ?phi)) ,(oe ?psi)))))

(rule goal!-iff ((goal! (= ?phi ?psi)))
  (:lisp
    (new-goal `(= ,(oe ?phi) ,(oe ?psi)))))

(rule goal!-= ((goal! (= ?c ?w)))
  (:lisp
    (new-goal `(= ,(oe ?c) ,(oe ?w)))))

(rule goal!-forall ((goal! (db-forall ?t (db-formula-combinator ?phi))))
  (:lisp
    (new-goal `(db-forall ,(oe ?t) (db-formula-combinator ,(oe ?phi))))))

(rule goal!-at-most-one ((goal! (at-most-one ?c)))
  (:lisp
    (new-goal `(at-most-one ,(oe ?c)))))

(rule goal!-not-there-exists ((goal! (not (there-exists ?c))))
  (:lisp
    (new-goal `(not (there-exists ,(oe ?c))))))

(rule goal!-there-exists ((goal! (there-exists ?c)))
  (:lisp
    (new-goal `(there-exists ,(oe ?c)))))

(rule goal!-there-exists-sst ((goal! (there-exists
				      (db-some-such-that
				       ?type
				       (db-formula-combinator
					(is ?c ?w)))))
			      (when (and (db-index ?c)

					 (= (db-index ?c) 0))
				(notice-db-index ?c)))
  (:lisp
   (new-goal `(there-exists
	       (db-some-such-that
		,(oe ?type)
		(db-formula-combinator (is ,(oe ?c) ,(oe ?w))))))))

(rule goal!-not-is ((goal! (not (is ?c ?w))))
  (:lisp
    (new-goal `(not (is ,(oe ?c) ,(oe ?w))))))

(defun clear-goals ()
  (setf *equivalent-goals* nil))

(defun construct-second-try-proofs (phi)
  (clear-goals)
  (ext-axiom-fun `(goal! ,phi))
  ;; Make sure translated phi is the first expansion.
  (let* ((tphi (translate phi))
	 (eg (cons tphi (remove tphi (remove-duplicates
				       *equivalent-goals* :test #'equal)
				:test #'equal))))
    (setf *equivalents* (acons phi eg *equivalents*))
    (second-try-proofs eg)))

(defun second-try-proofs (goals)
  (cond ((null (cdr goals))
	 `(possible-second-try ,(car goals)))
	(t
	  `(first
	     (possible-second-try ,(car goals))
	     ,(second-try-proofs-1 (cdr goals))))))

(defun second-try-proofs-1 (goals)
  (cond ((null (cdr goals))
	 `(subgoal ,(car goals)))
	(t
	  `(first
	     (subgoal ,(car goals))
	     ,(second-try-proofs (cdr goals))))))

(defmac subgoal
  (subgoal ?phi)
  t
  (lisp-when (<= *inferences* *inference-limit*)
    (possible-second-try ?phi)))

(defmac setup-goals
  (setup-goals ?phi)
  t
  (evaluate-proof
    (progn
      (goto-context *real-context*)
      (construct-second-try-proofs '?phi))))
