;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Defsys for Ontic release 11.5                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :ontic)

(defvar *production-compile* nil)

;; Set by emacs upon loadup if non-default.
(defvar *ontic-directory* "/home/c2/drdave/ontic")

(defvar *time-stamps* nil)

(defvar *supressed-warnings*
	'("Redefining ~A ~S whose source-file was not recorded"))

(defmacro with-supressed-warnings (&rest body)
  `(let ((warn-fun #'warn)
	 (ret nil))
     (unwind-protect
	 (progn
	   (setf (symbol-function 'warn)
		 #'(lambda (format &rest args)
		     (if (not (member format *supressed-warnings*
				      :test #'string=))
			 (apply warn-fun (cons format args)))))
	   (setq ret (progn ,@body)))
       (setf (symbol-function 'warn) warn-fun))
     ret))

(defun expand-names (files)
  (mapcar #'(lambda (file)
	      (concatenate 'string *ontic-directory* file))
	  files))

(defvar *util-files*
	(expand-names
	  '("/rel11.5/util"
	    "/rel11.5/pieces"
	    "/rel11.5/undo-array"
	    "/rel11.5/queues")))

(defvar *meta-files*
	(expand-names
	  '("/rel11.5/congruence"
	    "/rel11.5/syntax"
	    "/rel11.5/rcomp"
	    "/rel11.5/screamer"
	    "/rel11.5/exp-con"
	    "/rel11.5/sbhlps")))

(defvar *sort-cache-file* (car (expand-names '("/rel11.5/sort.lisp"))))
	
(defvar *ontic-files*
	(expand-names
	  '("/rel11.5/mo-util"
	    "/rel11.5/taxonomy"
	    "/rel11.5/ontic-eval"
	    "/rel11.5/integers"
	    "/rel11.5/large-thunks"
	    "/rel11.5/quantifiers"
	    "/rel11.5/new-recursion"
	    "/rel11.5/structures"
	    "/rel11.5/tactics"
	    "/rel11.5/goals"
	    "/rel11.5/debug")))

(defvar *final-files*
	(expand-names
	  '("/rel11.5/compile-defs-and-init")))

(defvar *patch-files*
	(expand-names
	 '("/rel11.5/patches")))

(defun source-file-name (file)
  (concatenate 'string file ".lisp"))

(defun binary-file-name (file)
  (concatenate 'string file
	       #+lucid ".sbin"
	       #+cmu ".sparcf"
	       #+allegro ".fasl"
	       #+akcl ".o"
	       #-(or lucid cmu allegro akcl) (error "Unknown system type")))

(defun load-files (files &key force-binary)
  (mapc #'(lambda (x)
	    (if force-binary
		(load (binary-file-name x))
		(let ((bin-date (file-write-date (binary-file-name x)))
		      (src-date (file-write-date (source-file-name x))))
		  (if (or (null bin-date)
			  (> src-date bin-date))
		      (progn
			(emacs-eval '(hlps-lisp-compile-start))
			(compile-file (source-file-name x))
			(emacs-eval '(hlps-lisp-compile-end))))
		  (load x)))
	    (push (file-write-date
		    (binary-file-name x)) *time-stamps*))
	files))

(defun load-files-no-timestamps (files &key force-binary)
  (mapc #'(lambda (x)
	    (if force-binary
		(load (binary-file-name x))
		(let ((bin-date (file-write-date (binary-file-name x)))
		      (src-date (file-write-date (source-file-name x))))
		  (if (or (null bin-date)
			  (> src-date bin-date))
		      (progn
			(emacs-eval '(hlps-lisp-compile-start))
			(compile-file (source-file-name x))
			(emacs-eval '(hlps-lisp-compile-end))))
		  (load x))))
	files))

(defun compile-files (files &key final)
  (mapc #'(lambda (x)
	    (if final
		(emacs-eval '(hlps-lisp-compile-final-start))
		(emacs-eval '(hlps-lisp-compile-start)))
	    (compile-file (source-file-name x))
	    (emacs-eval '(hlps-lisp-compile-end))
	    (load x)
	    (push (file-write-date
		   (binary-file-name x)) *time-stamps*))
	files))

(defun compile-final-file ()
  (with-open-file (tsfile (concatenate 'string *ontic-directory*
				  "/rel11.5/timestamps")
			  :direction :output
			  :if-exists :supersede)
    (write *time-stamps* :stream tsfile)
    (compile-files *final-files* :final t)))

(defun load-ontic (&key force-binary)
  (when *production-compile*
    (proclaim '(optimize speed))
    (proclaim '(optimize (compilation-speed 0)))
    (proclaim '(optimize (safety 1))))
  (with-supressed-warnings
   (setf *time-stamps* nil)
   (emacs-eval '(ilisp-update-status ':util))
   (load-files *util-files* :force-binary force-binary)
   (emacs-eval '(ilisp-update-status ':meta))
   (load-files *meta-files* :force-binary force-binary)
   (emacs-eval '(ilisp-update-status ':ontic))
   (load-files *ontic-files* :force-binary force-binary)
   (emacs-eval '(ilisp-update-status ':final))
   (let ((*print-length* nil))
     (if force-binary
	 (load-files *final-files* :force-binary t)
       (with-open-file (tsfile (concatenate 'string *ontic-directory*
					    "/rel11.5/timestamps")
			       :if-does-not-exist :create)
		       (let ((old-time-stamps (read tsfile nil)))
			 (if (equal *time-stamps* old-time-stamps)
			     (load-files *final-files*)
			   (compile-final-file))))))
   (setq util::*do-merging* nil)
   (emacs-eval '(ilisp-update-status ':patches))
   (load-files-no-timestamps *patch-files* :force-binary nil)
   (emacs-eval '(ilisp-update-status ':init))
   (ontic-init))
  (proclaim '(optimize (speed 2)))
  (proclaim '(optimize (compilation-speed 3)))
  (proclaim '(optimize (safety 3))))

(defun compile-ontic ()
  (when *production-compile*
    (proclaim '(optimize speed))
    (proclaim '(optimize (compilation-speed 0)))
    (proclaim '(optimize (safety 1))))
  (setf *time-stamps* nil)
  (compile-files *util-files*)
  (compile-files *meta-files*)
  (compile-files *ontic-files*)
  (compile-final-file)
  (ontic-init)
  (proclaim '(optimize (speed 2)))
  (proclaim '(optimize (compilation-speed 3)))
  (proclaim '(optimize (safety 3))))
