;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Initializations for Ontic running under Lucid:                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package :ontic)

;; Set by emacs if non default.
(defvar *ontic-directory* "/home/c2/drdave/ontic")
(defvar *ontic-release* "10.6")
(defvar *binary-load* nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Lucid compiler seems to have problems if the memory size            ;;;
;;; isn't grown.                                                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(user::change-memory-management :growth-limit 2048)
(user::change-memory-management :expand 50)

;; Takes a long time during initialization:
(user::egc-options :level-sizes '(16 20 20))

;; Load lisp end of emacs-eval.
(load (format nil "~a/interface/emacs-eval" *ontic-directory*))

;; Load the correct defsystem.
(load (format nil "~a/rel~a/defsys.lisp" *ontic-directory* *ontic-release*))

;; Load up Ontic.
(load-ontic :force-binary *binary-load*)
