;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Ontic Mode extensions for implementors:                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'ontic-mode)
(provide 'ontic-implementors)

(defconst *default-ontic-release* "11.5")
(defconst *report-inferences* t)

(defvar ilisp-prefix "\C-z" "Prefix sequence for ilisp commands.")

(setup-ontic-mode-map lisp-mode-map (concat ilisp-prefix "o"))

(define-key ontic-mode-map (concat *ontic-prefix* "!") 'ontic-interrupt)

(defun ontic-interrupt ()
  (interactive)
  (if (ontic-running-p)
      (interrupt-process (ilisp-process))
      (error "Ontic is not running.")))
