;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'ilisp)
(require 'emacs-eval)

(defvar *ontic-release* nil)
(defvar *binary-load* nil)
(setq ilisp-motd nil)

(defun ontic ()
  (interactive)
  (if (ontic-running-p)
      (message "Ontic is already running.")
      (let ((release (read-string
		       (format "Release (%s): " *default-ontic-release*))))
	(if (string= release "")
	    (setq *ontic-release* *default-ontic-release*)
	    (setq *ontic-release* release))
	;; Start up ontic quitely.
	(setq mode-line-process 'ilisp-status)
	(setq *binary-load* nil)
	(if current-prefix-arg
	    (progn
	      (setq current-prefix-arg nil)
	      (setq *binary-load* t)))
	(let ((lptb (symbol-function 'lisp-pop-to-buffer)))
	  (unwind-protect
	      (progn
		(fset 'lisp-pop-to-buffer '(lambda (buffer) buffer))
		(funcall (symbol-function *ontic-dialect*)))
	    (fset 'lisp-pop-to-buffer lptb))))))

(defdialect ontic-lucid "Lucid Common LISP running Ontic"
  lucid
  (ilisp-load-init 'ontic-lucid "ontic")
  (setq comint-prompt-regexp "^\\(->\\)+ \\|^[^> \^[\^]]*> "
	comint-fix-error ":a"
	ilisp-reset ":a :t"
	comint-continue ":c"
	comint-interrupt-regexp ">>Break: Keyboard interrupt"
	comint-prompt-status 
	(function (lambda (old line)
		    (comint-prompt-status old line 'lucid-check-prompt))))
  (setq ilisp-error-regexp "ILISP:[^\"]*\\|>>[^\n]*")
  (setq ilisp-source-types (append ilisp-source-types '(("any"))))
  (setq ilisp-find-source-command 
	"(ILISP:ilisp-source-files \"%s\" \"%s\" \"%s\")")
  (setq ilisp-binary-command 
	"(first (last lucid::*load-binary-pathname-types*))")
  ;; Create the Util and Ontic packages and drop into the Ontic package.
  (add-hook 'ilisp-init-hook
	    '(lambda ()
	       (comint-send
		 (ilisp-process)
		 "(progn
                    (unless (find-package 'util)
                      (make-package 'util :use '(lisp)))
                    (unless (find-package 'ontic)
                      (make-package 'ontic :use '(util lisp)))
;                    (unless (find-package 'ontic-user)
;                      (make-package 'ontic-user :use '(ontic lisp)))
                    (in-package :ontic))"
		 t)))
  ;; Magically add these global variables to Lucid:
  (add-hook 'ilisp-init-hook
	    '(lambda ()
	       (comint-send
		 (ilisp-process)
		 (format
		   "(setq *ontic-directory* \"%s\" *ontic-release* \"%s\"
                          *binary-load* %s *report-inferences* %s)"
		   *ontic-directory* *ontic-release*
		   *binary-load* *report-inferences*)
		 t)))
  (add-hook 'ilisp-init-hook
	    '(lambda ()
	       (message "Ontic is loading..."))))
