;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'util :use '(lisp))

(export 'rprint)

(defun rprint (x)
  (let ((*print-level* 150)
	(*print-length* 150))
    (pprint x)))

;; Doesn't bother to check for quotes in a string.
(defun simple-downcase (string)
  (let ((in-string nil)
	(next nil))
    (dotimes (x (length string))
      (setq next (aref string x))
      (cond ((and (not in-string)
		  (char= next #\"))
	     (setq in-string t))
	    ((and in-string (char= next #\"))
	     (setq in-string nil))
	    ((not in-string)
	     (setf (aref string x) (char-downcase next)))))
    string))

(export 'emacs-eval)

(defvar *last-message-time* (get-internal-real-time))
(defvar *message-prefix* (format nil "~a" (character 27)))

(defvar *message-suffix* (format nil "~a" (character 29)))

;;(defvar *message-prefix* (format nil "~a!Bcm:" (int-char 0)))
;;(defvar *message-suffix* (format nil "~a:Ecm." (int-char 0)))

;; If things stop working, exchange simple-downcase with string-downcase.
(defun emacs-eval (exp)
  (setf *last-message-time* (get-internal-real-time))
  (format t "~a~a~a"
	  *message-prefix*
;;	  (string-downcase (format nil "~a" exp))
	  (simple-downcase (format nil "~a" exp))
	  *message-suffix*))

(export 'emacs-indent)

(defmacro emacs-indent (name number-to-skip)
  `(emacs-eval '(put ',name 'lisp-indent-hook ,number-to-skip)))

(export 'emacs)

(export '*visible-evaluation?*)

(defvar *visible-evaluation?* nil)

(export 'quote-string)

(defun quote-string (string)
  (format nil "\"~a\"" string))

(export 'when-visible-eval)

(defun when-visible-eval (exp)
  (when *visible-evaluation?*
    (emacs-eval exp)))

(export 'throw-to-emacs)

(defun throw-to-emacs (msg)
  (if *visible-evaluation?*
      (progn (emacs-eval `(message ,(quote-string msg)))
	     (throw 'emacs nil))
      (error msg)))
