;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; - NFS Share File - ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Emacs Eval independant module                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'ilisp)
(require 'bridge)
(provide 'emacs-eval)

(defvar *lisp-eval-buffer* "")
(defvar *no-eval-echo* t)

;; Always install bridge.
(add-hook 'clisp-hook '(lambda ()
			 (add-hook 'ilisp-init-hook
			       '(lambda () (install-bridge)))))

;; Set up bridge properly.
(setq bridge-hook 
      '(lambda ()
	 ;; Don't insert in source or destination buffer
	 (setq bridge-source-insert nil)
	 (setq bridge-destination-insert nil)
	 ;; Set up bridge handler
	(setq bridge-handlers
	 '((".*" . catch-lisp-eval)))))

;; Process info that comes to emacs from the bridge.
(defun catch-lisp-eval (process string)
  (if string
      (setq *lisp-eval-buffer* (concat *lisp-eval-buffer* string))
      (let ((buffer (current-buffer))
	    (eval-string *lisp-eval-buffer*))
	(setq *lisp-eval-buffer* "")
	(condition-case err
	    (eval (read eval-string))
	  (error (message "Bridge Error: %s on eval of: %s" err eval-string)))
	(set-buffer buffer))))

;; The following evaluates the string in lisp taking into account
;; the package and file of the current buffer.
(defun ilisp-eval-string (string)
  (comint-send
   (ilisp-process)
   (format (ilisp-value 'ilisp-eval-command)
	   (lisp-slashify string)
	   (lisp-buffer-package)
	   (buffer-file-name))
   *no-eval-echo*))

;; Use the following when trying to evaluate an expression in LISP.
(defun ilisp-eval (exp)
  (ilisp-eval-string (format "%s" exp)))
