;;;
;;;   KNOWBEL knowledge representation system
;;;    
;;;    author: Bryan M. Kramer
;;;    
;;;    
;;; Copyright (c) 1990, 1991 University of Toronto, Toronto, ON
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all copies and
;;; supporting documentation.
;;;
;;; The University of Toronto provides this software "as is" without
;;; express or implied warranty.
;;;

;;;    
;;;    


;? compile and load a KNOWBEL system
;;;    
;;;  
  
(defmacro sys-load (file-or-list)
  `(let ((file (if (listp ,file-or-list) (car ,file-or-list) ,file-or-list)))
     (let ((comp-path (make-pathname :name file :type "fasl")))
       (when (not (probe-file comp-path))
	 (compile-file file))
       (load comp-path)
       )
     )
  )


(sys-load "pretools")
(sys-load '("tools" "pretools"))
(sys-load '("ndprog" "tools"))
(sys-load '("prove-structs" "tools" "ndprog"))
(sys-load '("time" "prove-structs" "tools"))
(sys-load '("prove" "prove-structs" "tools" "ndprog" "time"))
(sys-load '("kb" "prove-structs" "tools" "ndprog"))
(sys-load '("kbresolve" "prove-structs" "tools" "ndprog"))
(sys-load '("forward" "prove-structs" "tools"))
(sys-load '("tmp" "prove-structs" "tools"))
(sys-load '("new-stuff" "prove-structs" "tools" "ndprog"))
(sys-load "telos")


