;*******************************************************************************
;*
;*	File : Functions -----------> DD 04.08.92
;*
;*******************************************************************************

(defun prim-SR (prim cnf)
  (cond ((find prim (get-pos-definitive-prims cnf)))
	((find prim (get-pos-possible-prims cnf))
	 'unknown)))

(defun neg-prim-SR (prim cnf)
  (cond ((find prim (get-neg-definitive-prims cnf)))
	((find prim (get-neg-possible-prims cnf))
	 'unknown)))

(defun cprim-SR (prim cnf)
  (let ((family (get-family prim))
	)
       (cond ((or (find prim (get-pos-definitive-prims-of-family family cnf))
		  (and (family-exists? family (get-pos-definitive-families cnf))
		       (all-neg-exist? family prim (get-neg-definitive-families cnf)))))
	     ((or (find prim (get-pos-possible-prims-of-family family cnf))
		  (and (family-exists? family (get-pos-possible-families cnf))
		       (all-neg-exist? family prim (get-neg-possible-families cnf))))
	      'unknown))))

(defun oprim-SR (prim cnf)
  (let ((family (get-family prim))
	)
       (cond ((find prim (get-pos-definitive-prims-of-family family cnf)))
	     ((find prim (get-pos-possible-prims-of-family family cnf))
	      'unknown)
	     )))
	     
(defun neg-sprim-SR (prim cnf)
  (let ((family (get-family prim))
	)
       (cond ((or (find prim (get-neg-definitive-prims-of-family family cnf))
		  (neg-family-exists? family (get-neg-definitive-prims-of-family family cnf))
		  (disj-prim-exists? family prim (get-pos-definitive-families cnf))))
	     ((or (find prim (get-neg-possible-prims-of-family family cnf))
		  (neg-family-exists? family (get-neg-possible-prims-of-family family cnf))
		  (disj-prim-exists? family prim (get-pos-possible-families cnf)))
	     'unknown)
	     )))

(defun sfamily-SR (sfam cnf)
  (let ((fam-entry (get-tbox-entry sfam))
        )
       (let ((fam (tbox-entry-family fam-entry))
             (members (tbox-entry-members fam-entry))
             )
	    (cond ((and (get-pos-definitive-prims-of-family fam cnf)
			(subsetp (get-pos-definitive-prims-of-family fam cnf) members)))
		  ((and (get-pos-possible-prims-of-family fam cnf)
			(subsetp (get-pos-possible-prims-of-family fam cnf) members))
		   'unknown)
		  ))))

(defun neg-sfamily-SR (sfam cnf)
  'unknown)


(defun family-SR (fam cnf)
  (cond ((assoc fam (get-pos-definitive-families cnf)))
	((assoc fam (get-pos-possible-families cnf))
	 'unknown)
	))
(defun neg-family-SR (fam cnf)
  (cond ((neg-family-exists? fam (get-neg-definitive-prims-of-family fam cnf)))
	((neg-family-exists? fam (get-neg-possible-prims-of-family fam cnf))
	 'unknown)
	))

(defun concept-SR (cnf1 cnf2)
  (if (and (get-node cnf1) (get-node cnf2))
      (subsumption-look-up cnf1 cnf2)
      (subsumes-weakly? cnf1 cnf2)))

(defun neg-concept-SR (cnf1 cnf2)
  'unknown)

(defun or-SR (cnf1 cnf2)
  'unknown)

(defun agree-SR (f1 f2 cnf)
  (let ((links (append (get-exists-links cnf) (get-forall-links cnf)))
	)
       (if (and (find f1 links)
		(find f2 links))
	   'unknown)))
(defun disagree-SR (f1 f2 cnf)
  (let ((some-links (get-exists-links cnf))
	)
       (if (and (find f1 some-links)
		(find f2 some-links))
	   'unknown)))

(defun forall-SR (first-roles cnf)
  (let ((result 'unknown)
	(links (append (get-exists-links cnf) (get-forall-links cnf)))
	)
       (dolist (role first-roles result)
	       (unless (find role links)
		       (setq result nil)
		       (return))
	       )))
(defun some-SR (first-roles cnf)
  (let ((result 'unknown)
	(some-links (get-exists-links cnf))
	)
       (dolist (role first-roles result)
	       (unless (find role some-links)
		       (setq result nil)
		       (return))
	       )))

