;************************************************************
;*                                                          *
;*                File : constructors->functions
;*                                                          *
;************************************************************

(defun constructors->functions (ct)
  (cond ((conjunction? ct)
	 (make-conjunction-rule (mapcar 'constructors->functions
					(get-concepts-of-conjunction ct))))
	((disjunction? ct)
	 (make-disjunction-rule (mapcar 'constructors->functions
					(get-concepts-of-disjunction ct))))
	((negation? ct)
	 (let ((nct (get-concept-of-negation ct))
	       )
	      (cond ((prim? nct)
		     (make-neg-prim-rule nct))
		    ((family? nct)
		     (make-neg-family-rule nct))
		    ((subfamily? nct)
		     (let ((fam-entry (get-tbox-entry nct))
			   )
			  (let ((fam (tbox-entry-family fam-entry))
				(c-members (tbox-entry-c-members fam-entry))
				)
			       (make-neg-subfamily-rule fam c-members))))
		    ((cprim? nct)
		     (make-neg-cprim-rule (get-family nct) nct))	
		    ((oprim? nct)
		     (make-neg-oprim-rule (get-family nct) nct))
		    ((conceptname? nct)
		     (make-neg-conceptname-rule (get-CNF-of-conceptname nct)))
                    ((abstract-predicate-restriction? nct)
                     (make-QPP-rule (negate-quantifier (get-quantifier nct))
                                    (get-pathes-of-restriction nct)
                                    (get-restrictor nct)
                                    t
                                    (negated-restrictor? nct)))
                    ((concrete-predicate-restriction? nct)
                     (make-QPP-rule (negate-quantifier (get-quantifier nct))
                                    (get-pathes-of-restriction nct)
                                    (get-restrictor nct)
                                    t
                                    '()))
		    ((restriction? nct)
		     (make-QPC-rule (negate-quantifier (get-quantifier nct))
				    (get-pathes-of-restriction nct)
				    (get-restrictor nct)
				    t))
		    ((agreement? nct)
		     (make-disagree-rule (get-pathes-of-restriction nct)))
		    ((disagreement? nct)
		     (make-agree-rule (get-pathes-of-restriction nct)))
		    (t (error "Unknown Negated Concept Term in constructors->functions")))))
	((prim? ct) (make-prim-rule ct))
	((family? ct) (make-family-rule ct))
	((subfamily? ct)
	 (let ((fam-entry (get-tbox-entry ct))
	       )
	      (let ((fam (tbox-entry-family fam-entry))
		    (members (tbox-entry-members fam-entry))
		    )
		   (make-subfamily-rule fam members))))
	((sprim? ct)
	 (make-sprim-rule (get-family ct) ct))
	((conceptname? ct) (make-conceptname-rule (get-CNF-of-conceptname ct)))
        ((abstract-predicate-restriction? ct)
	 (make-QPP-rule (negate-quantifier (get-quantifier ct))
			(get-pathes-of-restriction ct)
			(get-restrictor ct)
			nil
			(negated-restrictor? ct)))
        ((concrete-predicate-restriction? ct)
	 (make-QPP-rule (negate-quantifier (get-quantifier ct))
			(get-pathes-of-restriction ct)
			(get-restrictor ct)
			nil
			'()))
	((restriction? ct) (make-QPC-rule (get-quantifier ct)
					  (get-pathes-of-restriction ct)
					  (get-restrictor ct)))
	((agreement? ct)
	 (make-agree-rule (get-pathes-of-restriction ct)))
	((disagreement? ct)
	 (make-disagree-rule (get-pathes-of-restriction ct)))
	(t (error "Unknown Concept Term in constructors->functions")))
  )
