#|
****************************************************************************************************************
	File :  	propagate-real
	Last Change :   13 nov 91
	Author :	dd

****************************************************************************************************************
|#

(defun propagate-number-constraint-= (ro-obj_a ro-obj_b)
  (let ((ub-a (real-ord-obj-ub ro-obj_a))
	(lb-a (real-ord-obj-lb ro-obj_a))
	(ne-a (real-ord-obj-ne ro-obj_a))
	(ub-b (real-ord-obj-ub ro-obj_b))
	(lb-b (real-ord-obj-lb ro-obj_b))
	(ne-b (real-ord-obj-ne ro-obj_b)))  
	(let ((new-ub (get-new-ub-= ub-a ub-b))  
	      (new-lb (get-new-lb-= lb-a lb-b))
	      (new-ne (union ne-a ne-b))
	      )
	     (cond ((lb-ub-clash-=? new-lb new-ub)
		    (clash 'propagate-number-constraint-= ro-obj_a ro-obj_b))
		   ((new-eq-=? new-lb new-ub)
		    (let ((new-eq (get-new-eq-= new-lb)))
			 (cond ((eq-ne-clash? new-eq new-ne)
				(clash 'propagate-number-constraint-= ro-obj_a ro-obj_b))
			       (t (set-eq new-eq ro-obj_a)
				  (propagate-number-rest-> new-eq (bit-ior (real-ord-obj-*> ro-obj_a)
									   (real-ord-obj-*> ro-obj_b)))
				  (propagate-number-rest->= new-eq (bit-ior (real-ord-obj-*>= ro-obj_a)
									    (real-ord-obj-*>= ro-obj_b)))
				  (propagate-number-rest-< new-eq (bit-ior (real-ord-obj-*< ro-obj_a)
									   (real-ord-obj-*< ro-obj_b)))
				  (propagate-number-rest-<= new-eq (bit-ior (real-ord-obj-*<= ro-obj_a)
									    (real-ord-obj-*<= ro-obj_b)))
				  ))))
		   (t (let ((nr-lb (nr-of-b new-lb))
			    (nr-ub (nr-of-b new-ub))
			    )
			   (propagate-symbolic-= ro-obj_a ro-obj_b)
			   (cond ((not (equal new-lb lb-a))
				  (cond ((>? new-lb)
					 (propagate-number-rest-> nr-lb (bit-ior (real-ord-obj-*> ro-obj_a)
										 (real-ord-obj-*>= ro-obj_a))))
					(t (propagate-number-rest-> nr-lb (real-ord-obj-*> ro-obj_a))
					   (propagate-number-rest->= nr-lb (real-ord-obj-*>= ro-obj_a)))))
				 ((not (equal new-lb lb-b))
				  (cond ((>? new-lb)
					 (propagate-number-rest-> nr-lb (bit-ior (real-ord-obj-*> ro-obj_b)
										 (real-ord-obj-*>= ro-obj_b))))
					(t (propagate-number-rest-> nr-lb (real-ord-obj-*> ro-obj_b))
					   (propagate-number-rest->= nr-lb (real-ord-obj-*>= ro-obj_b))))))
			   (cond ((not (equal new-ub ub-a))
				  (cond ((<? new-ub)
					 (propagate-number-rest-< nr-ub (bit-ior (real-ord-obj-*< ro-obj_a)
										 (real-ord-obj-*>= ro-obj_a))))
					(t (propagate-number-rest-< nr-lb (real-ord-obj-*> ro-obj_a))
					   (propagate-number-rest-<= nr-lb (real-ord-obj-*>= ro-obj_a)))))
				 ((not (equal new-ub ub-b))
				  (cond ((<? new-ub)
					 (propagate-number-rest-< nr-ub (bit-ior (real-ord-obj-*< ro-obj_b)
										 (real-ord-obj-*<= ro-obj_b))))
					(t (propagate-number-rest-< nr-ub (real-ord-obj-*< ro-obj_b))
					   (propagate-number-rest-<= nr-ub (real-ord-obj-*<= ro-obj_b))))))))))))

(defun propagate-number-constraint-> (ro-obj_a ro-obj_b)
  (let ((lb-a (real-ord-obj-lb ro-obj_a))
	  (ub-a (real-ord-obj-ub ro-obj_a))
	  (lb-b (real-ord-obj-lb ro-obj_b))
	  (ub-b (real-ord-obj-ub ro-obj_b))
	  )
	 (cond ((and ub-a
			 lb-b
			 (<= (nr-of-b ub-a) (nr-of-b lb-b)))
		  (clash 'propagate-number-constraint-> ro-obj_a ro-obj_b))
		 (t (propagate-symbolic-> ro-obj_a ro-obj_b)
		    (let ((new-lb-a (get-new-lb-> lb-a lb-b))
			    (new-ub-b (get-new-ub-> ub-b ub-a))
			    )
			   (cond ((equal new-lb-a lb-a))
				   (t (set-lb new-lb-a ro-obj_a)
					(propagate-number-rest-> (nr-of-b new-lb-a) (bit-ior (real-ord-obj-*> ro-obj_a)
													     (real-ord-obj-*>= ro-obj_a)))))
			   (cond ((equal new-ub-b ub-b))
				   (t (set-ub new-ub-b ro-obj_b)	
					(propagate-number-rest-< (nr-of-b new-ub-b) (bit-ior (real-ord-obj-*< ro-obj_b)
													     (real-ord-obj-*<= ro-obj_b)))))
			   ))))
  )

(defun propagate-number-constraint->= (ro-obj_a ro-obj_b)
  (let ((ub-a (real-ord-obj-ub ro-obj_a))
	  (lb-a (real-ord-obj-lb ro-obj_a))
	  (ub-b (real-ord-obj-ub ro-obj_b))
	  (lb-b (real-ord-obj-lb ro-obj_b))
	  )
	 (cond ((and ub-a
			 lb-a
			 (or (eq (rel-of-b ub-a) '<)
			     (eq (rel-of-b lb-b) '>))
			 (<= (nr-of-b ub-a) (nr-of-b lb-b)))
		  (clash 'propagate-number-constraint->= ro-obj_a ro-obj_b))
		 ((and ub-a
			 lb-a
			 (< (nr-of-b ub-a) (nr-of-b lb-b)))
		  (clash 'propagate-number-constraint->= ro-obj_a ro-obj_b))
		 ((and (eq (rel-of-b lb-b) '>=)
			 (eq (rel-of-b ub-a) '<=)
			 (= (nr-of-b ub-a)
			    (nr-of-b lb-b)))
		  (let ((eq (nr-of-b ub-a))
			  )
			 (propagate-number-rest-> eq (bit-ior (real-ord-obj-*> ro-obj_a) (real-ord-obj-*> ro-obj_b)))
			 (propagate-number-rest->= eq (bit-ior (real-ord-obj-*>= ro-obj_a) (real-ord-obj-*>= ro-obj_b)))
			 (propagate-number-rest-< eq (bit-ior (real-ord-obj-*< ro-obj_a) (real-ord-obj-*< ro-obj_b)))
			 (propagate-number-rest-<= eq (bit-ior (real-ord-obj-*<= ro-obj_a) (real-ord-obj-*<= ro-obj_b)))))
		 (t (propagate-symbolic->= ro-obj_a ro-obj_b)
		    (let ((new-lb-a (get-new-lb->= lb-a lb-b))
			    (new-ub-b (get-new-ub->= ub-b ub-a)))
			   (cond ((equal new-lb-a lb-a))
				   (t (set-lb new-lb-a ro-obj_a)
					(cond ((>? new-lb-a)
						 (propagate-number-rest-> new-lb-a (bit-ior (real-ord-obj-*> ro-obj_a)
													  (real-ord-obj-*>= ro-obj_a))))
						(t (propagate-number-rest-> new-lb-a (real-ord-obj-*> ro-obj_a))
						   (propagate-number-rest->= new-lb-a (real-ord-obj-*>= ro-obj_a))))))
			   (cond ((equal new-ub-b ub-b))
				   (t (set-ub new-ub-b ro-obj_b)
					(cond ((<? new-ub-b)
						 (propagate-number-rest-< new-ub-b (bit-ior (real-ord-obj-*< ro-obj_b)
													  (real-ord-obj-*<= ro-obj_b))))
						(t (propagate-number-rest-< new-ub-b (real-ord-obj-*< ro-obj_b))
						   (propagate-number-rest-<= new-ub-b (real-ord-obj-*<= ro-obj_b)))))))))))
