#|
********************************************************************************************
	File		: propagate-number
	Last Change	: 13 nov 91
	Author		: dd
********************************************************************************************
|#

(defun propagate-number-= (number obj)
  (cond ((or (eq-ne-clash? number (real-ord-obj-ne obj))
	     (eq-lb-clash? number (real-ord-obj-lb obj))
	     (eq-ub-clash? number (real-ord-obj-ub obj)))
	 (clash 'propagate-number-= number obj))
	(t (set-eq number obj)
	   (propagate-number-rest-> number (real-ord-obj-*> obj))
	   (propagate-number-rest->= number (real-ord-obj-*>= obj))
	   (propagate-number-rest-< number (real-ord-obj-*< obj))
	   (propagate-number-rest-<= number (real-ord-obj-*<= obj))
	   ))
  )
(defun propagate-number-<> (number obj)
  (let ((ne (real-ord-obj-ne obj))
	(lb (real-ord-obj-lb obj))
	(ub (real-ord-obj-ub obj)))
       (cond ((and lb
		   (= number (nr-of-b lb))
		   (eq '>= (rel-of-b lb)))
	      (propagate-number-<-obj number obj))
	     ((and ub
		   (= number (nr-of-b ub))
		   (eq '<= (rel-of-b ub)))
	      (propagate-number->-obj number obj))
	     (t (set-ne (cons number ne) obj))))
  )
(defun propagate-number-<-obj (number obj)
  (let ((ub (real-ord-obj-ub obj))
	(lb (real-ord-obj-lb obj))
	)
       (cond ((and ub (>= number (nr-of-b ub))) (clash 'propagate-number-<-obj number obj))
	     ((or (not lb)
		  (and (not (equal lb (list '> number)))
		       (>= number (nr-of-b lb))))
	      (set-lb (list '> number) obj)
	      (propagate-number-rest-> number (bit-ior (real-ord-obj-*> obj)
						       (real-ord-obj-*>= obj))))))
  )
(defun propagate-number->-obj (number obj)
  (let ((ub (real-ord-obj-ub obj))
	(lb (real-ord-obj-lb obj))
	)
       (cond ((and lb (<= number (nr-of-b lb))) (clash 'propagate-number->-obj number obj))
	     ((or (not ub)
		  (and (not (equal ub (list '< number)))
		       (<= number (nr-of-b ub))))
	      (set-ub (list '< number) obj)
	      (propagate-number-rest-< number (bit-ior (real-ord-obj-*< obj)
						       (real-ord-obj-*<= obj))))))
  )
(defun propagate-number-<=-obj (number obj)
  (let ((ub (real-ord-obj-ub obj))
	(lb (real-ord-obj-lb obj))
	)
       (cond ((equal (list '<= number) ub)
	      (propagate-number-= number obj))
	     ((and ub (>= number (nr-of-b ub))) (clash 'propagate-number-<=-obj number obj))
	     ((or (not lb)
		  (> number (nr-of-b lb)))
	      (set-lb (list '>= number) obj)
	      (propagate-number-rest-> number (real-ord-obj-*> obj))
	      (propagate-number-rest->= number (real-ord-obj-*>= obj)))))
  )
(defun propagate-number->=-obj (number obj)
  (let ((ub (real-ord-obj-ub obj))
	(lb (real-ord-obj-lb obj))
	)
       (cond ((equal (list '>= number) lb)
	      (propagate-number-= number obj))
	     ((and lb (<= number (nr-of-b lb)) (clash 'propagate-number->=-obj number obj)))
	     ((or (not ub)
		  (< number (nr-of-b ub)))
	      (set-ub (list '<= number) obj)
	      (propagate-number-rest-< number (real-ord-obj-*< obj))
	      (propagate-number-rest-<= number (real-ord-obj-*<= obj)))))
  )
