#include <stdio.h>
#include <malloc.h>
#include "cmd.h"

#define	cmd_align	(sizeof(long))

/*
 *	allocate
 */

struct cmd_str_list *alloc_cmd_str_list(len)
    int len;
{
    int size;

    size = sizeof(struct cmd_str_list) + len;
    return (struct cmd_str_list *)memalign(cmd_align, size);
}

struct cmd_create *alloc_cmd_create()
{
    return (struct cmd_create *)memalign(cmd_align, sizeof(struct cmd_create));
}

struct cmd_add_items *alloc_cmd_add_items()
{
    return (struct cmd_add_items *)
      memalign(cmd_align, sizeof(struct cmd_add_items));
}

struct cmd_clear_items *alloc_cmd_clear_items(len)
    int len;
{
    int size;

    size = sizeof(struct cmd_clear_items) + len;
    return (struct cmd_clear_items *)memalign(cmd_align, size);
}

struct cmd_set_title *alloc_cmd_set_title(len)
    int len;
{
    int size;

    size = sizeof(struct cmd_set_title) + len;
    return (struct cmd_set_title *)memalign(cmd_align, size);
}

struct cmd_set_font *alloc_cmd_set_font(len)
    int len;
{
    int size;

    size = sizeof(struct cmd_set_font) + len;
    return (struct cmd_set_font *)memalign(cmd_align, size);
}

struct cmd_get *alloc_cmd_get()
{
    return (struct cmd_get *)memalign(cmd_align, sizeof(struct cmd_get));
}

struct cmd_put *alloc_cmd_put(len)
    int len;
{
    int size;

    size = sizeof(struct cmd_put) + len;
    return (struct cmd_put *)memalign(cmd_align, size);
}

/*
 *	free
 */

void free_cmd_str_list(list)
    struct cmd_str_list *list;
{
    struct cmd_str_list *ptr;

    while (list != NULL) {
	ptr = list->next;
	free(list);
	list = ptr;
    }
}

void free_cmd_create(ptr)
    struct cmd_create *ptr;
{
    free_cmd_str_list(ptr->str_list);
    free((char *)ptr);
}

void free_cmd_add_items(ptr)
    struct cmd_add_items *ptr;
{
    free_cmd_str_list(ptr->str_list);
    free((char *)ptr);
}

void free_cmd_clear_items(ptr)
    struct cmd_add_items *ptr;
{
    free((char *)ptr);
}

void free_cmd_set_title(ptr)
    struct cmd_add_items *ptr;
{
    free((char *)ptr);
}

void free_cmd_set_font(ptr)
    struct cmd_add_items *ptr;
{
    free((char *)ptr);
}

void free_cmd_get(ptr)
    struct cmd_add_items *ptr;
{
    free((char *)ptr);
}

void free_cmd_put(ptr)
    struct cmd_add_items *ptr;
{
    free((char *)ptr);
}
