#include <stdio.h>
#include <Mrm/MrmPublic.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include "cmd.h"

#define k_main_window		0
#define k_menu_bar		1
#define k_text_window		2
#define MAX_BASIC_WIDGETS	3
#define MAX_MENU_WIDGETS	16

extern void connect_to_pim();
extern void receive_from_pim();
extern int send_to_pim();
extern int get_fd();

static MrmHierarchy	s_MrmHierarchy;
static char	       	*vec[]={"win.uid"};

static MrmCode	       	class;

Display  	*display;
XtAppContext  	app_context;

static void create_proc();
static void activate_proc();
static void modify_proc();
static void motion_proc();
static void change_proc();

static MrmRegisterArg regvec[] = {
    {"create_proc", (caddr_t)create_proc},
    {"activate_proc", (caddr_t)activate_proc},
    {"modify_proc", (caddr_t)modify_proc},
    {"motion_proc", (caddr_t)motion_proc},
    {"change_proc", (caddr_t)change_proc},
};
static MrmCount	regnum = sizeof(regvec) / sizeof(MrmRegisterArg);

static Widget toplevel;
static Widget basic_widgets[MAX_BASIC_WIDGETS];
static Widget title_widgets[MAX_MENU_WIDGETS];
static Widget menu_widgets[MAX_MENU_WIDGETS];
static struct cmd_add_items *item_obj[MAX_MENU_WIDGETS];
static int num_menus;
static struct cmd_str_list *menu_list;


main(argc, argv)
    int argc;
    char **argv;
{
    Arg arglist[1];
    int n;

    connect_to_pim();

    MrmInitialize ();

    XmjpInitialize(&argc, argv, NULL);

    XtToolkitInitialize();
    app_context = XtCreateApplicationContext();

    display = XtOpenDisplay(app_context, NULL, argv[0], "dulclass",
                            NULL, 0, &argc, argv);
    if (display == NULL) {
        fprintf(stderr, "%s:  Can't open display\n", argv[0]);
        exit(1);
    }

    n = 0;
    XtSetArg(arglist[n], XmNallowShellResize, True);  n++;
    toplevel = XtAppCreateShell(argv[0], NULL, applicationShellWidgetClass,
                              display, arglist, n);

    if (MrmOpenHierarchy (1,			    /* number of files	    */
			vec, 			    /* files     	    */
			NULL,			    /* os_ext_list (null)   */
			&s_MrmHierarchy)	    /* ptr to returned id   */
			!= MrmSUCCESS) {
	printf ("can't open hierarchy\n");
     }

    if (MrmRegisterNames(regvec, regnum) != MrmSUCCESS)
        printf("can't register names\n");

    if (MrmFetchWidget(s_MrmHierarchy,
		       "main_window",
		       toplevel,
		       &(basic_widgets[k_main_window]),
		       &class) != MrmSUCCESS)
	printf("can't fetch interface\n");

    XtManageChild(basic_widgets[k_main_window]);
    
    XtRealizeWidget(toplevel);

    XtAppMainLoop(app_context);
}

static void quit_proc(widget, tag, callback_data)
    Widget widget;
    char *tag;
    XmAnyCallbackStruct *callback_data;
{
    exit(0);
}

static void pimio(closure, source, id)
    XtPointer	closure;
    int		*source;
    XtInputId	*id;
{
    receive_from_pim();
}

/*
 *	menu bar
 */

static void title_proc(widget, client_data, callback_data)
    Widget widget;
    XtPointer client_data;
    XmAnyCallbackStruct *callback_data;
{
    struct cmd_str_list *title;
    int i;
    char buf[128];

    
    title = (struct cmd_str_list *)client_data;
    if (menu_widgets[title->number] != NULL)
	return;
    sprintf(buf, "menu(%s,%s)", &(title->string[0]), "empty");
    if (send_to_pim(ACK_MENU, buf, strlen(buf)) == False)
	quit_proc(widget, client_data, callback_data);
}

void create_menu_titles(data)
    struct cmd_create *data;
{
    struct cmd_str_list *list;
    XmString str;
    int i, n;
    Arg args[4];

    num_menus = data->num_titles;
    list = menu_list = data->str_list;
    for (i = 0; i < num_menus; i++) {
        n = 0;
        str = XmStringCreate(&(list->string[0]), "title_char_set");
        XtSetArg(args[n], XmNlabelString, str);  n++;
        title_widgets[i] = XmCreateCascadeButton(basic_widgets[k_menu_bar],
						 "menu_title", args, n);
	XtFree(str);
        XtAddCallback(title_widgets[i], XmNactivateCallback, title_proc, list);
	XtManageChild(title_widgets[i]);
	menu_widgets[i] = NULL;
	list->number = i;
	list = list->next;
    }
}

static void menu_proc(widget, client_data, callback_data)
    Widget widget;
    XtPointer client_data;
    XmAnyCallbackStruct *callback_data;
{
    struct cmd_str_list *menu, *item;
    int i;
    char buf[128];

    item = (struct cmd_str_list *)client_data;
    menu = menu_list;
    for (i = 0; i < item->number; i++)
	menu = menu->next;
    sprintf(buf, "menu(%s,%s)", &(menu->string[0]), &(item->string[0]));
    if (send_to_pim(ACK_MENU, buf, strlen(buf)) == False)
	quit_proc(widget, client_data, callback_data);
}

static int search_menu(title, list)
    char *title;
    struct cmd_str_list *list;
{
    while (list != NULL) {
	if (strcmp(&(list->string[0]), title) == 0)
	    return list->number;
	list = list->next;
    }
    return -1;
}

void add_menu_items(data)
    struct cmd_add_items *data;
{
    Widget button;
    struct cmd_str_list *list;
    XmString str;
    int m, n;
    char *name;
    Arg args[4];

    name = &(data->str_list->string[0]);
    if ((m = search_menu(name, menu_list)) == -1)
	return;
    item_obj[m] = data;
    menu_widgets[m] = XmCreatePulldownMenu(title_widgets[m], "pd_menu", NULL, 0);
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, menu_widgets[m]);  n++;
    XtSetValues(title_widgets[m], args, n);
    for (list = data->str_list->next; list != NULL; list = list->next) {
        n = 0;
        str = XmStringCreate(&(list->string[0]), "item_char_set");
        XtSetArg(args[n], XmNlabelString, str);  n++;
        button = XmCreatePushButtonGadget(menu_widgets[m], "menu_item", args, n);
        XtFree(str);
	list->number = m;
        XtAddCallback(button, XmNactivateCallback, menu_proc, list);
	XtManageChild(button);
    }
}

void clear_menu_items(data)
    struct cmd_clear_items *data;
{
    Widget button;
    struct cmd_str_list *list;
    XmString str;
    int m, n;
    Arg args[4];

    if ((m = search_menu(&(data->string[0]), menu_list)) == -1)
	return;
    if (menu_widgets[m] == NULL)
	return;
    XtDestroyWidget(menu_widgets[m]);
    menu_widgets[m] = NULL;
    free_cmd_add_items(item_obj[m]);
    free_cmd_clear_items(data);
}


/*
 *	text widget
 */

static XmTextPosition first, last;
static int fs_flag = False;
static int cr_flag = False;
static int gt_flag = False;

void set_mark()
{
    first = last = XmTextGetLastPosition(basic_widgets[k_text_window]);
    XmTextSetInsertionPosition(basic_widgets[k_text_window], last);
    gt_flag = True;
}

void put_string(ptr)
    char *ptr;
{
    first = last = XmTextGetLastPosition(basic_widgets[k_text_window]);
    XmTextSetInsertionPosition(basic_widgets[k_text_window], last);
    XmTextInsert(basic_widgets[k_text_window], last, ptr);
    first = last = XmTextGetLastPosition(basic_widgets[k_text_window]);
    XmTextSetInsertionPosition(basic_widgets[k_text_window], last);
}

static void create_proc(widget, tag, callback_data)
    Widget widget;
    char *tag;
    XmAnyCallbackStruct *callback_data;
{
    int key = *((int *)tag);

    basic_widgets[key] = widget;
    switch (key) {
    case k_main_window:
	break;
    case k_menu_bar:
	break;
    case k_text_window:
	XtAppAddInput(app_context, get_fd(), XtInputReadMask, pimio, NULL);
	break;
    }
}

static void activate_proc(widget, tag, callback_data)
    Widget widget;
    char *tag;
    XmAnyCallbackStruct *callback_data;
{
    int n = *((int *)tag);
}

static void modify_proc(widget, tag, callback_data)
    Widget widget;
    char *tag;
    XmAnyCallbackStruct *callback_data;
{
    XmTextVerifyPtr tvp = (XmTextVerifyPtr)callback_data;
    XmTextBlock tb;
    char *tbp;
    int tbl;

    if (gt_flag == False)
	return;
    tb = tvp->text;
    tbp = tb->ptr;
    tbl = tb->length;
    if (tbl == 1 && *tbp == '.') {
	last = XmTextGetLastPosition(basic_widgets[k_text_window]);
	XmTextSetInsertionPosition(basic_widgets[k_text_window], last);
	tvp->newInsert = tvp->startPos = tvp->endPos = last;
	fs_flag = True;
    } else if (tbl == 1 && *tbp == '\n' && fs_flag == True) {
	cr_flag = True;
    } else if (tbl == 0) {
	if (XmTextGetInsertionPosition(basic_widgets[k_text_window]) <= first)
	    tvp->doit = False;
    }
}
/*
static char *scan_string(str, n)
    char *str;
    int n;
{
    int i;

    for (i = 0; i < n; i++)
	if (*str & 0x80)
	    str +=2;
	else
	    str++;
    return str;
}
*/
static void change_proc(widget, tag, callback_data)
    Widget widget;
    char *tag;
    XmAnyCallbackStruct *callback_data;
{
    char *str, *ptr;

    if (gt_flag == False)
	return;
    if (cr_flag == True) {
	cr_flag = False;
	fs_flag = False;
	gt_flag = False;
	last = XmTextGetLastPosition(basic_widgets[k_text_window]);
	if (first+1 < last) {
/*	    str = XmTextGetString(basic_widgets[k_text_window]);*/
	    XmTextSetSelection(widget, first, last, CurrentTime);
	    str = XmTextGetSelection(widget);
	    XmTextClearSelection(widget, CurrentTime);
#ifdef DEBUG
fprintf(stderr, "{%d:%d}\n", first, last);
#endif
	    if (send_to_pim(ACK_TEXT, str, strlen(str)) == False)
		quit_proc(widget, tag, callback_data);
	    XtFree(str);
	}
    }
}

static void motion_proc(widget, tag, callback_data)
    Widget widget;
    char *tag;
    XmAnyCallbackStruct *callback_data;
{
}
