/*
 *	command data structure
 */

#define	MAX_PACKET		(1024*32)

#define	CMD_ERROR	(-1)
#define	CMD_STR_LIST	0
#define	CMD_CREATE	1
#define	CMD_ADD_ITEMS	2
#define	CMD_CLEAR_ITEMS	3
#define	CMD_SET_TITLE	4
#define	CMD_SET_FONT	5
#define	CMD_GET		6
#define	CMD_PUT		7

#define ACK_FALSE	0
#define ACK_TRUE	1
#define ACK_TEXT	2
#define ACK_MENU	3


struct cmd_str_list {
    struct cmd_str_list	*next;
    short		number;
    short		str_length;
    char		string[1];
};

struct cmd_create {
    short		num_titles;
    struct cmd_str_list	*str_list;
};

struct cmd_add_items {
    short		num_items;
    struct cmd_str_list	*str_list;
};

struct cmd_clear_items {
    short		str_length;
    char		string[1];
};

struct cmd_set_title {
    short		str_length;
    char		string[1];
};

struct cmd_set_font {
    short		str_length;
    char		string[1];
};

struct cmd_get {
    short		str_length;
};

struct cmd_put {
    short		str_length;
    char		string[1];
};

struct cmd_str_list *alloc_cmd_str_list(/*len*/);
struct cmd_create *alloc_cmd_create();
struct cmd_add_items *alloc_cmd_add_items();
struct cmd_clear_items *alloc_cmd_clear_items(/*len*/);
struct cmd_set_title *alloc_cmd_set_title(/*len*/);
struct cmd_set_font *alloc_cmd_set_font(/*len*/);
struct cmd_get *alloc_cmd_get();
struct cmd_put *alloc_cmd_put(/*len*/);
