/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* execution engine */

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

int executing;
struct obstack *mm_exec;
MQ_Goal mq_goal_true;
static int printing;
static jmp_buf catch_exec, catch_print;

static MQ_Goal prev_goal;
static struct obstack exec_obstack;
static unsigned char *exec_first_obj;

/* function prototype for debugging */
static MQ_VTerm tangle_var _P((MQ_Var, MQ_VTerm *));
static MQ_Dot tangle_dot _P((MQ_Dot));
static MQ_VTerm tangle_vterm _P((MQ_VTerm, MQ_VTerm *));
static MQ_Term tangle_term _P((MQ_Term, MQ_Term *));
static MQ_Constraint tangle_constraint _P((MQ_Constraint));

void init_exec ()
{
  mm_exec = &exec_obstack;
  obstack_begin (mm_exec, EXEC_SIZE);
}

void begin_exec ()
{
  executing = 1;
  mm_current = mm_exec;
  exec_first_obj = (unsigned char *)obstack_alloc (mm_exec, 0);
  prev_goal = NULL;
}

void suspend_exec ()
{
  mm_current = mm_rule;
  executing = 0;
}

void resume_exec ()
{
  executing = 1;
  mm_current = mm_exec;
}

void end_exec ()
{
  executing = 0;
  obstack_free (mm_exec, exec_first_obj);
  exec_first_obj = (unsigned char *)obstack_alloc (mm_exec, 0);
  mm_current = mm_rule;
}

void free_exec ()
{
  obstack_free (mm_exec, exec_first_obj);
  exec_first_obj = (unsigned char *)obstack_alloc (mm_exec, 0);
}

#define DOWN 0
#define UP   1

int solve (sg)
     MQ_Goal sg;
{
  MQ_Goal g;
  int direction = DOWN;

  g = sg;
  while (g)
    if (direction == UP)
      if (g->type == GT_Once)
	if (g->next == NULL)
	  {
	    g = g->parent;
	    direction = UP;
	  }
	else
	  {
	    direction = DOWN;
	    g = g->next;
	  }
      else if (g->type == GT_Attribute)
	{
	  if (g->next == NULL)
	    {
	      g = g->parent;
	      direction = UP;
	    }
	  else
	    {
	      direction = DOWN;
	      g = g->next;
	    }
	}
      else if (constrain_back (g) == SUCCESS)
	{
	  MQ_Goal ag;

	  if (g->type == GT_Done ||
	      (ag = make_attribute_goals (g)) == NULL)
	    if (g->next == NULL)
	      {
		g = g->parent;
		direction = UP;
	      }
	    else
	      {
		direction = DOWN;
		g = g->next;
	      }
	  else
	    {
	      if (lookup_active_goals (ag) == FALSE)
		{
		  direction = DOWN;
		  ag->prev = prev_goal;
		  prev_goal = ag;
		  g = ag->subgoal;
		}
	      else if (g->next == NULL)
		{
		  g = g->parent;
		  direction = UP;
		}
	      else
		{
		  direction = DOWN;
		  g = g->next;
		}
	    }
	}
      else
	{
	  g = prev_goal;
	  direction = DOWN;
	}
    else /* direction == DOWN */
      if (g->type == GT_General)
	{
	  MQ_Goal first_subgoal;

	  if (g->rule == NULL)
	    { /* first execution */
	      MQ_Atom a;
	      int arity;
	      MQ_RuleList rl;

	      g->up = up;
	      g->cnstrs_asmpts = cnstrs_asmpts;
	      g->prev = prev_goal;
	      g->keep_clean = (unsigned char *)obstack_alloc (mm_exec, 0);

	      if (g->goal_vterm->type == TT_Obj)
		{
		  a = ((MQ_Obj) g->goal_vterm)->atom;
		  arity = ((MQ_Obj) g->goal_vterm)->arity;
		  rl = a->rule_list;
		  while (rl)
		    if (rl->arity < arity)
		      rl = rl->next;
		    else
		      break;
		  if ((rl == NULL) || (rl->arity > arity))
		    {
		      g = g->prev;
		      continue;
		    }

		  g->rule_list = NULL;
		  g->rule = rl->rule;
		}
	      else
		{ /* variable proposition */
		  /* rule_list has always mQ_void_rule_list */
		  g->rule_list = rule_list->next;
		  if (g->rule_list == NULL)
		    {
		      g = g->prev;
		      continue;
		    }
		  g->rule = g->rule_list->rule;
		}
	    }
	  else
	    { /* try next rule */
	      cnstrs_asmpts = g->cnstrs_asmpts;
	      unwind_variables (g->up);
	      obstack_free (mm_exec, g->keep_clean);
	      g->keep_clean = (unsigned char *)obstack_alloc (mm_exec, 0);
	      if (g->rule_list)
		{ /* variable proposition */
		  g->rule_list = g->rule_list->next;
		  if (g->rule_list == NULL)
		    {
		      g->rule = NULL;
		      g = g->prev;
		      if (mq_opt_trace)
			printf ("fail.\n");
		      continue;
		    }
		  g->rule = g->rule_list->rule;
		}
	      else
		if ((g->rule = g->rule->next) == NULL)
		  {
		    g = g->prev;
		    if (mq_opt_trace)
		      printf ("fail.\n");
		    continue;
		  }
	    }

	  g->var_list = generate_variables (g->rule->var_list);
	  g->head = tangle_vterm (g->rule->head, &g->head);

	  if (unify (&g->goal_vterm, &g->head) == FAILURE)
	    continue;

	  g->head_cnstrs = tangle_constraints (g->rule->head_cnstrs);
	  g->body_cnstrs = tangle_constraints (g->rule->body_cnstrs);

	  if (constrain_front (g) == FAILURE)
	    continue;

	  g->subgoal = first_subgoal = generate_subgoals (g);

	  if (mq_opt_trace)
	    print_goal (g);

	  g->lookup = NULL;

	  if (first_subgoal == NULL)
	    { /* fact */
	      direction = UP;
	      prev_goal = g;
	      continue;
	    }

	  if (lookup_active_goals (g) == FALSE)
	    {
	      prev_goal = g;
	      g = g->subgoal;
	    }
	}
      else if (g->type == GT_Attribute)
	{
	  g = g->prev;
	}
      else if (g->type == GT_Done)
	{
	  g->type = GT_Through;
	  g = g->prev;
	}
      else if (g->type == GT_Once)
	{
	  cnstrs_asmpts = g->cnstrs_asmpts;
	  unwind_variables (g->up);
	  obstack_free (mm_exec, g->keep_clean);
	  g->keep_clean = (unsigned char *)obstack_alloc (mm_exec, 0);
	  g->type = GT_Done;
	  if (constrain_front (g) == FAILURE)
	    {
	      g = g->prev;
	      continue;
	    }

	  prev_goal = g;
	  if (g->subgoal)
	    g = g->subgoal;
	  else
	    direction = UP;
	}
      else if (g->type == GT_Through)
	{
	  g->type = GT_Once;
	  g->up = up;
	  g->cnstrs_asmpts = cnstrs_asmpts;
	  g->prev = prev_goal;
	  g->keep_clean = (unsigned char *)obstack_alloc (mm_exec, 0);
	  lookup_active_goals (g);
	  prev_goal = g;
	  direction = UP;
	}
      else
	fatal ("solve.\n");

  if (direction == UP)
    return SUCCESS;
  else
    return FAILURE;
}

void do_query (query)
     MQ_Query query;
{
  int say_yes = 0;

  printing = FALSE;
  (void)signal (SIGINT, interrupt_handler);
  if (setjmp (catch_exec))
    {
      fflush (stdout);
      fprintf (stderr, "aborted.\n");
      (void)signal (SIGINT, SIG_IGN);
      unwind_variables (NULL);
      free_lookup ();
      cnstrs_asmpts = mQ_void_cnstrs_asmpts;
      mq_goal_true->rule = NULL;
      return;
    }

  up = NULL;
  cnstrs_asmpts = mQ_void_cnstrs_asmpts;
  if (constrain_front (query->goal) == FAILURE)
    goto fail;

  if (solve (query->goal->subgoal) == SUCCESS)
    {
      printf ("yes.\n");
      say_yes = 1;
      delete_nonsence_asmpts ();
      if (!constrain_failed)
	{
	  if (setjmp (catch_print))
	    {
	      fflush (stdout);
	      printf ("\n");
	      fprintf (stderr, "printing answer aborted.\n");
	    }
	  else
	    {
	      printing = TRUE;
	      print_answer (query);
	    }
	  printing = FALSE;
	}

      while (solve (prev_goal) == SUCCESS)
	{
	  delete_nonsence_asmpts ();
	  if (!constrain_failed)
	    {
	      if (setjmp (catch_print))
		{
		  fflush (stdout);
		  printf ("\n");
		  fprintf (stderr, "printing answer aborted.\n");
		}
	      else
		{
		  printing = TRUE;
		  print_answer (query);
		}
	      printing = FALSE;
	    }
	}
    }

 fail:
  if (!say_yes)
    printf ("no.\n");

  (void)signal (SIGINT, SIG_IGN);
}

MQ_VTermList generate_variables (var_list)
     MQ_VarList var_list;
{
  MQ_Var new_var;
  MQ_VTermList new, next;

  if (var_list == NULL)
    return NULL;

  next = generate_variables (var_list->next);
  new = make_vterm_list (next);

  new_var = make_variable ();
  new->vterm = (MQ_VTerm) new_var;
  /* executing == 1 here */
  new_var->vterm_addr_list = var_list->var->vterm_addr_list =
    make_vterm_addr_list (&new->vterm, NULL);
  return new;
}

static
MQ_VTerm tangle_var (var_template, vterm_p)
     MQ_Var var_template;
     MQ_VTerm *vterm_p;
{
  MQ_VTerm vt;

  vt = *(var_template->vterm_addr_list->vterm_addr);
  if (vt->type == TT_Var)
    {
      MQ_Var var;

      var = (MQ_Var) vt;
      /* executing == 1 here */
      var->vterm_addr_list
	= make_vterm_addr_list (vterm_p, var->vterm_addr_list);
    }
  return vt;
}

MQ_Obj tangle_obj (obj)
     MQ_Obj obj;
{
  MQ_Obj new;
  int i, arity;

  arity = obj->arity;
  new = make_object (obj->atom, arity);
  for (i=0; i < arity; i++)
    {
      new->attr[i].label = obj->attr[i].label;
      new->attr[i].vterm = tangle_vterm (obj->attr[i].vterm,
					 &new->attr[i].vterm);
    }
  return new;
}

static
MQ_Dot tangle_dot (dot)
     MQ_Dot dot;
{
  MQ_Dot new;

  new = make_dot (dot->label);
  new->vterm = tangle_vterm (dot->vterm, &new->vterm);
  return new;
}

static
MQ_VTerm tangle_vterm (vterm, vterm_p)
     MQ_VTerm vterm;
     MQ_VTerm *vterm_p;
{
  MQ_VTerm new;

  switch (vterm->type)
    {
    case TT_Var:
      new = tangle_var ((MQ_Var)vterm, vterm_p);
      break;
    case TT_Obj:
      new = (MQ_VTerm) tangle_obj ((MQ_Obj)vterm);
      break;
    default:
      fatal ("tangle_vterm\n");
      break;
    }
  return new;
}

static
MQ_Term tangle_term (term, term_p)
     MQ_Term term;
     MQ_Term *term_p;
{
  MQ_Term new;

  if (term == NULL)
    return NULL;

  switch (term->type)
    {
    case TT_Var:
      new = (MQ_Term) tangle_var ((MQ_Var)term, (MQ_VTerm *)term_p);
      break;
    case TT_Obj:
      new = (MQ_Term) tangle_obj ((MQ_Obj)term);
      break;
    case TT_Dot:
      new = (MQ_Term) tangle_dot ((MQ_Dot)term);
      break;
    default:
      fatal ("tangle_term\n");
      break;
    }
  return new;
}

static
MQ_Constraint tangle_constraint (cnstr)
     MQ_Constraint cnstr;
{
  MQ_Constraint new;

  new = make_cnstr (cnstr->rel, NULL, NULL);
  new->term = tangle_term (cnstr->term, &new->term);
  new->vterm = tangle_vterm (cnstr->vterm, &new->vterm);
  return new;
}

MQ_Constraints tangle_constraints (cnstrs)
     MQ_Constraints cnstrs;
{
  MQ_Constraints new, next;
  MQ_Constraint cnstr;

  if (cnstrs == NULL)
    fatal ("tangle_constraints\n");

  if (cnstrs == mQ_void_cnstrs)
    return mQ_void_cnstrs;

  next = tangle_constraints (cnstrs->next);
  cnstr = tangle_constraint (cnstrs->cnstr);
  new = make_cnstrs (cnstr, next);
  return new;
}

MQ_Goal generate_subgoals (g)
     MQ_Goal g;
{
  MQ_Goal subgoal, first_subgoal, last_subgoal;
  MQ_VTermList vl;

  first_subgoal = last_subgoal = subgoal = NULL;
  for (vl=g->rule->body; vl; vl = vl->next)
    {
      last_subgoal = subgoal;
      subgoal = make_goal ();
      subgoal->goal_vterm
	= tangle_vterm (vl->vterm, &subgoal->goal_vterm);
      subgoal->parent = g;
      if (last_subgoal)
	last_subgoal->next = subgoal;
      else
	first_subgoal = subgoal;
    }
  return first_subgoal;
}

void interrupt_handler ()
{
  if (printing)
    longjmp (catch_print, EXCEPT_ABORT);
  else
    longjmp (catch_exec, EXCEPT_ABORT);
}

void init_interactive (is_interactive_p)
     int is_interactive_p;
{
  interactive = is_interactive_p;
  if (interactive)
    (void)signal (SIGINT, SIG_IGN);
  else
    (void)signal (SIGINT, SIG_DFL);
}
