/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* interface to constraint solvers */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

int constrain_failed;
MQ_Constraints dot_cnstrs, dot_asmpts, dot_cnstrs_h;
MQ_Constraints sub_cnstrs, sub_asmpts, sub_cnstrs_h;
MQ_Constraints ext_cnstrs, ext_asmpts, ext_cnstrs_h;

MQ_CnstrsAsmpts cnstrs_asmpts;
MQ_Constraint mQ_void_cnstr;
MQ_Constraints mQ_void_cnstrs;
MQ_CnstrsAsmpts mQ_void_cnstrs_asmpts;

static struct obstack *mm_cnstrs;
static struct obstack cnstrs_obstack;
static unsigned char *cnstrs_first_obj;

typedef struct VariableProtect_Rec {
  struct VariableProtect_Rec *next;

  MQ_Var var;
  MQ_VTermAddrList vterm_addr_list;
} VariableProtect_Rec, *VariableProtect;

static VariableProtect vp;

/* function prototype for debugging */
static void constrain_with_head_and_body_front _P((MQ_Goal));
static void constrain_with_head_and_body_back _P((MQ_Goal));
static void constraint_solve_cnstrs _P((void));
static void constraint_solve_asmpts _P((void));
static void constraint_solve_cnstrs_h _P((void));
static void add_cnstr_to_cnstrs _P((MQ_Constraint));
static void add_cnstr_to_asmpts _P((MQ_Constraint));
static void add_cnstr_to_cnstrs_h _P((MQ_Constraint));
static MQ_Constraint cs_tangle_cnstr _P((MQ_Constraint));
static MQ_Constraints cs_tangle_cnstrs _P((MQ_Constraints));
static MQ_Constraints copy_cnstrs _P((MQ_Constraints));
static void mark_variable _P((MQ_Var));
static void mark_variables_in_vterm _P((MQ_VTerm));
static void mark_variables_in_cnstrs _P((MQ_Constraints));
static MQ_CnstrsAsmpts make_cnstrs_asmpts _P((void));

int constrain_front (g)
     MQ_Goal g;
{
  MQ_CnstrsAsmpts new;
  VariableProtect vp1;

  if (mq_opt_constrain == 0)
    return SUCCESS;

  vp = NULL;
  constrain_failed = FALSE;

  /* protect variables against GC */
  mark_variables_in_cnstrs (g->head_cnstrs);
  mark_variables_in_cnstrs (g->body_cnstrs);
  mark_variables_in_cnstrs (cnstrs_asmpts->dot_cnstrs);
  mark_variables_in_cnstrs (cnstrs_asmpts->sub_cnstrs);
  mark_variables_in_cnstrs (cnstrs_asmpts->ext_cnstrs);
  mark_variables_in_cnstrs (cnstrs_asmpts->dot_asmpts);
  mark_variables_in_cnstrs (cnstrs_asmpts->sub_asmpts);
  mark_variables_in_cnstrs (cnstrs_asmpts->ext_asmpts);
  mark_variables_in_cnstrs (cnstrs_asmpts->dot_cnstrs_h);
  mark_variables_in_cnstrs (cnstrs_asmpts->sub_cnstrs_h);
  mark_variables_in_cnstrs (cnstrs_asmpts->ext_cnstrs_h);
  for (vp1=vp; vp1; vp1=vp1->next)
    {
      unwind_protect_variable_in_cnstrs (vp1->var, vp1->vterm_addr_list);
      vp1->var->value = NULL;	/* clear PROTECTED mark */
    }

  mm_current = mm_cnstrs;
  dot_cnstrs = cs_tangle_cnstrs (cnstrs_asmpts->dot_cnstrs);
  sub_cnstrs = cs_tangle_cnstrs (cnstrs_asmpts->sub_cnstrs);
  ext_cnstrs = cs_tangle_cnstrs (cnstrs_asmpts->ext_cnstrs);
  dot_asmpts = cs_tangle_cnstrs (cnstrs_asmpts->dot_asmpts);
  sub_asmpts = cs_tangle_cnstrs (cnstrs_asmpts->sub_asmpts);
  ext_asmpts = cs_tangle_cnstrs (cnstrs_asmpts->ext_asmpts);
  dot_cnstrs_h = cs_tangle_cnstrs (cnstrs_asmpts->dot_cnstrs_h);
  sub_cnstrs_h = cs_tangle_cnstrs (cnstrs_asmpts->sub_cnstrs_h);
  ext_cnstrs_h = cs_tangle_cnstrs (cnstrs_asmpts->ext_cnstrs_h);

  while (1)
    {
      binding_changed = FALSE;
      constraint_solve_cnstrs ();
      if (constrain_failed)
	goto fail;

      constraint_solve_asmpts ();
      if (constrain_failed)
	goto fail;

      constraint_solve_cnstrs_h ();
      if (constrain_failed)
	goto fail;

      if (!binding_changed)
	break;
    }

  constrain_with_head_and_body_front (g);
  if (constrain_failed)
    goto fail;

  /* SUCCESS */
  for (vp1=vp; vp1; vp1=vp1->next)
    vp1->var->vterm_addr_list = vp1->vterm_addr_list;
  mm_current = mm_exec;
  new = make_cnstrs_asmpts ();
  /* scavenging */
  new->dot_cnstrs = cs_tangle_cnstrs (dot_cnstrs);
  new->sub_cnstrs = cs_tangle_cnstrs (sub_cnstrs);
  new->ext_cnstrs = cs_tangle_cnstrs (ext_cnstrs);
  new->dot_asmpts = cs_tangle_cnstrs (dot_asmpts);
  new->sub_asmpts = cs_tangle_cnstrs (sub_asmpts);
  new->ext_asmpts = cs_tangle_cnstrs (ext_asmpts);
  new->dot_cnstrs_h = cs_tangle_cnstrs (dot_cnstrs_h);
  new->sub_cnstrs_h = cs_tangle_cnstrs (sub_cnstrs_h);
  new->ext_cnstrs_h = cs_tangle_cnstrs (ext_cnstrs_h);
  cnstrs_asmpts = new;
  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
  return SUCCESS;

 fail:
  for (vp1=vp; vp1; vp1=vp1->next)
    vp1->var->vterm_addr_list = vp1->vterm_addr_list;
  mm_current = mm_exec;
  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
  return FAILURE;
}

static
void constrain_with_head_and_body_front (g)
     MQ_Goal g;
{
  MQ_Constraints cs;

  for (cs = g->body_cnstrs; cs!=mQ_void_cnstrs; cs = cs->next)
    {
      binding_changed = FALSE;
      add_cnstr_to_asmpts (cs->cnstr);
      if (constrain_failed)
	return;
#if 1
      add_cnstr_to_cnstrs_h (cs->cnstr);
      if (constrain_failed)
	return;
#endif

      while (1)
	{
	  binding_changed = FALSE;
	  constraint_solve_cnstrs ();
	  if (constrain_failed)
	    return;

	  constraint_solve_asmpts ();
	  if (constrain_failed)
	    return;

	  constraint_solve_cnstrs_h ();
	  if (constrain_failed)
	    return;

	  if (!binding_changed)
	    break;
	}
    }

  for (cs = g->head_cnstrs; cs!=mQ_void_cnstrs; cs = cs->next)
    {
      binding_changed = FALSE;
      add_cnstr_to_cnstrs_h (cs->cnstr);
      if (constrain_failed)
	return;

      if (!binding_changed)
	continue;

      while (1)
	{
	  binding_changed = FALSE;
	  constraint_solve_cnstrs ();
	  if (constrain_failed)
	    return;

	  constraint_solve_asmpts ();
	  if (constrain_failed)
	    return;

	  constraint_solve_cnstrs_h ();
	  if (constrain_failed)
	    return;

	  if (!binding_changed)
	    break;
	}
    }
}

int constrain_back (g)
     MQ_Goal g;
{
  MQ_CnstrsAsmpts new;
  VariableProtect vp1;

  if (mq_opt_constrain == 0)
    return SUCCESS;

  vp = NULL;
  constrain_failed = FALSE;

  /* protect variables against GC */
  mark_variables_in_cnstrs (g->head_cnstrs);
  mark_variables_in_cnstrs (g->body_cnstrs);
  mark_variables_in_cnstrs (cnstrs_asmpts->dot_cnstrs);
  mark_variables_in_cnstrs (cnstrs_asmpts->sub_cnstrs);
  mark_variables_in_cnstrs (cnstrs_asmpts->ext_cnstrs);
  mark_variables_in_cnstrs (cnstrs_asmpts->dot_asmpts);
  mark_variables_in_cnstrs (cnstrs_asmpts->sub_asmpts);
  mark_variables_in_cnstrs (cnstrs_asmpts->ext_asmpts);
  mark_variables_in_cnstrs (cnstrs_asmpts->dot_cnstrs_h);
  mark_variables_in_cnstrs (cnstrs_asmpts->sub_cnstrs_h);
  mark_variables_in_cnstrs (cnstrs_asmpts->ext_cnstrs_h);
  for (vp1=vp; vp1; vp1=vp1->next)
    {
      unwind_protect_variable_in_cnstrs (vp1->var, vp1->vterm_addr_list);
      vp1->var->value = NULL;	/* clear PROTECTED mark */
    }

  mm_current = mm_cnstrs;
  dot_cnstrs = cs_tangle_cnstrs (cnstrs_asmpts->dot_cnstrs);
  sub_cnstrs = cs_tangle_cnstrs (cnstrs_asmpts->sub_cnstrs);
  ext_cnstrs = cs_tangle_cnstrs (cnstrs_asmpts->ext_cnstrs);
  dot_asmpts = cs_tangle_cnstrs (cnstrs_asmpts->dot_asmpts);
  sub_asmpts = cs_tangle_cnstrs (cnstrs_asmpts->sub_asmpts);
  ext_asmpts = cs_tangle_cnstrs (cnstrs_asmpts->ext_asmpts);
  dot_cnstrs_h = cs_tangle_cnstrs (cnstrs_asmpts->dot_cnstrs_h);
  sub_cnstrs_h = cs_tangle_cnstrs (cnstrs_asmpts->sub_cnstrs_h);
  ext_cnstrs_h = cs_tangle_cnstrs (cnstrs_asmpts->ext_cnstrs_h);

  while (1)
    {
      binding_changed = FALSE;
      constraint_solve_cnstrs ();
      if (constrain_failed)
	goto fail;

      constraint_solve_asmpts ();
      if (constrain_failed)
	goto fail;

      constraint_solve_cnstrs_h ();
      if (constrain_failed)
	goto fail;

      if (!binding_changed)
	break;
    }

  constrain_with_head_and_body_back (g);
  if (constrain_failed)
    goto fail;

  /* SUCCESS */
  for (vp1=vp; vp1; vp1=vp1->next)
    vp1->var->vterm_addr_list = vp1->vterm_addr_list;
  mm_current = mm_exec;
  new = make_cnstrs_asmpts ();
  /* scavenging */
  new->dot_cnstrs = cs_tangle_cnstrs (dot_cnstrs);
  new->sub_cnstrs = cs_tangle_cnstrs (sub_cnstrs);
  new->ext_cnstrs = cs_tangle_cnstrs (ext_cnstrs);
  new->dot_asmpts = cs_tangle_cnstrs (dot_asmpts);
  new->sub_asmpts = cs_tangle_cnstrs (sub_asmpts);
  new->ext_asmpts = cs_tangle_cnstrs (ext_asmpts);
  new->dot_cnstrs_h = cs_tangle_cnstrs (dot_cnstrs_h);
  new->sub_cnstrs_h = cs_tangle_cnstrs (sub_cnstrs_h);
  new->ext_cnstrs_h = cs_tangle_cnstrs (ext_cnstrs_h);
  cnstrs_asmpts = new;
  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
  return SUCCESS;

 fail:
  for (vp1=vp; vp1; vp1=vp1->next)
    vp1->var->vterm_addr_list = vp1->vterm_addr_list;
  mm_current = mm_exec;
  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
  return FAILURE;
}

static
void constrain_with_head_and_body_back (g)
     MQ_Goal g;
{
  MQ_Constraints cs;

  for (cs = g->head_cnstrs; cs!=mQ_void_cnstrs; cs = cs->next)
    {
      binding_changed = FALSE;

      add_cnstr_to_cnstrs (cs->cnstr);
      if (constrain_failed)
	return;

      while (1)
	{
	  binding_changed = FALSE;
	  constraint_solve_cnstrs ();
	  if (constrain_failed)
	    return;

	  constraint_solve_asmpts ();
	  if (constrain_failed)
	    return;

	  constraint_solve_cnstrs_h ();
	  if (constrain_failed)
	    return;

	  if (!binding_changed)
	    break;
	}
    }
}

static
void constraint_solve_cnstrs ()
{
  int binding_changed_saved = binding_changed;
  int binding_changed_1;

  binding_changed_1 = FALSE;
  binding_changed = FALSE;

  constraint_solve_dot_cnstrs ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 1: 0);

  binding_changed = FALSE;
  constraint_solve_sub_cnstrs ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 2: 0);

  binding_changed = FALSE;
  constraint_solve_ext_cnstrs ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 4: 0);

  while (binding_changed_1)
    {
      binding_changed_1 = FALSE;
      binding_changed_saved = TRUE;

      if (binding_changed_1 & 6)
	{
	  binding_changed = FALSE;
	  constraint_solve_dot_cnstrs ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 1: 0);
	}

      if (binding_changed_1 & 5)
	{
	  binding_changed = FALSE;
	  constraint_solve_sub_cnstrs ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 2: 0);
	}

      if (binding_changed_1 & 3)
	{
	  binding_changed = FALSE;
	  constraint_solve_ext_cnstrs ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 4: 0);
	}
    }
  binding_changed = binding_changed_saved;
  return;
}

static
void constraint_solve_asmpts ()
{
  int binding_changed_saved = binding_changed;
  int binding_changed_1;

  binding_changed_1 = FALSE;
  binding_changed = FALSE;

  constraint_solve_dot_asmpts ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 1: 0);

  binding_changed = FALSE;
  constraint_solve_sub_asmpts ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 2: 0);

  binding_changed = FALSE;
  constraint_solve_ext_asmpts ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 4: 0);

  while (binding_changed_1)
    {
      binding_changed_1 = FALSE;
      binding_changed_saved = TRUE;

      if (binding_changed_1 & 6)
	{
	  binding_changed = FALSE;
	  constraint_solve_dot_asmpts ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 1: 0);
	}

      if (binding_changed_1 & 5)
	{
	  binding_changed = FALSE;
	  constraint_solve_sub_asmpts ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 2: 0);
	}

      if (binding_changed_1 & 3)
	{
	  binding_changed = FALSE;
	  constraint_solve_ext_asmpts ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 4: 0);
	}
    }
  binding_changed = binding_changed_saved;
  return;
}

static
void constraint_solve_cnstrs_h ()
{
  int binding_changed_saved = binding_changed;
  int binding_changed_1;

  binding_changed_1 = FALSE;
  binding_changed = FALSE;

  constraint_solve_dot_cnstrs_h ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 1: 0);

  binding_changed = FALSE;
  constraint_solve_sub_cnstrs_h ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 2: 0);

  binding_changed = FALSE;
  constraint_solve_ext_cnstrs_h ();
  if (constrain_failed)
    return;
  binding_changed_1 |= (binding_changed? 4: 0);

  while (binding_changed_1)
    {
      binding_changed_1 = FALSE;
      binding_changed_saved = TRUE;

      if (binding_changed_1 & 6)
	{
	  binding_changed = FALSE;
	  constraint_solve_dot_cnstrs_h ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 1: 0);
	}

      if (binding_changed_1 & 5)
	{
	  binding_changed = FALSE;
	  constraint_solve_sub_cnstrs_h ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 2: 0);
	}

      if (binding_changed_1 & 3)
	{
	  binding_changed = FALSE;
	  constraint_solve_ext_cnstrs_h ();
	  if (constrain_failed)
	    return;
	  binding_changed_1 |= (binding_changed? 4: 0);
	}
    }
  binding_changed = binding_changed_saved;
  return;
}

static
void add_cnstr_to_cnstrs (cnstr)
     MQ_Constraint cnstr;
{
  int binding_changed_saved = binding_changed;

  binding_changed = FALSE;
  switch (cnstr->rel)
    {
    case DotCongruent:
      add_cnstr_to_dot_cnstrs (cnstr);
      break;

    case Subsumes:
    case SubsumesVarVar:
    case SubsumesVarObj:
    case SubsumesObjVar:
      add_cnstr_to_sub_cnstrs (cnstr);
      break;

    case Congruent:
      if (unify ((MQ_VTerm *)&cnstr->term, &cnstr->vterm) == FAILURE)
	constrain_failed = TRUE;
      break;

    case ExternalExpr:
    case ExternalCnstr:
      add_cnstr_to_ext_cnstrs (cnstr);
      break;

    default:
      fatal ("add_cnstr_to_csntrs\n");
      break;
    }
  if (constrain_failed || !binding_changed)
    {
      binding_changed = binding_changed_saved;
      return;
    }
  constraint_solve_cnstrs ();
  binding_changed = TRUE;
}

static
void add_cnstr_to_asmpts (cnstr)
     MQ_Constraint cnstr;
{
  int binding_changed_saved = binding_changed;

  binding_changed = FALSE;
  switch (cnstr->rel)
    {
    case DotCongruent:
      add_cnstr_to_dot_asmpts (cnstr);
      break;

    case Subsumes:
    case SubsumesVarVar:
    case SubsumesVarObj:
    case SubsumesObjVar:
      add_cnstr_to_sub_asmpts (cnstr);
      break;

    case Congruent:
      if (unify ((MQ_VTerm *)&cnstr->term, &cnstr->vterm) == FAILURE)
	constrain_failed = TRUE;
      break;

    case ExternalExpr:
    case ExternalCnstr:
      add_cnstr_to_ext_asmpts (cnstr);
      break;

    default:
      fatal ("add_cnstr_to_asmpts\n");
      break;
    }
  if (constrain_failed || !binding_changed)
    {
      binding_changed = binding_changed_saved;
      return;
    }
  constraint_solve_asmpts ();
  binding_changed = TRUE;
}

static
void add_cnstr_to_cnstrs_h (cnstr)
     MQ_Constraint cnstr;
{
  int binding_changed_saved = binding_changed;

  binding_changed = FALSE;
  switch (cnstr->rel)
    {
    case DotCongruent:
      add_cnstr_to_dot_cnstrs_h (cnstr);
      break;

    case Subsumes:
    case SubsumesVarVar:
    case SubsumesVarObj:
    case SubsumesObjVar:
      add_cnstr_to_sub_cnstrs_h(cnstr);
      break;

    case Congruent:
      if (unify ((MQ_VTerm *)&cnstr->term, &cnstr->vterm) == FAILURE)
	constrain_failed = TRUE;
      break;

    case ExternalExpr:
    case ExternalCnstr:
      add_cnstr_to_ext_cnstrs_h (cnstr);
      break;

    default:
      fatal ("add_cnstr_to_cnstrs_h\n");
      break;
    }
  if (constrain_failed || !binding_changed)
    {
      binding_changed = binding_changed_saved;
      return;
    }
  constraint_solve_cnstrs_h ();
  binding_changed = TRUE;
}

void delete_nonsence_asmpts ()
{
  MQ_Constraints cs;
  VariableProtect vp1;

  vp = NULL;
  dot_cnstrs = cnstrs_asmpts->dot_cnstrs;
  sub_cnstrs = cnstrs_asmpts->sub_cnstrs;
  ext_cnstrs = cnstrs_asmpts->ext_cnstrs;
  dot_asmpts = cnstrs_asmpts->dot_asmpts;
  sub_asmpts = cnstrs_asmpts->sub_asmpts;
  ext_asmpts = cnstrs_asmpts->ext_asmpts;
  dot_cnstrs_h = cnstrs_asmpts->dot_cnstrs_h;
  sub_cnstrs_h = cnstrs_asmpts->sub_cnstrs_h;
  ext_cnstrs_h = cnstrs_asmpts->ext_cnstrs_h;

  /* protect variables against GC */
  mark_variables_in_cnstrs (dot_cnstrs);
  mark_variables_in_cnstrs (sub_cnstrs);
  mark_variables_in_cnstrs (ext_cnstrs);
  mark_variables_in_cnstrs (dot_asmpts);
  mark_variables_in_cnstrs (sub_asmpts);
  mark_variables_in_cnstrs (ext_asmpts);
  mark_variables_in_cnstrs (dot_cnstrs_h);
  mark_variables_in_cnstrs (sub_cnstrs_h);
  mark_variables_in_cnstrs (ext_cnstrs_h);
  for (vp1=vp; vp1; vp1=vp1->next)
    {
      unwind_protect_variable_in_cnstrs (vp1->var, vp1->vterm_addr_list);
      vp1->var->value = NULL;	/* clear PROTECTED mark */
    }

  while (1)
    {
      binding_changed = FALSE;
      for (cs=dot_asmpts; cs!=mQ_void_cnstrs; cs=cs->next)
	if (check_cnstr_in_dot_cnstrs (cs->cnstr)) /* NOTE: may bind var */
	  { 
	    if (constrain_failed)
	      return;

	    /* delete it */
	    if (cs->prev == NULL) /* that is: cs == dot_asmpts */
	      {
		dot_asmpts = cs->next;
		if (cs->next != mQ_void_cnstrs)
		  cs->next->prev = NULL;
	      }
	    else
	      {
		cs->prev->next = cs->next;
		if (cs->next != mQ_void_cnstrs)
		  cs->next->prev = cs->prev;
	      }
	  }
      if (!binding_changed)
	break;
    }
  cnstrs_asmpts->dot_asmpts = dot_asmpts;

  for (cs=sub_asmpts; cs!=mQ_void_cnstrs; cs=cs->next)
    if (check_cnstr_in_sub_cnstrs (cs->cnstr))
      {
	if (constrain_failed)
	  return;

	if (cs->prev == NULL) /* that is: cs == sub_asmpts */
	  {
	    sub_asmpts = cs->next;
	    if (cs->next != mQ_void_cnstrs)
	      cs->next->prev = NULL;
	  }
	else
	  {
	    cs->prev->next = cs->next;
	    if (cs->next != mQ_void_cnstrs)
	      cs->next->prev = cs->prev;
	  }
      }
  cnstrs_asmpts->sub_asmpts = sub_asmpts;

  for (cs=ext_asmpts; cs!=mQ_void_cnstrs; cs=cs->next)
    if (check_cnstr_in_ext_cnstrs (cs->cnstr))
      {
	if (constrain_failed)
	  return;

	if (cs->prev == NULL) /* that is: cs == ext_asmpts */
	  {
	    ext_asmpts = cs->next;
	    if (cs->next != mQ_void_cnstrs)
	      cs->next->prev = NULL;
	  }
	else
	  {
	    cs->prev->next = cs->next;
	    if (cs->next != mQ_void_cnstrs)
	      cs->next->prev = cs->prev;
	  }
      }
  cnstrs_asmpts->ext_asmpts = ext_asmpts;
}

static
MQ_VarList cs_tangle_var_list (vl)
     MQ_VarList vl;
{
  MQ_VarList next;

  if (vl == NULL)
    return NULL;
  next = cs_tangle_var_list (vl->next);
  return make_var_list (vl->var, next);
}

static
MQ_Constraint cs_tangle_cnstr (cnstr)
     MQ_Constraint cnstr;
{
  MQ_Constraint new;

  new = make_cnstr (cnstr->rel, cnstr->term, cnstr->vterm);
  return new;
}

static
MQ_Constraints cs_tangle_cnstrs (cnstrs)
     MQ_Constraints cnstrs;
{
  MQ_Constraints new, next;
  MQ_Constraint new_cnstr;

  if (cnstrs == mQ_void_cnstrs)
    return mQ_void_cnstrs;

  next = cs_tangle_cnstrs (cnstrs->next);

  if (cnstrs->cnstr->mark)
    new_cnstr = cs_tangle_cnstr (cnstrs->cnstr);
  else
    new_cnstr = cnstrs->cnstr;

  new = make_cnstrs (new_cnstr, next);
  new->l_var_list = cs_tangle_var_list (cnstrs->l_var_list);
  new->r_var_list = cs_tangle_var_list (cnstrs->r_var_list);
  return new;
}

static
MQ_Constraints copy_cnstrs (cnstrs)
     MQ_Constraints cnstrs;
{
  MQ_Constraints new, next;

  if (cnstrs == mQ_void_cnstrs)
    return mQ_void_cnstrs;

  next = copy_cnstrs (cnstrs->next);

  new = make_cnstrs (cnstrs->cnstr, next);
  new->l_var_list = cs_tangle_var_list (cnstrs->l_var_list);
  new->r_var_list = cs_tangle_var_list (cnstrs->r_var_list);
  return new;
}

static
void mark_variable (var)
     MQ_Var var;
{
  VariableProtect new;

  if (var->value == PROTECTED)
    return;
  if (var->value)
    fatal ("variable already has bound in mark_variables.\n");
  var->value = PROTECTED;
  new = (VariableProtect)
    obstack_alloc (mm_cnstrs, sizeof (VariableProtect_Rec));
  new->var = var;
  new->vterm_addr_list = var->vterm_addr_list;
  new->next = vp;
  vp = new;
}

static MQ_VTermList vterm_list_visited;

static
void mark_variables_in_vterm (vt)
     MQ_VTerm vt;
{
  MQ_Obj o;
  int i;
  MQ_VTermList vl;

  for (vl=vterm_list_visited; vl; vl=vl->next)
    if (vl->vterm == vt)
      return;
  vterm_list_visited = make_vterm_list (vterm_list_visited);
  vterm_list_visited->vterm = vt;

  switch (vt->type)
    {
    case TT_Var:
      mark_variable ((MQ_Var)vt);
      break;
    case TT_Obj:
      o = (MQ_Obj)vt;
      for (i=0; i< o->arity; i++)
	mark_variables_in_vterm (o->attr[i].vterm);
      break;
    default:
      fatal ("mark_variables_in_vterm.\n");
      break;
    }
}

static
void mark_variables_in_cnstrs (cnstrs)
     MQ_Constraints cnstrs;
{
  MQ_Constraints cs;

  vterm_list_visited = NULL;
  for (cs=cnstrs; cs != mQ_void_cnstrs; cs= cs->next)
    {
      if (cs->cnstr->term->type == TT_Dot)
	;
      else
	mark_variables_in_vterm ((MQ_VTerm) cs->cnstr->term);
      mark_variables_in_vterm (cs->cnstr->vterm);
    }
}

MQ_Constraint make_cnstr (rel, term, vterm)
     Rel rel;
     MQ_Term term;
     MQ_VTerm vterm;
{
  MQ_Constraint new;

  new = (MQ_Constraint) obstack_alloc (mm_current, sizeof (MQ_Constraint_Rec));
  new->rel = rel;
  new->term = term;
  new->vterm = vterm;
  if (term && executing && (term->type == TT_Var))
    ((MQ_Var)term)->vterm_addr_list
      = make_vterm_addr_list ((MQ_VTerm *)&new->term,
			      ((MQ_Var)term)->vterm_addr_list);
  if (vterm && executing && (vterm->type == TT_Var))
    ((MQ_Var)vterm)->vterm_addr_list
      = make_vterm_addr_list (&new->vterm, ((MQ_Var)vterm)->vterm_addr_list);
  if (mm_current == mm_cnstrs)
    new->mark = 1;
  else
    new->mark = 0;
  return new;
}

MQ_Constraints make_cnstrs (cnstr, next)
     MQ_Constraint cnstr;
     MQ_Constraints next;
{
  MQ_Constraints new;

  new =(MQ_Constraints)obstack_alloc (mm_current, sizeof (MQ_Constraints_Rec));
  new->next = next;
  if (next && next != mQ_void_cnstrs)
    next->prev = new;
  new->cnstr = cnstr;
  new->prev = NULL;
  new->l_var_list = new->r_var_list = NULL;
  return new;
}

static
MQ_CnstrsAsmpts make_cnstrs_asmpts ()
{
  MQ_CnstrsAsmpts new;

  new = (MQ_CnstrsAsmpts)obstack_alloc (mm_exec,
					sizeof (MQ_CnstrsAsmpts_Rec));
  new->dot_cnstrs = new->dot_asmpts = new->dot_cnstrs_h =
    new->sub_cnstrs = new->sub_asmpts = new->sub_cnstrs_h =
      new->ext_cnstrs = new->ext_asmpts = new->ext_cnstrs_h = NULL;
  return new;
}

void init_constraints ()
{
  mm_cnstrs = &cnstrs_obstack;
  obstack_begin (mm_cnstrs, CONSTRAINTS_SIZE);

  mm_current = mm_cnstrs;
  mQ_void_cnstr = make_cnstr (Congruent, NULL, NULL);
  mQ_void_cnstrs = make_cnstrs (mQ_void_cnstr, NULL);
  mQ_void_cnstrs_asmpts = make_cnstrs_asmpts ();
  mQ_void_cnstrs_asmpts->dot_cnstrs = mQ_void_cnstrs_asmpts->dot_asmpts
    = mQ_void_cnstrs_asmpts->sub_cnstrs = mQ_void_cnstrs_asmpts->sub_asmpts
      = mQ_void_cnstrs_asmpts->ext_cnstrs = mQ_void_cnstrs_asmpts->ext_asmpts
	= mQ_void_cnstrs_asmpts->dot_cnstrs_h
	  = mQ_void_cnstrs_asmpts->sub_cnstrs_h
	    = mQ_void_cnstrs_asmpts->ext_cnstrs_h
	      = mQ_void_cnstrs;
  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
  cnstrs_asmpts = mQ_void_cnstrs_asmpts;
}
