/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* dot constraint solver */

#include <stdio.h>
#include "mq.h"
#include "internal.h"
#include "extern.h"

/* function prototype for debugging */
static void constraint_solve_dot _P((MQ_Constraints *));
static void add_cnstr_to_dot _P((MQ_Constraint, MQ_Constraints *));
static MQ_Constraint search_dot _P((MQ_Dot, MQ_Constraints));

void constraint_solve_dot_cnstrs ()
{
  constraint_solve_dot (&dot_cnstrs);
}

void constraint_solve_dot_asmpts ()
{
  constraint_solve_dot (&dot_asmpts);
}

void constraint_solve_dot_cnstrs_h ()
{
  constraint_solve_dot (&dot_cnstrs_h);
}

void add_cnstr_to_dot_cnstrs (cnstr)
     MQ_Constraint cnstr;
{
  add_cnstr_to_dot (cnstr, &dot_cnstrs);
}

void add_cnstr_to_dot_asmpts (cnstr)
     MQ_Constraint cnstr;
{
  add_cnstr_to_dot (cnstr, &dot_asmpts);
}

void add_cnstr_to_dot_cnstrs_h (cnstr)
     MQ_Constraint cnstr;
{
  add_cnstr_to_dot (cnstr, &dot_cnstrs_h);
}

int check_cnstr_in_dot_cnstrs (cnstr)
     MQ_Constraint cnstr;
{
  MQ_Constraints cs;
  MQ_Dot dot1, dot2;

  for (cs=dot_cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
    {
      dot1 = (MQ_Dot)cnstr->term;
      dot2 = (MQ_Dot)cs->cnstr->term;

      if ((dot1->label == dot2->label) && equal (dot1->vterm, dot2->vterm))
	{
#if 0
	  if (unify (&cnstr->vterm, &cs->cnstr->vterm) == FAILURE)
	    constrain_failed = TRUE;
	  return TRUE;
#else
	  if (equal (cnstr->vterm, cs->cnstr->vterm))
	    {
	      binding_changed = FALSE;
	      return TRUE;
	    }
	  binding_changed = FALSE;
#endif
	}
      /* equal may bind variables */
      binding_changed = FALSE;
    }
  return FALSE;
}

static
void constraint_solve_dot (cs_p)
     MQ_Constraints *cs_p;
{
  MQ_Constraints cnstrs_changed, cs;
  MQ_Dot dot;
  MQ_Constraint cnstr1;
  int binding_changed_saved;
  MQ_VTerm *vt_p;

  binding_changed_saved = binding_changed;
  while (1)
    {
      cnstrs_changed = mQ_void_cnstrs;
      for (cs=*cs_p; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  switch (cs->cnstr->rel)
	    {
	    case DotCongruentVar:
	      dot = (MQ_Dot)cs->cnstr->term;
	      if (dot->vterm->type == TT_Obj
		  || (dot->vterm->type == TT_Var
		      && ((MQ_Var)dot->vterm)->var_list != cs->l_var_list))
		{ /* instanciated or another binding to variable */
		  if (cs->prev == NULL) /* cs == *cs_p */
		    {
		      *cs_p = cs->next;
		      if (cs->next != mQ_void_cnstrs)
			cs->next->prev = NULL;
		    }
		  else
		    {
		      cs->prev->next = cs->next;
		      if (cs->next != mQ_void_cnstrs)
			cs->next->prev = cs->prev;
		    }
		  cs->next = cnstrs_changed;
		  cs->prev = NULL;
		  if (cnstrs_changed != mQ_void_cnstrs)
		    cnstrs_changed->prev = cs;
		  cnstrs_changed = cs;
		}
	      break;
	    case DotCongruentObj:
	      break;
	    default:
	      fatal ("constraint_solve_dot.\n");
	      break;
	    }
	}

      binding_changed = FALSE;
      for (cs=cnstrs_changed; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  dot = (MQ_Dot)cs->cnstr->term;
	  if ((vt_p = eval_dot (dot)) == NULL)
	    {
	      cnstr1 = search_dot (dot, *cs_p);
	      if (cnstr1 == NULL)
		{
		  switch (dot->vterm->type)
		    {
		    case TT_Var:
		      cnstr1 = make_cnstr (DotCongruentVar,
					   cs->cnstr->term, cs->cnstr->vterm);
		      *cs_p = make_cnstrs (cnstr1, *cs_p);
		      (*cs_p)->l_var_list = ((MQ_Var)dot->vterm)->var_list;
		      break;
		    case TT_Obj:
		      cnstr1 = make_cnstr (DotCongruentObj,
					   cs->cnstr->term, cs->cnstr->vterm);
		      *cs_p = make_cnstrs (cnstr1, *cs_p);
		      (*cs_p)->l_var_list = cs->l_var_list;
		      break;
		    default:
		      fatal ("constraint_solve_dot_cnstrs.\n");
		      break;
		    }
		}
	      else
		if (unify (&cnstr1->vterm, &cs->cnstr->vterm) == FAILURE)
		  {
		    constrain_failed = TRUE;
		    return;
		  }
	    }
	  else /* dot has inherent attribute */
	    if (unify (vt_p, &cs->cnstr->vterm) == FAILURE)
	      {
		constrain_failed = TRUE;
		return;
	      }
	}
      if (!binding_changed)
	break;
      binding_changed_saved = TRUE;
    }
  binding_changed = binding_changed_saved;
}

static
void add_cnstr_to_dot (cnstr, cs_p)
     MQ_Constraint cnstr;
     MQ_Constraints *cs_p;
{
  MQ_Constraint cnstr1;
  MQ_Dot dot;
  MQ_VTerm *vt_p;

  dot = (MQ_Dot)cnstr->term;
  if ((cnstr1 = search_dot (dot, *cs_p)) == NULL)
    switch (dot->vterm->type)
      {
      case TT_Var:
	cnstr1 = make_cnstr (DotCongruentVar, cnstr->term, cnstr->vterm);
	*cs_p = make_cnstrs (cnstr1, *cs_p);
	(*cs_p)->l_var_list = ((MQ_Var)dot->vterm)->var_list;
	break;
      case TT_Obj:
	if ((vt_p = eval_dot (dot)) == NULL)
	  {
	    cnstr1 = make_cnstr (DotCongruentObj, cnstr->term, cnstr->vterm);
	    *cs_p = make_cnstrs (cnstr1, *cs_p);
	    (*cs_p)->l_var_list = NULL;
	  }
	else /* dot has inherent attribute */
	  if (unify (vt_p, &cnstr->vterm) == FAILURE)
	    constrain_failed = TRUE;
	break;
      default:
	fatal ("add_cnstr_to_dot.\n");
	break;
      }
  else
    if (unify (&cnstr->vterm, &cnstr1->vterm) == FAILURE)
      constrain_failed = TRUE;
}

static
MQ_Constraint search_dot (dot, cnstrs)
     MQ_Dot dot;
     MQ_Constraints cnstrs;
{
  MQ_Constraints cs;
  MQ_Dot dot1;

  for (cs=cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
    {
      dot1 = (MQ_Dot)cs->cnstr->term;
      if ((dot->label == dot1->label) && equal (dot->vterm, dot1->vterm))
	return cs->cnstr;
    }
  return NULL;
}
