/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* commands */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

static MQ_Atom atom_on, atom_off;
static MQ_Atom atom_lookup;
static MQ_Atom atom_constrain;
static MQ_Atom atom_program, atom_rule, atom_subsumption;
static MQ_Atom atom_no, atom_down, atom_up, atom_all;
static MQ_Atom atom_inheritance;
static MQ_Atom atom_version;

/* function prototype for debugging */
static void print_lookup_value _P((void));
static void print_constrain_value _P((void));
static void print_inheritance_value _P((void));
static void show_program _P((void));
static void show_rule _P((void));
static void show_subsumption _P((void));

void init_command ()
{
  atom_on = system_atom ((unsigned char *)"on");
  atom_off = system_atom ((unsigned char *)"off");
  atom_lookup = system_atom ((unsigned char *)"lookup");
  atom_constrain = system_atom ((unsigned char *)"constrain");
  atom_program = system_atom ((unsigned char *)"program");
  atom_rule = system_atom ((unsigned char *)"rule");
  atom_subsumption = system_atom ((unsigned char *)"subsumption");
  atom_inheritance = system_atom ((unsigned char *)"inheritance");
  atom_version = system_atom ((unsigned char *)"version");
  atom_no = system_atom ((unsigned char *)"no");
  atom_down = system_atom ((unsigned char *)"down");
  atom_up = system_atom ((unsigned char *)"up");
  atom_all = system_atom ((unsigned char *)"all");
  atom_first_obj = (unsigned char *)obstack_alloc (mm_atom, 0);
}

void cmd_quit ()
{
  exit (0);
}

static
void print_lookup_value ()
{
  if (mq_opt_lookup)
    printf ("lookup: on\n");
  else
    printf ("lookup: off\n");
}

static
void print_constrain_value ()
{
  if (mq_opt_constrain == 1)
    printf ("constrain: on\n");
  else
    printf ("constrain: off\n");
}

static
void print_inheritance_value ()
{
  switch (mq_opt_inheritance)
    {
    case INHERIT_NO:
      printf ("inheritance: no\n");
      break;
    case INHERIT_DOWNWARD:
      printf ("inheritance: down\n");
      break;
    case INHERIT_UPWARD:
      printf ("inheritance: up\n");
      break;
    case INHERIT_BOTH:
      printf ("inheritance: all\n");
      break;
    default:
      fatal ("print_inheritance_value\n");
      break;
    }
}

void cmd_set (option, value)
     MQ_Atom option, value;
{
  if (option == NULL)
    {
      print_constrain_value ();
      print_lookup_value ();
      print_inheritance_value ();
    }
  else if (option == atom_constrain)
    {
      if (value == NULL)
	{
	  printf ("valid values are:\n");
	  printf ("\ton off\n");
	}
      else if (value == atom_on)
	mq_opt_constrain = 1;
      else if (value == atom_off)
	mq_opt_constrain = 0;
      else
	error ("invalid value for constrain\n");
      print_constrain_value ();
    }
  else if (option == atom_lookup)
    {
      if (value == NULL)
	{
	  printf ("valid values are:\n");
	  printf ("\toff on\n");
	}
      else if (value == atom_on)
	mq_opt_lookup = 1;
      else if (value == atom_off)
	mq_opt_lookup = 0;
      else
	error ("invalid value for lookup\n");
      print_lookup_value ();
    }
  else if (option == atom_inheritance)
    {
      if (value == NULL)
	{
	  printf ("valid values are:\n");
	  printf ("\tno down up all\n");
	}
      else if (value == atom_no)
	mq_opt_inheritance = INHERIT_NO;
      else if (value == atom_down)
	mq_opt_inheritance = INHERIT_DOWNWARD;
      else if (value == atom_up)
	mq_opt_inheritance = INHERIT_UPWARD;
      else if (value == atom_all)
	mq_opt_inheritance = INHERIT_BOTH;
      else
	error ("invalid value for inheritance\n");
      print_inheritance_value ();
    }
}

void cmd_load (filename)
     MQ_Atom filename;
{
  gobble_newline ();
  pushfilename (filename->name, TRUE);
}

void cmd_clear (what)
     MQ_Atom what;
{
  if (what == NULL)
    {
      free_atom ();
      free_subrel ();
      free_rule ();
    }
  else if (what == atom_rule)
    {
      free_rule ();
      remove_rule ();
    }
  else if (what == atom_subsumption)
    {
      free_subrel ();
    }
  else
    {
      printf ("\tusage:\n");
      printf ("\t\t&clear\n");
      printf ("\t\t&clear rule\n");
      printf ("\t\t&clear subsumption\n");
    }
}

void cmd_show (what)
     MQ_Atom what;
{
  if (what == atom_program)
    show_program ();
  else if (what == atom_rule)
    show_rule ();
  else if (what == atom_subsumption)
    show_subsumption ();
  else if (what == atom_version)
    show_version ();
  else
    {
      printf ("\tusage:\n");
      printf ("\t\t&show\n");
      printf ("\t\t&show version\n");
      printf ("\t\t&show program\n");
      printf ("\t\t&show rule\n");
      printf ("\t\t&show subsumption\n");
    }
}

void show_version ()
{
  printf ("Micro Quixote version %s.  Copyright (C) 1993 ICOT\n\n",
	  mq_version);
}

static
void show_program ()
{
  printf ("&program;;\n");
  show_subsumption ();
  show_rule ();
  printf ("&end.\n");
}

static
void show_rule ()
{
  mm_current = mm_exec;
  printf ("&rule;;\n");
  print_all_rules ();
  mm_current = mm_rule;
}

static
void show_subsumption ()
{
  mm_current = mm_exec;
  printf ("&subsumption;;\n");
  print_all_subrel ();
  mm_current = mm_rule;
}
