/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* attribute inheritance */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

/* function prototype for debugging */
static void generate_attribute_goals _P((MQ_Dot));
static void generate_attribute_goals_upward _P((MQ_Dot));
static void generate_attribute_goals_downward _P((MQ_Dot));
static int is_parametric _P((MQ_VTerm));

static MQ_Goal first_subgoal, last_subgoal;

MQ_Goal make_attribute_goals (g)
     MQ_Goal g;
{
  MQ_Goal ag, g1;
  MQ_Constraints cs;
  MQ_Dot dot;

  if (!mq_opt_inheritance)
    return NULL;

  first_subgoal = last_subgoal = NULL;

  for (cs=cnstrs_asmpts->dot_asmpts; cs!=mQ_void_cnstrs; cs=cs->next)
    {
      dot = (MQ_Dot)cs->cnstr->term;
      if (!equal (dot->vterm, g->head))
	continue;

      if (cs->cnstr->vterm->type == TT_Var
	  && (is_parametric (dot->vterm) == FALSE))
	generate_attribute_goals (dot);
    }

  if (first_subgoal)
    {
      ag = make_goal ();
      ag->goal_vterm = g->goal_vterm;
      ag->type = GT_Attribute;
      ag->next = g->next;
      ag->parent = g->parent;
      ag->subgoal = first_subgoal;
      for (g1=first_subgoal; g1; g1 = g1->next)
	g1->parent = ag;
    }
  else
    ag = NULL;

  return ag;
}

static
void generate_attribute_goals (dot)
     MQ_Dot dot;
{
  if (mq_opt_inheritance & INHERIT_UPWARD)
    generate_attribute_goals_upward (dot);
  if (mq_opt_inheritance & INHERIT_DOWNWARD)
    generate_attribute_goals_downward (dot);
}

static
void generate_attribute_goals_upward (dot)
     MQ_Dot dot;
{
  MQ_Obj o;
  MQ_Constraints cs;
  MQ_Goal subgoal;
  MQ_Constraint cnstr1, cnstr2, cnstr3;
  MQ_Var v1, v2;
  MQ_Dot dot2;
  MQ_Atom l;
  MQ_Atom a;
  MQ_Obj obj;
  int arity;
  MQ_RuleList rl;
  MQ_Rule r;
  MQ_VTermList var_list;
  int exist_p;
  int supersume_p;
  int i, j;

  o = (MQ_Obj)dot->vterm;
  l = dot->label;
  arity = o->arity;

  begin_get_atom_which_supersumes (o->atom);
  a = o->atom;

  subgoal = last_subgoal;
  do
    {
      for (rl=a->rule_list; rl && rl->arity < arity; rl=rl->next)
	;

      for (rl=a->rule_list; rl; rl=rl->next)
	for (r=rl->rule; r; r=r->next)
	  {
	    if (r->head->type != TT_Obj)
	      fatal ("attr.c\n");
	    obj = (MQ_Obj)r->head;
	    supersume_p = TRUE;

	    if (obj->atom == o->atom && rl->arity == arity)
	      supersume_p = FALSE; /* avoid refuting same object */

	    /* check obj is really supersumes o */
	    for (i=j=0; j < rl->arity; j++)
	      {
		if (i == arity)
		  supersume_p = FALSE;

		if (!supersume_p)
		  break;

		while (i < arity)
		  if (obj->attr[i].label > o->attr[j].label)
		    {
		      supersume_p = FALSE;
		      break;
		    }
		  else if (obj->attr[i].label == o->attr[j].label)
		    break;
		  else
		    i++;
	      }
	    if (!supersume_p)
	      continue;

	    /* check the rule bind the dot term */
	    exist_p = FALSE;
	    for (cs=r->head_cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
	      if (cs->cnstr->term->type == TT_Dot
		  && ((MQ_Dot)cs->cnstr->term)->label == l)
		{
		  exist_p = TRUE;
		  break;
		}
	    if (!exist_p)
	      continue;

	    /* check if it is not intrinsic attribute */
	    for (j=0; j < rl->arity; j++)
	      if (obj->attr[j].label == l)
		{
		  exist_p = FALSE;
		  break;
		}
	    if (!exist_p)
	      continue;

	    cs = mQ_void_cnstrs;
	    var_list = generate_variables (r->var_list);
	    obj = tangle_obj (obj);
	    if (eval_subsumption ((MQ_VTerm)o, (MQ_VTerm)obj, &cs) == TRUE)
	      {
		last_subgoal = subgoal;
		subgoal = make_goal ();
		subgoal->var_list = var_list;
		subgoal->type = GT_Through;
		subgoal->goal_vterm = (MQ_VTerm)obj;
		subgoal->rule = r;
		subgoal->head_cnstrs
		  = tangle_constraints (r->head_cnstrs);
		subgoal->body_cnstrs
		  = tangle_constraints (r->body_cnstrs);

		subgoal->subgoal = generate_subgoals (subgoal);
		dot2 = make_dot (dot->label);
		dot2->vterm = (MQ_VTerm)obj;
		v1 = make_variable ();
		v2 = make_variable ();
		cnstr1 = make_cnstr (DotCongruent, (MQ_Term)dot,(MQ_VTerm)v1);
		cnstr2 = make_cnstr (DotCongruent, (MQ_Term)dot2,(MQ_VTerm)v2);
		cnstr3 = make_cnstr (Subsumes, (MQ_Term)v1, (MQ_VTerm)v2);
		cs = subgoal->head_cnstrs;
		cs = make_cnstrs (cnstr1, cs);
		cs = make_cnstrs (cnstr2, cs);
		cs = make_cnstrs (cnstr3, cs);
		subgoal->head_cnstrs = cs;
		if (last_subgoal)
		  last_subgoal->next = subgoal;
		else
		  first_subgoal = subgoal;
	      }
	  }
    }
  while ((a = get_next_atom_supersump ()));

  last_subgoal = subgoal;
}

static
void generate_attribute_goals_downward (dot)
     MQ_Dot dot;
{
  MQ_Obj o;
  MQ_Constraints cs;
  MQ_Goal subgoal;
  MQ_Constraint cnstr1, cnstr2, cnstr3;
  MQ_Var v1, v2;
  MQ_Dot dot2;
  MQ_Atom l;
  MQ_Atom a;
  MQ_Obj obj;
  int arity;
  MQ_RuleList rl;
  MQ_Rule r;
  MQ_VTermList var_list;
  int exist_p;
  int subsume_p;
  int i, j;

  o = (MQ_Obj)dot->vterm;
  l = dot->label;
  arity = o->arity;

  begin_get_atom_which_subsumes (o->atom);
  a = o->atom;

  subgoal = last_subgoal;
  do
    for (rl=a->rule_list; rl && rl->arity <= arity; rl=rl->next)
      for (r=rl->rule; r; r=r->next)
	{
	  if (r->head->type != TT_Obj)
	    fatal ("attr.c\n");
	  obj = (MQ_Obj)r->head;
	  subsume_p = TRUE;

	  if (obj->atom == o->atom && rl->arity == arity)
	    subsume_p = FALSE; /* avoid refuting same object */

	  /* check obj is really subsumes o */
	  for (i=j=0; i < rl->arity; i++)
	    {
	      if (j == arity)
		subsume_p = FALSE;

	      if (!subsume_p)
		break;

	      while (j < arity)
		if (obj->attr[i].label > o->attr[j].label)
		  {
		    subsume_p = FALSE;
		    break;
		  }
		else if (obj->attr[i].label == o->attr[j].label)
		  break;
		else
		  j++;
	    }
	  if (!subsume_p)
	    continue;
	  exist_p = FALSE;
	  for (cs=r->head_cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
	    if (cs->cnstr->term->type == TT_Dot
		&& ((MQ_Dot)cs->cnstr->term)->label == l)
	      {
		exist_p = TRUE;
		break;
	      }
	  if (!exist_p)
	    continue;
	  /* check if it is not intrinsic attribute */
	  for (j=0; j < rl->arity; j++)
	    if (obj->attr[j].label == l)
	      {
		exist_p = FALSE;
		break;
	      }
	  if (!exist_p)
	    continue;

	  cs = mQ_void_cnstrs;
	  var_list = generate_variables (r->var_list);
	  obj = tangle_obj (obj);
	  if (eval_subsumption ((MQ_VTerm)obj, (MQ_VTerm)o, &cs) == TRUE)
	    {
	      last_subgoal = subgoal;
	      subgoal = make_goal ();
	      subgoal->var_list = var_list;
	      subgoal->type = GT_Through;
	      subgoal->goal_vterm = (MQ_VTerm)obj;
	      subgoal->rule = r;
	      subgoal->head_cnstrs = tangle_constraints (r->head_cnstrs);
	      subgoal->body_cnstrs = tangle_constraints (r->body_cnstrs);

	      subgoal->subgoal = generate_subgoals (subgoal);
	      dot2 = make_dot (dot->label);
	      dot2->vterm = (MQ_VTerm)obj;
	      v1 = make_variable ();
	      v2 = make_variable ();
	      cnstr1 = make_cnstr (DotCongruent, (MQ_Term)dot, (MQ_VTerm)v1);
	      cnstr2 = make_cnstr (DotCongruent, (MQ_Term)dot2, (MQ_VTerm)v2);
	      cnstr3 = make_cnstr (Subsumes, (MQ_Term)v2, (MQ_VTerm)v1);
	      cs = subgoal->head_cnstrs;
	      cs = make_cnstrs (cnstr1, cs);
	      cs = make_cnstrs (cnstr2, cs);
	      cs = make_cnstrs (cnstr3, cs);
	      subgoal->head_cnstrs = cs;
	      if (last_subgoal)
		last_subgoal->next = subgoal;
	      else
		first_subgoal = subgoal;
	    }
	}
  while ((a = get_next_atom_subsump ()));

  last_subgoal = subgoal;
}

static
int is_parametric (vt)
     MQ_VTerm vt;
{
  MQ_Obj o;
  int i;

  switch (vt->type)
    {
    case TT_Var:
      return TRUE;
      break;
    case TT_Obj:
      o = (MQ_Obj) vt;
      for (i=0; i < o->arity; i++)
	if (is_parametric (o->attr[i].vterm))
	  return TRUE;
      return FALSE;
      break;
    default:
      fatal ("something wrong in is_parametric.\n");
      break;
    }
}
