/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	visual.h	---	Global variables for visual.c.
 *
 */

/* Font name */
#define	DEFFONT		"a14"

/* Window's names passed to the window-manager */
#define SYS_NAME	"DCP"
#define COM_NAME	"DCP.Command"
#define LTRL_INFO_NAME	"DCP.Info.ACnstr"
#define LINK_INFO_NAME  "DCP.Info.Link"

/* types of information windows */
#define LTRL_INFO 0
#define LINK_INFO 1

/* Default window size */
#define DEF_WIND_SIZE   "900x800"

/* Parameters for layout of the buttons */
#define	NUM_OF_BUTTONS	6
#define	BUTTON_H_MARGIN	10
#define	BUTTON_V_MARGIN	5
#define	FOCUS_WIDTH	3

/* Parameters for layout of the literals */
#define LITRL_H_MARGIN	5
#define LITRL_V_MARGIN	10
#define ARC_WIDTH	40

/* Parameters for layout of the command-window */
#define PARAM_H_MARGIN	10
#define PARAM_V_MARGIN	10
#define	PARAM_WIDTH	500

/* Parameter for layout of the info-window */
#define	INFO_WIDTH	360

/* Range of the location appearing new clauses */
#define HMIN	10
#define VMIN	50
#define	HMAX	900
#define	VMAX	700
#define	HSTEP	100
#define VSTEP	30

/* Resolution of display of activation value */
#define	RESOLUTION	11

/* Parameters of arrow-mark */
#define CAND_ARROW_LENGTH1	20
#define CAND_ARROW_LENGTH2	20
#define CAND_ARROW_LENGTH3	10

#define SUBSMD_LINK	1
#define NOT_SUBSMD_LINK	2
#define HIGH_ACT_LINK	3

#define	MAX(x, y)	((x) > (y) ? (x) : (y))


typedef	struct _VNodeRec_chunk {
  struct _VNodeRec_chunk *nxt;
  struct _VNodeRec       cell[NUM_OF_VNODEREC];
} VNodeRec_chunk;

typedef	struct _Button {
  char       *name;
  int        highlight;
  Window     wind;
  XRectangle gmtry;
  GC         normalGC;
  GC         inverseGC;
  void       (*action)();
} Button;

typedef struct _ParamWindow {
  Boolean dirty;
  Boolean mapped;
  int     lines;
  char    text[COLUMNS][ROWS];
  int     p;
  char    buffer[BUFFSIZE];
  Window  wind;
  GC      tl;
  GC      cl;
} ParamWindow;

typedef struct _InfoWindow {
  int     type;
  Boolean dirty;
  int     lines;
  char    text[COLUMNS][ROWS];
  union {
    litrlrec *literal;
    linkrec  *link;
  } body;
  Window  wind;
  GC      font;
  struct _InfoWindow *prev;
  struct _InfoWindow *next;
} InfoWindow;


#ifdef	PROTO_VISUAL_C

VNodeRec_chunk *VNodeRec_c;
VNodeRec *VNodeRec_r;

struct _Global {
  Display  *disp;

  Window   wind;
  Cursor   normcs;
  Cursor   chngcs1;
  Cursor   chngcs2;
  GC       txt;			/* for writing equations          */
  GC       xor;			/* for drawing clausal-rect       */
  GC       color[RESOLUTION];	/* for writing literals and links */
  GC	   mark;		/* for marker of next subsumption */
  GC       clear;               /* for clearing markers           */
  Colormap cm;
  XPoint   prev;
  int      linkmode;
  VNodeRec *clauses;
} Global;

Window GButtonFrame;

ParamWindow GParamWindow;

InfoWindow *GInfoWindowsList;

struct _FntInfo {
  XFontStruct *fs;
  XCharStruct cs;
  int         ch;
  int         cw;
} FntInfo;

#else

extern struct _Global {
  Display  *disp;

  Window   wind;
  Cursor   normcs;
  Cursor   chngcs1;
  Cursor   chngcs2;
  GC       txt;			/* for writing equations          */
  GC       xor;			/* for drawing clausal-rect       */
  GC       color[RESOLUTION];	/* for writing literals and links */
  GC	   mark;		/* for marker of next subsumption */
  GC       clear;               /* for clearing markers           */
  Colormap cm;
  XPoint   prev;
  int      linkmode;
  VNodeRec *clauses;
} Global;

extern Button GButton[NUM_OF_BUTTONS];

extern Window GButtonFrame;

extern ParamWindow GParamWindow;

extern InfoWindow *GInfoWindowsList;

extern struct _FntInfo {
  XFontStruct *fs;
  XCharStruct cs;
  int         ch;
  int         cw;
} FntInfo;

#endif	/* PROTO_VISUAL_C */
