/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	button.c	---	Action-functions of button.
 *
 */

#include	<stdio.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#define	PROTO_BUTTON_C
#include	"../main/define.h"
#include	"../main/typedef.h"
#include	"../main/global.h"
#include	"visual.h"
#include	"proto.h"
#undef	PROTO_BUTTON_C

#pragma segment	visual


void ExposeButton(n)
     int n;
{
  int dir, asc, desc;
  XCharStruct overall;

  XFillRectangle(Global.disp, GButton[n].wind,
		 (GButton[n].highlight ?
		  GButton[n].normalGC : GButton[n].inverseGC),
		 0, 0,
		 GButton[n].gmtry.width, GButton[n].gmtry.height);
  XTextExtents(FntInfo.fs,
	       GButton[n].name, strlen(GButton[n].name),
	       &dir, &asc, &desc, &overall);
  XDrawString(Global.disp, GButton[n].wind,
	      (GButton[n].highlight ?
	       GButton[n].inverseGC : GButton[n].normalGC),
	      (GButton[n].gmtry.width - overall.width)/2,
	      (GButton[n].gmtry.height - asc - desc)/2 + asc,
	      GButton[n].name, strlen(GButton[n].name));
}


void EnterButton(n)
     int n;
{
  int dir, asc,desc;
  XCharStruct overall;

  XTextExtents(FntInfo.fs,
	       GButton[n].name, strlen(GButton[n].name),
	       &dir, &asc, &desc, &overall);
  XFillRectangle(Global.disp, GButton[n].wind,
		 GButton[n].inverseGC, 0, 0,
		 GButton[n].gmtry.width, GButton[n].gmtry.height);
  XDrawImageString(Global.disp, GButton[n].wind,
		   GButton[n].inverseGC,
		   (GButton[n].gmtry.width - overall.width)/2,
		   (GButton[n].gmtry.height - asc - desc)/2 + asc,
		   GButton[n].name, strlen(GButton[n].name));
}


void LeaveButton(n)
     int n;
{
  int dir, asc, desc;
  XCharStruct overall;

  XTextExtents(FntInfo.fs,
	       GButton[n].name, strlen(GButton[n].name),
	       &dir, &asc, &desc, &overall);
  XFillRectangle(Global.disp, GButton[n].wind,
		 GButton[n].inverseGC, 0, 0,
		 GButton[n].gmtry.width, GButton[n].gmtry.height);
  XDrawString(Global.disp, GButton[n].wind,
	      GButton[n].normalGC,
	      (GButton[n].gmtry.width - overall.width)/2,
	      (GButton[n].gmtry.height - asc - desc)/2 + asc,
	      GButton[n].name, strlen(GButton[n].name));
  if (GButton[n].highlight) {
    /*	Reverse this button and draw its name.	*/
    XFillRectangle(Global.disp, GButton[n].wind, GButton[n].inverseGC,
		   0, 0,
		   GButton[n].gmtry.width, GButton[n].gmtry.height);
    XTextExtents(FntInfo.fs, GButton[n].name, strlen(GButton[n].name),
		 &dir, &asc, &desc, &overall);
    XDrawString(Global.disp, GButton[n].wind, GButton[n].normalGC,
		(GButton[n].gmtry.width - overall.width)/2,
		(GButton[n].gmtry.height - asc - desc)/2 + asc,
		GButton[n].name, strlen(GButton[n].name));
    GButton[n].highlight = FALSE;
  }
}


void PressButton(n, x, y)
     int n;
     int x, y;
{
  int dir, asc, desc;
  XCharStruct overall;

  if (!GButton[n].highlight) {
    /*	Reverse this button and draw its name.	*/
    XFillRectangle(Global.disp, GButton[n].wind, GButton[n].normalGC,
		   0, 0,
		   GButton[n].gmtry.width, GButton[n].gmtry.height);
    XTextExtents(FntInfo.fs, GButton[n].name, strlen(GButton[n].name),
		 &dir, &asc, &desc, &overall);
    XDrawString(Global.disp, GButton[n].wind, GButton[n].inverseGC,
		(GButton[n].gmtry.width - overall.width)/2,
		(GButton[n].gmtry.height - asc - desc)/2 + asc,
		GButton[n].name, strlen(GButton[n].name));
    if (0 < x && x < GButton[n].gmtry.width &&
	0 < y && y < GButton[n].gmtry.height) {
      GButton[n].highlight = TRUE;
      /* Call callback routine HERE !!! */
    }
  }
}


void ReleaseButton(n, x, y)
     int n;
     int x, y;
{
  int dir, asc, desc;
  XCharStruct overall;

  if (GButton[n].highlight) {
    /*	Reverse this button and draw its name.	*/
    XFillRectangle(Global.disp, GButton[n].wind, GButton[n].inverseGC,
		   0, 0,
		   GButton[n].gmtry.width, GButton[n].gmtry.height);
    XTextExtents(FntInfo.fs, GButton[n].name, strlen(GButton[n].name),
		 &dir, &asc, &desc, &overall);
    XDrawString(Global.disp, GButton[n].wind, GButton[n].normalGC,
		(GButton[n].gmtry.width - overall.width)/2,
		(GButton[n].gmtry.height - asc - desc)/2 + asc,
		GButton[n].name, strlen(GButton[n].name));
    if (0 < x && x < GButton[n].gmtry.width &&
	0 < y && y < GButton[n].gmtry.height) {
      GButton[n].highlight = FALSE;
      (*GButton[n].action)();
    }
  }
}
