/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	special.c	---	Routines handling I/O special predicates.
 *				(1992.11.6 (Fri))
 */

#include	<stdio.h>

#define	PROTO_SPECIAL_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_special_C

#pragma segment	special


/* check_special_litral() monitors pressures
 * which come into SPECIAL literal's argument.
 * If these pressures are large enough, invoke
 * I/O process.
 */
Boolean check_special_literal()
{
  litrlrec *ltrl, *newfunc;
  jointrec *jnt;
  dependrec *dpnd;
  press *prss, *mprss;
  double mimprt;
  Boolean processed;

  processed = FALSE;
  for (ltrl = Gcontrol.signed_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt)
    if (ltrl->tag == CONSTRAINT &&
	ltrl->body.afm.name[0] == '@') {
      mprss = NULL;
      mimprt = 0.0;
      for (jnt = ltrl->body.afm.arg[0].body.val; jnt != NULL; jnt = jnt->nxt)
	for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt)
	  for (prss = dpnd->link->press[1-dpnd->dir];
	       prss != NULL; prss = prss->nxt)
	    if (prss->orgn != NULL &&
		prss->orgn->imp > mimprt) {
	      mprss = prss;
	      mimprt = prss->orgn->imp;
	    }
      if (mprss != NULL && mimprt > Gparams.actTH &&
	  mprss->orgn->tag == FUNCTION) {
	processed = TRUE;
	if (Gparams.subsume)
	  printf("Invoking action `%s'\n",
		 mprss->orgn->body.afm.name);
	newfunc = special_io(mprss->link->ptr[mprss->dir], mprss->orgn);
	put_probe(mprss->link, addto_llist(NULL, newfunc), 1-mprss->dir,
		  mprss->link->ptr[1-mprss->dir]->joint->nth, "");
      }
    }
  return processed;
}


/*
 * special_io() transforms the given literal SPEECH(X0) as follows:
 *
 *    X0=newfunc(X1) SPEECH(X1)
 *
 * where:
 *   newfunc: the first element of the origins of the given probe `prb'.
 *   linkend: end of the link X0.
 */
litrlrec *special_io(linkend, origin)
     dependrec *linkend;
     litrlrec *origin;
{
  pphandle *newfunc, *top;
  litrlrec *special, *ltrl;
  jointrec *jnt0, *jnt1;
  dependrec *dpnd0, *dpnd1;
  linkrec *lnk;
  int dir;

  special = linkend->joint->ltrl;
  Gparams.copiedp = TRUE;
  /*
   * create literals and connect them to other ones.
   */
  newfunc = new_function(NEGATIVE, origin);
  newfunc->body->sbsm = TRUE;
  newfunc->body->rel = special->rel;
  newfunc->body->coeff = special->coeff;
  for (jnt0 = origin->joint; jnt0 != NULL; jnt0 = jnt0->nxt)
    for (dpnd0 = jnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt) {
      ltrl = dpnd0->link->ptr[dpnd0->dir]->joint->ltrl;
      connect_literals(ltrl, newfunc->body, origin->body.afm.arity+1, Gparams.wsub);
    }
  connect_literals(origin, newfunc->body, origin->body.afm.arity+1, Gparams.wsub);
  /*=== order of connection is very important... ===*/
  /*
   * connect equations.
   */
  jnt0 = new_equation_joint(newfunc->body, 0, "");
  jnt1 = new_equation_joint(special, 0, "");
  dpnd0 = new_dependency(jnt0);
  dpnd1 = new_dependency(jnt1);
  new_equation_link(dpnd0, dpnd1, TRUE);
  disconnect_dependency(linkend);
  jnt0 = new_equation_joint(newfunc->body, LEFTHAND, "");
  connect_dependency(jnt0, linkend);
  /*
   * serialize new literals
   */
  for (top = special->pphndl->begin; top->next != NULL; top = top->next)
    DisposePPHandleVNode(top);
  DisposePPHandleVNode(top);
  top->next = newfunc;
  newfunc->top = special->pphndl->top;
  newfunc->begin = special->pphndl->begin;
  newfunc->next = NULL;
  return newfunc->body;
}


pphandle *new_function(pol, aform)
     int pol;
     litrlrec *aform;
{
  litrlrec *newfunc;
  int i;

  newfunc = NEW_litrlrec();
  newfunc->tag = FUNCTION;
  newfunc->pol = pol;
  newfunc->rel = REL_DEFAULT;
  newfunc->coeff.nOmega = 0.0;
  newfunc->coeff.omegaN = 1.0;
  newfunc->coeff.disj = DISJ_DEFAULT;
  newfunc->coeff.excl = EXCL_DEFAULT;
  newfunc->coeff.cmpl = CMPL_DEFAULT;
  newfunc->coeff.assm = ASSM_DEFAULT;
  newfunc->dfrc = 0.0;
  newfunc->path = NULL;
  newfunc->press = NULL;
  newfunc->act = LITERAL_INIT;
  newfunc->z = 0.0;
  newfunc->imp = 0.0;
  newfunc->body.afm.name = aform->body.afm.name;
  newfunc->body.afm.arity = aform->body.afm.arity;
  newfunc->body.afm.arg = NEW_argument(aform->body.afm.arity);
  for (i=0; i < aform->body.afm.arity; i++) {
    newfunc->body.afm.arg[i].body.val = NULL;
    newfunc->body.afm.arg[i].body.print.varname = new_name('Y');
  }
  newfunc->lefth = NULL;
  newfunc->joint = NULL;
  newfunc->handle = NULL;
  newfunc->pphndl = NEW_pphandle();
  newfunc->pphndl->body = newfunc;
  newfunc->pphndl->aux = NULL;
  newfunc->pphndl->vnode = NULL;
  newfunc->pphndl->next = NULL;
  newfunc->lid = Gcontrol.lid++;
  newfunc->mark = TRUE;
  newfunc->sbsm = FALSE;
  newfunc->misc = 0;
  newfunc->vnode = NULL;
  if (pol == UNSIGNED) {
    newfunc->ctrl.nxt = Gcontrol.unsigned_preds;
    Gcontrol.unsigned_preds = newfunc;
    if (newfunc->ctrl.nxt != NULL)
      newfunc->ctrl.nxt->ctrl.prv = newfunc;
  } else {
    newfunc->ctrl.nxt = Gcontrol.signed_preds;
    Gcontrol.signed_preds = newfunc;
    if (newfunc->ctrl.nxt != NULL)
      newfunc->ctrl.nxt->ctrl.prv = newfunc;
  }
  newfunc->print.varname = new_name('X');
  return newfunc->pphndl;
}
