/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	pressure.c	---	Pressure handling routines.
 *
 */

#include	<stdio.h>

#define	PROTO_PRESSURE_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_PRESSURE_C

#pragma segment	spread


void put_pressure(orgn, link, dir, nth, ftr, strng, dump, dist, path)
     litrlrec *orgn;
     linkrec *link;
     int dir;
     int nth;
     char *ftr;
     double strng;
     int dump;
     int dist;
     press *path;
{
  press *prss, *newprss;
  double nxtstrng;

  if (orgn == NULL)
    return;
  /* pressure can't pass through weak links */
  if (link->tag == INFERENCE &&
      !link->ptr[0]->joint->total && !link->ptr[1]->joint->total)
    return;
  /* check the same sort of pressure in the same direction */
  for (prss = link->press[dir]; prss != NULL; prss = prss->nxt)
    if (prss->orgn == orgn &&
	(link->tag == EQUATION ||
	 coupled(prss->nth, prss->ftr, nth, ftr))) {
      if (strng < prss->strng)
	return;
      else if (strng == prss->strng) {
	if (dump > prss->dump)
	  return;
	else if (dump == prss->dump) {
	  if (dist >= prss->dist)
	    return;
	}
      }
      /**** replace this press with new one ****/
      if (prss->path.prv != NULL)
	prss->path.prv->path.nxt = NULL;
      if (prss->path.nxt != NULL)
	prss->path.nxt->path.prv = NULL;
      newprss = prss;
      break;
    }
  if (prss == NULL) {
    newprss = NEW_press();
    /**** attach to link ****/
    newprss->prv = NULL;
    newprss->nxt = link->press[dir];
    if (newprss->nxt != NULL)
      newprss->nxt->prv = newprss;
    link->press[dir] = newprss;
    /**** add to control list ****/
    newprss->ctrl.prv = NULL;
    newprss->ctrl.nxt = orgn->press;
    if (newprss->ctrl.nxt != NULL)
      newprss->ctrl.nxt->ctrl.prv = newprss;
    orgn->press = newprss;
  }
  newprss->dir = dir;
  newprss->link = link;
  newprss->orgn = orgn;
  newprss->nth = nth;
  newprss->ftr = ftr;
  newprss->strng = strng;
  newprss->dump = dump;
  newprss->dist = dist;
  /**** add to path ****/
  newprss->path.prv = NULL;
  newprss->path.nxt = path;
  if (newprss->path.nxt != NULL)
    newprss->path.nxt->path.prv = newprss;
  /**** calculate next strength ****/
  if (link->tag == EQUATION)
    nxtstrng = strng * link->sub * nAct(link->coeff[0].body.act);
  else if (nth == PSTENTRY)
    nxtstrng = strng * link->sub * nAct(link->coeff[0].body.act);
  else if (nth == LEFTHAND)
    nxtstrng = strng * link->sub * nAct(link->coeff[link->n-1].body.act);
  else
    nxtstrng = strng * link->sub * nAct(link->coeff[nth].body.act);
  provide_pressure(orgn, link, dir, newprss, nxtstrng);
}


void provide_pressure(orgn, link, dir, prss, strng)
     litrlrec *orgn;
     linkrec *link;
     int dir;
     press *prss;
     double strng;
{
  litrlrec *literal, *ftr;
  jointrec *joint, *jnt0, *jnt1;
  dependrec *dpnd0;
  int dump;

  joint = link->ptr[dir]->joint;
  literal = joint->ltrl;
  if (link->tag == EQUATION) {
    /* check if this pressure arrives a competing binding */
    if (joint->nth == LEFTHAND) {
      if (compete(literal, orgn) && literal->dfrc < strng) {
	literal->dfrc = strng;
	literal->path = prss;
      }
      return;
    }
    /* provide pressures from inference-link */
    if (literal->tag == PSTERM)
      for (ftr = literal->body.pst.nxt; ftr != NULL; ftr = ftr->body.pst.nxt)
	for (jnt0 = ftr->joint; jnt0 != NULL; jnt0 = jnt0->nxt)
	  for (dpnd0 = jnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt)
	    put_pressure(orgn,
			 dpnd0->link, dpnd0->dir, prss->nth, prss->ftr,
			 strng, prss->dump, prss->dist+1, prss);
    else
      for (jnt0 = literal->joint; jnt0 != NULL; jnt0 = jnt0->nxt)
	for (dpnd0 = jnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt)
	  put_pressure(orgn,
		       dpnd0->link, dpnd0->dir, prss->nth, prss->ftr,
		       strng, prss->dump, prss->dist+1, prss);
  } else {
    /* provide pressures from an appropriate argument */
    if (dominate(joint))
      dump = prss->dump;
    else
      dump = prss->dump + 1;
    switch (literal->tag) {
    case SYMBOL:
    case NUMBER:
      panic("0-ary predicate has inference-link ? (`provide_pressure')", 0);
      break;
    case FUNCTION:
      if (prss->nth == LEFTHAND) {
	for (jnt0 = literal->lefth; jnt0 != NULL; jnt0 = jnt0->nxt)
	  for (dpnd0 = jnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt) {
	    jnt1 = dpnd0->link->ptr[dpnd0->dir]->joint;
	    put_pressure(orgn,
			 dpnd0->link, dpnd0->dir, jnt1->nth, jnt1->ftr,
			 strng, dump, prss->dist+1, prss);
	  }
	break;
      }
    case CONSTRAINT:		/* FUNCTION also needs following */
      for (jnt0 = literal->body.afm.arg[prss->nth].body.val;
	   jnt0 != NULL; jnt0 = jnt0->nxt)
	for (dpnd0 = jnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt) {
	  jnt1 = dpnd0->link->ptr[dpnd0->dir]->joint;
	  put_pressure(orgn,
		       dpnd0->link, dpnd0->dir, jnt1->nth, jnt1->ftr,
		       strng, dump, prss->dist+1, prss);
	}
      break;
    case FEATURE:
      if (prss->nth == LEFTHAND) {
	for (jnt0 = literal->body.pst.root->lefth;
	     jnt0 != NULL; jnt0 = jnt0->nxt)
	  for (dpnd0 = jnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt) {
	    jnt1 = dpnd0->link->ptr[dpnd0->dir]->joint;
	    put_pressure(orgn,
			 dpnd0->link, dpnd0->dir, jnt1->nth, jnt1->ftr,
			 strng, dump, prss->dist+1, prss);
	  }
      } else
	for (jnt0 = literal->body.pst.val;
	     jnt0 != NULL; jnt0 = jnt0->nxt)
	  for (dpnd0 = jnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt) {
	    jnt1 = dpnd0->link->ptr[dpnd0->dir]->joint;
	    put_pressure(orgn,
			 dpnd0->link, dpnd0->dir, jnt1->nth, jnt1->ftr,
			 strng, dump, prss->dist+1, prss);
	  }
      break;
    default:
      panic("unknown type of literal (%d) (`provide_pressure')",
	    literal->tag);
      break;
    }
  }
}


void dispose_pressure_list(prss)
     press *prss;
{
  press	*temp;

  for (; prss != NULL; prss = temp) {
    temp = prss->ctrl.nxt;
    dispose_pressure(prss);
  }
}


void dispose_pressure(prss)
     press *prss;
{
  if (prss == NULL)
    return;
  if (prss->prv != NULL)
    prss->prv->nxt = prss->nxt;
  else
    prss->link->press[prss->dir] = prss->nxt;
  if (prss->nxt != NULL)
    prss->nxt->prv = prss->prv;
  if (prss->ctrl.prv != NULL)
    prss->ctrl.prv->ctrl.nxt = prss->ctrl.nxt;
  else
    prss->orgn->press = prss->ctrl.nxt;
  if (prss->ctrl.nxt != NULL)
    prss->ctrl.nxt->ctrl.prv = prss->ctrl.prv;
  FREE_press(prss);
}


void calc_pressure(val, prb)
     double *val;
     probe *prb;
{
  double maxprss, temp;
  press *prss0, *prss1;

  *val = 0.0;
  if (prb == NULL || prb->orgns == NULL)
    return;
  maxprss = 0.0;
  for (prss0 = prb->link->press[0]; prss0 != NULL; prss0 = prss0->nxt)
    for (prss1 = prb->link->press[1]; prss1 != NULL; prss1 = prss1->nxt)
      if ((prb->link->tag == EQUATION ||
	   coupled(prss0->nth, prss0->ftr, prss1->nth, prss1->ftr)) &&
	  compete(prss0->orgn, prss1->orgn)) {
	temp = prss0->strng * prss1->strng;
	if (maxprss < temp)
	  maxprss = temp;
      }
  *val = maxprss;
}


Boolean compete(ltrl1, ltrl2)
     litrlrec *ltrl1;
     litrlrec *ltrl2;
{
  jointrec *jnt;
  dependrec *dpnd;

  if (ltrl1 == NULL || ltrl2 == NULL || ltrl1 == ltrl2)
    return FALSE;
  if (ltrl1->joint == NULL || ltrl2->joint == NULL)
    return TRUE;
  for (jnt = ltrl1->joint; jnt != NULL; jnt = jnt->nxt)
    for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt)
      if ((jnt->total || dpnd->link->ptr[dpnd->dir]->joint->total) &&
	  dpnd->link->ptr[dpnd->dir]->joint->ltrl == ltrl2)
	return FALSE;
  return TRUE;
}


void check_combinatorial_contradiction()
{
  linkrec *link1, *link2;
  press *prss0, *prss1;
  jointrec *jnt;
  dependrec *dpnd;
  int valid, contra;

  for (link1 = Gcontrol.links; link1 != NULL; link1 = link2) {
    link2 = link1->ctrl.nxt;
    if (link1->tag != INFERENCE ||
	link1->press[0] == NULL || link1->press[1] == NULL ||
	link1->sub >= 1.0)
      continue;
    valid = contra = 0;
    for (prss0 = link1->press[0]; prss0 != NULL; prss0 = prss0->nxt)
      for (prss1 = link1->press[1]; prss1 != NULL; prss1 = prss1->nxt)
	if (coupled(prss0->nth, prss0->ftr, prss1->nth, prss1->ftr)) {
	  if (Gparams.option == SPEECH_RECOG) {
	    if ((prss0->orgn->tag == FEATURE &&
		 prss0->orgn->body.pst.name[0] == '!') ||
		(prss1->orgn->tag == FEATURE &&
		 prss1->orgn->body.pst.name[0] == '!'))
	      continue;
	  }
	  if (subsumable(prss0->orgn, prss1->orgn) != UNSUBSUMABLE)
	    valid++;
	  else
	    contra++;
	}
    if (valid == 0 && contra > 0) {
      if (Gparams.subsume) {
	printf("Contradiction is detected (combinatorial).\n");
	print_link(link1);
	putchar('\n');
      }
      delete_link(link1);
    }
  }
}


void check_binding_contradiction()
{
  litrlrec *ltrl0, *ltrl1;
  jointrec *jnt1, *jnt2;
  dependrec *dpnd1, *dpnd2;
  linkrec *lnk1, *lnk2;
  press *prss;

  /* First, mark all links */
  for (lnk1 = Gcontrol.links; lnk1 != NULL; lnk1 = lnk1->ctrl.nxt)
    lnk1->mark = TRUE;
  /* Second, check contradiction */
  /* (Not reachable and unified two bindings are contradict.) */
  for (ltrl0 = Gcontrol.signed_preds;
       ltrl0 != NULL; ltrl0 = ltrl0->ctrl.nxt)
    if (ltrl0->tag == FUNCTION || ltrl0->tag == FEATURE) {
      if (Gparams.option == SPEECH_RECOG) {
	if (ltrl0->tag == FEATURE && ltrl0->body.pst.name[0] == '!')
	  continue;
      }
      for (jnt1 = ltrl0->joint; jnt1 != NULL; jnt1 = jnt1->nxt)
	for (dpnd1 = jnt1->depend; dpnd1 != NULL; dpnd1 = dpnd1->nxt) {
	  lnk1 = dpnd1->link;
	  ltrl1 = lnk1->ptr[dpnd1->dir]->joint->ltrl;
	  if (ltrl0->tag == FUNCTION) {
	    for (jnt2 = ltrl0->lefth;
		 jnt2 != NULL; jnt2 = jnt2->nxt)
	      for (dpnd2 = jnt2->depend; dpnd2 != NULL; dpnd2 = dpnd2->nxt)
		for (prss = dpnd2->link->press[1-dpnd2->dir];
		     prss != NULL; prss = prss->nxt)
		  if (prss->orgn == ltrl1)
		    goto Next;
	    lnk1->mark = FALSE;
	  } else if (ltrl0->tag == FEATURE) {
	    for (jnt2 = ltrl0->body.pst.root->lefth;
		 jnt2 != NULL; jnt2 = jnt2->nxt)
	      for (dpnd2 = jnt2->depend; dpnd2 != NULL; dpnd2 = dpnd2->nxt)
		for (prss = dpnd2->link->press[1-dpnd2->dir];
		     prss != NULL; prss = prss->nxt)
		  if (prss->orgn == ltrl1)
		    goto Next;
	    lnk1->mark = FALSE;
	  }
	Next: ;
	}
    }
  /* Third, delete contradict links */
  for (lnk1 = Gcontrol.links; lnk1 != NULL; lnk1 = lnk2) {
    lnk2 = lnk1->ctrl.nxt;
    if (lnk1->sub >= 1.0 && !lnk1->mark) {
      if (Gparams.subsume) {
	printf("Contradiction is detected (binding).\n");
	print_link(lnk1);
	putchar('\n');
      }
      delete_link(lnk1);
    }
  }
}
