/*
 	(C)1993 Institute for New Generation Computer Technology
 	Read COPYRIGHT for detailed information.


	CHANGE NOTES (programmed by MIYATA Takashi)

	1992.03 (version 1.0) :
		* Implement Symbolic inference (fold/unfold translation).
		* Implement Dynamics (normalization,disjunction,exclusion,
		completion,assimilation,transitivity).
		* Implement visualization routines.
	1992.07 (version 1.1) :
		* Check and refine every program for IFS (ICOT Free Software)
		release.
	1992.07 (version 1.2) :
		* Implement graphical user interface.
	1992.09 (version 1.3) :
		* Implement generalized backpropagation routines.
	1992.10 (version 1.4) :
		* Implement additional function for simulation of
		speech recognition.
	1993.02 (version 1.5) :
	        * Bug fix and improve graphical interface.
	1993.11 (version 1.56):
		* Check and refine every program for IFS (ICOT Free Software)
		release.
*/

/*
 *	main.c	---	Main program and initializations.
 *
 */

#include	<stdio.h>

#define	PROTO_MAIN_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_MAIN_C

#pragma segment	command


int main(argc, argv)
     int argc;
     char *argv[];
{
  char *fname;

  /* ========== Initializations ========== */
  init_globals();
  INIT_parser_mem();
  INIT_main_mem();
  Gparams.appname = argv[0];
  strcpy(Gparams.fname, "");
  print_version();
  if (Initialize(&argc, argv)) {
    fname = CheckArguments(argc, argv);
    if (fname[0] != '\0') {
      strcpy(Gparams.fname, fname);
      if (load_program(FALSE))
	generate_probes();
    }
    DoWindowEventLoop();
  } else {
    fname = CheckArguments(argc, argv);
    if (fname[0] != '\0') {
      strcpy(Gparams.fname, fname);
      if (load_program(FALSE))
	generate_probes();
    }
    DoTextEventLoop();
  }
  return 0;
}


void DoTextEventLoop()
{
  char buff[BUFFSIZE];

  /* ========== Main Loop ========== */
  do {
    printf("%s> ",
	   (Gparams.state == PREPARING ? "PREPARING" :
	    (Gparams.state == STOPPED ? "STOPPED" :
	     (Gparams.state == FINISHED ? "FINISHED" :
	      (Gparams.state == UNCONVERGED ? "NOT-CONVERGED" : "ABORTED")))));
    gets(buff);
  } while (ProcessCommand(buff, FALSE) == TRUE);
}


char *CheckArguments(argc, argv)
     int argc;
     char *argv[];
{
  int itemp;
  double dtemp;

  while (argc > 1 && argv[1] != NULL) {
    if (strcmp(argv[1], "+SUBSUME") == 0 ||
	strcmp(argv[1], "+subsume") == 0)
      Gparams.subsume = TRUE;
    else if (strcmp(argv[1], "+DELETE") == 0 ||
	     strcmp(argv[1], "+delete") == 0)
      Gparams.delete = TRUE;
    else if (strcmp(argv[1], "+COPY") == 0 ||
	     strcmp(argv[1], "+copy") == 0)
      Gparams.copy = TRUE;
    else if (strcmp(argv[1], "+FIXACT") == 0 ||
	     strcmp(argv[1], "+fixact") == 0)
      Gparams.fixact = TRUE;
    else if (strcmp(argv[1], "-DISJ") == 0)
      Gparams.disjSW = FALSE;
    else if (strcmp(argv[1], "-EXCL") == 0)
      Gparams.exclSW = FALSE;
    else if (strcmp(argv[1], "-CMPL") == 0)
      Gparams.cmplSW = FALSE;
    else if (strcmp(argv[1], "-ASSM") == 0)
      Gparams.assmSW = FALSE;
    else if (strcmp(argv[1], "-EQLZ") == 0)
      Gparams.eqlzSW = FALSE;
    else if (strcmp(argv[1], "-TRNS") == 0)
      Gparams.trnsSW = FALSE;
    else if (strcmp(argv[1], "-DPND") == 0)
      Gparams.psdoSW = FALSE;
    else if (strcmp(argv[1], "-itrmax") == 0) {
      sscanf(argv[2], "%d", &itemp);
      if (0 < itemp)
	Gparams.itrmax = itemp;
      else
	printf("Out of range. (0 < itrmax)\n");
      argc--, argv++;
    } else if (strcmp(argv[1], "-trace") == 0) {
      sscanf(argv[2], "%d", &itemp);
      if (NOT_BREAK <= itemp && itemp <= EACH_STEP)
	Gparams.trace = itemp;
      else
	printf("Out of range. (%d <= trace <= %d)\n",
	       NOT_BREAK, EACH_STEP);
      argc--, argv++;
    } else if (strcmp(argv[1], "-disj") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.trnsWT = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-excl") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.exclWT = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-cmpl") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.cmplWT = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-assm") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.assmWT = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-eqlz") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.eqlzWT = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-trns") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.trnsWT = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-dpnd") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.psdoWT = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-tmprtr") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.tmprtr = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-theta") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.theta = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-subsTH") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.subsTH = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-actTH") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.actTH = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-epsilon") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.epsilon = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-strng") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.ssub = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-weak") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.wsub = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-atmp") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.atmp = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-stmp") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.stmp = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-sfREL") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.sframeREL = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-efREL") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.eframeREL = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-tmREL") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.timeREL = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-phREL") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.phonemeREL = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-frDISJ") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.frameDISJ = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-frEXCL") == 0) {
      sscanf(argv[2], "%lf", &dtemp);
      Gparams.frameEXCL = dtemp;
      argc--, argv++;
    } else if (strcmp(argv[1], "-lfile") == 0) {
      init_hmm(argv[2]);
      Gparams.option = SPEECH_RECOG;
      argc--, argv++;
    } else if (argv[1][0] == '-') {
      printf("unknown option `%s'...\n\n", argv[1]);
      usage();
      exit(1);
    } else
      return argv[1];
    argc--, argv++;
  }
  return "";
}


void init_globals()
{
  Gbuffer.top = FALSE;
  Gbuffer.literals = NULL;
  Gbuffer.variables = NULL;
  Gbuffer.constants = NULL;

  Gcontrol.signed_preds = NULL;
  Gcontrol.unsigned_preds = NULL;
  Gcontrol.links = NULL;
  Gcontrol.probes = NULL;
  Gcontrol.lid = 0;
  Gcontrol.candidate.c = 0;
  Gcontrol.candidate.link = NULL;
  Gcontrol.candidate.dir = -1;
  Gcontrol.candidate.probe = NULL;

  Gparams.state = PREPARING;
  Gparams.option = NONE;

  Gparams.subsume = FALSE;
  Gparams.delete = FALSE;
  Gparams.copy = FALSE;
  Gparams.disjSW = TRUE;
  Gparams.exclSW = TRUE;
  Gparams.cmplSW = TRUE;
  Gparams.assmSW = TRUE;
  Gparams.eqlzSW = TRUE;
  Gparams.trnsSW = TRUE;
  Gparams.psdoSW = TRUE;
  Gparams.fixact = FALSE;
  Gparams.manual = FALSE;

  Gparams.copiedp = FALSE;
  Gparams.deletedp = FALSE;
  Gparams.cnvrgdp = FALSE;

  Gparams.trace = DELETION | COPYING | UNCONVRG;
  Gparams.itrmax = 50;
  Gparams.disjWT = 1.0;
  Gparams.exclWT = 1.0;
  Gparams.cmplWT = 1.0;
  Gparams.assmWT = 1.0;
  Gparams.eqlzWT = 1.0;
  Gparams.trnsWT = 1.0;
  Gparams.psdoWT = 1.0;
  Gparams.tmprtr = 0.7;
  Gparams.theta = 0.49;
  Gparams.subsTH = 1.0e-9;
  Gparams.actTH = 0.07;
  Gparams.epsilon = 1.0e-7;
  Gparams.ssub = STRNG_SUBS_DEFAULT;
  Gparams.wsub = WEAK_SUBS_DEFAULT;
  Gparams.atmp = 1.0;
  Gparams.stmp = 0.6;

  Gparams.sframeREL = S_FRAME_REL_DEFAULT;
  Gparams.eframeREL = E_FRAME_REL_DEFAULT;
  Gparams.timeREL = TIME_REL_DEFAULT;
  Gparams.phonemeREL = PHONEME_REL_DEFAULT;
  Gparams.frameDISJ = FRAME_DISJ_DEFAULT;
  Gparams.frameEXCL = FRAME_EXCL_DEFAULT;

}


void usage()
{
  printf("usage:  %s [window-options] [switches] [parameters] [filename]\n",
	 Gparams.appname);
  printf("\t-h  : Prints usage (this)\n");
  printf("  window-options\n");
  printf("\t-nw                   : No window\n");
  printf("\t-display host:display : Specifies the host and screen\n");
  printf("\t-geometry geometry    : Specifies geometry of the window\n");
  printf("  switches\n");
  printf("\t+SUBSUME : Notifies sort of subsumption\n");
  printf("\t+DELETE  : Notifies literal-deletion\n");
  printf("\t+COPY    : Notifies literal-copy\n");
  printf("\t-DISJ    : Turns off disjunction energy\n");
  printf("\t-EXCL    : Turns off exclusion energy\n");
  printf("\t-CMPL    : Turns off completion energy\n");
  printf("\t-ASSM    : Turns off assimilation energy\n");
  printf("\t-EQLZ    : Turns off equalization energy\n");
  printf("\t-TRNS    : Turns off transitivity energy\n");
  printf("\t-DPND    : Turns off dependency energy\n");
  printf("  parameters\n");
  printf("\t-itrmax #  : Specifies max # of iterations\n");
  printf("\t-trace  #  : Specifies trace-level\n");
  printf("\t-disj disj : Specifies weight of disjunction energy\n");
  printf("\t-excl excl : Specifies weight of exclusion energy\n");
  printf("\t-cmpl cmpl : Specifies weight of completion energy\n");
  printf("\t-assm assm : Specifies weight of assimilation energy\n");
  printf("\t-eqlz eqlz : Specifies weight of equalization energy\n");
  printf("\t-trns trns : Specifies weight of transitivity energy\n");
  printf("\t-dpnd dpnd : Specifies weight of dependency energy\n");
  printf("\t-tmprtr  tmprtr    : Specifies degree of temperature\n");
  printf("\t-theta   theta     : Specifies threashold of transitivity energy\n");
  printf("\t-subsTH  threshold : Specifies threshold of invoking subsumption\n");
  printf("\t-actTH   threshold : Specifies threshold of invoking action\n");
  printf("\t-epsilon epsilon   : Specifies convergence criterion\n");
  printf("\t-strng   value     : Specifies the initial values of strong links\n");
  printf("\t-weak    value     : Specifies the initial values of weak links\n");
  printf("\t-atmp    value     : Specifies the atomic constraint`s temperature\n");
  printf("\t-stmp    value     : Specifies the sigmoid function's temperature\n");
  printf("  used only in simulation of speech-recognition\n");
  printf("\t-sfREL   value     : Specifies rel. coeff. of start framing literal\n");
  printf("\t-efREL   value     : Specifies rel. coeff. of end framing literal\n");
  printf("\t-tmREL   value     : Specifies rel. coeff. of timing literal\n");
  printf("\t-phREL   value     : Specifies rel. coeff. of phoneme literal\n");
  printf("\t-frDISJ  value     : Specifies disjunction coeff. of new clauses\n");
  printf("\t-frEXCL  value     : Specifies exclusion coeff. of new clauses\n");
  printf("\t-lfile   file-name : Specifies the name of lattice-file\n");
}


void print_version()
{
  putchar('\n');
  printf("=== Dynamical Constraint Programming Prototype System ===\n");
  printf("====== Version 1.56 (Thu Nov 18 10:34:01 JST 1993) ======\n\n");
}


void panic(fmt, n)
     char *fmt;
     int n;
{
  printf("\nPanic!: ");
  printf(fmt, n);
  putchar('\n');
  while (1);
  exit(1);
}
