/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	info.c	---	Clause-printing subroutines.
 *
 */

#include	<stdio.h>

#define	PROTO_INFO_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_INFO_C

#pragma segment	subsume


#define	CAT(str)	strcat(buffer, (str))


void CreateLiteralText(buffer, literal)
     char *buffer;
     litrlrec *literal;
{
  litrlrec *ftr;
  jointrec *jnt;
  dependrec *dpnd;
  char temp[BUFFSIZE], *val;

  if (literal->pol == POSITIVE || literal->pol == COST_POSITIVE)
    CAT("+");
  else if (literal->pol == NEGATIVE || literal->pol == COST_NEGATIVE)
    CAT("-");
  switch (literal->tag) {
  case SYMBOL :
    CAT(literal->print.varname);
    CAT("=");
    CAT(literal->body.sym);
    break;
  case NUMBER:
    CAT(literal->print.varname);
    CAT("=");
    sprintf(temp, "%d", literal->body.num);
    CAT(temp);
    break;
  case FUNCTION:
    CAT(literal->print.varname);
    CAT("=");
    if (strcmp(literal->body.afm.name, CONS_NAME) == 0) {
      CAT("[");
      CAT(argument_str(literal->body.afm.arg[0].body.val,
		       literal->body.afm.arg[0].body.print.varname,
		       &literal->body.afm.arg[0].body.print.embedded));
      CAT("|");
      CAT(argument_str(literal->body.afm.arg[1].body.val,
		       literal->body.afm.arg[1].body.print.varname,
		       &literal->body.afm.arg[1].body.print.embedded));
      CAT("]");
    } else {
      CAT(literal->body.afm.name);
      CatenateArgPart(buffer, literal);
    }
    break;
  case CONSTRAINT:
    CAT(literal->body.afm.name);
    CatenateArgPart(buffer, literal);
    break;
  case PSTERM:
    CAT(literal->print.varname);
    CAT("={");
    for (ftr = literal->body.pst.nxt; ftr != NULL;
	 ftr = ftr->body.pst.nxt) {
      CAT(ftr->body.pst.name);
      CAT("/");
      CAT(argument_str(ftr->body.pst.val,
		       ftr->body.pst.print.varname,
		       &ftr->body.pst.print.embedded));
      if (ftr->body.pst.nxt != NULL)
	CAT(",");
    }
    CAT("}");
    break;
  case FEATURE:
    sprintf(temp, "#%s(%s)=",
	    literal->body.pst.name,
	    literal->print.varname);
    CAT(temp);
    CAT(argument_str(literal->body.pst.val,
		     literal->body.pst.print.varname,
		     &literal->body.pst.print.embedded));
    break;
  }
  if (literal->pol == COST_POSITIVE || literal->pol == COST_NEGATIVE)
    CAT("$");
}


void CatenateArgPart(buffer, literal)
     char *buffer;
     litrlrec *literal;
{
  int i;

  CAT("(");
  for (i = 0; i < literal->body.afm.arity; i++) {
    CAT(argument_str(literal->body.afm.arg[i].body.val,
		     literal->body.afm.arg[i].body.print.varname,
		     &literal->body.afm.arg[i].body.print.embedded));
    if (i < literal->body.afm.arity-1)
      CAT(",");
  }
  CAT(")");
}


char *argument_str(value, varname, embedded)
     jointrec *value;
     char *varname;
     int *embedded;
{
  litrlrec *constltrl;
  jointrec *jnt;
  dependrec *dpnd;
  static char buff[BUFFSIZE];

  if (value == NULL)
    return "_";
  else
    for (jnt = value; jnt != NULL; jnt = jnt->nxt) {
      dpnd = jnt->depend;
      if (dpnd->link->coeff[0].body.act < 1.0)
	break;
      else if (dpnd->link->ptr[dpnd->dir]->joint->nth == LEFTHAND) {
	/* if the act. value is fixed, embed arg. */
	constltrl = dpnd->link->ptr[dpnd->dir]->joint->ltrl;
	if (constltrl->tag == SYMBOL) {
	  constltrl->mark = MARKED;
	  *embedded = TRUE;
	  return constltrl->body.sym;
	} else if (constltrl->tag == NUMBER) {
	  constltrl->mark = MARKED;
	  *embedded = TRUE;
	  sprintf(buff, "%d", constltrl->body.num);
	  return buff;
	}
      }
    }
  return varname;
}


Boolean CreateEquationsText(buffer, literal)
     char *buffer;
     litrlrec *literal;
{
  int i;
  Boolean created = FALSE;
  dependrec *dpnd0;
  jointrec *j0, *j1;
  litrlrec *ftr;
  char *temp;

  if (literal->tag == SYMBOL || literal->tag == NUMBER)
    return FALSE;
  switch (literal->tag) {
  case FUNCTION:
  case CONSTRAINT:
    for (i = 0; i < literal->body.afm.arity; i++) {
      if (literal->body.afm.arg[i].body.print.embedded)
	continue;
      /* if there is no connection to constant,
	 check if equation should be displayed explicit */
      for (j0 = literal->body.afm.arg[i].body.val; j0 != NULL; j0 = j0->nxt) {
	dpnd0 = j0->depend;
	j1 = dpnd0->link->ptr[dpnd0->dir]->joint;
	if (dpnd0->link->explct && dpnd0->link->mark == FALSE) {
	  temp = equation_text_aux(literal->body.afm.arg[i].body.print.varname, j1);
	  dpnd0->link->mark = TRUE;
	  CAT(temp);
	  created = TRUE;
	}
      }
    }
    break;
  case PSTERM:
    for (ftr = literal->body.pst.nxt;
	 ftr != NULL; ftr = ftr->body.pst.nxt) {
      if (ftr->body.pst.print.embedded)
	continue;
      /* if there is no connection to constant,
	 check if equation should be displayed explicit */
      for (j0 = ftr->body.pst.val; j0 != NULL; j0 = j0->nxt) {
	dpnd0 = j0->depend;
	j1 = dpnd0->link->ptr[dpnd0->dir]->joint;
	if (dpnd0->link->explct && dpnd0->link->mark == FALSE) {
	  temp = equation_text_aux(ftr->body.pst.print.varname, j1);
	  dpnd0->link->mark = TRUE;
	  CAT(temp);
	  created = TRUE;
	}
      }
    }
    break;
  case FEATURE:
    if (literal->body.pst.print.embedded)
      break;
    /* if there is no connection to constant,
       check if equation should be displayed explicit */
    for (j0 = literal->body.pst.val; j0 != NULL; j0 = j0->nxt) {
      dpnd0 = j0->depend;
      j1 = dpnd0->link->ptr[dpnd0->dir]->joint;
      if (dpnd0->link->explct && dpnd0->link->mark == FALSE) {
	temp = equation_text_aux(literal->body.pst.print.varname, j1);
	dpnd0->link->mark = TRUE;
	CAT(temp);
	created = TRUE;
      }
    }
    break;
  }
  return created;
}


char *equation_text_aux(left, rjnt)
     char *left;
     jointrec *rjnt;
{
  char *v;
  static char buff[BUFFSIZE];

  switch (rjnt->nth) {
  case LEFTHAND:
    v = rjnt->ltrl->print.varname; break;
  case PSTENTRY:
    v = rjnt->ltrl->body.pst.print.varname; break;
  default:
    v = rjnt->ltrl->body.afm.arg[rjnt->nth].body.print.varname; break;
  }
  sprintf(buff, "-%s==%s ", left, v);
  return buff;
}


int SetLiteralInformation(text, ltrl)
     char text[COLUMNS][ROWS];
     litrlrec *ltrl;
{
  int l = 0;
  double disj1, disj2, disjD, excl1, excl2, exclD;
  double assm1, assm2, assmD, cmpl1, cmpl2, cmplD;
  double psdo, imin, imax;
  jointrec *jnt;
  dependrec *dpnd;
  press *prss;
  char temp[BUFFSIZE];

  switch (ltrl->tag) {
  case SYMBOL:
    sprintf(text[l++], "type:  SYMBOL (%s)", ltrl->body.sym);
    strcpy(text[l++], " ");
    break;
  case NUMBER:
    sprintf(text[l++], "type:  NUMBER (%d)", ltrl->body.num);
    strcpy(text[l++], " ");
    break;
  case PSTERM:
    sprintf(text[l++], "type:  PS-TERM");
    strcpy(text[l++], " ");
    break;
  case FEATURE:
    sprintf(text[l++], "type:  FEATURE (%s)", ltrl->body.pst.name);
    strcpy(text[l++], " ");
    break;
  case FUNCTION:
    sprintf(text[l++], "type: FUNCTION");
    sprintf(text[l++], "      (name=%s,arity=%d)",
	    ltrl->body.afm.name, ltrl->body.afm.arity);
    break;
  case CONSTRAINT:
    sprintf(text[l++], "type: CONSTRAINT");
    sprintf(text[l++], "      (name=%s,arity=%d)",
	    ltrl->body.afm.name, ltrl->body.afm.arity);
    break;
  default:
    break;
  }
  sprintf(text[l++], "polarity: %c %s",
	  (ltrl->pol == POSITIVE || ltrl->pol == COST_POSITIVE ? '+' :
	   (ltrl->pol == NEGATIVE || ltrl->pol == COST_NEGATIVE ?
	    '-' : 'u')),
	  (ltrl->pol == COST_POSITIVE || ltrl->pol == COST_NEGATIVE ?
	   "(cost)" : ""));
  if (ltrl->tag == CONSTRAINT && ltrl->body.afm.name[0] == '@') {
    sprintf(text[l++], "candidate actions:");
    for (jnt = ltrl->body.afm.arg[0].body.val; jnt != NULL; jnt = jnt->nxt)
      for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt)
	for (prss = dpnd->link->press[1-dpnd->dir];
	     prss != NULL; prss = prss->nxt)
	  if (l < ROWS - 15) { /* 15 lines follows... */
	    if (prss->orgn->vnode != NULL)
	      sprintf(text[l++], "   %s<%d> : %14.11lf",
		      prss->orgn->vnode->title, prss->orgn->lid,
		      prss->orgn->imp);
	    else if (prss->orgn->tag == SYMBOL)
	      sprintf(text[l++], "   %s<%d> (SYMBOL) : %14.11lf",
		      prss->orgn->body.sym, prss->orgn->lid,
		      prss->orgn->imp);
	    else if (prss->orgn->tag == NUMBER)
	      sprintf(text[l++], "   %d<%d> (NUMBER) : %14.11lf",
		      prss->orgn->body.num, prss->orgn->lid,
		      prss->orgn->imp);
	    else {
	      temp[0] = '\0';
	      CreateLiteralText(temp, prss->orgn);
	      sprintf(text[l++], "   %s<%d> : %14.11lf",
		      temp, prss->orgn->lid,
		      prss->orgn->imp);
	    }
	  } else {
	    sprintf(text[l++], "   ...");
	    goto Break;
	  }
  Break:
    sprintf(text[l++], " ");
  }
  sprintf(text[l++], "relevance coeff.   : %14.11lf", ltrl->rel);
  sprintf(text[l++], "disjunction coeff. : %14.11lf", ltrl->coeff.disj);
  sprintf(text[l++], "exclusion coeff.   : %14.11lf", ltrl->coeff.excl);
  sprintf(text[l++], "completion coeff.  : %14.11lf", ltrl->coeff.cmpl);
  sprintf(text[l++], "assimulation coeff.: %14.11lf", ltrl->coeff.assm);
  sprintf(text[l++], " ");
  sprintf(text[l++], "activation value   : %14.11lf", ltrl->act);
  sprintf(text[l++], "dP/ds' (importance): %14.11lf", ltrl->imp);
  sprintf(text[l++], "z value            : %14.11lf", ltrl->z);
  sprintf(text[l++], " ");
  if (ltrl->pphndl != NULL && ltrl->pphndl->begin != NULL) {
    calc_clausal_forces(ltrl->pphndl->begin, ltrl->pphndl,
			&disj1, &excl1, &disjD, &exclD);
    calc_clausal_estimations(ltrl->pphndl->begin, ltrl->pphndl,
			     &disj2, &excl2);
 } else {
    disj1 = excl1 = 0.0;
    disj2 = excl2 = 0.0;
  }
  calc_literal_forces(ltrl, &assm1, &cmpl1, &assmD, &cmplD, &imin, &imax);
  calc_literal_estimations(ltrl, &assm2, &cmpl2, &psdo);
  sprintf(text[l++], "      Disj  :  Excl  :  Assm  :  Cmpl  :  Dpnd");
  sprintf(text[l++], "act:%7.4lf :%7.4lf :%7.4lf :%7.4lf :%7.4lf",
	  -Gparams.disjWT * disj1, -Gparams.exclWT * excl1,
	  -Gparams.assmWT * assm1, -Gparams.cmplWT * cmpl1,
	  Gparams.psdoWT * ltrl->dfrc);
  sprintf(text[l++], " z :%7.4lf :%7.4lf :%7.4lf :%7.4lf :%7.4lf",
	  Gparams.disjWT * disj2, Gparams.exclWT * excl2,
	  Gparams.assmWT * assm2, Gparams.cmplWT * cmpl2,
	  -Gparams.psdoWT * psdo);
  text[l][0] = '\0';
  return l;
}


int SetLinkInformation(text, lnk, dir)
     char text[COLUMNS][ROWS];
     linkrec *lnk;
     int dir;
{
  int l = 0, j;
  double assm, assmD, eqlz, eqlzD, trns, trnsD, dpnd, dpndD;
  litrlrec *ltrl0, *ltrl1;
  probe *prb;
  litrllst *orgn;
  press *prss;
  char temp[BUFFSIZE];

  switch (lnk->tag) {
  case EQUATION:
    sprintf(text[l++], "type: EQUATION");
    break;
  case INFERENCE:
    sprintf(text[l++], "type: INFERENCE");
    break;
  }
  ltrl0 = lnk->ptr[1-dir]->joint->ltrl;
  ltrl1 = lnk->ptr[dir]->joint->ltrl;
  if (ltrl0->vnode != NULL)
    sprintf(text[l++], "joint [0]: %s   %s<%d>",
	    (lnk->ptr[0]->joint->total ? " total " : "partial"),
	    ltrl0->vnode->title, ltrl0->lid);
  else {
    temp[0] = '\0';
    CreateLiteralText(temp, ltrl0);
    sprintf(text[l++], "joint [0]: %s   %s<%d>",
	    (lnk->ptr[0]->joint->total ? " total " : "partial"),
	    temp, ltrl0->lid);
  }
  if (ltrl1->vnode != NULL)
    sprintf(text[l++], "joint [1]: %s   %s<%d>",
	    (lnk->ptr[1]->joint->total ? " total " : "partial"),
	    ltrl1->vnode->title, ltrl1->lid);
  else {
    temp[0] = '\0';
    CreateLiteralText(temp, ltrl0);
    sprintf(text[l++], "joint [1]: %s   %s<%d>",
	    (lnk->ptr[1]->joint->total ? " total " : "partial"),
	    temp, ltrl1->lid);
  }
  sprintf(text[l++], "subsumption coefficient: %14.11lf", lnk->sub);
  if (Gparams.option == SPEECH_RECOG)
    sprintf(text[l++], "matching probability : %14.11lf", lnk->confuse);
  sprintf(text[l++], "        dP / ds        : %14.11lf", lnk->dsub);
  sprintf(text[l++], " ");
  sprintf(text[l++], "origins of probes [0]=>[1]:");
  for (j = 0; j < lnk->n; j++)
    if (l < ROWS - lnk->n*2 - 10) { /* at least lnk->n*2+10 lines follows... */
      for (prb = lnk->probe[1]; prb != NULL; prb = prb->nxt)
	if (prb->nth == j) {
	  for (orgn = prb->orgns; orgn != NULL; orgn = orgn->nxt)
	    if (orgn->handle->body.ltrl == NULL)
	      sprintf(text[l++], "  [%2d]:   ## missing ##", j);
	    else if (orgn->handle->body.ltrl->vnode != NULL)
	      sprintf(text[l++], "  [%2d]:   %s<%d>",
		      j,
		      orgn->handle->body.ltrl->vnode->title,
		      orgn->handle->body.ltrl->lid);
	    else if (orgn->handle->body.ltrl->tag == SYMBOL)
	      sprintf(text[l++], "  [%2d]:   %s<%d> (SYMBOL)",
		      j,
		      orgn->handle->body.ltrl->body.sym,
		      orgn->handle->body.ltrl->lid);
	    else if (orgn->handle->body.ltrl->tag == NUMBER)
	      sprintf(text[l++], "  [%2d]:   %d<%d> (NUMBER)",
		      j,
		      orgn->handle->body.ltrl->body.num,
		      orgn->handle->body.ltrl->lid);
	    else {
	      temp[0] = '\0';
	      CreateLiteralText(temp, orgn->handle->body.ltrl);
	      sprintf(text[l++], "  [%2d]:   %s<%d>",
		      j, temp, orgn->handle->body.ltrl->lid);
	    }
	}
    } else {
      sprintf(text[l++], "  ...");
      goto Break1;
    }
 Break1:
  sprintf(text[l++], "origins of probes [1]=>[0]:");
  for (j = 0; j < lnk->n; j++)
    for (prb = lnk->probe[0]; prb != NULL; prb = prb->nxt)
      if (l < ROWS - lnk->n*2 - 9) { /* at least lnk->n*2+9 lines follows... */
	if (prb->nth == j) {
	  for (orgn = prb->orgns; orgn != NULL; orgn = orgn->nxt)
	    if (orgn->handle->body.ltrl == NULL)
	      sprintf(text[l++], "  [%2d]:   ## missing ##", j);
	    else if (orgn->handle->body.ltrl->vnode != NULL)
	      sprintf(text[l++], "  [%2d]:   %s<%d>",
		      j,
		      orgn->handle->body.ltrl->vnode->title,
		      orgn->handle->body.ltrl->lid);
	    else if (orgn->handle->body.ltrl->tag == SYMBOL)
	      sprintf(text[l++], "  [%2d]:   %s<%d> (SYMBOL)",
		      j,
		      orgn->handle->body.ltrl->body.sym,
		      orgn->handle->body.ltrl->lid);
	    else if (orgn->handle->body.ltrl->tag == NUMBER)
	      sprintf(text[l++], "  [%2d]:   %d<%d> (NUMBER)",
		      j,
		      orgn->handle->body.ltrl->body.num,
		      orgn->handle->body.ltrl->lid);
	    else {
	      temp[0] = '\0';
	      CreateLiteralText(temp, orgn->handle->body.ltrl);
	      sprintf(text[l++], "  [%2d]:   %s<%d>",
		      j, temp, orgn->handle->body.ltrl->lid);
	    }
	}
      } else {
	sprintf(text[l++], "  ...");
	goto Break2;
      }
 Break2:
  sprintf(text[l++], "origins of pressures [0]=>[1]:");
  for (j = 0; j < lnk->n; j++)
    for (prss = lnk->press[1]; prss != NULL; prss = prss->nxt)
      if (l < ROWS - lnk->n*2 - 8) { /* at least lnk->n*2+8 lines follows... */
	if (prss->nth == j) {
	  if (prss->orgn->vnode != NULL)
	    sprintf(text[l++], "  [%2d]:   %s<%d>",
		    j, prss->orgn->vnode->title, prss->orgn->lid);
	  else if (prss->orgn->tag == SYMBOL)
	    sprintf(text[l++], "  [%2d]:   %s<%d> (SYMBOL)",
		    j, prss->orgn->body.sym, prss->orgn->lid);
	  else if (prss->orgn->tag == NUMBER)
	    sprintf(text[l++], "  [%2d]:   %d<%d> (NUMBER)",
		    j, prss->orgn->body.num, prss->orgn->lid);
	  else {
	    temp[0] = '\0';
	    CreateLiteralText(temp, prss->orgn);
	    sprintf(text[l++], "  [%2d]:   %s<%d>",
		    j, temp, prss->orgn->lid);
	  }
	}
      } else {
	sprintf(text[l++], "  ...");
	goto Break3;
      }
 Break3:
  sprintf(text[l++], "origins of pressures [1]=>[0]:");
  for (j = 0; j < lnk->n; j++)
    for (prss = lnk->press[0]; prss != NULL; prss = prss->nxt)
      if (l < ROWS - lnk->n*2 - 7) { /* at least lnk->n*2+7 lines follows... */
	if (prss->nth == j) {
	  if (prss->orgn->vnode != NULL)
	    sprintf(text[l++], "  [%2d]:   %s<%d>",
		    j, prss->orgn->vnode->title, prss->orgn->lid);
	  else if (prss->orgn->tag == SYMBOL)
	    sprintf(text[l++], "  [%2d]:   %s<%d> (SYMBOL)",
		    j, prss->orgn->body.sym, prss->orgn->lid);
	  else if (prss->orgn->tag == NUMBER)
	    sprintf(text[l++], "  [%2d]:   %d<%d> (NUMBER)",
		    j, prss->orgn->body.num, prss->orgn->lid);
	  else {
	    temp[0] = '\0';
	    CreateLiteralText(temp, prss->orgn);
	    sprintf(text[l++], "  [%2d]:   %s<%d>",
		    j, temp, prss->orgn->lid);
	  }
	}
      } else {
	sprintf(text[l++], "  ...");
	goto Break4;
      }
 Break4:
  sprintf(text[l++], " ");
  sprintf(text[l++], " nth:  act.v  :   Assm  :   Eqlz  :   Trns");
  for (j = 0; j < lnk->n; j++) {
    if (lnk->coeff[j].body.act < 1.0)
      calc_link_forces(lnk, j,
		       &assm, &eqlz, &trns, &dpnd,
		       &assmD, &eqlzD, &trnsD, &dpndD);
    else
      assm = eqlz = trns = dpnd = 0.0;
    if (j == lnk->n-1 && ltrl0->tag != CONSTRAINT)
      sprintf(text[l++], "[LH]: %7.4lf : %7.4lf : %7.4lf : %7.4lf",
	      lnk->coeff[j].body.act,
	      -Gparams.assmWT * assm,
	      -Gparams.eqlzWT * eqlz,
	      -Gparams.trnsWT * trns);
    else
      sprintf(text[l++], "[%2d]: %7.4lf : %7.4lf : %7.4lf : %7.4lf",
	      j, lnk->coeff[j].body.act,
	      -Gparams.assmWT * assm,
	      -Gparams.eqlzWT * eqlz,
	      -Gparams.trnsWT * trns);
  }
  sprintf(text[l++], " ");
  sprintf(text[l++], " nth:    z    :   Assm  :   Eqlz  :   Trns");
  for (j = 0; j < lnk->n; j++) {
    if (lnk->coeff[j].body.z < 1.0)
      calc_link_estimations(lnk, j, &assm, &eqlz, &trns, &dpnd);
    else
      assm = eqlz = trns = dpnd = 0.0;
    if (j == lnk->n-1 && ltrl0->tag != CONSTRAINT)
      sprintf(text[l++], "[LH]: %7.4lf : %7.4lf : %7.4lf : %7.4lf",
	      lnk->coeff[j].body.z,
	      Gparams.assmWT * assm,
	      Gparams.eqlzWT * eqlz,
	      Gparams.trnsWT * trns);
    else
      sprintf(text[l++], "[%2d]: %7.4lf : %7.4lf : %7.4lf : %7.4lf",
	      j, lnk->coeff[j].body.z,
	      Gparams.assmWT * assm,
	      Gparams.eqlzWT * eqlz,
	      Gparams.trnsWT * trns);
  }
  text[l][0] = '\0';
  return l;
}


int SetStatus(text)
     char text[COLUMNS][ROWS];
{
  int l = 0;

  sprintf(text[l++], "System          : %s", Gparams.appname);
  sprintf(text[l++], "Current program : %s", Gparams.fname);
  sprintf(text[l++], "Current status  : %s",
	  (Gparams.state == PREPARING ? "PREPARING" :
	   (Gparams.state == STOPPED ? "STOPPED" :
	    (Gparams.state == FINISHED ? "FINISHED" :
	     (Gparams.state == UNCONVERGED ? "NOT-CONVERGED" :
	      "ABORTED")))));
  sprintf(text[l++], "Options:");
  sprintf(text[l++],
	  "   subsume : %s   (Display what kind of subsumption occurred)",
	  (Gparams.subsume ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   delete  : %s   (Notify each literal-deletion)",
	  (Gparams.delete ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   copy    : %s   (Notify each literal-copy)",
	  (Gparams.copy ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   fixact  : %s   (fix act. value to 1 after subsumption)",
	  (Gparams.fixact ? "ON " : "OFF"));
  sprintf(text[l++], "Parameters:");
  sprintf(text[l++],
	  "   disj    : %8.5lf   %s   (Weight of disjunction energy)",
	  Gparams.disjWT, (Gparams.disjSW ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   excl    : %8.5lf   %s   (Weight of exclusion energy)",
	  Gparams.exclWT, (Gparams.exclSW ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   cmpl    : %8.5lf   %s   (Weight of completion energy)",
	  Gparams.cmplWT, (Gparams.cmplSW ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   assm    : %8.5lf   %s   (Weight of assimilation energy)",
	  Gparams.assmWT, (Gparams.assmSW ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   eqlz    : %8.5lf   %s   (Weight of equalization energy)",
	  Gparams.eqlzWT, (Gparams.eqlzSW ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   trns    : %8.5lf   %s   (Weight of transitive energy)",
	  Gparams.trnsWT, (Gparams.trnsSW ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   dpnd    : %8.5lf   %s   (Weight of dependency energy)",
	  Gparams.psdoWT, (Gparams.psdoSW ? "ON " : "OFF"));
  sprintf(text[l++],
	  "   trace   : %8d   (trace-level)", Gparams.trace);
  sprintf(text[l++],
	  "             [0:no break, 1:deletion, 2:copying]");
  sprintf(text[l++],
	  "             [4:when not converging,  8:break at each step]");
  sprintf(text[l++],
	  "   itrmax  : %8d   (Maximum # of iteration)",
	  Gparams.itrmax);
  sprintf(text[l++],
	  "   tmprtr  : %8.5lf   (Temperature)",
	  Gparams.tmprtr);
  sprintf(text[l++],
	  "   atmp    : %8.5lf   (Temperature of the atomic constraints)",
	  Gparams.atmp);
  sprintf(text[l++],
	  "   stmp    : %8.5lf   (Temperature of the sigmoid function)",
	  Gparams.stmp);
  sprintf(text[l++],
	  "   theta   : %8.5lf   (Threshold of transitive energy)",
	  Gparams.theta);
  sprintf(text[l++],
	  "   subsTH  : %4.2e   (Threshold of invoking subsumption)",
	  Gparams.subsTH);
  sprintf(text[l++],
	  "   actTH   : %4.2e   (Threshold of invoking action)",
	  Gparams.actTH);
  sprintf(text[l++],
	  "   epsilon : %4.2e   (Convergence criterion)",
	  Gparams.epsilon);
  return l;
}
