/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	binding.c	---	Binding handling routines.
 *
 */

#include	<stdio.h>

#define	PROTO_BINDING_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_BINDING_C

#pragma segment	parser


pphandle *make_binding(varname, value, explct)
     char *varname;
     varblrec *value;
     Boolean explct;
{
  varblrec *varbl;
  litrlrec *ftr;
  pphandle *cnst;

  if (value->nth == LEFTHAND && get_var(varname) == NULL) {
    /* rename the variable name of the right-hand (value) */
    value->name = varname;
    value->paren->print.varname = varname;
    if (value->paren->tag == PSTERM)
      for (ftr = value->paren->body.pst.nxt;
	   ftr != NULL; ftr = ftr->body.pst.nxt)
	ftr->print.varname = varname;
  } else {
    varbl = var_node(varname);
    connect_all_combinations(varbl, value, explct);
  }
  if (value->paren == NULL)
    /* some error has occurred (processed later) */
    return NULL;
  else if (value->paren->tag == SYMBOL || value->paren->tag == NUMBER) {
    for (cnst = Gbuffer.literals; cnst != NULL; cnst = cnst->next)
      if (cnst->body == value->paren)
	/* no processes meeded any more */
	return NULL;
    cnst = NEW_pphandle();
    cnst->body = value->paren;
    cnst->aux = NULL;
    cnst->vnode = NULL;
    cnst->next = Gbuffer.literals;
    Gbuffer.literals = cnst;
    return cnst;
  } else
    return value->paren->pphndl;
}


pphandle *make_equation(sign, subc, var1, var2)
     int sign;
     double subc;
     char *var1;
     char *var2;
{
  varblrec *varbl1, *varbl2;

  varbl1 = var_node(var1);
  varbl2 = var_node(var2);
  connect_all_combinations(varbl1, varbl2, TRUE);
  return NULL;
}


void connect_all_combinations(lvar, rvar, explct)
     varblrec *lvar, *rvar;
     Boolean explct;
{
  varblrec *var1, *var2;
  bndngrec *left, *right, *ll, *rr;

  /*** This routine uses the fact that binding records are stacked. ***/
  left = lvar->brecs;
  right = rvar->brecs;
  for (ll = left; ll != NULL; ll = ll->nxt) {
    var1 = ll->link->ptr[ll->dir]->var;
    for (rr = right; rr != NULL; rr = rr->nxt) {
      var2 = rr->link->ptr[rr->dir]->var;
      variable_binding(var1, var2, 1.0, FALSE);
    }
  }
  for (ll = left; ll != NULL; ll = ll->nxt) {
    var1 = ll->link->ptr[ll->dir]->var;
    variable_binding(var1, rvar, 1.0, FALSE);
  }
  for (rr = right; rr != NULL; rr = rr->nxt) {
    var2 = rr->link->ptr[rr->dir]->var;
    variable_binding(lvar, var2, 1.0, FALSE);
  }
  variable_binding(lvar, rvar, 1.0, explct);
}


void variable_binding(var1, var2, sub, explct)
     varblrec *var1;
     varblrec *var2;
     double sub;
     Boolean explct;
{
  bndngrec *newbnd1, *newbnd2;
  conctrec *newconct;

  newbnd1 = NEW_bndngrec();
  newbnd2 = NEW_bndngrec();
  newconct = NEW_conctrec();
  push_binding(var1, newbnd1);
  push_binding(var2, newbnd2);
  newbnd1->link = newconct;
  newbnd2->link = newconct;
  newconct->ptr[0] = newbnd1;
  newconct->ptr[1] = newbnd2;
  newconct->explct = explct;
  newconct->sub = sub;
  newbnd1->dir = 1;
  newbnd2->dir = 0;
}


void push_binding(variable, binding)
     varblrec *variable;
     bndngrec *binding;
{
  binding->var = variable;
  binding->nxt = variable->brecs;
  variable->brecs = binding;
}
