/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	absorb.c	---	Absorption management routines.
 *
 */

#include	<stdio.h>

#define	PROTO_ABSORB_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_ABSORB_C

#pragma segment	subsume


void absorb(outputliteral, origins, inputliteral)
     litrlrec *outputliteral;
     litrllst *origins;
     litrlrec *inputliteral;
{
  int absorbed;
  litrllst *orgn;
  dependrec *linkend, *dpnd1, *dpnd2;
  jointrec *endjnt, *jnt1, *jnt2;
  handlerec *hndl;

  absorbed = FALSE;
  for (orgn = origins; orgn != NULL; orgn = orgn->nxt) {
    /**** get linkend of outputliteral-side to be absorbed ****/
    linkend = get_absorbed_linkend(outputliteral, orgn->handle->body.ltrl);
    if (linkend != NULL) {
      /**** remove all links from outputliteral
	except for the link which has `linkend' ****/
      endjnt = linkend->joint;
      hndl = get_literal_handle(endjnt->ltrl);
      for (jnt1 = endjnt->ltrl->joint; jnt1 != NULL; jnt1 = jnt2) {
	jnt2 = jnt1->nxt;
	for (dpnd1 = jnt1->depend; dpnd1 != NULL; dpnd1 = dpnd2) {
	  dpnd2 = dpnd1->nxt;
	  if (dpnd1 != linkend) {
	    delete_link(dpnd1->link);
	    if (hndl->body.ltrl == NULL)
	      return;
	  }
	}
	if (jnt1 != endjnt) {
	  delete_joint(jnt1);
	  if (hndl->body.ltrl == NULL)
	    return;
	}
      }
      endjnt->total = TRUE;
      absorbed = TRUE;

      /* remove all links from ORIGIN-literal
	 except for the link which has `linkend' */
      if (Gparams.option != SPEECH_RECOG) {
	endjnt = linkend->link->ptr[linkend->dir]->joint;
	hndl = get_literal_handle(endjnt->ltrl);
	for (jnt1 = endjnt->ltrl->joint; jnt1 != NULL; jnt1 = jnt2) {
	  jnt2 = jnt1->nxt;
	  for (dpnd1 = jnt1->depend; dpnd1 != NULL; dpnd1 = dpnd2) {
	    dpnd2 = dpnd1->nxt;
	    if (dpnd1->link != linkend->link) {
	      delete_link(dpnd1->link);
	      if (hndl->body.ltrl == NULL)
		return;
	    }
	  }
	  if (jnt1 != endjnt) {
	    delete_joint(jnt1);
	    if (hndl->body.ltrl == NULL)
	      return;
	  }
	}
      }
      
      /**** fix subsumption coefficient to 1.0 ****/
      linkend->link->sub = 1.0;
    } else if (outputliteral == orgn->handle->body.ltrl)
      return;
  }
  /**** none of origins can absorb outputliteral ****/
  if (!absorbed)
    delete_literal(inputliteral);
}


dependrec *get_absorbed_linkend(literal, origin)
     litrlrec *literal;
     litrlrec *origin;
{
  litrlrec *ftr;
  jointrec *joint;
  dependrec *depend;

  if (literal == NULL || origin == NULL)
    return NULL;
  if (origin->tag == FEATURE && literal->tag == PSTERM) {
    for (ftr = literal->body.pst.nxt; ftr != NULL; ftr = ftr->body.pst.nxt)
      for (joint = ftr->joint; joint != NULL; joint = joint->nxt)
	for (depend = joint->depend; depend != NULL; depend = depend->nxt)
	  if (depend->link->ptr[depend->dir]->joint->ltrl == origin)
	    return depend;
  } else {
    for (joint = literal->joint; joint != NULL; joint = joint->nxt)
      for (depend = joint->depend; depend != NULL; depend = depend->nxt)
	if (depend->link->ptr[depend->dir]->joint->ltrl == origin)
	  return depend;
  }
  return NULL;
}
